package software.amazon.awscdk.services.ses;

/**
 * Resource to create a traffic policy for a Mail Manager ingress endpoint which contains policy statements used to evaluate whether incoming emails should be allowed or denied.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnMailManagerTrafficPolicy cfnMailManagerTrafficPolicy = CfnMailManagerTrafficPolicy.Builder.create(this, "MyCfnMailManagerTrafficPolicy")
 *         .defaultAction("defaultAction")
 *         .policyStatements(List.of(PolicyStatementProperty.builder()
 *                 .action("action")
 *                 .conditions(List.of(PolicyConditionProperty.builder()
 *                         .booleanExpression(IngressBooleanExpressionProperty.builder()
 *                                 .evaluate(IngressBooleanToEvaluateProperty.builder()
 *                                         .analysis(IngressAnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .build())
 *                                 .operator("operator")
 *                                 .build())
 *                         .ipExpression(IngressIpv4ExpressionProperty.builder()
 *                                 .evaluate(IngressIpToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .stringExpression(IngressStringExpressionProperty.builder()
 *                                 .evaluate(IngressStringToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .tlsExpression(IngressTlsProtocolExpressionProperty.builder()
 *                                 .evaluate(IngressTlsProtocolToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .value("value")
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .maxMessageSizeBytes(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trafficPolicyName("trafficPolicyName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:26.082Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy")
public class CfnMailManagerTrafficPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnMailManagerTrafficPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMailManagerTrafficPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMailManagerTrafficPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the traffic policy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTrafficPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTrafficPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the traffic policy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTrafficPolicyId() {
        return software.amazon.jsii.Kernel.get(this, "attrTrafficPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefaultAction() {
        return software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultAction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultAction", java.util.Objects.requireNonNull(value, "defaultAction is required"));
    }

    /**
     * Conditional statements for filtering email traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicyStatements() {
        return software.amazon.jsii.Kernel.get(this, "policyStatements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Conditional statements for filtering email traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyStatements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policyStatements", java.util.Objects.requireNonNull(value, "policyStatements is required"));
    }

    /**
     * Conditional statements for filtering email traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyStatements(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.PolicyStatementProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.PolicyStatementProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "policyStatements", java.util.Objects.requireNonNull(value, "policyStatements is required"));
    }

    /**
     * The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxMessageSizeBytes() {
        return software.amazon.jsii.Kernel.get(this, "maxMessageSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxMessageSizeBytes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxMessageSizeBytes", value);
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The name of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTrafficPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "trafficPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrafficPolicyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trafficPolicyName", value);
    }
    /**
     * The Add On ARN and its returned value that is evaluated in a policy statement's conditional expression to either deny or block the incoming email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressAnalysisProperty ingressAnalysisProperty = IngressAnalysisProperty.builder()
     *         .analyzer("analyzer")
     *         .resultField("resultField")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressanalysis.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressanalysis.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressAnalysisProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressAnalysisProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressAnalysisProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an Add On.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressanalysis.html#cfn-ses-mailmanagertrafficpolicy-ingressanalysis-analyzer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressanalysis.html#cfn-ses-mailmanagertrafficpolicy-ingressanalysis-analyzer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAnalyzer();

        /**
         * The returned value from an Add On.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressanalysis.html#cfn-ses-mailmanagertrafficpolicy-ingressanalysis-resultfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressanalysis.html#cfn-ses-mailmanagertrafficpolicy-ingressanalysis-resultfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResultField();

        /**
         * @return a {@link Builder} of {@link IngressAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressAnalysisProperty> {
            java.lang.String analyzer;
            java.lang.String resultField;

            /**
             * Sets the value of {@link IngressAnalysisProperty#getAnalyzer}
             * @param analyzer The Amazon Resource Name (ARN) of an Add On. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analyzer(java.lang.String analyzer) {
                this.analyzer = analyzer;
                return this;
            }

            /**
             * Sets the value of {@link IngressAnalysisProperty#getResultField}
             * @param resultField The returned value from an Add On. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultField(java.lang.String resultField) {
                this.resultField = resultField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressAnalysisProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressAnalysisProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressAnalysisProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressAnalysisProperty {
            private final java.lang.String analyzer;
            private final java.lang.String resultField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.analyzer = software.amazon.jsii.Kernel.get(this, "analyzer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resultField = software.amazon.jsii.Kernel.get(this, "resultField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.analyzer = java.util.Objects.requireNonNull(builder.analyzer, "analyzer is required");
                this.resultField = java.util.Objects.requireNonNull(builder.resultField, "resultField is required");
            }

            @Override
            public final java.lang.String getAnalyzer() {
                return this.analyzer;
            }

            @Override
            public final java.lang.String getResultField() {
                return this.resultField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("analyzer", om.valueToTree(this.getAnalyzer()));
                data.set("resultField", om.valueToTree(this.getResultField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressAnalysisProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressAnalysisProperty.Jsii$Proxy that = (IngressAnalysisProperty.Jsii$Proxy) o;

                if (!analyzer.equals(that.analyzer)) return false;
                return this.resultField.equals(that.resultField);
            }

            @Override
            public final int hashCode() {
                int result = this.analyzer.hashCode();
                result = 31 * result + (this.resultField.hashCode());
                return result;
            }
        }
    }
    /**
     * The structure for a boolean condition matching on the incoming mail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressBooleanExpressionProperty ingressBooleanExpressionProperty = IngressBooleanExpressionProperty.builder()
     *         .evaluate(IngressBooleanToEvaluateProperty.builder()
     *                 .analysis(IngressAnalysisProperty.builder()
     *                         .analyzer("analyzer")
     *                         .resultField("resultField")
     *                         .build())
     *                 .build())
     *         .operator("operator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleanexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleanexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressBooleanExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressBooleanExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressBooleanExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operand on which to perform a boolean condition operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleanexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressbooleanexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleanexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressbooleanexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The matching operator for a boolean condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleanexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressbooleanexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleanexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressbooleanexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * @return a {@link Builder} of {@link IngressBooleanExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressBooleanExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressBooleanExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;

            /**
             * Sets the value of {@link IngressBooleanExpressionProperty#getEvaluate}
             * @param evaluate The operand on which to perform a boolean condition operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressBooleanExpressionProperty#getEvaluate}
             * @param evaluate The operand on which to perform a boolean condition operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressBooleanToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressBooleanExpressionProperty#getOperator}
             * @param operator The matching operator for a boolean condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressBooleanExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressBooleanExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressBooleanExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressBooleanExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressBooleanExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressBooleanExpressionProperty.Jsii$Proxy that = (IngressBooleanExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                return this.operator.equals(that.operator);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                return result;
            }
        }
    }
    /**
     * The union type representing the allowed types of operands for a boolean condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressBooleanToEvaluateProperty ingressBooleanToEvaluateProperty = IngressBooleanToEvaluateProperty.builder()
     *         .analysis(IngressAnalysisProperty.builder()
     *                 .analyzer("analyzer")
     *                 .resultField("resultField")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleantoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleantoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressBooleanToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressBooleanToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressBooleanToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The structure type for a boolean condition stating the Add On ARN and its returned value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleantoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingressbooleantoevaluate-analysis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressbooleantoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingressbooleantoevaluate-analysis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAnalysis();

        /**
         * @return a {@link Builder} of {@link IngressBooleanToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressBooleanToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressBooleanToEvaluateProperty> {
            java.lang.Object analysis;

            /**
             * Sets the value of {@link IngressBooleanToEvaluateProperty#getAnalysis}
             * @param analysis The structure type for a boolean condition stating the Add On ARN and its returned value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.IResolvable analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Sets the value of {@link IngressBooleanToEvaluateProperty#getAnalysis}
             * @param analysis The structure type for a boolean condition stating the Add On ARN and its returned value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysis(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressAnalysisProperty analysis) {
                this.analysis = analysis;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressBooleanToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressBooleanToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressBooleanToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressBooleanToEvaluateProperty {
            private final java.lang.Object analysis;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.analysis = software.amazon.jsii.Kernel.get(this, "analysis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.analysis = java.util.Objects.requireNonNull(builder.analysis, "analysis is required");
            }

            @Override
            public final java.lang.Object getAnalysis() {
                return this.analysis;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("analysis", om.valueToTree(this.getAnalysis()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressBooleanToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressBooleanToEvaluateProperty.Jsii$Proxy that = (IngressBooleanToEvaluateProperty.Jsii$Proxy) o;

                return this.analysis.equals(that.analysis);
            }

            @Override
            public final int hashCode() {
                int result = this.analysis.hashCode();
                return result;
            }
        }
    }
    /**
     * The structure for an IP based condition matching on the incoming mail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressIpToEvaluateProperty ingressIpToEvaluateProperty = IngressIpToEvaluateProperty.builder()
     *         .attribute("attribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressiptoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressiptoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressIpToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressIpToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressIpToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An enum type representing the allowed attribute types for an IP condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressiptoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingressiptoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressiptoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingressiptoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * @return a {@link Builder} of {@link IngressIpToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressIpToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressIpToEvaluateProperty> {
            java.lang.String attribute;

            /**
             * Sets the value of {@link IngressIpToEvaluateProperty#getAttribute}
             * @param attribute An enum type representing the allowed attribute types for an IP condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressIpToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressIpToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressIpToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressIpToEvaluateProperty {
            private final java.lang.String attribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressIpToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressIpToEvaluateProperty.Jsii$Proxy that = (IngressIpToEvaluateProperty.Jsii$Proxy) o;

                return this.attribute.equals(that.attribute);
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                return result;
            }
        }
    }
    /**
     * The union type representing the allowed types for the left hand side of an IP condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressIpv4ExpressionProperty ingressIpv4ExpressionProperty = IngressIpv4ExpressionProperty.builder()
     *         .evaluate(IngressIpToEvaluateProperty.builder()
     *                 .attribute("attribute")
     *                 .build())
     *         .operator("operator")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressIpv4ExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressIpv4ExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressIpv4ExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The left hand side argument of an IP condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html#cfn-ses-mailmanagertrafficpolicy-ingressipv4expression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html#cfn-ses-mailmanagertrafficpolicy-ingressipv4expression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The matching operator for an IP condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html#cfn-ses-mailmanagertrafficpolicy-ingressipv4expression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html#cfn-ses-mailmanagertrafficpolicy-ingressipv4expression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The right hand side argument of an IP condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html#cfn-ses-mailmanagertrafficpolicy-ingressipv4expression-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressipv4expression.html#cfn-ses-mailmanagertrafficpolicy-ingressipv4expression-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link IngressIpv4ExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressIpv4ExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressIpv4ExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link IngressIpv4ExpressionProperty#getEvaluate}
             * @param evaluate The left hand side argument of an IP condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressIpv4ExpressionProperty#getEvaluate}
             * @param evaluate The left hand side argument of an IP condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressIpToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressIpv4ExpressionProperty#getOperator}
             * @param operator The matching operator for an IP condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link IngressIpv4ExpressionProperty#getValues}
             * @param values The right hand side argument of an IP condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressIpv4ExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressIpv4ExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressIpv4ExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressIpv4ExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressIpv4ExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressIpv4ExpressionProperty.Jsii$Proxy that = (IngressIpv4ExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The structure for a string based condition matching on the incoming mail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressStringExpressionProperty ingressStringExpressionProperty = IngressStringExpressionProperty.builder()
     *         .evaluate(IngressStringToEvaluateProperty.builder()
     *                 .attribute("attribute")
     *                 .build())
     *         .operator("operator")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressStringExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressStringExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressStringExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The left hand side argument of a string condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressstringexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressstringexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressstringexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressstringexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The right hand side argument of a string condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressstringexpression-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringexpression.html#cfn-ses-mailmanagertrafficpolicy-ingressstringexpression-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link IngressStringExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressStringExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressStringExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link IngressStringExpressionProperty#getEvaluate}
             * @param evaluate The left hand side argument of a string condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressStringExpressionProperty#getEvaluate}
             * @param evaluate The left hand side argument of a string condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressStringToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressStringExpressionProperty#getOperator}
             * @param operator the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link IngressStringExpressionProperty#getValues}
             * @param values The right hand side argument of a string condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressStringExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressStringExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressStringExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressStringExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressStringExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressStringExpressionProperty.Jsii$Proxy that = (IngressStringExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The union type representing the allowed types for the left hand side of a string condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressStringToEvaluateProperty ingressStringToEvaluateProperty = IngressStringToEvaluateProperty.builder()
     *         .attribute("attribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringtoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringtoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressStringToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressStringToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressStringToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The enum type representing the allowed attribute types for a string condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringtoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingressstringtoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingressstringtoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingressstringtoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * @return a {@link Builder} of {@link IngressStringToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressStringToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressStringToEvaluateProperty> {
            java.lang.String attribute;

            /**
             * Sets the value of {@link IngressStringToEvaluateProperty#getAttribute}
             * @param attribute The enum type representing the allowed attribute types for a string condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressStringToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressStringToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressStringToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressStringToEvaluateProperty {
            private final java.lang.String attribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressStringToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressStringToEvaluateProperty.Jsii$Proxy that = (IngressStringToEvaluateProperty.Jsii$Proxy) o;

                return this.attribute.equals(that.attribute);
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                return result;
            }
        }
    }
    /**
     * The structure for a TLS related condition matching on the incoming mail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressTlsProtocolExpressionProperty ingressTlsProtocolExpressionProperty = IngressTlsProtocolExpressionProperty.builder()
     *         .evaluate(IngressTlsProtocolToEvaluateProperty.builder()
     *                 .attribute("attribute")
     *                 .build())
     *         .operator("operator")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressTlsProtocolExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressTlsProtocolExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressTlsProtocolExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The left hand side argument of a TLS condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression-evaluate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression-evaluate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEvaluate();

        /**
         * The matching operator for a TLS condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The right hand side argument of a TLS condition expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocolexpression-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link IngressTlsProtocolExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressTlsProtocolExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressTlsProtocolExpressionProperty> {
            java.lang.Object evaluate;
            java.lang.String operator;
            java.lang.String value;

            /**
             * Sets the value of {@link IngressTlsProtocolExpressionProperty#getEvaluate}
             * @param evaluate The left hand side argument of a TLS condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.IResolvable evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressTlsProtocolExpressionProperty#getEvaluate}
             * @param evaluate The left hand side argument of a TLS condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluate(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressTlsProtocolToEvaluateProperty evaluate) {
                this.evaluate = evaluate;
                return this;
            }

            /**
             * Sets the value of {@link IngressTlsProtocolExpressionProperty#getOperator}
             * @param operator The matching operator for a TLS condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link IngressTlsProtocolExpressionProperty#getValue}
             * @param value The right hand side argument of a TLS condition expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressTlsProtocolExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressTlsProtocolExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressTlsProtocolExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressTlsProtocolExpressionProperty {
            private final java.lang.Object evaluate;
            private final java.lang.String operator;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluate = software.amazon.jsii.Kernel.get(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluate = java.util.Objects.requireNonNull(builder.evaluate, "evaluate is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.Object getEvaluate() {
                return this.evaluate;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluate", om.valueToTree(this.getEvaluate()));
                data.set("operator", om.valueToTree(this.getOperator()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressTlsProtocolExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressTlsProtocolExpressionProperty.Jsii$Proxy that = (IngressTlsProtocolExpressionProperty.Jsii$Proxy) o;

                if (!evaluate.equals(that.evaluate)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluate.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The union type representing the allowed types for the left hand side of a TLS condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * IngressTlsProtocolToEvaluateProperty ingressTlsProtocolToEvaluateProperty = IngressTlsProtocolToEvaluateProperty.builder()
     *         .attribute("attribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocoltoevaluate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocoltoevaluate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressTlsProtocolToEvaluateProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressTlsProtocolToEvaluateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressTlsProtocolToEvaluateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The enum type representing the allowed attribute types for the TLS condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocoltoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocoltoevaluate-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-ingresstlsprotocoltoevaluate.html#cfn-ses-mailmanagertrafficpolicy-ingresstlsprotocoltoevaluate-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttribute();

        /**
         * @return a {@link Builder} of {@link IngressTlsProtocolToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressTlsProtocolToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressTlsProtocolToEvaluateProperty> {
            java.lang.String attribute;

            /**
             * Sets the value of {@link IngressTlsProtocolToEvaluateProperty#getAttribute}
             * @param attribute The enum type representing the allowed attribute types for the TLS condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressTlsProtocolToEvaluateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressTlsProtocolToEvaluateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressTlsProtocolToEvaluateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressTlsProtocolToEvaluateProperty {
            private final java.lang.String attribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attribute", om.valueToTree(this.getAttribute()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.IngressTlsProtocolToEvaluateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressTlsProtocolToEvaluateProperty.Jsii$Proxy that = (IngressTlsProtocolToEvaluateProperty.Jsii$Proxy) o;

                return this.attribute.equals(that.attribute);
            }

            @Override
            public final int hashCode() {
                int result = this.attribute.hashCode();
                return result;
            }
        }
    }
    /**
     * The email traffic filtering conditions which are contained in a traffic policy resource.
     * <p>
     * <blockquote>
     * <p>
     * This data type is a UNION, so only one of the following members can be specified when used or returned.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * PolicyConditionProperty policyConditionProperty = PolicyConditionProperty.builder()
     *         .booleanExpression(IngressBooleanExpressionProperty.builder()
     *                 .evaluate(IngressBooleanToEvaluateProperty.builder()
     *                         .analysis(IngressAnalysisProperty.builder()
     *                                 .analyzer("analyzer")
     *                                 .resultField("resultField")
     *                                 .build())
     *                         .build())
     *                 .operator("operator")
     *                 .build())
     *         .ipExpression(IngressIpv4ExpressionProperty.builder()
     *                 .evaluate(IngressIpToEvaluateProperty.builder()
     *                         .attribute("attribute")
     *                         .build())
     *                 .operator("operator")
     *                 .values(List.of("values"))
     *                 .build())
     *         .stringExpression(IngressStringExpressionProperty.builder()
     *                 .evaluate(IngressStringToEvaluateProperty.builder()
     *                         .attribute("attribute")
     *                         .build())
     *                 .operator("operator")
     *                 .values(List.of("values"))
     *                 .build())
     *         .tlsExpression(IngressTlsProtocolExpressionProperty.builder()
     *                 .evaluate(IngressTlsProtocolToEvaluateProperty.builder()
     *                         .attribute("attribute")
     *                         .build())
     *                 .operator("operator")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.PolicyConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This represents a boolean type condition matching on the incoming mail.
         * <p>
         * It performs the boolean operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-booleanexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-booleanexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanExpression() {
            return null;
        }

        /**
         * This represents an IP based condition matching on the incoming mail.
         * <p>
         * It performs the operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-ipexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-ipexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpExpression() {
            return null;
        }

        /**
         * This represents a string based condition matching on the incoming mail.
         * <p>
         * It performs the string operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-stringexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-stringexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringExpression() {
            return null;
        }

        /**
         * This represents a TLS based condition matching on the incoming mail.
         * <p>
         * It performs the operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-tlsexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policycondition.html#cfn-ses-mailmanagertrafficpolicy-policycondition-tlsexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTlsExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyConditionProperty> {
            java.lang.Object booleanExpression;
            java.lang.Object ipExpression;
            java.lang.Object stringExpression;
            java.lang.Object tlsExpression;

            /**
             * Sets the value of {@link PolicyConditionProperty#getBooleanExpression}
             * @param booleanExpression This represents a boolean type condition matching on the incoming mail.
             *                          It performs the boolean operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanExpression(software.amazon.awscdk.IResolvable booleanExpression) {
                this.booleanExpression = booleanExpression;
                return this;
            }

            /**
             * Sets the value of {@link PolicyConditionProperty#getBooleanExpression}
             * @param booleanExpression This represents a boolean type condition matching on the incoming mail.
             *                          It performs the boolean operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanExpression(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressBooleanExpressionProperty booleanExpression) {
                this.booleanExpression = booleanExpression;
                return this;
            }

            /**
             * Sets the value of {@link PolicyConditionProperty#getIpExpression}
             * @param ipExpression This represents an IP based condition matching on the incoming mail.
             *                     It performs the operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipExpression(software.amazon.awscdk.IResolvable ipExpression) {
                this.ipExpression = ipExpression;
                return this;
            }

            /**
             * Sets the value of {@link PolicyConditionProperty#getIpExpression}
             * @param ipExpression This represents an IP based condition matching on the incoming mail.
             *                     It performs the operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipExpression(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressIpv4ExpressionProperty ipExpression) {
                this.ipExpression = ipExpression;
                return this;
            }

            /**
             * Sets the value of {@link PolicyConditionProperty#getStringExpression}
             * @param stringExpression This represents a string based condition matching on the incoming mail.
             *                         It performs the string operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringExpression(software.amazon.awscdk.IResolvable stringExpression) {
                this.stringExpression = stringExpression;
                return this;
            }

            /**
             * Sets the value of {@link PolicyConditionProperty#getStringExpression}
             * @param stringExpression This represents a string based condition matching on the incoming mail.
             *                         It performs the string operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringExpression(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressStringExpressionProperty stringExpression) {
                this.stringExpression = stringExpression;
                return this;
            }

            /**
             * Sets the value of {@link PolicyConditionProperty#getTlsExpression}
             * @param tlsExpression This represents a TLS based condition matching on the incoming mail.
             *                      It performs the operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsExpression(software.amazon.awscdk.IResolvable tlsExpression) {
                this.tlsExpression = tlsExpression;
                return this;
            }

            /**
             * Sets the value of {@link PolicyConditionProperty#getTlsExpression}
             * @param tlsExpression This represents a TLS based condition matching on the incoming mail.
             *                      It performs the operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsExpression(software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.IngressTlsProtocolExpressionProperty tlsExpression) {
                this.tlsExpression = tlsExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyConditionProperty {
            private final java.lang.Object booleanExpression;
            private final java.lang.Object ipExpression;
            private final java.lang.Object stringExpression;
            private final java.lang.Object tlsExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanExpression = software.amazon.jsii.Kernel.get(this, "booleanExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipExpression = software.amazon.jsii.Kernel.get(this, "ipExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringExpression = software.amazon.jsii.Kernel.get(this, "stringExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tlsExpression = software.amazon.jsii.Kernel.get(this, "tlsExpression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanExpression = builder.booleanExpression;
                this.ipExpression = builder.ipExpression;
                this.stringExpression = builder.stringExpression;
                this.tlsExpression = builder.tlsExpression;
            }

            @Override
            public final java.lang.Object getBooleanExpression() {
                return this.booleanExpression;
            }

            @Override
            public final java.lang.Object getIpExpression() {
                return this.ipExpression;
            }

            @Override
            public final java.lang.Object getStringExpression() {
                return this.stringExpression;
            }

            @Override
            public final java.lang.Object getTlsExpression() {
                return this.tlsExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanExpression() != null) {
                    data.set("booleanExpression", om.valueToTree(this.getBooleanExpression()));
                }
                if (this.getIpExpression() != null) {
                    data.set("ipExpression", om.valueToTree(this.getIpExpression()));
                }
                if (this.getStringExpression() != null) {
                    data.set("stringExpression", om.valueToTree(this.getStringExpression()));
                }
                if (this.getTlsExpression() != null) {
                    data.set("tlsExpression", om.valueToTree(this.getTlsExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.PolicyConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyConditionProperty.Jsii$Proxy that = (PolicyConditionProperty.Jsii$Proxy) o;

                if (this.booleanExpression != null ? !this.booleanExpression.equals(that.booleanExpression) : that.booleanExpression != null) return false;
                if (this.ipExpression != null ? !this.ipExpression.equals(that.ipExpression) : that.ipExpression != null) return false;
                if (this.stringExpression != null ? !this.stringExpression.equals(that.stringExpression) : that.stringExpression != null) return false;
                return this.tlsExpression != null ? this.tlsExpression.equals(that.tlsExpression) : that.tlsExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanExpression != null ? this.booleanExpression.hashCode() : 0;
                result = 31 * result + (this.ipExpression != null ? this.ipExpression.hashCode() : 0);
                result = 31 * result + (this.stringExpression != null ? this.stringExpression.hashCode() : 0);
                result = 31 * result + (this.tlsExpression != null ? this.tlsExpression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The structure containing traffic policy conditions and actions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * PolicyStatementProperty policyStatementProperty = PolicyStatementProperty.builder()
     *         .action("action")
     *         .conditions(List.of(PolicyConditionProperty.builder()
     *                 .booleanExpression(IngressBooleanExpressionProperty.builder()
     *                         .evaluate(IngressBooleanToEvaluateProperty.builder()
     *                                 .analysis(IngressAnalysisProperty.builder()
     *                                         .analyzer("analyzer")
     *                                         .resultField("resultField")
     *                                         .build())
     *                                 .build())
     *                         .operator("operator")
     *                         .build())
     *                 .ipExpression(IngressIpv4ExpressionProperty.builder()
     *                         .evaluate(IngressIpToEvaluateProperty.builder()
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .stringExpression(IngressStringExpressionProperty.builder()
     *                         .evaluate(IngressStringToEvaluateProperty.builder()
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .tlsExpression(IngressTlsProtocolExpressionProperty.builder()
     *                         .evaluate(IngressTlsProtocolToEvaluateProperty.builder()
     *                                 .attribute("attribute")
     *                                 .build())
     *                         .operator("operator")
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policystatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policystatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.PolicyStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that informs a traffic policy resource to either allow or block the email if it matches a condition in the policy statement.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policystatement.html#cfn-ses-mailmanagertrafficpolicy-policystatement-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policystatement.html#cfn-ses-mailmanagertrafficpolicy-policystatement-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The list of conditions to apply to incoming messages for filtering email traffic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policystatement.html#cfn-ses-mailmanagertrafficpolicy-policystatement-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-mailmanagertrafficpolicy-policystatement.html#cfn-ses-mailmanagertrafficpolicy-policystatement-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

        /**
         * @return a {@link Builder} of {@link PolicyStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyStatementProperty> {
            java.lang.String action;
            java.lang.Object conditions;

            /**
             * Sets the value of {@link PolicyStatementProperty#getAction}
             * @param action The action that informs a traffic policy resource to either allow or block the email if it matches a condition in the policy statement. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link PolicyStatementProperty#getConditions}
             * @param conditions The list of conditions to apply to incoming messages for filtering email traffic. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link PolicyStatementProperty#getConditions}
             * @param conditions The list of conditions to apply to incoming messages for filtering email traffic. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyStatementProperty {
            private final java.lang.String action;
            private final java.lang.Object conditions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("conditions", om.valueToTree(this.getConditions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicy.PolicyStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyStatementProperty.Jsii$Proxy that = (PolicyStatementProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                return this.conditions.equals(that.conditions);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.conditions.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicyProps.Builder();
        }

        /**
         * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-defaultaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-defaultaction</a>
         * @param defaultAction Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(final java.lang.String defaultAction) {
            this.props.defaultAction(defaultAction);
            return this;
        }

        /**
         * Conditional statements for filtering email traffic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-policystatements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-policystatements</a>
         * @param policyStatements Conditional statements for filtering email traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatements(final software.amazon.awscdk.IResolvable policyStatements) {
            this.props.policyStatements(policyStatements);
            return this;
        }
        /**
         * Conditional statements for filtering email traffic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-policystatements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-policystatements</a>
         * @param policyStatements Conditional statements for filtering email traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatements(final java.util.List<? extends java.lang.Object> policyStatements) {
            this.props.policyStatements(policyStatements);
            return this;
        }

        /**
         * The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-maxmessagesizebytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-maxmessagesizebytes</a>
         * @param maxMessageSizeBytes The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxMessageSizeBytes(final java.lang.Number maxMessageSizeBytes) {
            this.props.maxMessageSizeBytes(maxMessageSizeBytes);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for the resource.
         * <p>
         * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-tags</a>
         * @param tags The tags used to organize, track, or control access for the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The name of the policy.
         * <p>
         * The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-trafficpolicyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-trafficpolicyname</a>
         * @param trafficPolicyName The name of the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficPolicyName(final java.lang.String trafficPolicyName) {
            this.props.trafficPolicyName(trafficPolicyName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy build() {
            return new software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
