package software.amazon.awscdk.services.ses;

/**
 * An email identity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * User user;
 * EmailIdentity identity = EmailIdentity.Builder.create(this, "Identity")
 *         .identity(Identity.domain("cdk.dev"))
 *         .build();
 * identity.grantSendEmail(user);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:26.121Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.EmailIdentity")
public class EmailIdentity extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ses.IEmailIdentity {

    protected EmailIdentity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmailIdentity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EmailIdentity(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EmailIdentityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Use an existing email identity.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param emailIdentityName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IEmailIdentity fromEmailIdentityName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String emailIdentityName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.EmailIdentity.class, "fromEmailIdentityName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IEmailIdentity.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(emailIdentityName, "emailIdentityName is required") });
    }

    /**
     * Adds an IAM policy statement associated with this email identity to an IAM principal's policy.
     * <p>
     * @param grantee the principal (no-op if undefined). This parameter is required.
     * @param actions the set of actions to allow. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits an IAM principal the send email action.
     * <p>
     * Actions: SendEmail, SendRawEmail.
     * <p>
     * @param grantee the principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSendEmail(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantSendEmail", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The host name for the first token that you have to add to the DNS configurationfor your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDkimDnsTokenName1() {
        return software.amazon.jsii.Kernel.get(this, "dkimDnsTokenName1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the second token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDkimDnsTokenName2() {
        return software.amazon.jsii.Kernel.get(this, "dkimDnsTokenName2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the third token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDkimDnsTokenName3() {
        return software.amazon.jsii.Kernel.get(this, "dkimDnsTokenName3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the first token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDkimDnsTokenValue1() {
        return software.amazon.jsii.Kernel.get(this, "dkimDnsTokenValue1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the second token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDkimDnsTokenValue2() {
        return software.amazon.jsii.Kernel.get(this, "dkimDnsTokenValue2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the third token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDkimDnsTokenValue3() {
        return software.amazon.jsii.Kernel.get(this, "dkimDnsTokenValue3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * DKIM records for this identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ses.DkimRecord> getDkimRecords() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dkimRecords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.DkimRecord.class))));
    }

    /**
     * The ARN of the email identity.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEmailIdentityArn() {
        return software.amazon.jsii.Kernel.get(this, "emailIdentityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the email identity.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEmailIdentityName() {
        return software.amazon.jsii.Kernel.get(this, "emailIdentityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.EmailIdentity}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.EmailIdentity> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.EmailIdentityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.EmailIdentityProps.Builder();
        }

        /**
         * The email address or domain to verify.
         * <p>
         * @return {@code this}
         * @param identity The email address or domain to verify. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identity(final software.amazon.awscdk.services.ses.Identity identity) {
            this.props.identity(identity);
            return this;
        }

        /**
         * The configuration set to associate with the email identity.
         * <p>
         * Default: - do not use a specific configuration set
         * <p>
         * @return {@code this}
         * @param configurationSet The configuration set to associate with the email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSet(final software.amazon.awscdk.services.ses.IConfigurationSet configurationSet) {
            this.props.configurationSet(configurationSet);
            return this;
        }

        /**
         * The type of DKIM identity to use.
         * <p>
         * Default: - Easy DKIM with a key length of 2048-bit
         * <p>
         * @return {@code this}
         * @param dkimIdentity The type of DKIM identity to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimIdentity(final software.amazon.awscdk.services.ses.DkimIdentity dkimIdentity) {
            this.props.dkimIdentity(dkimIdentity);
            return this;
        }

        /**
         * Whether the messages that are sent from the identity are signed using DKIM.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param dkimSigning Whether the messages that are sent from the identity are signed using DKIM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigning(final java.lang.Boolean dkimSigning) {
            this.props.dkimSigning(dkimSigning);
            return this;
        }

        /**
         * Whether to receive email notifications when bounce or complaint events occur.
         * <p>
         * These notifications are sent to the address that you specified in the <code>Return-Path</code>
         * header of the original email.
         * <p>
         * You're required to have a method of tracking bounces and complaints. If you haven't set
         * up another mechanism for receiving bounce or complaint notifications (for example, by
         * setting up an event destination), you receive an email notification when these events
         * occur (even if this setting is disabled).
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param feedbackForwarding Whether to receive email notifications when bounce or complaint events occur. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackForwarding(final java.lang.Boolean feedbackForwarding) {
            this.props.feedbackForwarding(feedbackForwarding);
            return this;
        }

        /**
         * The action to take if the required MX record for the MAIL FROM domain isn't found when you send an email.
         * <p>
         * Default: MailFromBehaviorOnMxFailure.USE_DEFAULT_VALUE
         * <p>
         * @return {@code this}
         * @param mailFromBehaviorOnMxFailure The action to take if the required MX record for the MAIL FROM domain isn't found when you send an email. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromBehaviorOnMxFailure(final software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure mailFromBehaviorOnMxFailure) {
            this.props.mailFromBehaviorOnMxFailure(mailFromBehaviorOnMxFailure);
            return this;
        }

        /**
         * The custom MAIL FROM domain that you want the verified identity to use.
         * <p>
         * The MAIL FROM domain
         * must meet the following criteria:
         * <p>
         * <ul>
         * <li>It has to be a subdomain of the verified identity</li>
         * <li>It can't be used to receive email</li>
         * <li>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback
         * forwarding emails</li>
         * </ul>
         * <p>
         * Default: - use amazonses.com
         * <p>
         * @return {@code this}
         * @param mailFromDomain The custom MAIL FROM domain that you want the verified identity to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromDomain(final java.lang.String mailFromDomain) {
            this.props.mailFromDomain(mailFromDomain);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.EmailIdentity}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.EmailIdentity build() {
            return new software.amazon.awscdk.services.ses.EmailIdentity(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
