package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Base CallApiGatewayEdnpoint Task Props.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * TaskInput taskInput;
 * CallApiGatewayEndpointBaseOptions callApiGatewayEndpointBaseOptions = CallApiGatewayEndpointBaseOptions.builder()
 *         .method(HttpMethod.GET)
 *         // the properties below are optional
 *         .apiPath("apiPath")
 *         .authType(AuthType.NO_AUTH)
 *         .headers(taskInput)
 *         .queryParameters(taskInput)
 *         .requestBody(taskInput)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:26.619Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.CallApiGatewayEndpointBaseOptions")
@software.amazon.jsii.Jsii.Proxy(CallApiGatewayEndpointBaseOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CallApiGatewayEndpointBaseOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Http method for the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod getMethod();

    /**
     * Path parameters appended after API endpoint.
     * <p>
     * Default: - No path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiPath() {
        return null;
    }

    /**
     * Authentication methods.
     * <p>
     * Default: AuthType.NO_AUTH
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.AuthType getAuthType() {
        return null;
    }

    /**
     * HTTP request information that does not relate to contents of the request.
     * <p>
     * Default: - No headers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getHeaders() {
        return null;
    }

    /**
     * Query strings attatched to end of request.
     * <p>
     * Default: - No query parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getQueryParameters() {
        return null;
    }

    /**
     * HTTP Request body.
     * <p>
     * Default: - No request body
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getRequestBody() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CallApiGatewayEndpointBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CallApiGatewayEndpointBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CallApiGatewayEndpointBaseOptions> {
        software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod method;
        java.lang.String apiPath;
        software.amazon.awscdk.services.stepfunctions.tasks.AuthType authType;
        software.amazon.awscdk.services.stepfunctions.TaskInput headers;
        software.amazon.awscdk.services.stepfunctions.TaskInput queryParameters;
        software.amazon.awscdk.services.stepfunctions.TaskInput requestBody;

        /**
         * Sets the value of {@link CallApiGatewayEndpointBaseOptions#getMethod}
         * @param method Http method for the API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayEndpointBaseOptions#getApiPath}
         * @param apiPath Path parameters appended after API endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiPath(java.lang.String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayEndpointBaseOptions#getAuthType}
         * @param authType Authentication methods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(software.amazon.awscdk.services.stepfunctions.tasks.AuthType authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayEndpointBaseOptions#getHeaders}
         * @param headers HTTP request information that does not relate to contents of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headers(software.amazon.awscdk.services.stepfunctions.TaskInput headers) {
            this.headers = headers;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayEndpointBaseOptions#getQueryParameters}
         * @param queryParameters Query strings attatched to end of request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryParameters(software.amazon.awscdk.services.stepfunctions.TaskInput queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayEndpointBaseOptions#getRequestBody}
         * @param requestBody HTTP Request body.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBody(software.amazon.awscdk.services.stepfunctions.TaskInput requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CallApiGatewayEndpointBaseOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CallApiGatewayEndpointBaseOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CallApiGatewayEndpointBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CallApiGatewayEndpointBaseOptions {
        private final software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod method;
        private final java.lang.String apiPath;
        private final software.amazon.awscdk.services.stepfunctions.tasks.AuthType authType;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput headers;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput queryParameters;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput requestBody;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod.class));
            this.apiPath = software.amazon.jsii.Kernel.get(this, "apiPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AuthType.class));
            this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.requestBody = software.amazon.jsii.Kernel.get(this, "requestBody", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
            this.apiPath = builder.apiPath;
            this.authType = builder.authType;
            this.headers = builder.headers;
            this.queryParameters = builder.queryParameters;
            this.requestBody = builder.requestBody;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public final java.lang.String getApiPath() {
            return this.apiPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getHeaders() {
            return this.headers;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getRequestBody() {
            return this.requestBody;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("method", om.valueToTree(this.getMethod()));
            if (this.getApiPath() != null) {
                data.set("apiPath", om.valueToTree(this.getApiPath()));
            }
            if (this.getAuthType() != null) {
                data.set("authType", om.valueToTree(this.getAuthType()));
            }
            if (this.getHeaders() != null) {
                data.set("headers", om.valueToTree(this.getHeaders()));
            }
            if (this.getQueryParameters() != null) {
                data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
            }
            if (this.getRequestBody() != null) {
                data.set("requestBody", om.valueToTree(this.getRequestBody()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.CallApiGatewayEndpointBaseOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CallApiGatewayEndpointBaseOptions.Jsii$Proxy that = (CallApiGatewayEndpointBaseOptions.Jsii$Proxy) o;

            if (!method.equals(that.method)) return false;
            if (this.apiPath != null ? !this.apiPath.equals(that.apiPath) : that.apiPath != null) return false;
            if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
            if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
            if (this.queryParameters != null ? !this.queryParameters.equals(that.queryParameters) : that.queryParameters != null) return false;
            return this.requestBody != null ? this.requestBody.equals(that.requestBody) : that.requestBody == null;
        }

        @Override
        public final int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + (this.apiPath != null ? this.apiPath.hashCode() : 0);
            result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
            result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
            result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
            result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
            return result;
        }
    }
}
