package software.amazon.awscdk.services.systemsmanagersap;

/**
 * Properties for defining a <code>CfnApplication</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.systemsmanagersap.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .applicationId("applicationId")
 *         .applicationType("applicationType")
 *         // the properties below are optional
 *         .componentsInfo(List.of(ComponentInfoProperty.builder()
 *                 .componentType("componentType")
 *                 .ec2InstanceId("ec2InstanceId")
 *                 .sid("sid")
 *                 .build()))
 *         .credentials(List.of(CredentialProperty.builder()
 *                 .credentialType("credentialType")
 *                 .databaseName("databaseName")
 *                 .secretId("secretId")
 *                 .build()))
 *         .databaseArn("databaseArn")
 *         .instances(List.of("instances"))
 *         .sapInstanceNumber("sapInstanceNumber")
 *         .sid("sid")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-14T15:41:27.034Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_systemsmanagersap.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The type of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-applicationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationType();

    /**
     * This is an optional parameter for component details to which the SAP ABAP application is attached, such as Web Dispatcher.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-componentsinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-componentsinfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComponentsInfo() {
        return null;
    }

    /**
     * The credentials of the SAP application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-credentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-credentials</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCredentials() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-databasearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-databasearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseArn() {
        return null;
    }

    /**
     * The Amazon EC2 instances on which your SAP application is running.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-instances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-instances</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstances() {
        return null;
    }

    /**
     * The SAP instance number of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sapinstancenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sapinstancenumber</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSapInstanceNumber() {
        return null;
    }

    /**
     * The System ID of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-sid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSid() {
        return null;
    }

    /**
     * The tags on the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-systemsmanagersap-application.html#cfn-systemsmanagersap-application-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String applicationId;
        java.lang.String applicationType;
        java.lang.Object componentsInfo;
        java.lang.Object credentials;
        java.lang.String databaseArn;
        java.util.List<java.lang.String> instances;
        java.lang.String sapInstanceNumber;
        java.lang.String sid;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationId}
         * @param applicationId The ID of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationType}
         * @param applicationType The type of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationType(java.lang.String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getComponentsInfo}
         * @param componentsInfo This is an optional parameter for component details to which the SAP ABAP application is attached, such as Web Dispatcher.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentsInfo(software.amazon.awscdk.IResolvable componentsInfo) {
            this.componentsInfo = componentsInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getComponentsInfo}
         * @param componentsInfo This is an optional parameter for component details to which the SAP ABAP application is attached, such as Web Dispatcher.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentsInfo(java.util.List<? extends java.lang.Object> componentsInfo) {
            this.componentsInfo = componentsInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getCredentials}
         * @param credentials The credentials of the SAP application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.IResolvable credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getCredentials}
         * @param credentials The credentials of the SAP application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(java.util.List<? extends java.lang.Object> credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getDatabaseArn}
         * @param databaseArn The Amazon Resource Name (ARN) of the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseArn(java.lang.String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getInstances}
         * @param instances The Amazon EC2 instances on which your SAP application is running.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(java.util.List<java.lang.String> instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getSapInstanceNumber}
         * @param sapInstanceNumber The SAP instance number of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sapInstanceNumber(java.lang.String sapInstanceNumber) {
            this.sapInstanceNumber = sapInstanceNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getSid}
         * @param sid The System ID of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sid(java.lang.String sid) {
            this.sid = sid;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags The tags on the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String applicationId;
        private final java.lang.String applicationType;
        private final java.lang.Object componentsInfo;
        private final java.lang.Object credentials;
        private final java.lang.String databaseArn;
        private final java.util.List<java.lang.String> instances;
        private final java.lang.String sapInstanceNumber;
        private final java.lang.String sid;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationType = software.amazon.jsii.Kernel.get(this, "applicationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.componentsInfo = software.amazon.jsii.Kernel.get(this, "componentsInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.databaseArn = software.amazon.jsii.Kernel.get(this, "databaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sapInstanceNumber = software.amazon.jsii.Kernel.get(this, "sapInstanceNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sid = software.amazon.jsii.Kernel.get(this, "sid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.applicationType = java.util.Objects.requireNonNull(builder.applicationType, "applicationType is required");
            this.componentsInfo = builder.componentsInfo;
            this.credentials = builder.credentials;
            this.databaseArn = builder.databaseArn;
            this.instances = builder.instances;
            this.sapInstanceNumber = builder.sapInstanceNumber;
            this.sid = builder.sid;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getApplicationType() {
            return this.applicationType;
        }

        @Override
        public final java.lang.Object getComponentsInfo() {
            return this.componentsInfo;
        }

        @Override
        public final java.lang.Object getCredentials() {
            return this.credentials;
        }

        @Override
        public final java.lang.String getDatabaseArn() {
            return this.databaseArn;
        }

        @Override
        public final java.util.List<java.lang.String> getInstances() {
            return this.instances;
        }

        @Override
        public final java.lang.String getSapInstanceNumber() {
            return this.sapInstanceNumber;
        }

        @Override
        public final java.lang.String getSid() {
            return this.sid;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("applicationType", om.valueToTree(this.getApplicationType()));
            if (this.getComponentsInfo() != null) {
                data.set("componentsInfo", om.valueToTree(this.getComponentsInfo()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getDatabaseArn() != null) {
                data.set("databaseArn", om.valueToTree(this.getDatabaseArn()));
            }
            if (this.getInstances() != null) {
                data.set("instances", om.valueToTree(this.getInstances()));
            }
            if (this.getSapInstanceNumber() != null) {
                data.set("sapInstanceNumber", om.valueToTree(this.getSapInstanceNumber()));
            }
            if (this.getSid() != null) {
                data.set("sid", om.valueToTree(this.getSid()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_systemsmanagersap.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!applicationType.equals(that.applicationType)) return false;
            if (this.componentsInfo != null ? !this.componentsInfo.equals(that.componentsInfo) : that.componentsInfo != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.databaseArn != null ? !this.databaseArn.equals(that.databaseArn) : that.databaseArn != null) return false;
            if (this.instances != null ? !this.instances.equals(that.instances) : that.instances != null) return false;
            if (this.sapInstanceNumber != null ? !this.sapInstanceNumber.equals(that.sapInstanceNumber) : that.sapInstanceNumber != null) return false;
            if (this.sid != null ? !this.sid.equals(that.sid) : that.sid != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.applicationType.hashCode());
            result = 31 * result + (this.componentsInfo != null ? this.componentsInfo.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.databaseArn != null ? this.databaseArn.hashCode() : 0);
            result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
            result = 31 * result + (this.sapInstanceNumber != null ? this.sapInstanceNumber.hashCode() : 0);
            result = 31 * result + (this.sid != null ? this.sid.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
