/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.dms.CfnEndpoint;
import software.amazon.awscdk.services.dms.CfnEndpointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint")
public class CfnEndpoint
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEndpoint.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull CfnEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrExternalId() {
        return (String)Kernel.get((Object)this, (String)"attrExternalId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getEndpointType() {
        return (String)Kernel.get((Object)this, (String)"endpointType", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpointType(@NotNull String value) {
        Kernel.set((Object)this, (String)"endpointType", (Object)Objects.requireNonNull(value, "endpointType is required"));
    }

    @NotNull
    public String getEngineName() {
        return (String)Kernel.get((Object)this, (String)"engineName", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineName(@NotNull String value) {
        Kernel.set((Object)this, (String)"engineName", (Object)Objects.requireNonNull(value, "engineName is required"));
    }

    @Nullable
    public String getCertificateArn() {
        return (String)Kernel.get((Object)this, (String)"certificateArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setCertificateArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"certificateArn", (Object)value);
    }

    @Nullable
    public String getDatabaseName() {
        return (String)Kernel.get((Object)this, (String)"databaseName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDatabaseName(@Nullable String value) {
        Kernel.set((Object)this, (String)"databaseName", (Object)value);
    }

    @Nullable
    public Object getDocDbSettings() {
        return Kernel.get((Object)this, (String)"docDbSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDocDbSettings(@Nullable DocDbSettingsProperty value) {
        Kernel.set((Object)this, (String)"docDbSettings", (Object)value);
    }

    public void setDocDbSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"docDbSettings", (Object)value);
    }

    @Nullable
    public Object getDynamoDbSettings() {
        return Kernel.get((Object)this, (String)"dynamoDbSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDynamoDbSettings(@Nullable DynamoDbSettingsProperty value) {
        Kernel.set((Object)this, (String)"dynamoDbSettings", (Object)value);
    }

    public void setDynamoDbSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dynamoDbSettings", (Object)value);
    }

    @Nullable
    public Object getElasticsearchSettings() {
        return Kernel.get((Object)this, (String)"elasticsearchSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setElasticsearchSettings(@Nullable ElasticsearchSettingsProperty value) {
        Kernel.set((Object)this, (String)"elasticsearchSettings", (Object)value);
    }

    public void setElasticsearchSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"elasticsearchSettings", (Object)value);
    }

    @Nullable
    public String getEndpointIdentifier() {
        return (String)Kernel.get((Object)this, (String)"endpointIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpointIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"endpointIdentifier", (Object)value);
    }

    @Nullable
    public String getExtraConnectionAttributes() {
        return (String)Kernel.get((Object)this, (String)"extraConnectionAttributes", (NativeType)NativeType.forClass(String.class));
    }

    public void setExtraConnectionAttributes(@Nullable String value) {
        Kernel.set((Object)this, (String)"extraConnectionAttributes", (Object)value);
    }

    @Nullable
    public Object getGcpMySqlSettings() {
        return Kernel.get((Object)this, (String)"gcpMySqlSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setGcpMySqlSettings(@Nullable GcpMySQLSettingsProperty value) {
        Kernel.set((Object)this, (String)"gcpMySqlSettings", (Object)value);
    }

    public void setGcpMySqlSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"gcpMySqlSettings", (Object)value);
    }

    @Nullable
    public Object getIbmDb2Settings() {
        return Kernel.get((Object)this, (String)"ibmDb2Settings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIbmDb2Settings(@Nullable IbmDb2SettingsProperty value) {
        Kernel.set((Object)this, (String)"ibmDb2Settings", (Object)value);
    }

    public void setIbmDb2Settings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ibmDb2Settings", (Object)value);
    }

    @Nullable
    public Object getKafkaSettings() {
        return Kernel.get((Object)this, (String)"kafkaSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKafkaSettings(@Nullable KafkaSettingsProperty value) {
        Kernel.set((Object)this, (String)"kafkaSettings", (Object)value);
    }

    public void setKafkaSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"kafkaSettings", (Object)value);
    }

    @Nullable
    public Object getKinesisSettings() {
        return Kernel.get((Object)this, (String)"kinesisSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKinesisSettings(@Nullable KinesisSettingsProperty value) {
        Kernel.set((Object)this, (String)"kinesisSettings", (Object)value);
    }

    public void setKinesisSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"kinesisSettings", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public Object getMicrosoftSqlServerSettings() {
        return Kernel.get((Object)this, (String)"microsoftSqlServerSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMicrosoftSqlServerSettings(@Nullable MicrosoftSqlServerSettingsProperty value) {
        Kernel.set((Object)this, (String)"microsoftSqlServerSettings", (Object)value);
    }

    public void setMicrosoftSqlServerSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"microsoftSqlServerSettings", (Object)value);
    }

    @Nullable
    public Object getMongoDbSettings() {
        return Kernel.get((Object)this, (String)"mongoDbSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMongoDbSettings(@Nullable MongoDbSettingsProperty value) {
        Kernel.set((Object)this, (String)"mongoDbSettings", (Object)value);
    }

    public void setMongoDbSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"mongoDbSettings", (Object)value);
    }

    @Nullable
    public Object getMySqlSettings() {
        return Kernel.get((Object)this, (String)"mySqlSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMySqlSettings(@Nullable MySqlSettingsProperty value) {
        Kernel.set((Object)this, (String)"mySqlSettings", (Object)value);
    }

    public void setMySqlSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"mySqlSettings", (Object)value);
    }

    @Nullable
    public Object getNeptuneSettings() {
        return Kernel.get((Object)this, (String)"neptuneSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNeptuneSettings(@Nullable NeptuneSettingsProperty value) {
        Kernel.set((Object)this, (String)"neptuneSettings", (Object)value);
    }

    public void setNeptuneSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"neptuneSettings", (Object)value);
    }

    @Nullable
    public Object getOracleSettings() {
        return Kernel.get((Object)this, (String)"oracleSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOracleSettings(@Nullable OracleSettingsProperty value) {
        Kernel.set((Object)this, (String)"oracleSettings", (Object)value);
    }

    public void setOracleSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"oracleSettings", (Object)value);
    }

    @Nullable
    public String getPassword() {
        return (String)Kernel.get((Object)this, (String)"password", (NativeType)NativeType.forClass(String.class));
    }

    public void setPassword(@Nullable String value) {
        Kernel.set((Object)this, (String)"password", (Object)value);
    }

    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)this, (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPort(@Nullable Number value) {
        Kernel.set((Object)this, (String)"port", (Object)value);
    }

    @Nullable
    public Object getPostgreSqlSettings() {
        return Kernel.get((Object)this, (String)"postgreSqlSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPostgreSqlSettings(@Nullable PostgreSqlSettingsProperty value) {
        Kernel.set((Object)this, (String)"postgreSqlSettings", (Object)value);
    }

    public void setPostgreSqlSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"postgreSqlSettings", (Object)value);
    }

    @Nullable
    public Object getRedisSettings() {
        return Kernel.get((Object)this, (String)"redisSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRedisSettings(@Nullable RedisSettingsProperty value) {
        Kernel.set((Object)this, (String)"redisSettings", (Object)value);
    }

    public void setRedisSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"redisSettings", (Object)value);
    }

    @Nullable
    public Object getRedshiftSettings() {
        return Kernel.get((Object)this, (String)"redshiftSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRedshiftSettings(@Nullable RedshiftSettingsProperty value) {
        Kernel.set((Object)this, (String)"redshiftSettings", (Object)value);
    }

    public void setRedshiftSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"redshiftSettings", (Object)value);
    }

    @Nullable
    public String getResourceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"resourceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"resourceIdentifier", (Object)value);
    }

    @Nullable
    public Object getS3Settings() {
        return Kernel.get((Object)this, (String)"s3Settings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setS3Settings(@Nullable S3SettingsProperty value) {
        Kernel.set((Object)this, (String)"s3Settings", (Object)value);
    }

    public void setS3Settings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"s3Settings", (Object)value);
    }

    @Nullable
    public String getServerName() {
        return (String)Kernel.get((Object)this, (String)"serverName", (NativeType)NativeType.forClass(String.class));
    }

    public void setServerName(@Nullable String value) {
        Kernel.set((Object)this, (String)"serverName", (Object)value);
    }

    @Nullable
    public String getSslMode() {
        return (String)Kernel.get((Object)this, (String)"sslMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setSslMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"sslMode", (Object)value);
    }

    @Nullable
    public Object getSybaseSettings() {
        return Kernel.get((Object)this, (String)"sybaseSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSybaseSettings(@Nullable SybaseSettingsProperty value) {
        Kernel.set((Object)this, (String)"sybaseSettings", (Object)value);
    }

    public void setSybaseSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sybaseSettings", (Object)value);
    }

    @Nullable
    public String getUsername() {
        return (String)Kernel.get((Object)this, (String)"username", (NativeType)NativeType.forClass(String.class));
    }

    public void setUsername(@Nullable String value) {
        Kernel.set((Object)this, (String)"username", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEndpoint> {
        private final Construct scope;
        private final String id;
        private final CfnEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEndpointProps.Builder();
        }

        public Builder endpointType(String endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        public Builder engineName(String engineName) {
            this.props.engineName(engineName);
            return this;
        }

        public Builder certificateArn(String certificateArn) {
            this.props.certificateArn(certificateArn);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        public Builder docDbSettings(DocDbSettingsProperty docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }

        public Builder docDbSettings(IResolvable docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }

        public Builder dynamoDbSettings(DynamoDbSettingsProperty dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }

        public Builder dynamoDbSettings(IResolvable dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }

        public Builder elasticsearchSettings(ElasticsearchSettingsProperty elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }

        public Builder elasticsearchSettings(IResolvable elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }

        public Builder endpointIdentifier(String endpointIdentifier) {
            this.props.endpointIdentifier(endpointIdentifier);
            return this;
        }

        public Builder extraConnectionAttributes(String extraConnectionAttributes) {
            this.props.extraConnectionAttributes(extraConnectionAttributes);
            return this;
        }

        public Builder gcpMySqlSettings(GcpMySQLSettingsProperty gcpMySqlSettings) {
            this.props.gcpMySqlSettings(gcpMySqlSettings);
            return this;
        }

        public Builder gcpMySqlSettings(IResolvable gcpMySqlSettings) {
            this.props.gcpMySqlSettings(gcpMySqlSettings);
            return this;
        }

        public Builder ibmDb2Settings(IbmDb2SettingsProperty ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }

        public Builder ibmDb2Settings(IResolvable ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }

        public Builder kafkaSettings(KafkaSettingsProperty kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }

        public Builder kafkaSettings(IResolvable kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }

        public Builder kinesisSettings(KinesisSettingsProperty kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }

        public Builder kinesisSettings(IResolvable kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }

        public Builder microsoftSqlServerSettings(IResolvable microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }

        public Builder mongoDbSettings(MongoDbSettingsProperty mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }

        public Builder mongoDbSettings(IResolvable mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }

        public Builder mySqlSettings(MySqlSettingsProperty mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }

        public Builder mySqlSettings(IResolvable mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }

        public Builder neptuneSettings(NeptuneSettingsProperty neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }

        public Builder neptuneSettings(IResolvable neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }

        public Builder oracleSettings(OracleSettingsProperty oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }

        public Builder oracleSettings(IResolvable oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }

        public Builder password(String password) {
            this.props.password(password);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder postgreSqlSettings(PostgreSqlSettingsProperty postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }

        public Builder postgreSqlSettings(IResolvable postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }

        public Builder redisSettings(RedisSettingsProperty redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }

        public Builder redisSettings(IResolvable redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }

        public Builder redshiftSettings(RedshiftSettingsProperty redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }

        public Builder redshiftSettings(IResolvable redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }

        public Builder resourceIdentifier(String resourceIdentifier) {
            this.props.resourceIdentifier(resourceIdentifier);
            return this;
        }

        public Builder s3Settings(S3SettingsProperty s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }

        public Builder s3Settings(IResolvable s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }

        public Builder serverName(String serverName) {
            this.props.serverName(serverName);
            return this;
        }

        public Builder sslMode(String sslMode) {
            this.props.sslMode(sslMode);
            return this;
        }

        public Builder sybaseSettings(SybaseSettingsProperty sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }

        public Builder sybaseSettings(IResolvable sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder username(String username) {
            this.props.username(username);
            return this;
        }

        public CfnEndpoint build() {
            return new CfnEndpoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.SybaseSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SybaseSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SybaseSettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public SybaseSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.S3SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAddColumnName() {
            return null;
        }

        @Nullable
        default public String getBucketFolder() {
            return null;
        }

        @Nullable
        default public String getBucketName() {
            return null;
        }

        @Nullable
        default public String getCannedAclForObjects() {
            return null;
        }

        @Nullable
        default public Object getCdcInsertsAndUpdates() {
            return null;
        }

        @Nullable
        default public Object getCdcInsertsOnly() {
            return null;
        }

        @Nullable
        default public Number getCdcMaxBatchInterval() {
            return null;
        }

        @Nullable
        default public Number getCdcMinFileSize() {
            return null;
        }

        @Nullable
        default public String getCdcPath() {
            return null;
        }

        @Nullable
        default public String getCompressionType() {
            return null;
        }

        @Nullable
        default public String getCsvDelimiter() {
            return null;
        }

        @Nullable
        default public String getCsvNoSupValue() {
            return null;
        }

        @Nullable
        default public String getCsvNullValue() {
            return null;
        }

        @Nullable
        default public String getCsvRowDelimiter() {
            return null;
        }

        @Nullable
        default public String getDataFormat() {
            return null;
        }

        @Nullable
        default public Number getDataPageSize() {
            return null;
        }

        @Nullable
        default public String getDatePartitionDelimiter() {
            return null;
        }

        @Nullable
        default public Object getDatePartitionEnabled() {
            return null;
        }

        @Nullable
        default public String getDatePartitionSequence() {
            return null;
        }

        @Nullable
        default public String getDatePartitionTimezone() {
            return null;
        }

        @Nullable
        default public Number getDictPageSizeLimit() {
            return null;
        }

        @Nullable
        default public Object getEnableStatistics() {
            return null;
        }

        @Nullable
        default public String getEncodingType() {
            return null;
        }

        @Nullable
        default public String getEncryptionMode() {
            return null;
        }

        @Nullable
        default public String getExternalTableDefinition() {
            return null;
        }

        @Nullable
        default public Number getIgnoreHeaderRows() {
            return null;
        }

        @Nullable
        default public Object getIncludeOpForFullLoad() {
            return null;
        }

        @Nullable
        default public Number getMaxFileSize() {
            return null;
        }

        @Nullable
        default public Object getParquetTimestampInMillisecond() {
            return null;
        }

        @Nullable
        default public String getParquetVersion() {
            return null;
        }

        @Nullable
        default public Object getPreserveTransactions() {
            return null;
        }

        @Nullable
        default public Object getRfc4180() {
            return null;
        }

        @Nullable
        default public Number getRowGroupLength() {
            return null;
        }

        @Nullable
        default public String getServerSideEncryptionKmsKeyId() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getTimestampColumnName() {
            return null;
        }

        @Nullable
        default public Object getUseCsvNoSupValue() {
            return null;
        }

        @Nullable
        default public Object getUseTaskStartTimeForFullLoadTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3SettingsProperty> {
            Object addColumnName;
            String bucketFolder;
            String bucketName;
            String cannedAclForObjects;
            Object cdcInsertsAndUpdates;
            Object cdcInsertsOnly;
            Number cdcMaxBatchInterval;
            Number cdcMinFileSize;
            String cdcPath;
            String compressionType;
            String csvDelimiter;
            String csvNoSupValue;
            String csvNullValue;
            String csvRowDelimiter;
            String dataFormat;
            Number dataPageSize;
            String datePartitionDelimiter;
            Object datePartitionEnabled;
            String datePartitionSequence;
            String datePartitionTimezone;
            Number dictPageSizeLimit;
            Object enableStatistics;
            String encodingType;
            String encryptionMode;
            String externalTableDefinition;
            Number ignoreHeaderRows;
            Object includeOpForFullLoad;
            Number maxFileSize;
            Object parquetTimestampInMillisecond;
            String parquetVersion;
            Object preserveTransactions;
            Object rfc4180;
            Number rowGroupLength;
            String serverSideEncryptionKmsKeyId;
            String serviceAccessRoleArn;
            String timestampColumnName;
            Object useCsvNoSupValue;
            Object useTaskStartTimeForFullLoadTimestamp;

            public Builder addColumnName(Boolean addColumnName) {
                this.addColumnName = addColumnName;
                return this;
            }

            public Builder addColumnName(IResolvable addColumnName) {
                this.addColumnName = addColumnName;
                return this;
            }

            public Builder bucketFolder(String bucketFolder) {
                this.bucketFolder = bucketFolder;
                return this;
            }

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder cannedAclForObjects(String cannedAclForObjects) {
                this.cannedAclForObjects = cannedAclForObjects;
                return this;
            }

            public Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
                this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
                return this;
            }

            public Builder cdcInsertsAndUpdates(IResolvable cdcInsertsAndUpdates) {
                this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
                return this;
            }

            public Builder cdcInsertsOnly(Boolean cdcInsertsOnly) {
                this.cdcInsertsOnly = cdcInsertsOnly;
                return this;
            }

            public Builder cdcInsertsOnly(IResolvable cdcInsertsOnly) {
                this.cdcInsertsOnly = cdcInsertsOnly;
                return this;
            }

            public Builder cdcMaxBatchInterval(Number cdcMaxBatchInterval) {
                this.cdcMaxBatchInterval = cdcMaxBatchInterval;
                return this;
            }

            public Builder cdcMinFileSize(Number cdcMinFileSize) {
                this.cdcMinFileSize = cdcMinFileSize;
                return this;
            }

            public Builder cdcPath(String cdcPath) {
                this.cdcPath = cdcPath;
                return this;
            }

            public Builder compressionType(String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            public Builder csvDelimiter(String csvDelimiter) {
                this.csvDelimiter = csvDelimiter;
                return this;
            }

            public Builder csvNoSupValue(String csvNoSupValue) {
                this.csvNoSupValue = csvNoSupValue;
                return this;
            }

            public Builder csvNullValue(String csvNullValue) {
                this.csvNullValue = csvNullValue;
                return this;
            }

            public Builder csvRowDelimiter(String csvRowDelimiter) {
                this.csvRowDelimiter = csvRowDelimiter;
                return this;
            }

            public Builder dataFormat(String dataFormat) {
                this.dataFormat = dataFormat;
                return this;
            }

            public Builder dataPageSize(Number dataPageSize) {
                this.dataPageSize = dataPageSize;
                return this;
            }

            public Builder datePartitionDelimiter(String datePartitionDelimiter) {
                this.datePartitionDelimiter = datePartitionDelimiter;
                return this;
            }

            public Builder datePartitionEnabled(Boolean datePartitionEnabled) {
                this.datePartitionEnabled = datePartitionEnabled;
                return this;
            }

            public Builder datePartitionEnabled(IResolvable datePartitionEnabled) {
                this.datePartitionEnabled = datePartitionEnabled;
                return this;
            }

            public Builder datePartitionSequence(String datePartitionSequence) {
                this.datePartitionSequence = datePartitionSequence;
                return this;
            }

            public Builder datePartitionTimezone(String datePartitionTimezone) {
                this.datePartitionTimezone = datePartitionTimezone;
                return this;
            }

            public Builder dictPageSizeLimit(Number dictPageSizeLimit) {
                this.dictPageSizeLimit = dictPageSizeLimit;
                return this;
            }

            public Builder enableStatistics(Boolean enableStatistics) {
                this.enableStatistics = enableStatistics;
                return this;
            }

            public Builder enableStatistics(IResolvable enableStatistics) {
                this.enableStatistics = enableStatistics;
                return this;
            }

            public Builder encodingType(String encodingType) {
                this.encodingType = encodingType;
                return this;
            }

            public Builder encryptionMode(String encryptionMode) {
                this.encryptionMode = encryptionMode;
                return this;
            }

            public Builder externalTableDefinition(String externalTableDefinition) {
                this.externalTableDefinition = externalTableDefinition;
                return this;
            }

            public Builder ignoreHeaderRows(Number ignoreHeaderRows) {
                this.ignoreHeaderRows = ignoreHeaderRows;
                return this;
            }

            public Builder includeOpForFullLoad(Boolean includeOpForFullLoad) {
                this.includeOpForFullLoad = includeOpForFullLoad;
                return this;
            }

            public Builder includeOpForFullLoad(IResolvable includeOpForFullLoad) {
                this.includeOpForFullLoad = includeOpForFullLoad;
                return this;
            }

            public Builder maxFileSize(Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            public Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
                this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
                return this;
            }

            public Builder parquetTimestampInMillisecond(IResolvable parquetTimestampInMillisecond) {
                this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
                return this;
            }

            public Builder parquetVersion(String parquetVersion) {
                this.parquetVersion = parquetVersion;
                return this;
            }

            public Builder preserveTransactions(Boolean preserveTransactions) {
                this.preserveTransactions = preserveTransactions;
                return this;
            }

            public Builder preserveTransactions(IResolvable preserveTransactions) {
                this.preserveTransactions = preserveTransactions;
                return this;
            }

            public Builder rfc4180(Boolean rfc4180) {
                this.rfc4180 = rfc4180;
                return this;
            }

            public Builder rfc4180(IResolvable rfc4180) {
                this.rfc4180 = rfc4180;
                return this;
            }

            public Builder rowGroupLength(Number rowGroupLength) {
                this.rowGroupLength = rowGroupLength;
                return this;
            }

            public Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
                this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public Builder timestampColumnName(String timestampColumnName) {
                this.timestampColumnName = timestampColumnName;
                return this;
            }

            public Builder useCsvNoSupValue(Boolean useCsvNoSupValue) {
                this.useCsvNoSupValue = useCsvNoSupValue;
                return this;
            }

            public Builder useCsvNoSupValue(IResolvable useCsvNoSupValue) {
                this.useCsvNoSupValue = useCsvNoSupValue;
                return this;
            }

            public Builder useTaskStartTimeForFullLoadTimestamp(Boolean useTaskStartTimeForFullLoadTimestamp) {
                this.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
                return this;
            }

            public Builder useTaskStartTimeForFullLoadTimestamp(IResolvable useTaskStartTimeForFullLoadTimestamp) {
                this.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
                return this;
            }

            public S3SettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.RedshiftSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftSettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public RedshiftSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.RedisSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedisSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthPassword() {
            return null;
        }

        @Nullable
        default public String getAuthType() {
            return null;
        }

        @Nullable
        default public String getAuthUserName() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public String getServerName() {
            return null;
        }

        @Nullable
        default public String getSslCaCertificateArn() {
            return null;
        }

        @Nullable
        default public String getSslSecurityProtocol() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedisSettingsProperty> {
            String authPassword;
            String authType;
            String authUserName;
            Number port;
            String serverName;
            String sslCaCertificateArn;
            String sslSecurityProtocol;

            public Builder authPassword(String authPassword) {
                this.authPassword = authPassword;
                return this;
            }

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public Builder authUserName(String authUserName) {
                this.authUserName = authUserName;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder serverName(String serverName) {
                this.serverName = serverName;
                return this;
            }

            public Builder sslCaCertificateArn(String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            public Builder sslSecurityProtocol(String sslSecurityProtocol) {
                this.sslSecurityProtocol = sslSecurityProtocol;
                return this;
            }

            public RedisSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.PostgreSqlSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PostgreSqlSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PostgreSqlSettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public PostgreSqlSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.OracleSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OracleSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerOracleAsmAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerOracleAsmSecretId() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OracleSettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerOracleAsmAccessRoleArn;
            String secretsManagerOracleAsmSecretId;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
                this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
                return this;
            }

            public Builder secretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
                this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public OracleSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.NeptuneSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NeptuneSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getErrorRetryDuration() {
            return null;
        }

        @Nullable
        default public Object getIamAuthEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaxFileSize() {
            return null;
        }

        @Nullable
        default public Number getMaxRetryCount() {
            return null;
        }

        @Nullable
        default public String getS3BucketFolder() {
            return null;
        }

        @Nullable
        default public String getS3BucketName() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NeptuneSettingsProperty> {
            Number errorRetryDuration;
            Object iamAuthEnabled;
            Number maxFileSize;
            Number maxRetryCount;
            String s3BucketFolder;
            String s3BucketName;
            String serviceAccessRoleArn;

            public Builder errorRetryDuration(Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            public Builder iamAuthEnabled(Boolean iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            public Builder iamAuthEnabled(IResolvable iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            public Builder maxFileSize(Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            public Builder maxRetryCount(Number maxRetryCount) {
                this.maxRetryCount = maxRetryCount;
                return this;
            }

            public Builder s3BucketFolder(String s3BucketFolder) {
                this.s3BucketFolder = s3BucketFolder;
                return this;
            }

            public Builder s3BucketName(String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public NeptuneSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.MySqlSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MySqlSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MySqlSettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public MySqlSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.MongoDbSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MongoDbSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthMechanism() {
            return null;
        }

        @Nullable
        default public String getAuthSource() {
            return null;
        }

        @Nullable
        default public String getAuthType() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getDocsToInvestigate() {
            return null;
        }

        @Nullable
        default public String getExtractDocId() {
            return null;
        }

        @Nullable
        default public String getNestingLevel() {
            return null;
        }

        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        @Nullable
        default public String getServerName() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MongoDbSettingsProperty> {
            String authMechanism;
            String authSource;
            String authType;
            String databaseName;
            String docsToInvestigate;
            String extractDocId;
            String nestingLevel;
            String password;
            Number port;
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;
            String serverName;
            String username;

            public Builder authMechanism(String authMechanism) {
                this.authMechanism = authMechanism;
                return this;
            }

            public Builder authSource(String authSource) {
                this.authSource = authSource;
                return this;
            }

            public Builder authType(String authType) {
                this.authType = authType;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder docsToInvestigate(String docsToInvestigate) {
                this.docsToInvestigate = docsToInvestigate;
                return this;
            }

            public Builder extractDocId(String extractDocId) {
                this.extractDocId = extractDocId;
                return this;
            }

            public Builder nestingLevel(String nestingLevel) {
                this.nestingLevel = nestingLevel;
                return this;
            }

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public Builder serverName(String serverName) {
                this.serverName = serverName;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public MongoDbSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MicrosoftSqlServerSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MicrosoftSqlServerSettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public MicrosoftSqlServerSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.KinesisSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIncludeControlDetails() {
            return null;
        }

        @Nullable
        default public Object getIncludeNullAndEmpty() {
            return null;
        }

        @Nullable
        default public Object getIncludeTableAlterOperations() {
            return null;
        }

        @Nullable
        default public Object getIncludeTransactionDetails() {
            return null;
        }

        @Nullable
        default public String getMessageFormat() {
            return null;
        }

        @Nullable
        default public Object getNoHexPrefix() {
            return null;
        }

        @Nullable
        default public Object getPartitionIncludeSchemaTable() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getStreamArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisSettingsProperty> {
            Object includeControlDetails;
            Object includeNullAndEmpty;
            Object includeTableAlterOperations;
            Object includeTransactionDetails;
            String messageFormat;
            Object noHexPrefix;
            Object partitionIncludeSchemaTable;
            String serviceAccessRoleArn;
            String streamArn;

            public Builder includeControlDetails(Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            public Builder includeControlDetails(IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            public Builder includeNullAndEmpty(Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            public Builder includeNullAndEmpty(IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            public Builder includeTableAlterOperations(Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            public Builder includeTableAlterOperations(IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            public Builder includeTransactionDetails(Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            public Builder includeTransactionDetails(IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            public Builder messageFormat(String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            public Builder noHexPrefix(Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            public Builder noHexPrefix(IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            public Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            public Builder partitionIncludeSchemaTable(IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public Builder streamArn(String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            public KinesisSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.KafkaSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KafkaSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBroker() {
            return null;
        }

        @Nullable
        default public Object getIncludeControlDetails() {
            return null;
        }

        @Nullable
        default public Object getIncludeNullAndEmpty() {
            return null;
        }

        @Nullable
        default public Object getIncludeTableAlterOperations() {
            return null;
        }

        @Nullable
        default public Object getIncludeTransactionDetails() {
            return null;
        }

        @Nullable
        default public Object getNoHexPrefix() {
            return null;
        }

        @Nullable
        default public Object getPartitionIncludeSchemaTable() {
            return null;
        }

        @Nullable
        default public String getSaslPassword() {
            return null;
        }

        @Nullable
        default public String getSaslUserName() {
            return null;
        }

        @Nullable
        default public String getSecurityProtocol() {
            return null;
        }

        @Nullable
        default public String getSslCaCertificateArn() {
            return null;
        }

        @Nullable
        default public String getSslClientCertificateArn() {
            return null;
        }

        @Nullable
        default public String getSslClientKeyArn() {
            return null;
        }

        @Nullable
        default public String getSslClientKeyPassword() {
            return null;
        }

        @Nullable
        default public String getTopic() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KafkaSettingsProperty> {
            String broker;
            Object includeControlDetails;
            Object includeNullAndEmpty;
            Object includeTableAlterOperations;
            Object includeTransactionDetails;
            Object noHexPrefix;
            Object partitionIncludeSchemaTable;
            String saslPassword;
            String saslUserName;
            String securityProtocol;
            String sslCaCertificateArn;
            String sslClientCertificateArn;
            String sslClientKeyArn;
            String sslClientKeyPassword;
            String topic;

            public Builder broker(String broker) {
                this.broker = broker;
                return this;
            }

            public Builder includeControlDetails(Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            public Builder includeControlDetails(IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            public Builder includeNullAndEmpty(Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            public Builder includeNullAndEmpty(IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            public Builder includeTableAlterOperations(Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            public Builder includeTableAlterOperations(IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            public Builder includeTransactionDetails(Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            public Builder includeTransactionDetails(IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            public Builder noHexPrefix(Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            public Builder noHexPrefix(IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            public Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            public Builder partitionIncludeSchemaTable(IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            public Builder saslPassword(String saslPassword) {
                this.saslPassword = saslPassword;
                return this;
            }

            public Builder saslUserName(String saslUserName) {
                this.saslUserName = saslUserName;
                return this;
            }

            public Builder securityProtocol(String securityProtocol) {
                this.securityProtocol = securityProtocol;
                return this;
            }

            public Builder sslCaCertificateArn(String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            public Builder sslClientCertificateArn(String sslClientCertificateArn) {
                this.sslClientCertificateArn = sslClientCertificateArn;
                return this;
            }

            public Builder sslClientKeyArn(String sslClientKeyArn) {
                this.sslClientKeyArn = sslClientKeyArn;
                return this;
            }

            public Builder sslClientKeyPassword(String sslClientKeyPassword) {
                this.sslClientKeyPassword = sslClientKeyPassword;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public KafkaSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.IbmDb2SettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IbmDb2SettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IbmDb2SettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public IbmDb2SettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.GcpMySQLSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GcpMySQLSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAfterConnectScript() {
            return null;
        }

        @Nullable
        default public Object getCleanSourceMetadataOnMismatch() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public Number getEventsPollInterval() {
            return null;
        }

        @Nullable
        default public Number getMaxFileSize() {
            return null;
        }

        @Nullable
        default public Number getParallelLoadThreads() {
            return null;
        }

        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        @Nullable
        default public String getServerName() {
            return null;
        }

        @Nullable
        default public String getServerTimezone() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GcpMySQLSettingsProperty> {
            String afterConnectScript;
            Object cleanSourceMetadataOnMismatch;
            String databaseName;
            Number eventsPollInterval;
            Number maxFileSize;
            Number parallelLoadThreads;
            String password;
            Number port;
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;
            String serverName;
            String serverTimezone;
            String username;

            public Builder afterConnectScript(String afterConnectScript) {
                this.afterConnectScript = afterConnectScript;
                return this;
            }

            public Builder cleanSourceMetadataOnMismatch(Boolean cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            public Builder cleanSourceMetadataOnMismatch(IResolvable cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder eventsPollInterval(Number eventsPollInterval) {
                this.eventsPollInterval = eventsPollInterval;
                return this;
            }

            public Builder maxFileSize(Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            public Builder parallelLoadThreads(Number parallelLoadThreads) {
                this.parallelLoadThreads = parallelLoadThreads;
                return this;
            }

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public Builder serverName(String serverName) {
                this.serverName = serverName;
                return this;
            }

            public Builder serverTimezone(String serverTimezone) {
                this.serverTimezone = serverTimezone;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public GcpMySQLSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.ElasticsearchSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEndpointUri() {
            return null;
        }

        @Nullable
        default public Number getErrorRetryDuration() {
            return null;
        }

        @Nullable
        default public Number getFullLoadErrorPercentage() {
            return null;
        }

        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchSettingsProperty> {
            String endpointUri;
            Number errorRetryDuration;
            Number fullLoadErrorPercentage;
            String serviceAccessRoleArn;

            public Builder endpointUri(String endpointUri) {
                this.endpointUri = endpointUri;
                return this;
            }

            public Builder errorRetryDuration(Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            public Builder fullLoadErrorPercentage(Number fullLoadErrorPercentage) {
                this.fullLoadErrorPercentage = fullLoadErrorPercentage;
                return this;
            }

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public ElasticsearchSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.DynamoDbSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDbSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getServiceAccessRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDbSettingsProperty> {
            String serviceAccessRoleArn;

            public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            public DynamoDbSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dms.CfnEndpoint.DocDbSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DocDbSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretsManagerAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getSecretsManagerSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DocDbSettingsProperty> {
            String secretsManagerAccessRoleArn;
            String secretsManagerSecretId;

            public Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            public Builder secretsManagerSecretId(String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            public DocDbSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

