/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.Ec2Service;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedEc2ServiceProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceBase;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs_patterns.NetworkLoadBalancedEc2Service")
public class NetworkLoadBalancedEc2Service
extends NetworkLoadBalancedServiceBase {
    protected NetworkLoadBalancedEc2Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkLoadBalancedEc2Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkLoadBalancedEc2Service(@NotNull Construct scope, @NotNull String id, @Nullable NetworkLoadBalancedEc2ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public NetworkLoadBalancedEc2Service(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public Ec2Service getService() {
        return (Ec2Service)Kernel.get((Object)((Object)this), (String)"service", (NativeType)NativeType.forClass(Ec2Service.class));
    }

    @NotNull
    public Ec2TaskDefinition getTaskDefinition() {
        return (Ec2TaskDefinition)Kernel.get((Object)((Object)this), (String)"taskDefinition", (NativeType)NativeType.forClass(Ec2TaskDefinition.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NetworkLoadBalancedEc2Service> {
        private final Construct scope;
        private final String id;
        private NetworkLoadBalancedEc2ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.props().circuitBreaker(circuitBreaker);
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.props().cloudMapOptions(cloudMapOptions);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        public Builder domainName(String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        public Builder domainZone(IHostedZone domainZone) {
            this.props().domainZone(domainZone);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.props().healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        public Builder listenerPort(Number listenerPort) {
            this.props().listenerPort(listenerPort);
            return this;
        }

        public Builder loadBalancer(INetworkLoadBalancer loadBalancer) {
            this.props().loadBalancer(loadBalancer);
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.props().maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.props().minHealthyPercent(minHealthyPercent);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        public Builder publicLoadBalancer(Boolean publicLoadBalancer) {
            this.props().publicLoadBalancer(publicLoadBalancer);
            return this;
        }

        public Builder recordType(NetworkLoadBalancedServiceRecordType recordType) {
            this.props().recordType(recordType);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        public Builder taskImageOptions(NetworkLoadBalancedTaskImageOptions taskImageOptions) {
            this.props().taskImageOptions(taskImageOptions);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.props().memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementStrategies(List<? extends PlacementStrategy> placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        public Builder taskDefinition(Ec2TaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        public NetworkLoadBalancedEc2Service build() {
            return new NetworkLoadBalancedEc2Service(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private NetworkLoadBalancedEc2ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new NetworkLoadBalancedEc2ServiceProps.Builder();
            }
            return this.props;
        }
    }
}

