/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigatewayv2;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apigatewayv2.IApi;
import software.amazon.awscdk.services.apigatewayv2.IWebSocketApi;
import software.amazon.awscdk.services.apigatewayv2.IpAddressType;
import software.amazon.awscdk.services.apigatewayv2.WebSocketApiAttributes;
import software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression;
import software.amazon.awscdk.services.apigatewayv2.WebSocketApiProps;
import software.amazon.awscdk.services.apigatewayv2.WebSocketRoute;
import software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigatewayv2.WebSocketApi")
public class WebSocketApi
extends Resource
implements IWebSocketApi,
IApi {
    protected WebSocketApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public WebSocketApi(@NotNull Construct scope, @NotNull String id, @Nullable WebSocketApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public WebSocketApi(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IWebSocketApi fromWebSocketApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull WebSocketApiAttributes attrs) {
        return (IWebSocketApi)JsiiObject.jsiiStaticCall(WebSocketApi.class, (String)"fromWebSocketApiAttributes", (NativeType)NativeType.forClass(IWebSocketApi.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public WebSocketRoute addRoute(@NotNull String routeKey, @NotNull WebSocketRouteOptions options) {
        return (WebSocketRoute)Kernel.call((Object)this, (String)"addRoute", (NativeType)NativeType.forClass(WebSocketRoute.class), (Object[])new Object[]{Objects.requireNonNull(routeKey, "routeKey is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Deprecated
    @NotNull
    public String arnForExecuteApi(@Nullable String method, @Nullable String path, @Nullable String stage) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{method, path, stage});
    }

    @Deprecated
    @NotNull
    public String arnForExecuteApi(@Nullable String method, @Nullable String path) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{method, path});
    }

    @Deprecated
    @NotNull
    public String arnForExecuteApi(@Nullable String method) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{method});
    }

    @Deprecated
    @NotNull
    public String arnForExecuteApi() {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApi", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public String arnForExecuteApiV2(@Nullable String route, @Nullable String stage) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApiV2", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{route, stage});
    }

    @NotNull
    public String arnForExecuteApiV2(@Nullable String route) {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApiV2", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{route});
    }

    @NotNull
    public String arnForExecuteApiV2() {
        return (String)Kernel.call((Object)this, (String)"arnForExecuteApiV2", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public Grant grantManageConnections(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantManageConnections", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public String getApiEndpoint() {
        return (String)Kernel.get((Object)this, (String)"apiEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getApiId() {
        return (String)Kernel.get((Object)this, (String)"apiId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getWebSocketApiName() {
        return (String)Kernel.get((Object)this, (String)"webSocketApiName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<WebSocketApi> {
        private final Construct scope;
        private final String id;
        private WebSocketApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder apiKeySelectionExpression(WebSocketApiKeySelectionExpression apiKeySelectionExpression) {
            this.props().apiKeySelectionExpression(apiKeySelectionExpression);
            return this;
        }

        public Builder apiName(String apiName) {
            this.props().apiName(apiName);
            return this;
        }

        public Builder connectRouteOptions(WebSocketRouteOptions connectRouteOptions) {
            this.props().connectRouteOptions(connectRouteOptions);
            return this;
        }

        public Builder defaultRouteOptions(WebSocketRouteOptions defaultRouteOptions) {
            this.props().defaultRouteOptions(defaultRouteOptions);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder disconnectRouteOptions(WebSocketRouteOptions disconnectRouteOptions) {
            this.props().disconnectRouteOptions(disconnectRouteOptions);
            return this;
        }

        public Builder ipAddressType(IpAddressType ipAddressType) {
            this.props().ipAddressType(ipAddressType);
            return this;
        }

        public Builder routeSelectionExpression(String routeSelectionExpression) {
            this.props().routeSelectionExpression(routeSelectionExpression);
            return this;
        }

        public WebSocketApi build() {
            return new WebSocketApi(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private WebSocketApiProps.Builder props() {
            if (this.props == null) {
                this.props = new WebSocketApiProps.Builder();
            }
            return this.props;
        }
    }
}

