/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.batch.CfnJobDefinition;
import software.amazon.awscdk.services.batch.Device;
import software.amazon.awscdk.services.batch.LinuxParametersProps;
import software.amazon.awscdk.services.batch.Tmpfs;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.LinuxParameters")
public class LinuxParameters
extends Construct {
    protected LinuxParameters(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxParameters(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LinuxParameters(@NotNull Construct scope, @NotNull String id, @Nullable LinuxParametersProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public LinuxParameters(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addDevices(Device ... device) {
        Kernel.call((Object)((Object)this), (String)"addDevices", (NativeType)NativeType.VOID, (Object[])Arrays.stream(device).toArray(Object[]::new));
    }

    public void addTmpfs(Tmpfs ... tmpfs) {
        Kernel.call((Object)((Object)this), (String)"addTmpfs", (NativeType)NativeType.VOID, (Object[])Arrays.stream(tmpfs).toArray(Object[]::new));
    }

    @NotNull
    public CfnJobDefinition.LinuxParametersProperty renderLinuxParameters() {
        return (CfnJobDefinition.LinuxParametersProperty)Kernel.call((Object)((Object)this), (String)"renderLinuxParameters", (NativeType)NativeType.forClass(CfnJobDefinition.LinuxParametersProperty.class), (Object[])new Object[0]);
    }

    @NotNull
    protected List<Device> getDevices() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"devices", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Device.class))));
    }

    @NotNull
    protected List<Tmpfs> getTmpfs() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"tmpfs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Tmpfs.class))));
    }

    @Nullable
    protected Boolean getInitProcessEnabled() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"initProcessEnabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    protected Size getMaxSwap() {
        return (Size)((Object)Kernel.get((Object)((Object)this), (String)"maxSwap", (NativeType)NativeType.forClass(Size.class)));
    }

    @Nullable
    protected Size getSharedMemorySize() {
        return (Size)((Object)Kernel.get((Object)((Object)this), (String)"sharedMemorySize", (NativeType)NativeType.forClass(Size.class)));
    }

    @Nullable
    protected Number getSwappiness() {
        return (Number)Kernel.get((Object)((Object)this), (String)"swappiness", (NativeType)NativeType.forClass(Number.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LinuxParameters> {
        private final Construct scope;
        private final String id;
        private LinuxParametersProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder initProcessEnabled(Boolean initProcessEnabled) {
            this.props().initProcessEnabled(initProcessEnabled);
            return this;
        }

        public Builder maxSwap(Size maxSwap) {
            this.props().maxSwap(maxSwap);
            return this;
        }

        public Builder sharedMemorySize(Size sharedMemorySize) {
            this.props().sharedMemorySize(sharedMemorySize);
            return this;
        }

        public Builder swappiness(Number swappiness) {
            this.props().swappiness(swappiness);
            return this;
        }

        public LinuxParameters build() {
            return new LinuxParameters(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private LinuxParametersProps.Builder props() {
            if (this.props == null) {
                this.props = new LinuxParametersProps.Builder();
            }
            return this.props;
        }
    }
}

