/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bedrock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bedrock.CfnAgentAlias;
import software.amazon.awscdk.services.bedrock.CfnAgentAliasProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnAgentAlias")
public class CfnAgentAlias
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAgentAlias.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAgentAlias(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAgentAlias(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAgentAlias(@NotNull Construct scope, @NotNull String id, @NotNull CfnAgentAliasProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAgentAliasArn() {
        return (String)Kernel.get((Object)this, (String)"attrAgentAliasArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrAgentAliasHistoryEvents() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrAgentAliasHistoryEvents", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrAgentAliasId() {
        return (String)Kernel.get((Object)this, (String)"attrAgentAliasId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrAgentAliasStatus() {
        return (String)Kernel.get((Object)this, (String)"attrAgentAliasStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUpdatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getAgentAliasName() {
        return (String)Kernel.get((Object)this, (String)"agentAliasName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAgentAliasName(@NotNull String value) {
        Kernel.set((Object)this, (String)"agentAliasName", (Object)Objects.requireNonNull(value, "agentAliasName is required"));
    }

    @NotNull
    public String getAgentId() {
        return (String)Kernel.get((Object)this, (String)"agentId", (NativeType)NativeType.forClass(String.class));
    }

    public void setAgentId(@NotNull String value) {
        Kernel.set((Object)this, (String)"agentId", (Object)Objects.requireNonNull(value, "agentId is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getRoutingConfiguration() {
        return Kernel.get((Object)this, (String)"routingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRoutingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"routingConfiguration", (Object)value);
    }

    public void setRoutingConfiguration(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof AgentAliasRoutingConfigurationListItemProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrock.CfnAgentAlias.AgentAliasRoutingConfigurationListItemProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"routingConfiguration", value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnAgentAlias.AgentAliasRoutingConfigurationListItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AgentAliasRoutingConfigurationListItemProperty
    extends JsiiSerializable {
        @NotNull
        public String getAgentVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AgentAliasRoutingConfigurationListItemProperty> {
            String agentVersion;

            public Builder agentVersion(String agentVersion) {
                this.agentVersion = agentVersion;
                return this;
            }

            public AgentAliasRoutingConfigurationListItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAgentAlias> {
        private final Construct scope;
        private final String id;
        private final CfnAgentAliasProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAgentAliasProps.Builder();
        }

        public Builder agentAliasName(String agentAliasName) {
            this.props.agentAliasName(agentAliasName);
            return this;
        }

        public Builder agentId(String agentId) {
            this.props.agentId(agentId);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder routingConfiguration(IResolvable routingConfiguration) {
            this.props.routingConfiguration(routingConfiguration);
            return this;
        }

        public Builder routingConfiguration(List<? extends Object> routingConfiguration) {
            this.props.routingConfiguration(routingConfiguration);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnAgentAlias build() {
            return new CfnAgentAlias(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnAgentAlias.AgentAliasHistoryEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AgentAliasHistoryEventProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEndDate() {
            return null;
        }

        @Nullable
        default public Object getRoutingConfiguration() {
            return null;
        }

        @Nullable
        default public String getStartDate() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AgentAliasHistoryEventProperty> {
            String endDate;
            Object routingConfiguration;
            String startDate;

            public Builder endDate(String endDate) {
                this.endDate = endDate;
                return this;
            }

            public Builder routingConfiguration(IResolvable routingConfiguration) {
                this.routingConfiguration = routingConfiguration;
                return this;
            }

            public Builder routingConfiguration(List<? extends Object> routingConfiguration) {
                this.routingConfiguration = routingConfiguration;
                return this;
            }

            public Builder startDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public AgentAliasHistoryEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

