/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult;
import software.amazon.awscdk.services.iam.CustomizeRolesOptions;
import software.amazon.awscdk.services.iam.FromRoleArnOptions;
import software.amazon.awscdk.services.iam.FromRoleNameOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IManagedPolicy;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.Policy;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.iam.PrincipalPolicyFragment;
import software.amazon.awscdk.services.iam.RoleLookupOptions;
import software.amazon.awscdk.services.iam.RoleProps;
import software.amazon.awscdk.services.iam.WithoutPolicyUpdatesOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_iam.Role")
public class Role
extends Resource
implements IRole {
    protected Role(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Role(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Role(@NotNull Construct scope, @NotNull String id, @NotNull RoleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static void customizeRoles(@NotNull Construct scope, @Nullable CustomizeRolesOptions options) {
        JsiiObject.jsiiStaticCall(Role.class, (String)"customizeRoles", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), options});
    }

    public static void customizeRoles(@NotNull Construct scope) {
        JsiiObject.jsiiStaticCall(Role.class, (String)"customizeRoles", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    public static IRole fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull RoleLookupOptions options) {
        return (IRole)JsiiObject.jsiiStaticCall(Role.class, (String)"fromLookup", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public static IRole fromRoleArn(@NotNull Construct scope, @NotNull String id, @NotNull String roleArn, @Nullable FromRoleArnOptions options) {
        return (IRole)JsiiObject.jsiiStaticCall(Role.class, (String)"fromRoleArn", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(roleArn, "roleArn is required"), options});
    }

    @NotNull
    public static IRole fromRoleArn(@NotNull Construct scope, @NotNull String id, @NotNull String roleArn) {
        return (IRole)JsiiObject.jsiiStaticCall(Role.class, (String)"fromRoleArn", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(roleArn, "roleArn is required")});
    }

    @NotNull
    public static IRole fromRoleName(@NotNull Construct scope, @NotNull String id, @NotNull String roleName, @Nullable FromRoleNameOptions options) {
        return (IRole)JsiiObject.jsiiStaticCall(Role.class, (String)"fromRoleName", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(roleName, "roleName is required"), options});
    }

    @NotNull
    public static IRole fromRoleName(@NotNull Construct scope, @NotNull String id, @NotNull String roleName) {
        return (IRole)JsiiObject.jsiiStaticCall(Role.class, (String)"fromRoleName", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(roleName, "roleName is required")});
    }

    @NotNull
    public static Boolean isRole(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Role.class, (String)"isRole", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{x});
    }

    @Override
    public void addManagedPolicy(@NotNull IManagedPolicy policy) {
        Kernel.call((Object)this, (String)"addManagedPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @NotNull
    public Boolean addToPolicy(@NotNull PolicyStatement statement) {
        return (Boolean)Kernel.call((Object)this, (String)"addToPolicy", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public AddToPrincipalPolicyResult addToPrincipalPolicy(@NotNull PolicyStatement statement) {
        return (AddToPrincipalPolicyResult)Kernel.call((Object)this, (String)"addToPrincipalPolicy", (NativeType)NativeType.forClass(AddToPrincipalPolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    public void applyRemovalPolicy(@NotNull RemovalPolicy policy) {
        Kernel.call((Object)this, (String)"applyRemovalPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    public void attachInlinePolicy(@NotNull Policy policy) {
        Kernel.call((Object)this, (String)"attachInlinePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IPrincipal grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantAssumeRole(@NotNull IPrincipal identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantAssumeRole", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantPassRole(@NotNull IPrincipal identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPassRole", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @NotNull
    public IRole withoutPolicyUpdates(@Nullable WithoutPolicyUpdatesOptions options) {
        return (IRole)Kernel.call((Object)this, (String)"withoutPolicyUpdates", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{options});
    }

    @NotNull
    public IRole withoutPolicyUpdates() {
        return (IRole)Kernel.call((Object)this, (String)"withoutPolicyUpdates", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getAssumeRoleAction() {
        return (String)Kernel.get((Object)this, (String)"assumeRoleAction", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @Override
    @NotNull
    public PrincipalPolicyFragment getPolicyFragment() {
        return (PrincipalPolicyFragment)((Object)Kernel.get((Object)this, (String)"policyFragment", (NativeType)NativeType.forClass(PrincipalPolicyFragment.class)));
    }

    @Override
    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getRoleId() {
        return (String)Kernel.get((Object)this, (String)"roleId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRoleName() {
        return (String)Kernel.get((Object)this, (String)"roleName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public PolicyDocument getAssumeRolePolicy() {
        return (PolicyDocument)Kernel.get((Object)this, (String)"assumeRolePolicy", (NativeType)NativeType.forClass(PolicyDocument.class));
    }

    @Nullable
    public IManagedPolicy getPermissionsBoundary() {
        return (IManagedPolicy)Kernel.get((Object)this, (String)"permissionsBoundary", (NativeType)NativeType.forClass(IManagedPolicy.class));
    }

    @Override
    @Nullable
    public String getPrincipalAccount() {
        return (String)Kernel.get((Object)this, (String)"principalAccount", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Role> {
        private final Construct scope;
        private final String id;
        private final RoleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new RoleProps.Builder();
        }

        public Builder assumedBy(IPrincipal assumedBy) {
            this.props.assumedBy(assumedBy);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder externalIds(List<String> externalIds) {
            this.props.externalIds(externalIds);
            return this;
        }

        public Builder inlinePolicies(Map<String, ? extends PolicyDocument> inlinePolicies) {
            this.props.inlinePolicies(inlinePolicies);
            return this;
        }

        public Builder managedPolicies(List<? extends IManagedPolicy> managedPolicies) {
            this.props.managedPolicies(managedPolicies);
            return this;
        }

        public Builder maxSessionDuration(Duration maxSessionDuration) {
            this.props.maxSessionDuration(maxSessionDuration);
            return this;
        }

        public Builder path(String path) {
            this.props.path(path);
            return this;
        }

        public Builder permissionsBoundary(IManagedPolicy permissionsBoundary) {
            this.props.permissionsBoundary(permissionsBoundary);
            return this;
        }

        public Builder roleName(String roleName) {
            this.props.roleName(roleName);
            return this;
        }

        public Role build() {
            return new Role(this.scope, this.id, this.props.build());
        }
    }
}

