/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.kinesis.IStreamConsumer;
import software.amazon.awscdk.services.kinesis.StreamConsumerAttributes;
import software.amazon.awscdk.services.kinesis.StreamConsumerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesis.StreamConsumer")
public class StreamConsumer
extends Resource
implements IStreamConsumer {
    protected StreamConsumer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StreamConsumer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StreamConsumer(@NotNull Construct scope, @NotNull String id, @NotNull StreamConsumerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IStreamConsumer fromStreamConsumerArn(@NotNull Construct scope, @NotNull String id, @NotNull String streamConsumerArn) {
        return (IStreamConsumer)JsiiObject.jsiiStaticCall(StreamConsumer.class, (String)"fromStreamConsumerArn", (NativeType)NativeType.forClass(IStreamConsumer.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(streamConsumerArn, "streamConsumerArn is required")});
    }

    @NotNull
    public static IStreamConsumer fromStreamConsumerAttributes(@NotNull Construct scope, @NotNull String id, @NotNull StreamConsumerAttributes attrs) {
        return (IStreamConsumer)JsiiObject.jsiiStaticCall(StreamConsumer.class, (String)"fromStreamConsumerAttributes", (NativeType)NativeType.forClass(IStreamConsumer.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @NotNull
    protected Boolean getAutoCreatePolicy() {
        return (Boolean)Kernel.get((Object)this, (String)"autoCreatePolicy", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public IStream getStream() {
        return (IStream)Kernel.get((Object)this, (String)"stream", (NativeType)NativeType.forClass(IStream.class));
    }

    @Override
    @NotNull
    public String getStreamConsumerArn() {
        return (String)Kernel.get((Object)this, (String)"streamConsumerArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getStreamConsumerName() {
        return (String)Kernel.get((Object)this, (String)"streamConsumerName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<StreamConsumer> {
        private final Construct scope;
        private final String id;
        private final StreamConsumerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new StreamConsumerProps.Builder();
        }

        public Builder stream(IStream stream) {
            this.props.stream(stream);
            return this;
        }

        public Builder streamConsumerName(String streamConsumerName) {
            this.props.streamConsumerName(streamConsumerName);
            return this;
        }

        public StreamConsumer build() {
            return new StreamConsumer(this.scope, this.id, this.props.build());
        }
    }
}

