/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.scheduler.IScheduleGroup;
import software.amazon.awscdk.services.scheduler.ScheduleGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_scheduler.ScheduleGroup")
public class ScheduleGroup
extends Resource
implements IScheduleGroup {
    protected ScheduleGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduleGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ScheduleGroup(@NotNull Construct scope, @NotNull String id, @Nullable ScheduleGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ScheduleGroup(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IScheduleGroup fromDefaultScheduleGroup(@NotNull Construct scope, @NotNull String id) {
        return (IScheduleGroup)JsiiObject.jsiiStaticCall(ScheduleGroup.class, (String)"fromDefaultScheduleGroup", (NativeType)NativeType.forClass(IScheduleGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IScheduleGroup fromScheduleGroupArn(@NotNull Construct scope, @NotNull String id, @NotNull String scheduleGroupArn) {
        return (IScheduleGroup)JsiiObject.jsiiStaticCall(ScheduleGroup.class, (String)"fromScheduleGroupArn", (NativeType)NativeType.forClass(IScheduleGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(scheduleGroupArn, "scheduleGroupArn is required")});
    }

    @NotNull
    public static IScheduleGroup fromScheduleGroupName(@NotNull Construct scope, @NotNull String id, @NotNull String scheduleGroupName) {
        return (IScheduleGroup)JsiiObject.jsiiStaticCall(ScheduleGroup.class, (String)"fromScheduleGroupName", (NativeType)NativeType.forClass(IScheduleGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(scheduleGroupName, "scheduleGroupName is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantDeleteSchedules(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantDeleteSchedules", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantReadSchedules(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantReadSchedules", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Grant grantWriteSchedules(@NotNull IGrantable identity) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWriteSchedules", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required")}));
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricAttempts(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricAttempts", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricAttempts() {
        return (Metric)Kernel.call((Object)this, (String)"metricAttempts", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricDropped(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricDropped", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricDropped() {
        return (Metric)Kernel.call((Object)this, (String)"metricDropped", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricFailedToBeSentToDLQ(@Nullable String errorCode, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricFailedToBeSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{errorCode, props});
    }

    @Override
    @NotNull
    public Metric metricFailedToBeSentToDLQ(@Nullable String errorCode) {
        return (Metric)Kernel.call((Object)this, (String)"metricFailedToBeSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{errorCode});
    }

    @Override
    @NotNull
    public Metric metricFailedToBeSentToDLQ() {
        return (Metric)Kernel.call((Object)this, (String)"metricFailedToBeSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSentToDLQ(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSentToDLQ() {
        return (Metric)Kernel.call((Object)this, (String)"metricSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSentToDLQTruncated(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSentToDLQTruncated", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSentToDLQTruncated() {
        return (Metric)Kernel.call((Object)this, (String)"metricSentToDLQTruncated", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricTargetErrors(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTargetErrors() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricTargetThrottled(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTargetThrottled() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricThrottled(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricThrottled() {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getScheduleGroupArn() {
        return (String)Kernel.get((Object)this, (String)"scheduleGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getScheduleGroupName() {
        return (String)Kernel.get((Object)this, (String)"scheduleGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ScheduleGroup> {
        private final Construct scope;
        private final String id;
        private ScheduleGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder scheduleGroupName(String scheduleGroupName) {
            this.props().scheduleGroupName(scheduleGroupName);
            return this;
        }

        public ScheduleGroup build() {
            return new ScheduleGroup(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ScheduleGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new ScheduleGroupProps.Builder();
            }
            return this.props;
        }
    }
}

