package software.amazon.awscdk;

/**
 * Object respresenting an Aspect application.
 * <p>
 * Stores the Aspect, the pointer to the construct it was applied
 * to, and the priority value of that Aspect.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.constructs.*;
 * IAspect aspect;
 * Construct construct;
 * AspectApplication aspectApplication = new AspectApplication(construct, aspect, 123);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.AspectApplication")
public class AspectApplication extends software.amazon.jsii.JsiiObject {

    protected AspectApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AspectApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initializes AspectApplication object.
     * <p>
     * @param construct This parameter is required.
     * @param aspect This parameter is required.
     * @param priority This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AspectApplication(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IAspect aspect, final @org.jetbrains.annotations.NotNull java.lang.Number priority) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(construct, "construct is required"), java.util.Objects.requireNonNull(aspect, "aspect is required"), java.util.Objects.requireNonNull(priority, "priority is required") });
    }

    /**
     * The Aspect that was applied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IAspect getAspect() {
        return software.amazon.jsii.Kernel.get(this, "aspect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IAspect.class));
    }

    /**
     * The construct that the Aspect was applied to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.constructs.IConstruct getConstruct() {
        return software.amazon.jsii.Kernel.get(this, "construct", software.amazon.jsii.NativeType.forClass(software.constructs.IConstruct.class));
    }

    /**
     * Gets the priority value.
     * <p>
     * Sets the priority value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPriority() {
        return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Gets the priority value.
     * <p>
     * Sets the priority value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPriority(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "priority", java.util.Objects.requireNonNull(value, "priority is required"));
    }
}
