package software.amazon.awscdk;

/**
 * Represents a CloudFormation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * public class MyConstruct extends Resource implements ITaggable {
 *     public final Object tags;
 *     public MyConstruct(Construct scope, String id) {
 *         super(scope, id);
 *         CfnResource.Builder.create(this, "Resource")
 *                 .type("Whatever::The::Type")
 *                 .properties(Map.of(
 *                         // ...
 *                         "Tags", this.tags.getRenderedTags()))
 *                 .build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.607Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnResource")
public class CfnResource extends software.amazon.awscdk.CfnRefElement {

    protected CfnResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a resource construct.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Check whether the given object is a CfnResource.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnResource(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.CfnResource.class, "isCfnResource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Syntactic sugar for <code>addOverride(path, undefined)</code>.
     * <p>
     * @param path The path of the value to delete. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDeletionOverride(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        software.amazon.jsii.Kernel.call(this, "addDeletionOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Indicates that this resource depends on another resource and cannot be provisioned unless the other resource has been successfully provisioned.
     * <p>
     * This can be used for resources across stacks (or nested stack) boundaries
     * and the dependency will automatically be transferred to the relevant scope.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource target) {
        software.amazon.jsii.Kernel.call(this, "addDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (deprecated) Indicates that this resource depends on another resource and cannot be provisioned unless the other resource has been successfully provisioned.
     * <p>
     * @deprecated use addDependency
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void addDependsOn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource target) {
        software.amazon.jsii.Kernel.call(this, "addDependsOn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Add a value to the CloudFormation Resource Metadata.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/metadata-section-structure.html
     * Note that this is a different set of metadata from CDK node metadata; this
     * metadata ends up in the stack template under the resource, whereas CDK
     * node metadata ends up in the Cloud Assembly.">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/metadata-section-structure.html
     * Note that this is a different set of metadata from CDK node metadata; this
     * metadata ends up in the stack template under the resource, whereas CDK
     * node metadata ends up in the Cloud Assembly.</a>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMetadata(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "addMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Adds an override to the synthesized CloudFormation resource.
     * <p>
     * To add a
     * property override, either use <code>addPropertyOverride</code> or prefix <code>path</code> with
     * "Properties." (i.e. <code>Properties.TopicName</code>).
     * <p>
     * If the override is nested, separate each nested level using a dot (.) in the path parameter.
     * If there is an array as part of the nesting, specify the index in the path.
     * <p>
     * To include a literal <code>.</code> in the property name, prefix with a <code>\</code>. In most
     * programming languages you will need to write this as <code>"\\."</code> because the
     * <code>\</code> itself will need to be escaped.
     * <p>
     * For example,
     * <p>
     * <blockquote><pre>
     * cfnResource.addOverride("Properties.GlobalSecondaryIndexes.0.Projection.NonKeyAttributes", List.of("myattribute"));
     * cfnResource.addOverride("Properties.GlobalSecondaryIndexes.1.ProjectionType", "INCLUDE");
     * </pre></blockquote>
     * <p>
     * would add the overrides
     * <p>
     * <blockquote><pre>
     * "Properties": {
     *   "GlobalSecondaryIndexes": [
     *     {
     *       "Projection": {
     *         "NonKeyAttributes": [ "myattribute" ]
     *         ...
     *       }
     *       ...
     *     },
     *     {
     *       "ProjectionType": "INCLUDE"
     *       ...
     *     },
     *   ]
     *   ...
     * }
     * </pre></blockquote>
     * <p>
     * The <code>value</code> argument to <code>addOverride</code> will not be processed or translated
     * in any way. Pass raw JSON values in here with the correct capitalization
     * for CloudFormation. If you pass CDK classes or structs, they will be
     * rendered with lowercased key names, and CloudFormation will reject the
     * template.
     * <p>
     * @param path <ul><li>The path of the property, you can use dot notation to override values in complex types.</li></ul> This parameter is required.
     * @param value <ul><li>The value.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addOverride(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "addOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), value });
    }

    /**
     * Adds an override that deletes the value of a property from the resource definition.
     * <p>
     * @param propertyPath The path to the property. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPropertyDeletionOverride(final @org.jetbrains.annotations.NotNull java.lang.String propertyPath) {
        software.amazon.jsii.Kernel.call(this, "addPropertyDeletionOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(propertyPath, "propertyPath is required") });
    }

    /**
     * Adds an override to a resource property.
     * <p>
     * Syntactic sugar for <code>addOverride("Properties.&lt;...&gt;", value)</code>.
     * <p>
     * @param propertyPath The path of the property. This parameter is required.
     * @param value The value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPropertyOverride(final @org.jetbrains.annotations.NotNull java.lang.String propertyPath, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "addPropertyOverride", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(propertyPath, "propertyPath is required"), value });
    }

    /**
     * Sets the deletion policy of the resource based on the removal policy specified.
     * <p>
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     * <p>
     * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
     * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>). In some
     * cases, a snapshot can be taken of the resource prior to deletion
     * (<code>RemovalPolicy.SNAPSHOT</code>). A list of resources that support this policy
     * can be found in the following link:
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options</a>
     * @param policy
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyRemovalPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy policy, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyOptions options) {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { policy, options });
    }

    /**
     * Sets the deletion policy of the resource based on the removal policy specified.
     * <p>
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     * <p>
     * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
     * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>). In some
     * cases, a snapshot can be taken of the resource prior to deletion
     * (<code>RemovalPolicy.SNAPSHOT</code>). A list of resources that support this policy
     * can be found in the following link:
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options</a>
     * @param policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyRemovalPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { policy });
    }

    /**
     * Sets the deletion policy of the resource based on the removal policy specified.
     * <p>
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     * <p>
     * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
     * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>). In some
     * cases, a snapshot can be taken of the resource prior to deletion
     * (<code>RemovalPolicy.SNAPSHOT</code>). A list of resources that support this policy
     * can be found in the following link:
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyRemovalPolicy() {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Returns a token for an runtime attribute of this resource.
     * <p>
     * Ideally, use generated attribute accessors (e.g. <code>resource.arn</code>), but this can be used for future compatibility
     * in case there is no generated attribute.
     * <p>
     * @param attributeName The name of the attribute. This parameter is required.
     * @param typeHint
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.ResolutionTypeHint typeHint) {
        return software.amazon.jsii.Kernel.call(this, "getAtt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Reference.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required"), typeHint });
    }

    /**
     * Returns a token for an runtime attribute of this resource.
     * <p>
     * Ideally, use generated attribute accessors (e.g. <code>resource.arn</code>), but this can be used for future compatibility
     * in case there is no generated attribute.
     * <p>
     * @param attributeName The name of the attribute. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Reference getAtt(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.Kernel.call(this, "getAtt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Reference.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * Retrieve a value value from the CloudFormation Resource Metadata.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/metadata-section-structure.html
     * Note that this is a different set of metadata from CDK node metadata; this
     * metadata ends up in the stack template under the resource, whereas CDK
     * node metadata ends up in the Cloud Assembly.">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/metadata-section-structure.html
     * Note that this is a different set of metadata from CDK node metadata; this
     * metadata ends up in the stack template under the resource, whereas CDK
     * node metadata ends up in the Cloud Assembly.</a>
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMetadata(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.Kernel.call(this, "getMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Retrieves an array of resources this resource depends on.
     * <p>
     * This assembles dependencies on resources across stacks (including nested stacks)
     * automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> obtainDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "obtainDependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Get a shallow copy of dependencies between this resource and other resources in the same stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.CfnResource> obtainResourceDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "obtainResourceDependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnResource.class))));
    }

    /**
     * Indicates that this resource no longer depends on another resource.
     * <p>
     * This can be used for resources across stacks (including nested stacks)
     * and the dependency will automatically be removed from the relevant scope.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void removeDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource target) {
        software.amazon.jsii.Kernel.call(this, "removeDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * Replaces one dependency with another.
     * <p>
     * @param target The dependency to replace. This parameter is required.
     * @param newTarget The new dependency to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void replaceDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource newTarget) {
        software.amazon.jsii.Kernel.call(this, "replaceDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(newTarget, "newTarget is required") });
    }

    /**
     * Can be overridden by subclasses to determine if this resource will be rendered into the cloudformation template.
     * <p>
     * @return <code>true</code> if the resource should be included or <code>false</code> is the resource
     * should be omitted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean shouldSynthesize() {
        return software.amazon.jsii.Kernel.call(this, "shouldSynthesize", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Returns a string representation of this construct.
     * <p>
     * @return a string representation of this resource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param _properties This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void validateProperties(final @org.jetbrains.annotations.NotNull java.lang.Object _properties) {
        software.amazon.jsii.Kernel.call(this, "validateProperties", software.amazon.jsii.NativeType.VOID, new Object[] { _properties });
    }

    /**
     * Options for this resource, such as condition, update policy etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.ICfnResourceOptions getCfnOptions() {
        return software.amazon.jsii.Kernel.get(this, "cfnOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ICfnResourceOptions.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * AWS resource type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCfnResourceType() {
        return software.amazon.jsii.Kernel.get(this, "cfnResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) Deprecated.
     * <p>
     * @deprecated use <code>updatedProperties</code>
     * <p>
     * Return properties modified after initiation
     * <p>
     * Resources that expose mutable properties should override this function to
     * collect and return the properties object for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getUpdatedProperites() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "updatedProperites", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Return properties modified after initiation.
     * <p>
     * Resources that expose mutable properties should override this function to
     * collect and return the properties object for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getUpdatedProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "updatedProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.CfnResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.CfnResource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.CfnResourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.CfnResourceProps.Builder();
        }

        /**
         * CloudFormation resource type (e.g. <code>AWS::S3::Bucket</code>).
         * <p>
         * @return {@code this}
         * @param type CloudFormation resource type (e.g. <code>AWS::S3::Bucket</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Resource properties.
         * <p>
         * Default: - No resource properties.
         * <p>
         * @return {@code this}
         * @param properties Resource properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
            this.props.properties(properties);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.CfnResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.CfnResource build() {
            return new software.amazon.awscdk.CfnResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
