package software.amazon.awscdk;

/**
 * Represents a length of time.
 * <p>
 * The amount can be specified either as a literal value (e.g: <code>10</code>) which
 * cannot be negative, or as an unresolved number token.
 * <p>
 * When the amount is passed as a token, unit conversion is not possible.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role myRole;
 * AwsCustomResource.Builder.create(this, "Customized")
 *         .role(myRole) // must be assumable by the `lambda.amazonaws.com` service principal
 *         .timeout(Duration.minutes(10)) // defaults to 2 minutes
 *         .memorySize(1025) // defaults to 512 if installLatestAwsSdk is true
 *         .logGroup(LogGroup.Builder.create(this, "AwsCustomResourceLogs")
 *                 .retention(RetentionDays.ONE_DAY)
 *                 .build())
 *         .functionName("my-custom-name") // defaults to a CloudFormation generated name
 *         .removalPolicy(RemovalPolicy.RETAIN) // defaults to `RemovalPolicy.DESTROY`
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.683Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Duration")
public class Duration extends software.amazon.jsii.JsiiObject {

    protected Duration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Duration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a Duration representing an amount of days.
     * <p>
     * @return a new <code>Duration</code> representing <code>amount</code> Days.
     * @param amount the amount of Days the <code>Duration</code> will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration days(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Duration.class, "days", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of hours.
     * <p>
     * @return a new <code>Duration</code> representing <code>amount</code> Hours.
     * @param amount the amount of Hours the <code>Duration</code> will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration hours(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Duration.class, "hours", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of milliseconds.
     * <p>
     * @return a new <code>Duration</code> representing <code>amount</code> ms.
     * @param amount the amount of Milliseconds the <code>Duration</code> will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration millis(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Duration.class, "millis", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Duration representing an amount of minutes.
     * <p>
     * @return a new <code>Duration</code> representing <code>amount</code> Minutes.
     * @param amount the amount of Minutes the <code>Duration</code> will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration minutes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Duration.class, "minutes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Parse a period formatted according to the ISO 8601 standard.
     * <p>
     * Days are the largest ISO duration supported, i.e.,
     * weeks, months, and years are not supported.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // This represents 1 day, 2 hours, 3 minutes, 4 seconds, and 567 milliseconds.
     * "P1DT2H3M4.567S";
     * </pre></blockquote>
     * <p>
     * @return the parsed <code>Duration</code>.
     * @see <a href="https://www.iso.org/standard/70907.html">https://www.iso.org/standard/70907.html</a>
     * @param duration an ISO-formatted duration to be parsed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration parse(final @org.jetbrains.annotations.NotNull java.lang.String duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Duration.class, "parse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Create a Duration representing an amount of seconds.
     * <p>
     * @return a new <code>Duration</code> representing <code>amount</code> Seconds.
     * @param amount the amount of Seconds the <code>Duration</code> will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration seconds(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Duration.class, "seconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Returns stringified number of duration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String formatTokenToNumber() {
        return software.amazon.jsii.Kernel.call(this, "formatTokenToNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Checks if duration is a token or a resolvable object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isUnresolved() {
        return software.amazon.jsii.Kernel.call(this, "isUnresolved", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Substract two Durations together.
     * <p>
     * @param rhs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration minus(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration rhs) {
        return software.amazon.jsii.Kernel.call(this, "minus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(rhs, "rhs is required") });
    }

    /**
     * Add two Durations together.
     * <p>
     * @param rhs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration plus(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration rhs) {
        return software.amazon.jsii.Kernel.call(this, "plus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class), new Object[] { java.util.Objects.requireNonNull(rhs, "rhs is required") });
    }

    /**
     * Return the total number of days in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Days.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toDays(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of days in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toDays() {
        return software.amazon.jsii.Kernel.call(this, "toDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return the total number of hours in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Hours.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toHours(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of hours in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toHours() {
        return software.amazon.jsii.Kernel.call(this, "toHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Turn this duration into a human-readable string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toHumanString() {
        return software.amazon.jsii.Kernel.call(this, "toHumanString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return an ISO 8601 representation of this period.
     * <p>
     * @return a string starting with 'P' describing the period
     * @see <a href="https://www.iso.org/standard/70907.html">https://www.iso.org/standard/70907.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toIsoString() {
        return software.amazon.jsii.Kernel.call(this, "toIsoString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the total number of milliseconds in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Milliseconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMilliseconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of milliseconds in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMilliseconds() {
        return software.amazon.jsii.Kernel.call(this, "toMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return the total number of minutes in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Minutes.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMinutes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of minutes in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMinutes() {
        return software.amazon.jsii.Kernel.call(this, "toMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return the total number of seconds in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Seconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toSeconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return the total number of seconds in this Duration.
     * <p>
     * @return the value of this <code>Duration</code> expressed in Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toSeconds() {
        return software.amazon.jsii.Kernel.call(this, "toSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Returns a string representation of this <code>Duration</code>.
     * <p>
     * This is is never the right function to use when you want to use the <code>Duration</code>
     * object in a template. Use <code>toSeconds()</code>, <code>toMinutes()</code>, <code>toDays()</code>, etc. instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns unit of the duration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String unitLabel() {
        return software.amazon.jsii.Kernel.call(this, "unitLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
