package software.amazon.awscdk;

/**
 * The location of the published file asset.
 * <p>
 * This is where the asset
 * can be consumed at runtime.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * FileAssetLocation fileAssetLocation = FileAssetLocation.builder()
 *         .bucketName("bucketName")
 *         .httpUrl("httpUrl")
 *         .objectKey("objectKey")
 *         .s3ObjectUrl("s3ObjectUrl")
 *         // the properties below are optional
 *         .kmsKeyArn("kmsKeyArn")
 *         .s3ObjectUrlWithPlaceholders("s3ObjectUrlWithPlaceholders")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.686Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.FileAssetLocation")
@software.amazon.jsii.Jsii.Proxy(FileAssetLocation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileAssetLocation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The HTTP URL of this asset on Amazon S3.
     * <p>
     * This value suitable for inclusion in a CloudFormation template, and
     * may be an encoded token.
     * <p>
     * Example value: <code>https://s3-us-east-1.amazonaws.com/mybucket/myobject</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpUrl();

    /**
     * The Amazon S3 object key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

    /**
     * The S3 URL of this asset on Amazon S3.
     * <p>
     * This value suitable for inclusion in a CloudFormation template, and
     * may be an encoded token.
     * <p>
     * Example value: <code>s3://mybucket/myobject</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectUrl();

    /**
     * The ARN of the KMS key used to encrypt the file asset bucket, if any.
     * <p>
     * The CDK bootstrap stack comes with a key policy that does not require
     * setting this property, so you only need to set this property if you
     * have customized the bootstrap stack to require it.
     * <p>
     * Default: - Asset bucket is not encrypted, or decryption permissions are
     * defined by a Key Policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * Like <code>s3ObjectUrl</code>, but not suitable for CloudFormation consumption.
     * <p>
     * If there are placeholders in the S3 URL, they will be returned un-replaced
     * and un-evaluated.
     * <p>
     * Default: - This feature cannot be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectUrlWithPlaceholders() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileAssetLocation> {
        java.lang.String bucketName;
        java.lang.String httpUrl;
        java.lang.String objectKey;
        java.lang.String s3ObjectUrl;
        java.lang.String kmsKeyArn;
        java.lang.String s3ObjectUrlWithPlaceholders;

        /**
         * Sets the value of {@link FileAssetLocation#getBucketName}
         * @param bucketName The name of the Amazon S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getHttpUrl}
         * @param httpUrl The HTTP URL of this asset on Amazon S3. This parameter is required.
         *                This value suitable for inclusion in a CloudFormation template, and
         *                may be an encoded token.
         *                <p>
         *                Example value: <code>https://s3-us-east-1.amazonaws.com/mybucket/myobject</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpUrl(java.lang.String httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getObjectKey}
         * @param objectKey The Amazon S3 object key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKey(java.lang.String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getS3ObjectUrl}
         * @param s3ObjectUrl The S3 URL of this asset on Amazon S3. This parameter is required.
         *                    This value suitable for inclusion in a CloudFormation template, and
         *                    may be an encoded token.
         *                    <p>
         *                    Example value: <code>s3://mybucket/myobject</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ObjectUrl(java.lang.String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getKmsKeyArn}
         * @param kmsKeyArn The ARN of the KMS key used to encrypt the file asset bucket, if any.
         *                  The CDK bootstrap stack comes with a key policy that does not require
         *                  setting this property, so you only need to set this property if you
         *                  have customized the bootstrap stack to require it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetLocation#getS3ObjectUrlWithPlaceholders}
         * @param s3ObjectUrlWithPlaceholders Like <code>s3ObjectUrl</code>, but not suitable for CloudFormation consumption.
         *                                    If there are placeholders in the S3 URL, they will be returned un-replaced
         *                                    and un-evaluated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ObjectUrlWithPlaceholders(java.lang.String s3ObjectUrlWithPlaceholders) {
            this.s3ObjectUrlWithPlaceholders = s3ObjectUrlWithPlaceholders;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAssetLocation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileAssetLocation build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileAssetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAssetLocation {
        private final java.lang.String bucketName;
        private final java.lang.String httpUrl;
        private final java.lang.String objectKey;
        private final java.lang.String s3ObjectUrl;
        private final java.lang.String kmsKeyArn;
        private final java.lang.String s3ObjectUrlWithPlaceholders;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpUrl = software.amazon.jsii.Kernel.get(this, "httpUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectKey = software.amazon.jsii.Kernel.get(this, "objectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3ObjectUrl = software.amazon.jsii.Kernel.get(this, "s3ObjectUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3ObjectUrlWithPlaceholders = software.amazon.jsii.Kernel.get(this, "s3ObjectUrlWithPlaceholders", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            this.httpUrl = java.util.Objects.requireNonNull(builder.httpUrl, "httpUrl is required");
            this.objectKey = java.util.Objects.requireNonNull(builder.objectKey, "objectKey is required");
            this.s3ObjectUrl = java.util.Objects.requireNonNull(builder.s3ObjectUrl, "s3ObjectUrl is required");
            this.kmsKeyArn = builder.kmsKeyArn;
            this.s3ObjectUrlWithPlaceholders = builder.s3ObjectUrlWithPlaceholders;
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.String getHttpUrl() {
            return this.httpUrl;
        }

        @Override
        public final java.lang.String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public final java.lang.String getS3ObjectUrl() {
            return this.s3ObjectUrl;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.String getS3ObjectUrlWithPlaceholders() {
            return this.s3ObjectUrlWithPlaceholders;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucketName", om.valueToTree(this.getBucketName()));
            data.set("httpUrl", om.valueToTree(this.getHttpUrl()));
            data.set("objectKey", om.valueToTree(this.getObjectKey()));
            data.set("s3ObjectUrl", om.valueToTree(this.getS3ObjectUrl()));
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getS3ObjectUrlWithPlaceholders() != null) {
                data.set("s3ObjectUrlWithPlaceholders", om.valueToTree(this.getS3ObjectUrlWithPlaceholders()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.FileAssetLocation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileAssetLocation.Jsii$Proxy that = (FileAssetLocation.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            if (!httpUrl.equals(that.httpUrl)) return false;
            if (!objectKey.equals(that.objectKey)) return false;
            if (!s3ObjectUrl.equals(that.s3ObjectUrl)) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            return this.s3ObjectUrlWithPlaceholders != null ? this.s3ObjectUrlWithPlaceholders.equals(that.s3ObjectUrlWithPlaceholders) : that.s3ObjectUrlWithPlaceholders == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.httpUrl.hashCode());
            result = 31 * result + (this.objectKey.hashCode());
            result = 31 * result + (this.s3ObjectUrl.hashCode());
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.s3ObjectUrlWithPlaceholders != null ? this.s3ObjectUrlWithPlaceholders.hashCode() : 0);
            return result;
        }
    }
}
