package software.amazon.awscdk;

/**
 * Resource violating a specific rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * PolicyViolatingResourceBeta1 policyViolatingResourceBeta1 = PolicyViolatingResourceBeta1.builder()
 *         .locations(List.of("locations"))
 *         .resourceLogicalId("resourceLogicalId")
 *         .templatePath("templatePath")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.732Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.PolicyViolatingResourceBeta1")
@software.amazon.jsii.Jsii.Proxy(PolicyViolatingResourceBeta1.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyViolatingResourceBeta1 extends software.amazon.jsii.JsiiSerializable {

    /**
     * The locations in the CloudFormation template that pose the violations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLocations();

    /**
     * The logical ID of the resource in the CloudFormation template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceLogicalId();

    /**
     * The path to the CloudFormation template that contains this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplatePath();

    /**
     * @return a {@link Builder} of {@link PolicyViolatingResourceBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyViolatingResourceBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyViolatingResourceBeta1> {
        java.util.List<java.lang.String> locations;
        java.lang.String resourceLogicalId;
        java.lang.String templatePath;

        /**
         * Sets the value of {@link PolicyViolatingResourceBeta1#getLocations}
         * @param locations The locations in the CloudFormation template that pose the violations. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(java.util.List<java.lang.String> locations) {
            this.locations = locations;
            return this;
        }

        /**
         * Sets the value of {@link PolicyViolatingResourceBeta1#getResourceLogicalId}
         * @param resourceLogicalId The logical ID of the resource in the CloudFormation template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceLogicalId(java.lang.String resourceLogicalId) {
            this.resourceLogicalId = resourceLogicalId;
            return this;
        }

        /**
         * Sets the value of {@link PolicyViolatingResourceBeta1#getTemplatePath}
         * @param templatePath The path to the CloudFormation template that contains this resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templatePath(java.lang.String templatePath) {
            this.templatePath = templatePath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyViolatingResourceBeta1}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyViolatingResourceBeta1 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PolicyViolatingResourceBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyViolatingResourceBeta1 {
        private final java.util.List<java.lang.String> locations;
        private final java.lang.String resourceLogicalId;
        private final java.lang.String templatePath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.locations = software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resourceLogicalId = software.amazon.jsii.Kernel.get(this, "resourceLogicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templatePath = software.amazon.jsii.Kernel.get(this, "templatePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.locations = java.util.Objects.requireNonNull(builder.locations, "locations is required");
            this.resourceLogicalId = java.util.Objects.requireNonNull(builder.resourceLogicalId, "resourceLogicalId is required");
            this.templatePath = java.util.Objects.requireNonNull(builder.templatePath, "templatePath is required");
        }

        @Override
        public final java.util.List<java.lang.String> getLocations() {
            return this.locations;
        }

        @Override
        public final java.lang.String getResourceLogicalId() {
            return this.resourceLogicalId;
        }

        @Override
        public final java.lang.String getTemplatePath() {
            return this.templatePath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("locations", om.valueToTree(this.getLocations()));
            data.set("resourceLogicalId", om.valueToTree(this.getResourceLogicalId()));
            data.set("templatePath", om.valueToTree(this.getTemplatePath()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.PolicyViolatingResourceBeta1"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyViolatingResourceBeta1.Jsii$Proxy that = (PolicyViolatingResourceBeta1.Jsii$Proxy) o;

            if (!locations.equals(that.locations)) return false;
            if (!resourceLogicalId.equals(that.resourceLogicalId)) return false;
            return this.templatePath.equals(that.templatePath);
        }

        @Override
        public final int hashCode() {
            int result = this.locations.hashCode();
            result = 31 * result + (this.resourceLogicalId.hashCode());
            result = 31 * result + (this.templatePath.hashCode());
            return result;
        }
    }
}
