package software.amazon.awscdk;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * RemovalPolicyOptions removalPolicyOptions = RemovalPolicyOptions.builder()
 *         .applyToUpdateReplacePolicy(false)
 *         .default(RemovalPolicy.DESTROY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.735Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.RemovalPolicyOptions")
@software.amazon.jsii.Jsii.Proxy(RemovalPolicyOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RemovalPolicyOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Apply the same deletion policy to the resource's "UpdateReplacePolicy".
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApplyToUpdateReplacePolicy() {
        return null;
    }

    /**
     * The default policy to apply in case the removal policy is not defined.
     * <p>
     * Default: - Default value is resource specific. To determine the default value for a resource,
     * please consult that specific resource's documentation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getDefaultValue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RemovalPolicyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RemovalPolicyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RemovalPolicyOptions> {
        java.lang.Boolean applyToUpdateReplacePolicy;
        software.amazon.awscdk.RemovalPolicy defaultValue;

        /**
         * Sets the value of {@link RemovalPolicyOptions#getApplyToUpdateReplacePolicy}
         * @param applyToUpdateReplacePolicy Apply the same deletion policy to the resource's "UpdateReplacePolicy".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyToUpdateReplacePolicy(java.lang.Boolean applyToUpdateReplacePolicy) {
            this.applyToUpdateReplacePolicy = applyToUpdateReplacePolicy;
            return this;
        }

        /**
         * Sets the value of {@link RemovalPolicyOptions#getDefaultValue}
         * @param defaultValue The default policy to apply in case the removal policy is not defined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(software.amazon.awscdk.RemovalPolicy defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RemovalPolicyOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RemovalPolicyOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RemovalPolicyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RemovalPolicyOptions {
        private final java.lang.Boolean applyToUpdateReplacePolicy;
        private final software.amazon.awscdk.RemovalPolicy defaultValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applyToUpdateReplacePolicy = software.amazon.jsii.Kernel.get(this, "applyToUpdateReplacePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.defaultValue = software.amazon.jsii.Kernel.get(this, "default", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applyToUpdateReplacePolicy = builder.applyToUpdateReplacePolicy;
            this.defaultValue = builder.defaultValue;
        }

        @Override
        public final java.lang.Boolean getApplyToUpdateReplacePolicy() {
            return this.applyToUpdateReplacePolicy;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApplyToUpdateReplacePolicy() != null) {
                data.set("applyToUpdateReplacePolicy", om.valueToTree(this.getApplyToUpdateReplacePolicy()));
            }
            if (this.getDefaultValue() != null) {
                data.set("default", om.valueToTree(this.getDefaultValue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.RemovalPolicyOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RemovalPolicyOptions.Jsii$Proxy that = (RemovalPolicyOptions.Jsii$Proxy) o;

            if (this.applyToUpdateReplacePolicy != null ? !this.applyToUpdateReplacePolicy.equals(that.applyToUpdateReplacePolicy) : that.applyToUpdateReplacePolicy != null) return false;
            return this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applyToUpdateReplacePolicy != null ? this.applyToUpdateReplacePolicy.hashCode() : 0;
            result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            return result;
        }
    }
}
