package software.amazon.awscdk.pipelines;

/**
 * A manual approval step.
 * <p>
 * If this step is added to a Pipeline, the Pipeline will
 * be paused waiting for a human to resume it
 * <p>
 * Only engines that support pausing the deployment will
 * support this step type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * MyApplicationStage preprod = new MyApplicationStage(this, "PreProd");
 * MyApplicationStage prod = new MyApplicationStage(this, "Prod");
 * pipeline.addStage(preprod, AddStageOpts.builder()
 *         .post(List.of(
 *             ShellStep.Builder.create("Validate Endpoint")
 *                     .commands(List.of("curl -Ssf https://my.webservice.com/"))
 *                     .build()))
 *         .build());
 * pipeline.addStage(prod, AddStageOpts.builder()
 *         .pre(List.of(new ManualApprovalStep("PromoteToProd")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:58.241Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ManualApprovalStep")
public class ManualApprovalStep extends software.amazon.awscdk.pipelines.Step {

    protected ManualApprovalStep(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManualApprovalStep(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Identifier for this step. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManualApprovalStep(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.ManualApprovalStepProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param id Identifier for this step. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManualApprovalStep(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The comment associated with this manual approval.
     * <p>
     * Default: - No comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.pipelines.ManualApprovalStep}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.ManualApprovalStep> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id Identifier for this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private software.amazon.awscdk.pipelines.ManualApprovalStepProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
        }

        /**
         * The comment to display with this manual approval.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment The comment to display with this manual approval. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.pipelines.ManualApprovalStep}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.pipelines.ManualApprovalStep build() {
            return new software.amazon.awscdk.pipelines.ManualApprovalStep(
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.pipelines.ManualApprovalStepProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.pipelines.ManualApprovalStepProps.Builder();
            }
            return this.props;
        }
    }
}
