package software.amazon.awscdk.services.amplify;

/**
 * The AWS::Amplify::App resource specifies Apps in Amplify Hosting.
 * <p>
 * An App is a collection of branches.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * CfnApp cfnApp = CfnApp.Builder.create(this, "MyCfnApp")
 *         .name("name")
 *         // the properties below are optional
 *         .accessToken("accessToken")
 *         .autoBranchCreationConfig(AutoBranchCreationConfigProperty.builder()
 *                 .autoBranchCreationPatterns(List.of("autoBranchCreationPatterns"))
 *                 .basicAuthConfig(BasicAuthConfigProperty.builder()
 *                         .enableBasicAuth(false)
 *                         .password("password")
 *                         .username("username")
 *                         .build())
 *                 .buildSpec("buildSpec")
 *                 .enableAutoBranchCreation(false)
 *                 .enableAutoBuild(false)
 *                 .enablePerformanceMode(false)
 *                 .enablePullRequestPreview(false)
 *                 .environmentVariables(List.of(EnvironmentVariableProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .framework("framework")
 *                 .pullRequestEnvironmentName("pullRequestEnvironmentName")
 *                 .stage("stage")
 *                 .build())
 *         .basicAuthConfig(BasicAuthConfigProperty.builder()
 *                 .enableBasicAuth(false)
 *                 .password("password")
 *                 .username("username")
 *                 .build())
 *         .buildSpec("buildSpec")
 *         .cacheConfig(CacheConfigProperty.builder()
 *                 .type("type")
 *                 .build())
 *         .computeRoleArn("computeRoleArn")
 *         .customHeaders("customHeaders")
 *         .customRules(List.of(CustomRuleProperty.builder()
 *                 .source("source")
 *                 .target("target")
 *                 // the properties below are optional
 *                 .condition("condition")
 *                 .status("status")
 *                 .build()))
 *         .description("description")
 *         .enableBranchAutoDeletion(false)
 *         .environmentVariables(List.of(EnvironmentVariableProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .iamServiceRole("iamServiceRole")
 *         .oauthToken("oauthToken")
 *         .platform("platform")
 *         .repository("repository")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.881Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnApp")
public class CfnApp extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnApp(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApp(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.amplify.CfnApp.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApp(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.CfnAppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Unique Id for the Amplify App.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAppId() {
        return software.amazon.jsii.Kernel.get(this, "attrAppId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name for the Amplify App.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAppName() {
        return software.amazon.jsii.Kernel.get(this, "attrAppName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ARN for the Amplify App.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Default domain for the Amplify App.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDefaultDomain() {
        return software.amazon.jsii.Kernel.get(this, "attrDefaultDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The personal access token for a GitHub repository for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
        return software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The personal access token for a GitHub repository for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessToken(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessToken", value);
    }

    /**
     * Sets the configuration for your automatic branch creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoBranchCreationConfig() {
        return software.amazon.jsii.Kernel.get(this, "autoBranchCreationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Sets the configuration for your automatic branch creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoBranchCreationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoBranchCreationConfig", value);
    }

    /**
     * Sets the configuration for your automatic branch creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoBranchCreationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.CfnApp.AutoBranchCreationConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoBranchCreationConfig", value);
    }

    /**
     * The credentials for basic authorization for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthConfig() {
        return software.amazon.jsii.Kernel.get(this, "basicAuthConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The credentials for basic authorization for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBasicAuthConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "basicAuthConfig", value);
    }

    /**
     * The credentials for basic authorization for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBasicAuthConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.CfnApp.BasicAuthConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "basicAuthConfig", value);
    }

    /**
     * The build specification (build spec) for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBuildSpec() {
        return software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The build specification (build spec) for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBuildSpec(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "buildSpec", value);
    }

    /**
     * The cache configuration for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCacheConfig() {
        return software.amazon.jsii.Kernel.get(this, "cacheConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The cache configuration for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cacheConfig", value);
    }

    /**
     * The cache configuration for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.CfnApp.CacheConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "cacheConfig", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role for an SSR app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComputeRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "computeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role for an SSR app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "computeRoleArn", value);
    }

    /**
     * The custom HTTP headers for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomHeaders() {
        return software.amazon.jsii.Kernel.get(this, "customHeaders", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The custom HTTP headers for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomHeaders(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customHeaders", value);
    }

    /**
     * The custom rewrite and redirect rules for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomRules() {
        return software.amazon.jsii.Kernel.get(this, "customRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The custom rewrite and redirect rules for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customRules", value);
    }

    /**
     * The custom rewrite and redirect rules for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplify.CfnApp.CustomRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplify.CfnApp.CustomRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "customRules", value);
    }

    /**
     * The description of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableBranchAutoDeletion() {
        return software.amazon.jsii.Kernel.get(this, "enableBranchAutoDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableBranchAutoDeletion(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableBranchAutoDeletion", value);
    }

    /**
     * Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableBranchAutoDeletion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableBranchAutoDeletion", value);
    }

    /**
     * The environment variables for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
        return software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The environment variables for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentVariables(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "environmentVariables", value);
    }

    /**
     * The environment variables for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentVariables(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplify.CfnApp.EnvironmentVariableProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplify.CfnApp.EnvironmentVariableProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "environmentVariables", value);
    }

    /**
     * AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIamServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "iamServiceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamServiceRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "iamServiceRole", value);
    }

    /**
     * The OAuth token for a third-party source control system for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOauthToken() {
        return software.amazon.jsii.Kernel.get(this, "oauthToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The OAuth token for a third-party source control system for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOauthToken(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "oauthToken", value);
    }

    /**
     * The platform for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlatform() {
        return software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The platform for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatform(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "platform", value);
    }

    /**
     * The Git repository for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Git repository for the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepository(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "repository", value);
    }

    /**
     * The tag for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tag for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Use the AutoBranchCreationConfig property type to automatically create branches that match a certain pattern.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * AutoBranchCreationConfigProperty autoBranchCreationConfigProperty = AutoBranchCreationConfigProperty.builder()
     *         .autoBranchCreationPatterns(List.of("autoBranchCreationPatterns"))
     *         .basicAuthConfig(BasicAuthConfigProperty.builder()
     *                 .enableBasicAuth(false)
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .buildSpec("buildSpec")
     *         .enableAutoBranchCreation(false)
     *         .enableAutoBuild(false)
     *         .enablePerformanceMode(false)
     *         .enablePullRequestPreview(false)
     *         .environmentVariables(List.of(EnvironmentVariableProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .framework("framework")
     *         .pullRequestEnvironmentName("pullRequestEnvironmentName")
     *         .stage("stage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnApp.AutoBranchCreationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoBranchCreationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoBranchCreationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Automated branch creation glob patterns for the Amplify app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-autobranchcreationpatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-autobranchcreationpatterns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoBranchCreationPatterns() {
            return null;
        }

        /**
         * Sets password protection for your auto created branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-basicauthconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-basicauthconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthConfig() {
            return null;
        }

        /**
         * The build specification (build spec) for the autocreated branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-buildspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-buildspec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBuildSpec() {
            return null;
        }

        /**
         * Enables automated branch creation for the Amplify app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobranchcreation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobranchcreation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableAutoBranchCreation() {
            return null;
        }

        /**
         * Enables auto building for the auto created branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobuild">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobuild</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableAutoBuild() {
            return null;
        }

        /**
         * Enables performance mode for the branch.
         * <p>
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableperformancemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableperformancemode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePerformanceMode() {
            return null;
        }

        /**
         * Sets whether pull request previews are enabled for each branch that Amplify Hosting automatically creates for your app.
         * <p>
         * Amplify creates previews by deploying your app to a unique URL whenever a pull request is opened for the branch. Development and QA teams can use this preview to test the pull request before it's merged into a production or integration branch.
         * <p>
         * To provide backend support for your preview, Amplify Hosting automatically provisions a temporary backend environment that it deletes when the pull request is closed. If you want to specify a dedicated backend environment for your previews, use the <code>PullRequestEnvironmentName</code> property.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/pr-previews.html">Web Previews</a> in the <em>AWS Amplify Hosting User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enablepullrequestpreview">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enablepullrequestpreview</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePullRequestPreview() {
            return null;
        }

        /**
         * The environment variables for the autocreated branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-environmentvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
            return null;
        }

        /**
         * The framework for the autocreated branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-framework">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-framework</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFramework() {
            return null;
        }

        /**
         * If pull request previews are enabled, you can use this property to specify a dedicated backend environment for your previews.
         * <p>
         * For example, you could specify an environment named <code>prod</code> , <code>test</code> , or <code>dev</code> that you initialized with the Amplify CLI.
         * <p>
         * To enable pull request previews, set the <code>EnablePullRequestPreview</code> property to <code>true</code> .
         * <p>
         * If you don't specify an environment, Amplify Hosting provides backend support for each preview by automatically provisioning a temporary backend environment. Amplify deletes this environment when the pull request is closed.
         * <p>
         * For more information about creating backend environments, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/multi-environments.html">Feature Branch Deployments and Team Workflows</a> in the <em>AWS Amplify Hosting User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-pullrequestenvironmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-pullrequestenvironmentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPullRequestEnvironmentName() {
            return null;
        }

        /**
         * Stage for the auto created branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-stage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-stage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoBranchCreationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoBranchCreationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoBranchCreationConfigProperty> {
            java.util.List<java.lang.String> autoBranchCreationPatterns;
            java.lang.Object basicAuthConfig;
            java.lang.String buildSpec;
            java.lang.Object enableAutoBranchCreation;
            java.lang.Object enableAutoBuild;
            java.lang.Object enablePerformanceMode;
            java.lang.Object enablePullRequestPreview;
            java.lang.Object environmentVariables;
            java.lang.String framework;
            java.lang.String pullRequestEnvironmentName;
            java.lang.String stage;

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getAutoBranchCreationPatterns}
             * @param autoBranchCreationPatterns Automated branch creation glob patterns for the Amplify app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoBranchCreationPatterns(java.util.List<java.lang.String> autoBranchCreationPatterns) {
                this.autoBranchCreationPatterns = autoBranchCreationPatterns;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getBasicAuthConfig}
             * @param basicAuthConfig Sets password protection for your auto created branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthConfig(software.amazon.awscdk.IResolvable basicAuthConfig) {
                this.basicAuthConfig = basicAuthConfig;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getBasicAuthConfig}
             * @param basicAuthConfig Sets password protection for your auto created branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthConfig(software.amazon.awscdk.services.amplify.CfnApp.BasicAuthConfigProperty basicAuthConfig) {
                this.basicAuthConfig = basicAuthConfig;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getBuildSpec}
             * @param buildSpec The build specification (build spec) for the autocreated branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildSpec(java.lang.String buildSpec) {
                this.buildSpec = buildSpec;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnableAutoBranchCreation}
             * @param enableAutoBranchCreation Enables automated branch creation for the Amplify app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAutoBranchCreation(java.lang.Boolean enableAutoBranchCreation) {
                this.enableAutoBranchCreation = enableAutoBranchCreation;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnableAutoBranchCreation}
             * @param enableAutoBranchCreation Enables automated branch creation for the Amplify app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAutoBranchCreation(software.amazon.awscdk.IResolvable enableAutoBranchCreation) {
                this.enableAutoBranchCreation = enableAutoBranchCreation;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnableAutoBuild}
             * @param enableAutoBuild Enables auto building for the auto created branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAutoBuild(java.lang.Boolean enableAutoBuild) {
                this.enableAutoBuild = enableAutoBuild;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnableAutoBuild}
             * @param enableAutoBuild Enables auto building for the auto created branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAutoBuild(software.amazon.awscdk.IResolvable enableAutoBuild) {
                this.enableAutoBuild = enableAutoBuild;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnablePerformanceMode}
             * @param enablePerformanceMode Enables performance mode for the branch.
             *                              Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePerformanceMode(java.lang.Boolean enablePerformanceMode) {
                this.enablePerformanceMode = enablePerformanceMode;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnablePerformanceMode}
             * @param enablePerformanceMode Enables performance mode for the branch.
             *                              Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePerformanceMode(software.amazon.awscdk.IResolvable enablePerformanceMode) {
                this.enablePerformanceMode = enablePerformanceMode;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnablePullRequestPreview}
             * @param enablePullRequestPreview Sets whether pull request previews are enabled for each branch that Amplify Hosting automatically creates for your app.
             *                                 Amplify creates previews by deploying your app to a unique URL whenever a pull request is opened for the branch. Development and QA teams can use this preview to test the pull request before it's merged into a production or integration branch.
             *                                 <p>
             *                                 To provide backend support for your preview, Amplify Hosting automatically provisions a temporary backend environment that it deletes when the pull request is closed. If you want to specify a dedicated backend environment for your previews, use the <code>PullRequestEnvironmentName</code> property.
             *                                 <p>
             *                                 For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/pr-previews.html">Web Previews</a> in the <em>AWS Amplify Hosting User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePullRequestPreview(java.lang.Boolean enablePullRequestPreview) {
                this.enablePullRequestPreview = enablePullRequestPreview;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnablePullRequestPreview}
             * @param enablePullRequestPreview Sets whether pull request previews are enabled for each branch that Amplify Hosting automatically creates for your app.
             *                                 Amplify creates previews by deploying your app to a unique URL whenever a pull request is opened for the branch. Development and QA teams can use this preview to test the pull request before it's merged into a production or integration branch.
             *                                 <p>
             *                                 To provide backend support for your preview, Amplify Hosting automatically provisions a temporary backend environment that it deletes when the pull request is closed. If you want to specify a dedicated backend environment for your previews, use the <code>PullRequestEnvironmentName</code> property.
             *                                 <p>
             *                                 For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/pr-previews.html">Web Previews</a> in the <em>AWS Amplify Hosting User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePullRequestPreview(software.amazon.awscdk.IResolvable enablePullRequestPreview) {
                this.enablePullRequestPreview = enablePullRequestPreview;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnvironmentVariables}
             * @param environmentVariables The environment variables for the autocreated branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getEnvironmentVariables}
             * @param environmentVariables The environment variables for the autocreated branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(java.util.List<? extends java.lang.Object> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getFramework}
             * @param framework The framework for the autocreated branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framework(java.lang.String framework) {
                this.framework = framework;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getPullRequestEnvironmentName}
             * @param pullRequestEnvironmentName If pull request previews are enabled, you can use this property to specify a dedicated backend environment for your previews.
             *                                   For example, you could specify an environment named <code>prod</code> , <code>test</code> , or <code>dev</code> that you initialized with the Amplify CLI.
             *                                   <p>
             *                                   To enable pull request previews, set the <code>EnablePullRequestPreview</code> property to <code>true</code> .
             *                                   <p>
             *                                   If you don't specify an environment, Amplify Hosting provides backend support for each preview by automatically provisioning a temporary backend environment. Amplify deletes this environment when the pull request is closed.
             *                                   <p>
             *                                   For more information about creating backend environments, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/multi-environments.html">Feature Branch Deployments and Team Workflows</a> in the <em>AWS Amplify Hosting User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pullRequestEnvironmentName(java.lang.String pullRequestEnvironmentName) {
                this.pullRequestEnvironmentName = pullRequestEnvironmentName;
                return this;
            }

            /**
             * Sets the value of {@link AutoBranchCreationConfigProperty#getStage}
             * @param stage Stage for the auto created branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stage(java.lang.String stage) {
                this.stage = stage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoBranchCreationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoBranchCreationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoBranchCreationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoBranchCreationConfigProperty {
            private final java.util.List<java.lang.String> autoBranchCreationPatterns;
            private final java.lang.Object basicAuthConfig;
            private final java.lang.String buildSpec;
            private final java.lang.Object enableAutoBranchCreation;
            private final java.lang.Object enableAutoBuild;
            private final java.lang.Object enablePerformanceMode;
            private final java.lang.Object enablePullRequestPreview;
            private final java.lang.Object environmentVariables;
            private final java.lang.String framework;
            private final java.lang.String pullRequestEnvironmentName;
            private final java.lang.String stage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoBranchCreationPatterns = software.amazon.jsii.Kernel.get(this, "autoBranchCreationPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.basicAuthConfig = software.amazon.jsii.Kernel.get(this, "basicAuthConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableAutoBranchCreation = software.amazon.jsii.Kernel.get(this, "enableAutoBranchCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableAutoBuild = software.amazon.jsii.Kernel.get(this, "enableAutoBuild", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enablePerformanceMode = software.amazon.jsii.Kernel.get(this, "enablePerformanceMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enablePullRequestPreview = software.amazon.jsii.Kernel.get(this, "enablePullRequestPreview", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.framework = software.amazon.jsii.Kernel.get(this, "framework", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pullRequestEnvironmentName = software.amazon.jsii.Kernel.get(this, "pullRequestEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
                this.basicAuthConfig = builder.basicAuthConfig;
                this.buildSpec = builder.buildSpec;
                this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
                this.enableAutoBuild = builder.enableAutoBuild;
                this.enablePerformanceMode = builder.enablePerformanceMode;
                this.enablePullRequestPreview = builder.enablePullRequestPreview;
                this.environmentVariables = builder.environmentVariables;
                this.framework = builder.framework;
                this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
                this.stage = builder.stage;
            }

            @Override
            public final java.util.List<java.lang.String> getAutoBranchCreationPatterns() {
                return this.autoBranchCreationPatterns;
            }

            @Override
            public final java.lang.Object getBasicAuthConfig() {
                return this.basicAuthConfig;
            }

            @Override
            public final java.lang.String getBuildSpec() {
                return this.buildSpec;
            }

            @Override
            public final java.lang.Object getEnableAutoBranchCreation() {
                return this.enableAutoBranchCreation;
            }

            @Override
            public final java.lang.Object getEnableAutoBuild() {
                return this.enableAutoBuild;
            }

            @Override
            public final java.lang.Object getEnablePerformanceMode() {
                return this.enablePerformanceMode;
            }

            @Override
            public final java.lang.Object getEnablePullRequestPreview() {
                return this.enablePullRequestPreview;
            }

            @Override
            public final java.lang.Object getEnvironmentVariables() {
                return this.environmentVariables;
            }

            @Override
            public final java.lang.String getFramework() {
                return this.framework;
            }

            @Override
            public final java.lang.String getPullRequestEnvironmentName() {
                return this.pullRequestEnvironmentName;
            }

            @Override
            public final java.lang.String getStage() {
                return this.stage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoBranchCreationPatterns() != null) {
                    data.set("autoBranchCreationPatterns", om.valueToTree(this.getAutoBranchCreationPatterns()));
                }
                if (this.getBasicAuthConfig() != null) {
                    data.set("basicAuthConfig", om.valueToTree(this.getBasicAuthConfig()));
                }
                if (this.getBuildSpec() != null) {
                    data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
                }
                if (this.getEnableAutoBranchCreation() != null) {
                    data.set("enableAutoBranchCreation", om.valueToTree(this.getEnableAutoBranchCreation()));
                }
                if (this.getEnableAutoBuild() != null) {
                    data.set("enableAutoBuild", om.valueToTree(this.getEnableAutoBuild()));
                }
                if (this.getEnablePerformanceMode() != null) {
                    data.set("enablePerformanceMode", om.valueToTree(this.getEnablePerformanceMode()));
                }
                if (this.getEnablePullRequestPreview() != null) {
                    data.set("enablePullRequestPreview", om.valueToTree(this.getEnablePullRequestPreview()));
                }
                if (this.getEnvironmentVariables() != null) {
                    data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                }
                if (this.getFramework() != null) {
                    data.set("framework", om.valueToTree(this.getFramework()));
                }
                if (this.getPullRequestEnvironmentName() != null) {
                    data.set("pullRequestEnvironmentName", om.valueToTree(this.getPullRequestEnvironmentName()));
                }
                if (this.getStage() != null) {
                    data.set("stage", om.valueToTree(this.getStage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnApp.AutoBranchCreationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoBranchCreationConfigProperty.Jsii$Proxy that = (AutoBranchCreationConfigProperty.Jsii$Proxy) o;

                if (this.autoBranchCreationPatterns != null ? !this.autoBranchCreationPatterns.equals(that.autoBranchCreationPatterns) : that.autoBranchCreationPatterns != null) return false;
                if (this.basicAuthConfig != null ? !this.basicAuthConfig.equals(that.basicAuthConfig) : that.basicAuthConfig != null) return false;
                if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
                if (this.enableAutoBranchCreation != null ? !this.enableAutoBranchCreation.equals(that.enableAutoBranchCreation) : that.enableAutoBranchCreation != null) return false;
                if (this.enableAutoBuild != null ? !this.enableAutoBuild.equals(that.enableAutoBuild) : that.enableAutoBuild != null) return false;
                if (this.enablePerformanceMode != null ? !this.enablePerformanceMode.equals(that.enablePerformanceMode) : that.enablePerformanceMode != null) return false;
                if (this.enablePullRequestPreview != null ? !this.enablePullRequestPreview.equals(that.enablePullRequestPreview) : that.enablePullRequestPreview != null) return false;
                if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
                if (this.framework != null ? !this.framework.equals(that.framework) : that.framework != null) return false;
                if (this.pullRequestEnvironmentName != null ? !this.pullRequestEnvironmentName.equals(that.pullRequestEnvironmentName) : that.pullRequestEnvironmentName != null) return false;
                return this.stage != null ? this.stage.equals(that.stage) : that.stage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoBranchCreationPatterns != null ? this.autoBranchCreationPatterns.hashCode() : 0;
                result = 31 * result + (this.basicAuthConfig != null ? this.basicAuthConfig.hashCode() : 0);
                result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
                result = 31 * result + (this.enableAutoBranchCreation != null ? this.enableAutoBranchCreation.hashCode() : 0);
                result = 31 * result + (this.enableAutoBuild != null ? this.enableAutoBuild.hashCode() : 0);
                result = 31 * result + (this.enablePerformanceMode != null ? this.enablePerformanceMode.hashCode() : 0);
                result = 31 * result + (this.enablePullRequestPreview != null ? this.enablePullRequestPreview.hashCode() : 0);
                result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
                result = 31 * result + (this.framework != null ? this.framework.hashCode() : 0);
                result = 31 * result + (this.pullRequestEnvironmentName != null ? this.pullRequestEnvironmentName.hashCode() : 0);
                result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use the BasicAuthConfig property type to set password protection at an app level to all your branches.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * BasicAuthConfigProperty basicAuthConfigProperty = BasicAuthConfigProperty.builder()
     *         .enableBasicAuth(false)
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnApp.BasicAuthConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BasicAuthConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BasicAuthConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables basic authorization for the Amplify app's branches.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-enablebasicauth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-enablebasicauth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableBasicAuth() {
            return null;
        }

        /**
         * The password for basic authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The user name for basic authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BasicAuthConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BasicAuthConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BasicAuthConfigProperty> {
            java.lang.Object enableBasicAuth;
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link BasicAuthConfigProperty#getEnableBasicAuth}
             * @param enableBasicAuth Enables basic authorization for the Amplify app's branches.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableBasicAuth(java.lang.Boolean enableBasicAuth) {
                this.enableBasicAuth = enableBasicAuth;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthConfigProperty#getEnableBasicAuth}
             * @param enableBasicAuth Enables basic authorization for the Amplify app's branches.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableBasicAuth(software.amazon.awscdk.IResolvable enableBasicAuth) {
                this.enableBasicAuth = enableBasicAuth;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthConfigProperty#getPassword}
             * @param password The password for basic authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthConfigProperty#getUsername}
             * @param username The user name for basic authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BasicAuthConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BasicAuthConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BasicAuthConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicAuthConfigProperty {
            private final java.lang.Object enableBasicAuth;
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableBasicAuth = software.amazon.jsii.Kernel.get(this, "enableBasicAuth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableBasicAuth = builder.enableBasicAuth;
                this.password = builder.password;
                this.username = builder.username;
            }

            @Override
            public final java.lang.Object getEnableBasicAuth() {
                return this.enableBasicAuth;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableBasicAuth() != null) {
                    data.set("enableBasicAuth", om.valueToTree(this.getEnableBasicAuth()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnApp.BasicAuthConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BasicAuthConfigProperty.Jsii$Proxy that = (BasicAuthConfigProperty.Jsii$Proxy) o;

                if (this.enableBasicAuth != null ? !this.enableBasicAuth.equals(that.enableBasicAuth) : that.enableBasicAuth != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableBasicAuth != null ? this.enableBasicAuth.hashCode() : 0;
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the cache configuration for an Amplify app.
     * <p>
     * For more information about how Amplify applies an optimal cache configuration for your app based on the type of content that is being served, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/managing-cache-configuration">Managing cache configuration</a> in the <em>Amplify User guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * CacheConfigProperty cacheConfigProperty = CacheConfigProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-cacheconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-cacheconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnApp.CacheConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of cache configuration to use for an Amplify app.
         * <p>
         * The <code>AMPLIFY_MANAGED</code> cache configuration automatically applies an optimized cache configuration for your app based on its platform, routing rules, and rewrite rules. This is the default setting.
         * <p>
         * The <code>AMPLIFY_MANAGED_NO_COOKIES</code> cache configuration type is the same as <code>AMPLIFY_MANAGED</code> , except that it excludes all cookies from the cache key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-cacheconfig.html#cfn-amplify-app-cacheconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-cacheconfig.html#cfn-amplify-app-cacheconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheConfigProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link CacheConfigProperty#getType}
             * @param type The type of cache configuration to use for an Amplify app.
             *             The <code>AMPLIFY_MANAGED</code> cache configuration automatically applies an optimized cache configuration for your app based on its platform, routing rules, and rewrite rules. This is the default setting.
             *             <p>
             *             The <code>AMPLIFY_MANAGED_NO_COOKIES</code> cache configuration type is the same as <code>AMPLIFY_MANAGED</code> , except that it excludes all cookies from the cache key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CacheConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheConfigProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnApp.CacheConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheConfigProperty.Jsii$Proxy that = (CacheConfigProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The CustomRule property type allows you to specify redirects, rewrites, and reverse proxies.
     * <p>
     * Redirects enable a web app to reroute navigation from one URL to another.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * CustomRuleProperty customRuleProperty = CustomRuleProperty.builder()
     *         .source("source")
     *         .target("target")
     *         // the properties below are optional
     *         .condition("condition")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnApp.CustomRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source pattern for a URL rewrite or redirect rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The target pattern for a URL rewrite or redirect rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * The condition for a URL rewrite or redirect rule, such as a country code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
            return null;
        }

        /**
         * The status code for a URL rewrite or redirect rule.
         * <p>
         * <ul>
         * <li><strong>200</strong> - Represents a 200 rewrite rule.</li>
         * <li><strong>301</strong> - Represents a 301 (moved pemanently) redirect rule. This and all future requests should be directed to the target URL.</li>
         * <li><strong>302</strong> - Represents a 302 temporary redirect rule.</li>
         * <li><strong>404</strong> - Represents a 404 redirect rule.</li>
         * <li><strong>404-200</strong> - Represents a 404 rewrite rule.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomRuleProperty> {
            java.lang.String source;
            java.lang.String target;
            java.lang.String condition;
            java.lang.String status;

            /**
             * Sets the value of {@link CustomRuleProperty#getSource}
             * @param source The source pattern for a URL rewrite or redirect rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link CustomRuleProperty#getTarget}
             * @param target The target pattern for a URL rewrite or redirect rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link CustomRuleProperty#getCondition}
             * @param condition The condition for a URL rewrite or redirect rule, such as a country code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link CustomRuleProperty#getStatus}
             * @param status The status code for a URL rewrite or redirect rule.
             *               <ul>
             *               <li><strong>200</strong> - Represents a 200 rewrite rule.</li>
             *               <li><strong>301</strong> - Represents a 301 (moved pemanently) redirect rule. This and all future requests should be directed to the target URL.</li>
             *               <li><strong>302</strong> - Represents a 302 temporary redirect rule.</li>
             *               <li><strong>404</strong> - Represents a 404 redirect rule.</li>
             *               <li><strong>404-200</strong> - Represents a 404 rewrite rule.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomRuleProperty {
            private final java.lang.String source;
            private final java.lang.String target;
            private final java.lang.String condition;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.condition = builder.condition;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("source", om.valueToTree(this.getSource()));
                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnApp.CustomRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomRuleProperty.Jsii$Proxy that = (CustomRuleProperty.Jsii$Proxy) o;

                if (!source.equals(that.source)) return false;
                if (!target.equals(that.target)) return false;
                if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source.hashCode();
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Environment variables are key-value pairs that are available at build time.
     * <p>
     * Set environment variables for all branches in your app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * EnvironmentVariableProperty environmentVariableProperty = EnvironmentVariableProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnApp.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The environment variable name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The environment variable value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getName}
             * @param name The environment variable name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getValue}
             * @param value The environment variable value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnApp.EnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentVariableProperty.Jsii$Proxy that = (EnvironmentVariableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.amplify.CfnApp}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.CfnApp> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.amplify.CfnAppProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.amplify.CfnAppProps.Builder();
        }

        /**
         * The name of the Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name</a>
         * @param name The name of the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The personal access token for a GitHub repository for an Amplify app.
         * <p>
         * The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
         * <p>
         * Use <code>AccessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>OauthToken</code> .
         * <p>
         * You must specify either <code>AccessToken</code> or <code>OauthToken</code> when you create a new app.
         * <p>
         * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <em>Amplify User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken</a>
         * @param accessToken The personal access token for a GitHub repository for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessToken(final java.lang.String accessToken) {
            this.props.accessToken(accessToken);
            return this;
        }

        /**
         * Sets the configuration for your automatic branch creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig</a>
         * @param autoBranchCreationConfig Sets the configuration for your automatic branch creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBranchCreationConfig(final software.amazon.awscdk.IResolvable autoBranchCreationConfig) {
            this.props.autoBranchCreationConfig(autoBranchCreationConfig);
            return this;
        }
        /**
         * Sets the configuration for your automatic branch creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig</a>
         * @param autoBranchCreationConfig Sets the configuration for your automatic branch creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBranchCreationConfig(final software.amazon.awscdk.services.amplify.CfnApp.AutoBranchCreationConfigProperty autoBranchCreationConfig) {
            this.props.autoBranchCreationConfig(autoBranchCreationConfig);
            return this;
        }

        /**
         * The credentials for basic authorization for an Amplify app.
         * <p>
         * You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig</a>
         * @param basicAuthConfig The credentials for basic authorization for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basicAuthConfig(final software.amazon.awscdk.IResolvable basicAuthConfig) {
            this.props.basicAuthConfig(basicAuthConfig);
            return this;
        }
        /**
         * The credentials for basic authorization for an Amplify app.
         * <p>
         * You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig</a>
         * @param basicAuthConfig The credentials for basic authorization for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basicAuthConfig(final software.amazon.awscdk.services.amplify.CfnApp.BasicAuthConfigProperty basicAuthConfig) {
            this.props.basicAuthConfig(basicAuthConfig);
            return this;
        }

        /**
         * The build specification (build spec) for an Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec</a>
         * @param buildSpec The build specification (build spec) for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSpec(final java.lang.String buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        /**
         * The cache configuration for the Amplify app.
         * <p>
         * If you don't specify the cache configuration <code>type</code> , Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-cacheconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-cacheconfig</a>
         * @param cacheConfig The cache configuration for the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheConfig(final software.amazon.awscdk.IResolvable cacheConfig) {
            this.props.cacheConfig(cacheConfig);
            return this;
        }
        /**
         * The cache configuration for the Amplify app.
         * <p>
         * If you don't specify the cache configuration <code>type</code> , Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-cacheconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-cacheconfig</a>
         * @param cacheConfig The cache configuration for the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheConfig(final software.amazon.awscdk.services.amplify.CfnApp.CacheConfigProperty cacheConfig) {
            this.props.cacheConfig(cacheConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role for an SSR app.
         * <p>
         * The Compute role allows the Amplify Hosting compute service to securely access specific AWS resources based on the role's permissions. For more information about the SSR Compute role, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR Compute role</a> in the <em>Amplify User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-computerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-computerolearn</a>
         * @param computeRoleArn The Amazon Resource Name (ARN) of the IAM role for an SSR app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeRoleArn(final java.lang.String computeRoleArn) {
            this.props.computeRoleArn(computeRoleArn);
            return this;
        }

        /**
         * The custom HTTP headers for an Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customheaders</a>
         * @param customHeaders The custom HTTP headers for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(final java.lang.String customHeaders) {
            this.props.customHeaders(customHeaders);
            return this;
        }

        /**
         * The custom rewrite and redirect rules for an Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules</a>
         * @param customRules The custom rewrite and redirect rules for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRules(final software.amazon.awscdk.IResolvable customRules) {
            this.props.customRules(customRules);
            return this;
        }
        /**
         * The custom rewrite and redirect rules for an Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules</a>
         * @param customRules The custom rewrite and redirect rules for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRules(final java.util.List<? extends java.lang.Object> customRules) {
            this.props.customRules(customRules);
            return this;
        }

        /**
         * The description of the Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description</a>
         * @param description The description of the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion</a>
         * @param enableBranchAutoDeletion Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableBranchAutoDeletion(final java.lang.Boolean enableBranchAutoDeletion) {
            this.props.enableBranchAutoDeletion(enableBranchAutoDeletion);
            return this;
        }
        /**
         * Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion</a>
         * @param enableBranchAutoDeletion Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableBranchAutoDeletion(final software.amazon.awscdk.IResolvable enableBranchAutoDeletion) {
            this.props.enableBranchAutoDeletion(enableBranchAutoDeletion);
            return this;
        }

        /**
         * The environment variables for the Amplify app.
         * <p>
         * For a list of the environment variables that are accessible to Amplify by default, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html">Amplify Environment variables</a> in the <em>Amplify Hosting User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables</a>
         * @param environmentVariables The environment variables for the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final software.amazon.awscdk.IResolvable environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }
        /**
         * The environment variables for the Amplify app.
         * <p>
         * For a list of the environment variables that are accessible to Amplify by default, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html">Amplify Environment variables</a> in the <em>Amplify Hosting User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables</a>
         * @param environmentVariables The environment variables for the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(final java.util.List<? extends java.lang.Object> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        /**
         * AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole</a>
         * @param iamServiceRole AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamServiceRole(final java.lang.String iamServiceRole) {
            this.props.iamServiceRole(iamServiceRole);
            return this;
        }

        /**
         * The OAuth token for a third-party source control system for an Amplify app.
         * <p>
         * The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
         * <p>
         * Use <code>OauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use <code>AccessToken</code> .
         * <p>
         * You must specify either <code>OauthToken</code> or <code>AccessToken</code> when you create a new app.
         * <p>
         * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <em>Amplify User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken</a>
         * @param oauthToken The OAuth token for a third-party source control system for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oauthToken(final java.lang.String oauthToken) {
            this.props.oauthToken(oauthToken);
            return this;
        }

        /**
         * The platform for the Amplify app.
         * <p>
         * For a static app, set the platform type to <code>WEB</code> . For a dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code> . For an app requiring Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code> .
         * <p>
         * If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the application's build settings. For an example of the build specification settings, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14">Amplify build settings for a Next.js 14 SSG application</a> in the <em>Amplify Hosting User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-platform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-platform</a>
         * @param platform The platform for the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(final java.lang.String platform) {
            this.props.platform(platform);
            return this;
        }

        /**
         * The Git repository for the Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository</a>
         * @param repository The Git repository for the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(final java.lang.String repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * The tag for an Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags</a>
         * @param tags The tag for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.amplify.CfnApp}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.amplify.CfnApp build() {
            return new software.amazon.awscdk.services.amplify.CfnApp(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
