package software.amazon.awscdk.services.amplify;

/**
 * Specifies the AWS::Amplify::Domain resource that enables you to connect a custom domain to your app.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * CfnDomain cfnDomain = CfnDomain.Builder.create(this, "MyCfnDomain")
 *         .appId("appId")
 *         .domainName("domainName")
 *         .subDomainSettings(List.of(SubDomainSettingProperty.builder()
 *                 .branchName("branchName")
 *                 .prefix("prefix")
 *                 .build()))
 *         // the properties below are optional
 *         .autoSubDomainCreationPatterns(List.of("autoSubDomainCreationPatterns"))
 *         .autoSubDomainIamRole("autoSubDomainIamRole")
 *         .certificateSettings(CertificateSettingsProperty.builder()
 *                 .certificateType("certificateType")
 *                 .customCertificateArn("customCertificateArn")
 *                 .build())
 *         .enableAutoSubDomain(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.905Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnDomain")
public class CfnDomain extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.amplify.CfnDomain.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amplify.CfnDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * ARN for the Domain Association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Branch patterns for the automatically created subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrAutoSubDomainCreationPatterns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrAutoSubDomainCreationPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The IAM service role for the subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAutoSubDomainIamRole() {
        return software.amazon.jsii.Kernel.get(this, "attrAutoSubDomainIamRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrCertificate() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * DNS Record for certificate verification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCertificateRecord() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificateRecord", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Status for the Domain Association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the automated creation of subdomains for branches is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrEnableAutoSubDomain() {
        return software.amazon.jsii.Kernel.get(this, "attrEnableAutoSubDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Reason for the current status of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusReason() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the domain update operation that is currently in progress.
     * <p>
     * The following list describes the valid update states.
     * <p>
     * <ul>
     * <li><strong>REQUESTING_CERTIFICATE</strong> - The certificate is in the process of being updated.</li>
     * <li><strong>PENDING_VERIFICATION</strong> - Indicates that an Amplify managed certificate is in the process of being verified. This occurs during the creation of a custom domain or when a custom domain is updated to use a managed certificate.</li>
     * <li><strong>IMPORTING_CUSTOM_CERTIFICATE</strong> - Indicates that an Amplify custom certificate is in the process of being imported. This occurs during the creation of a custom domain or when a custom domain is updated to use a custom certificate.</li>
     * <li><strong>PENDING_DEPLOYMENT</strong> - Indicates that the subdomain or certificate changes are being propagated.</li>
     * <li><strong>AWAITING_APP_CNAME</strong> - Amplify is waiting for CNAME records corresponding to subdomains to be propagated. If your custom domain is on Route 53, Amplify handles this for you automatically. For more information about custom domains, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/custom-domains.html">Setting up custom domains</a> in the <em>Amplify Hosting User Guide</em> .</li>
     * <li><strong>UPDATE_COMPLETE</strong> - The certificate has been associated with a domain.</li>
     * <li><strong>UPDATE_FAILED</strong> - The certificate has failed to be provisioned or associated, and there is no existing active certificate to roll back to.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdateStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdateStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique ID for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppId() {
        return software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID for an Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appId", java.util.Objects.requireNonNull(value, "appId is required"));
    }

    /**
     * The domain name for the domain association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name for the domain association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * The setting for the subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSubDomainSettings() {
        return software.amazon.jsii.Kernel.get(this, "subDomainSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The setting for the subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubDomainSettings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "subDomainSettings", java.util.Objects.requireNonNull(value, "subDomainSettings is required"));
    }

    /**
     * The setting for the subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubDomainSettings(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplify.CfnDomain.SubDomainSettingProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplify.CfnDomain.SubDomainSettingProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "subDomainSettings", java.util.Objects.requireNonNull(value, "subDomainSettings is required"));
    }

    /**
     * Sets the branch patterns for automatic subdomain creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoSubDomainCreationPatterns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "autoSubDomainCreationPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Sets the branch patterns for automatic subdomain creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoSubDomainCreationPatterns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "autoSubDomainCreationPatterns", value);
    }

    /**
     * The required AWS Identity and Access Management (IAMlong) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoSubDomainIamRole() {
        return software.amazon.jsii.Kernel.get(this, "autoSubDomainIamRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The required AWS Identity and Access Management (IAMlong) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoSubDomainIamRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoSubDomainIamRole", value);
    }

    /**
     * The type of SSL/TLS certificate to use for your custom domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCertificateSettings() {
        return software.amazon.jsii.Kernel.get(this, "certificateSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The type of SSL/TLS certificate to use for your custom domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "certificateSettings", value);
    }

    /**
     * The type of SSL/TLS certificate to use for your custom domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplify.CfnDomain.CertificateSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "certificateSettings", value);
    }

    /**
     * Enables the automated creation of subdomains for branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableAutoSubDomain() {
        return software.amazon.jsii.Kernel.get(this, "enableAutoSubDomain", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables the automated creation of subdomains for branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableAutoSubDomain(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableAutoSubDomain", value);
    }

    /**
     * Enables the automated creation of subdomains for branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableAutoSubDomain(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableAutoSubDomain", value);
    }
    /**
     * Describes the SSL/TLS certificate for the domain association.
     * <p>
     * This can be your own custom certificate or the default certificate that Amplify provisions for you.
     * <p>
     * If you are updating your domain to use a different certificate, <code>Certificate</code> points to the new certificate that is being created instead of the current active certificate. Otherwise, <code>Certificate</code> points to the current active certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * CertificateProperty certificateProperty = CertificateProperty.builder()
     *         .certificateArn("certificateArn")
     *         .certificateType("certificateType")
     *         .certificateVerificationDnsRecord("certificateVerificationDnsRecord")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnDomain.CertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon resource name (ARN) for a custom certificate that you have already added to AWS Certificate Manager in your AWS account .
         * <p>
         * This field is required only when the certificate type is <code>CUSTOM</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html#cfn-amplify-domain-certificate-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html#cfn-amplify-domain-certificate-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * The type of SSL/TLS certificate that you want to use.
         * <p>
         * Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
         * <p>
         * Specify <code>CUSTOM</code> to use your own certificate that you have already added to AWS Certificate Manager in your AWS account . Make sure you request (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into AWS Certificate Manager</a> in the <em>ACM User guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html#cfn-amplify-domain-certificate-certificatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html#cfn-amplify-domain-certificate-certificatetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateType() {
            return null;
        }

        /**
         * The DNS record for certificate verification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html#cfn-amplify-domain-certificate-certificateverificationdnsrecord">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificate.html#cfn-amplify-domain-certificate-certificateverificationdnsrecord</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateVerificationDnsRecord() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateProperty> {
            java.lang.String certificateArn;
            java.lang.String certificateType;
            java.lang.String certificateVerificationDnsRecord;

            /**
             * Sets the value of {@link CertificateProperty#getCertificateArn}
             * @param certificateArn The Amazon resource name (ARN) for a custom certificate that you have already added to AWS Certificate Manager in your AWS account .
             *                       This field is required only when the certificate type is <code>CUSTOM</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link CertificateProperty#getCertificateType}
             * @param certificateType The type of SSL/TLS certificate that you want to use.
             *                        Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
             *                        <p>
             *                        Specify <code>CUSTOM</code> to use your own certificate that you have already added to AWS Certificate Manager in your AWS account . Make sure you request (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into AWS Certificate Manager</a> in the <em>ACM User guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateType(java.lang.String certificateType) {
                this.certificateType = certificateType;
                return this;
            }

            /**
             * Sets the value of {@link CertificateProperty#getCertificateVerificationDnsRecord}
             * @param certificateVerificationDnsRecord The DNS record for certificate verification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateVerificationDnsRecord(java.lang.String certificateVerificationDnsRecord) {
                this.certificateVerificationDnsRecord = certificateVerificationDnsRecord;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProperty {
            private final java.lang.String certificateArn;
            private final java.lang.String certificateType;
            private final java.lang.String certificateVerificationDnsRecord;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateType = software.amazon.jsii.Kernel.get(this, "certificateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateVerificationDnsRecord = software.amazon.jsii.Kernel.get(this, "certificateVerificationDnsRecord", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = builder.certificateArn;
                this.certificateType = builder.certificateType;
                this.certificateVerificationDnsRecord = builder.certificateVerificationDnsRecord;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getCertificateType() {
                return this.certificateType;
            }

            @Override
            public final java.lang.String getCertificateVerificationDnsRecord() {
                return this.certificateVerificationDnsRecord;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getCertificateType() != null) {
                    data.set("certificateType", om.valueToTree(this.getCertificateType()));
                }
                if (this.getCertificateVerificationDnsRecord() != null) {
                    data.set("certificateVerificationDnsRecord", om.valueToTree(this.getCertificateVerificationDnsRecord()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnDomain.CertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateProperty.Jsii$Proxy that = (CertificateProperty.Jsii$Proxy) o;

                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                if (this.certificateType != null ? !this.certificateType.equals(that.certificateType) : that.certificateType != null) return false;
                return this.certificateVerificationDnsRecord != null ? this.certificateVerificationDnsRecord.equals(that.certificateVerificationDnsRecord) : that.certificateVerificationDnsRecord == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn != null ? this.certificateArn.hashCode() : 0;
                result = 31 * result + (this.certificateType != null ? this.certificateType.hashCode() : 0);
                result = 31 * result + (this.certificateVerificationDnsRecord != null ? this.certificateVerificationDnsRecord.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The type of SSL/TLS certificate to use for your custom domain.
     * <p>
     * If a certificate type isn't specified, Amplify uses the default <code>AMPLIFY_MANAGED</code> certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * CertificateSettingsProperty certificateSettingsProperty = CertificateSettingsProperty.builder()
     *         .certificateType("certificateType")
     *         .customCertificateArn("customCertificateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificatesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificatesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnDomain.CertificateSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The certificate type.
         * <p>
         * Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
         * <p>
         * Specify <code>CUSTOM</code> to use your own certificate that you have already added to AWS Certificate Manager in your AWS account . Make sure you request (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into AWS Certificate Manager</a> in the <em>ACM User guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificatesettings.html#cfn-amplify-domain-certificatesettings-certificatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificatesettings.html#cfn-amplify-domain-certificatesettings-certificatetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateType() {
            return null;
        }

        /**
         * The Amazon resource name (ARN) for the custom certificate that you have already added to AWS Certificate Manager in your AWS account .
         * <p>
         * This field is required only when the certificate type is <code>CUSTOM</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificatesettings.html#cfn-amplify-domain-certificatesettings-customcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-certificatesettings.html#cfn-amplify-domain-certificatesettings-customcertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomCertificateArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CertificateSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateSettingsProperty> {
            java.lang.String certificateType;
            java.lang.String customCertificateArn;

            /**
             * Sets the value of {@link CertificateSettingsProperty#getCertificateType}
             * @param certificateType The certificate type.
             *                        Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
             *                        <p>
             *                        Specify <code>CUSTOM</code> to use your own certificate that you have already added to AWS Certificate Manager in your AWS account . Make sure you request (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into AWS Certificate Manager</a> in the <em>ACM User guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateType(java.lang.String certificateType) {
                this.certificateType = certificateType;
                return this;
            }

            /**
             * Sets the value of {@link CertificateSettingsProperty#getCustomCertificateArn}
             * @param customCertificateArn The Amazon resource name (ARN) for the custom certificate that you have already added to AWS Certificate Manager in your AWS account .
             *                             This field is required only when the certificate type is <code>CUSTOM</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customCertificateArn(java.lang.String customCertificateArn) {
                this.customCertificateArn = customCertificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateSettingsProperty {
            private final java.lang.String certificateType;
            private final java.lang.String customCertificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateType = software.amazon.jsii.Kernel.get(this, "certificateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customCertificateArn = software.amazon.jsii.Kernel.get(this, "customCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateType = builder.certificateType;
                this.customCertificateArn = builder.customCertificateArn;
            }

            @Override
            public final java.lang.String getCertificateType() {
                return this.certificateType;
            }

            @Override
            public final java.lang.String getCustomCertificateArn() {
                return this.customCertificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateType() != null) {
                    data.set("certificateType", om.valueToTree(this.getCertificateType()));
                }
                if (this.getCustomCertificateArn() != null) {
                    data.set("customCertificateArn", om.valueToTree(this.getCustomCertificateArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnDomain.CertificateSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateSettingsProperty.Jsii$Proxy that = (CertificateSettingsProperty.Jsii$Proxy) o;

                if (this.certificateType != null ? !this.certificateType.equals(that.certificateType) : that.certificateType != null) return false;
                return this.customCertificateArn != null ? this.customCertificateArn.equals(that.customCertificateArn) : that.customCertificateArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateType != null ? this.certificateType.hashCode() : 0;
                result = 31 * result + (this.customCertificateArn != null ? this.customCertificateArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The SubDomainSetting property type enables you to connect a subdomain (for example, example.exampledomain.com) to a specific branch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplify.*;
     * SubDomainSettingProperty subDomainSettingProperty = SubDomainSettingProperty.builder()
     *         .branchName("branchName")
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnDomain.SubDomainSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(SubDomainSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubDomainSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The branch name setting for the subdomain.
         * <p>
         * <em>Length Constraints:</em> Minimum length of 1. Maximum length of 255.
         * <p>
         * <em>Pattern:</em> (?s).+
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-branchname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-branchname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBranchName();

        /**
         * The prefix setting for the subdomain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrefix();

        /**
         * @return a {@link Builder} of {@link SubDomainSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubDomainSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubDomainSettingProperty> {
            java.lang.String branchName;
            java.lang.String prefix;

            /**
             * Sets the value of {@link SubDomainSettingProperty#getBranchName}
             * @param branchName The branch name setting for the subdomain. This parameter is required.
             *                   <em>Length Constraints:</em> Minimum length of 1. Maximum length of 255.
             *                   <p>
             *                   <em>Pattern:</em> (?s).+
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branchName(java.lang.String branchName) {
                this.branchName = branchName;
                return this;
            }

            /**
             * Sets the value of {@link SubDomainSettingProperty#getPrefix}
             * @param prefix The prefix setting for the subdomain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubDomainSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubDomainSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubDomainSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubDomainSettingProperty {
            private final java.lang.String branchName;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.branchName = software.amazon.jsii.Kernel.get(this, "branchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.branchName = java.util.Objects.requireNonNull(builder.branchName, "branchName is required");
                this.prefix = java.util.Objects.requireNonNull(builder.prefix, "prefix is required");
            }

            @Override
            public final java.lang.String getBranchName() {
                return this.branchName;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("branchName", om.valueToTree(this.getBranchName()));
                data.set("prefix", om.valueToTree(this.getPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnDomain.SubDomainSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubDomainSettingProperty.Jsii$Proxy that = (SubDomainSettingProperty.Jsii$Proxy) o;

                if (!branchName.equals(that.branchName)) return false;
                return this.prefix.equals(that.prefix);
            }

            @Override
            public final int hashCode() {
                int result = this.branchName.hashCode();
                result = 31 * result + (this.prefix.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.amplify.CfnDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplify.CfnDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.amplify.CfnDomainProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.amplify.CfnDomainProps.Builder();
        }

        /**
         * The unique ID for an Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid</a>
         * @param appId The unique ID for an Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(final java.lang.String appId) {
            this.props.appId(appId);
            return this;
        }

        /**
         * The domain name for the domain association.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname</a>
         * @param domainName The domain name for the domain association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The setting for the subdomain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings</a>
         * @param subDomainSettings The setting for the subdomain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subDomainSettings(final software.amazon.awscdk.IResolvable subDomainSettings) {
            this.props.subDomainSettings(subDomainSettings);
            return this;
        }
        /**
         * The setting for the subdomain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings</a>
         * @param subDomainSettings The setting for the subdomain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subDomainSettings(final java.util.List<? extends java.lang.Object> subDomainSettings) {
            this.props.subDomainSettings(subDomainSettings);
            return this;
        }

        /**
         * Sets the branch patterns for automatic subdomain creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns</a>
         * @param autoSubDomainCreationPatterns Sets the branch patterns for automatic subdomain creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSubDomainCreationPatterns(final java.util.List<java.lang.String> autoSubDomainCreationPatterns) {
            this.props.autoSubDomainCreationPatterns(autoSubDomainCreationPatterns);
            return this;
        }

        /**
         * The required AWS Identity and Access Management (IAMlong) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole</a>
         * @param autoSubDomainIamRole The required AWS Identity and Access Management (IAMlong) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSubDomainIamRole(final java.lang.String autoSubDomainIamRole) {
            this.props.autoSubDomainIamRole(autoSubDomainIamRole);
            return this;
        }

        /**
         * The type of SSL/TLS certificate to use for your custom domain.
         * <p>
         * If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-certificatesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-certificatesettings</a>
         * @param certificateSettings The type of SSL/TLS certificate to use for your custom domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateSettings(final software.amazon.awscdk.IResolvable certificateSettings) {
            this.props.certificateSettings(certificateSettings);
            return this;
        }
        /**
         * The type of SSL/TLS certificate to use for your custom domain.
         * <p>
         * If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-certificatesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-certificatesettings</a>
         * @param certificateSettings The type of SSL/TLS certificate to use for your custom domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateSettings(final software.amazon.awscdk.services.amplify.CfnDomain.CertificateSettingsProperty certificateSettings) {
            this.props.certificateSettings(certificateSettings);
            return this;
        }

        /**
         * Enables the automated creation of subdomains for branches.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain</a>
         * @param enableAutoSubDomain Enables the automated creation of subdomains for branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoSubDomain(final java.lang.Boolean enableAutoSubDomain) {
            this.props.enableAutoSubDomain(enableAutoSubDomain);
            return this;
        }
        /**
         * Enables the automated creation of subdomains for branches.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain</a>
         * @param enableAutoSubDomain Enables the automated creation of subdomains for branches. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoSubDomain(final software.amazon.awscdk.IResolvable enableAutoSubDomain) {
            this.props.enableAutoSubDomain(enableAutoSubDomain);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.amplify.CfnDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.amplify.CfnDomain build() {
            return new software.amazon.awscdk.services.amplify.CfnDomain(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
