package software.amazon.awscdk.services.apigateway;

/**
 * Options for creating an api mapping.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Object acmCertificateForExampleCom;
 * RestApi restApi;
 * RestApi secondRestApi;
 * DomainName domain = DomainName.Builder.create(this, "custom-domain")
 *         .domainName("example.com")
 *         .certificate(acmCertificateForExampleCom)
 *         .mapping(restApi)
 *         .build();
 * domain.addApiMapping(secondRestApi.getDeploymentStage(), ApiMappingOptions.builder()
 *         .basePath("orders/v2/api")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:41.998Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.ApiMappingOptions")
@software.amazon.jsii.Jsii.Proxy(ApiMappingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiMappingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The api path name that callers of the API must provide in the URL after the domain name (e.g. <code>example.com/base-path</code>). If you specify this property, it can't be an empty string.
     * <p>
     * If this is undefined, a mapping will be added for the empty path. Any request
     * that does not match a mapping will get sent to the API that has been mapped
     * to the empty path.
     * <p>
     * Default: - map requests from the domain root (e.g. `example.com`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBasePath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiMappingOptions> {
        java.lang.String basePath;

        /**
         * Sets the value of {@link ApiMappingOptions#getBasePath}
         * @param basePath The api path name that callers of the API must provide in the URL after the domain name (e.g. <code>example.com/base-path</code>). If you specify this property, it can't be an empty string.
         *                 If this is undefined, a mapping will be added for the empty path. Any request
         *                 that does not match a mapping will get sent to the API that has been mapped
         *                 to the empty path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePath(java.lang.String basePath) {
            this.basePath = basePath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiMappingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiMappingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiMappingOptions {
        private final java.lang.String basePath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.basePath = software.amazon.jsii.Kernel.get(this, "basePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.basePath = builder.basePath;
        }

        @Override
        public final java.lang.String getBasePath() {
            return this.basePath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBasePath() != null) {
                data.set("basePath", om.valueToTree(this.getBasePath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.ApiMappingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiMappingOptions.Jsii$Proxy that = (ApiMappingOptions.Jsii$Proxy) o;

            return this.basePath != null ? this.basePath.equals(that.basePath) : that.basePath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.basePath != null ? this.basePath.hashCode() : 0;
            return result;
        }
    }
}
