package software.amazon.awscdk.services.apigatewayv2;

/**
 * Options for the Route with Integration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpLambdaIntegration;
 * Function bookStoreDefaultFn;
 * HttpUrlIntegration getBooksIntegration = new HttpUrlIntegration("GetBooksIntegration", "https://get-books-proxy.example.com");
 * HttpLambdaIntegration bookStoreDefaultIntegration = new HttpLambdaIntegration("BooksIntegration", bookStoreDefaultFn);
 * HttpApi httpApi = new HttpApi(this, "HttpApi");
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .integration(getBooksIntegration)
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.ANY))
 *         .integration(bookStoreDefaultIntegration)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.224Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.AddRoutesOptions")
@software.amazon.jsii.Jsii.Proxy(AddRoutesOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddRoutesOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.BatchHttpRouteOptions {

    /**
     * The path at which all of these routes are configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPath();

    /**
     * The list of OIDC scopes to include in the authorization.
     * <p>
     * These scopes will override the default authorization scopes on the gateway.
     * Set to [] to remove default scopes
     * <p>
     * Default: - uses defaultAuthorizationScopes if configured on the API, otherwise none.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return null;
    }

    /**
     * Authorizer to be associated to these routes.
     * <p>
     * Use NoneAuthorizer to remove the default authorizer for the api
     * <p>
     * Default: - uses the default authorizer if one is specified on the HttpApi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer getAuthorizer() {
        return null;
    }

    /**
     * The HTTP methods to be configured.
     * <p>
     * Default: HttpMethod.ANY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> getMethods() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddRoutesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddRoutesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddRoutesOptions> {
        java.lang.String path;
        java.util.List<java.lang.String> authorizationScopes;
        software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer authorizer;
        java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> methods;
        software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration;

        /**
         * Sets the value of {@link AddRoutesOptions#getPath}
         * @param path The path at which all of these routes are configured. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link AddRoutesOptions#getAuthorizationScopes}
         * @param authorizationScopes The list of OIDC scopes to include in the authorization.
         *                            These scopes will override the default authorization scopes on the gateway.
         *                            Set to [] to remove default scopes
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        /**
         * Sets the value of {@link AddRoutesOptions#getAuthorizer}
         * @param authorizer Authorizer to be associated to these routes.
         *                   Use NoneAuthorizer to remove the default authorizer for the api
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Sets the value of {@link AddRoutesOptions#getMethods}
         * @param methods The HTTP methods to be configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder methods(java.util.List<? extends software.amazon.awscdk.services.apigatewayv2.HttpMethod> methods) {
            this.methods = (java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod>)methods;
            return this;
        }

        /**
         * Sets the value of {@link AddRoutesOptions#getIntegration}
         * @param integration The integration to be configured on this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddRoutesOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddRoutesOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddRoutesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddRoutesOptions {
        private final java.lang.String path;
        private final java.util.List<java.lang.String> authorizationScopes;
        private final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer authorizer;
        private final java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> methods;
        private final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer.class));
            this.methods = software.amazon.jsii.Kernel.get(this, "methods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class)));
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
            this.authorizationScopes = builder.authorizationScopes;
            this.authorizer = builder.authorizer;
            this.methods = (java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod>)builder.methods;
            this.integration = java.util.Objects.requireNonNull(builder.integration, "integration is required");
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpMethod> getMethods() {
            return this.methods;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration getIntegration() {
            return this.integration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("path", om.valueToTree(this.getPath()));
            if (this.getAuthorizationScopes() != null) {
                data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
            }
            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }
            if (this.getMethods() != null) {
                data.set("methods", om.valueToTree(this.getMethods()));
            }
            data.set("integration", om.valueToTree(this.getIntegration()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.AddRoutesOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddRoutesOptions.Jsii$Proxy that = (AddRoutesOptions.Jsii$Proxy) o;

            if (!path.equals(that.path)) return false;
            if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
            if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
            if (this.methods != null ? !this.methods.equals(that.methods) : that.methods != null) return false;
            return this.integration.equals(that.integration);
        }

        @Override
        public final int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            result = 31 * result + (this.methods != null ? this.methods.hashCode() : 0);
            result = 31 * result + (this.integration.hashCode());
            return result;
        }
    }
}
