package software.amazon.awscdk.services.appconfig;

/**
 * Properties for defining a <code>CfnDeploymentStrategy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appconfig.*;
 * CfnDeploymentStrategyProps cfnDeploymentStrategyProps = CfnDeploymentStrategyProps.builder()
 *         .deploymentDurationInMinutes(123)
 *         .growthFactor(123)
 *         .name("name")
 *         .replicateTo("replicateTo")
 *         // the properties below are optional
 *         .description("description")
 *         .finalBakeTimeInMinutes(123)
 *         .growthType("growthType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.416Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.CfnDeploymentStrategyProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeploymentStrategyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeploymentStrategyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Total amount of time for a deployment to last.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-deploymentdurationinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-deploymentdurationinminutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getDeploymentDurationInMinutes();

    /**
     * The percentage of targets to receive a deployed configuration during each interval.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthfactor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getGrowthFactor();

    /**
     * A name for the deployment strategy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Save the deployment strategy to a Systems Manager (SSM) document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-replicateto">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-replicateto</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReplicateTo();

    /**
     * A description of the deployment strategy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies the amount of time AWS AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete.
     * <p>
     * If an alarm is triggered during this time, AWS AppConfig rolls back the deployment. You must configure permissions for AWS AppConfig to roll back based on CloudWatch alarms. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/getting-started-with-appconfig-cloudwatch-alarms-permissions.html">Configuring permissions for rollback based on Amazon CloudWatch alarms</a> in the <em>AWS AppConfig User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-finalbaketimeinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-finalbaketimeinminutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFinalBakeTimeInMinutes() {
        return null;
    }

    /**
     * The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:.
     * <p>
     * <em>Linear</em> : For this type, AWS AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code> . For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.
     * <p>
     * <em>Exponential</em> : For this type, AWS AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code> . In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
     * <p>
     * <code>2*(2^0)</code>
     * <p>
     * <code>2*(2^1)</code>
     * <p>
     * <code>2*(2^2)</code>
     * <p>
     * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGrowthType() {
        return null;
    }

    /**
     * Assigns metadata to an AWS AppConfig resource.
     * <p>
     * Tags help organize and categorize your AWS AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeploymentStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeploymentStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeploymentStrategyProps> {
        java.lang.Number deploymentDurationInMinutes;
        java.lang.Number growthFactor;
        java.lang.String name;
        java.lang.String replicateTo;
        java.lang.String description;
        java.lang.Number finalBakeTimeInMinutes;
        java.lang.String growthType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getDeploymentDurationInMinutes}
         * @param deploymentDurationInMinutes Total amount of time for a deployment to last. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentDurationInMinutes(java.lang.Number deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getGrowthFactor}
         * @param growthFactor The percentage of targets to receive a deployed configuration during each interval. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder growthFactor(java.lang.Number growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getName}
         * @param name A name for the deployment strategy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getReplicateTo}
         * @param replicateTo Save the deployment strategy to a Systems Manager (SSM) document. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicateTo(java.lang.String replicateTo) {
            this.replicateTo = replicateTo;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getDescription}
         * @param description A description of the deployment strategy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getFinalBakeTimeInMinutes}
         * @param finalBakeTimeInMinutes Specifies the amount of time AWS AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete.
         *                               If an alarm is triggered during this time, AWS AppConfig rolls back the deployment. You must configure permissions for AWS AppConfig to roll back based on CloudWatch alarms. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/getting-started-with-appconfig-cloudwatch-alarms-permissions.html">Configuring permissions for rollback based on Amazon CloudWatch alarms</a> in the <em>AWS AppConfig User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder finalBakeTimeInMinutes(java.lang.Number finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getGrowthType}
         * @param growthType The algorithm used to define how percentage grows over time. AWS AppConfig supports the following growth types:.
         *                   <em>Linear</em> : For this type, AWS AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code> . For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.
         *                   <p>
         *                   <em>Exponential</em> : For this type, AWS AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code> . In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
         *                   <p>
         *                   <code>2*(2^0)</code>
         *                   <p>
         *                   <code>2*(2^1)</code>
         *                   <p>
         *                   <code>2*(2^2)</code>
         *                   <p>
         *                   Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder growthType(java.lang.String growthType) {
            this.growthType = growthType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentStrategyProps#getTags}
         * @param tags Assigns metadata to an AWS AppConfig resource.
         *             Tags help organize and categorize your AWS AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeploymentStrategyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeploymentStrategyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeploymentStrategyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeploymentStrategyProps {
        private final java.lang.Number deploymentDurationInMinutes;
        private final java.lang.Number growthFactor;
        private final java.lang.String name;
        private final java.lang.String replicateTo;
        private final java.lang.String description;
        private final java.lang.Number finalBakeTimeInMinutes;
        private final java.lang.String growthType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentDurationInMinutes = software.amazon.jsii.Kernel.get(this, "deploymentDurationInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.growthFactor = software.amazon.jsii.Kernel.get(this, "growthFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicateTo = software.amazon.jsii.Kernel.get(this, "replicateTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.finalBakeTimeInMinutes = software.amazon.jsii.Kernel.get(this, "finalBakeTimeInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.growthType = software.amazon.jsii.Kernel.get(this, "growthType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentDurationInMinutes = java.util.Objects.requireNonNull(builder.deploymentDurationInMinutes, "deploymentDurationInMinutes is required");
            this.growthFactor = java.util.Objects.requireNonNull(builder.growthFactor, "growthFactor is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.replicateTo = java.util.Objects.requireNonNull(builder.replicateTo, "replicateTo is required");
            this.description = builder.description;
            this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
            this.growthType = builder.growthType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getDeploymentDurationInMinutes() {
            return this.deploymentDurationInMinutes;
        }

        @Override
        public final java.lang.Number getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getReplicateTo() {
            return this.replicateTo;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getFinalBakeTimeInMinutes() {
            return this.finalBakeTimeInMinutes;
        }

        @Override
        public final java.lang.String getGrowthType() {
            return this.growthType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deploymentDurationInMinutes", om.valueToTree(this.getDeploymentDurationInMinutes()));
            data.set("growthFactor", om.valueToTree(this.getGrowthFactor()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("replicateTo", om.valueToTree(this.getReplicateTo()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFinalBakeTimeInMinutes() != null) {
                data.set("finalBakeTimeInMinutes", om.valueToTree(this.getFinalBakeTimeInMinutes()));
            }
            if (this.getGrowthType() != null) {
                data.set("growthType", om.valueToTree(this.getGrowthType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.CfnDeploymentStrategyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeploymentStrategyProps.Jsii$Proxy that = (CfnDeploymentStrategyProps.Jsii$Proxy) o;

            if (!deploymentDurationInMinutes.equals(that.deploymentDurationInMinutes)) return false;
            if (!growthFactor.equals(that.growthFactor)) return false;
            if (!name.equals(that.name)) return false;
            if (!replicateTo.equals(that.replicateTo)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.finalBakeTimeInMinutes != null ? !this.finalBakeTimeInMinutes.equals(that.finalBakeTimeInMinutes) : that.finalBakeTimeInMinutes != null) return false;
            if (this.growthType != null ? !this.growthType.equals(that.growthType) : that.growthType != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentDurationInMinutes.hashCode();
            result = 31 * result + (this.growthFactor.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.replicateTo.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.finalBakeTimeInMinutes != null ? this.finalBakeTimeInMinutes.hashCode() : 0);
            result = 31 * result + (this.growthType != null ? this.growthType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
