package software.amazon.awscdk.services.appconfig;

/**
 * An AWS AppConfig extension.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new LambdaDestination(fn))
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.447Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.Extension")
public class Extension extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appconfig.IExtension {

    protected Extension(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Extension(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Extension(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an extension into the CDK using its Amazon Resource Name (ARN).
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the extension construct. This parameter is required.
     * @param extensionArn The Amazon Resource Name (ARN) of the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension fromExtensionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String extensionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Extension.class, "fromExtensionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IExtension.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(extensionArn, "extensionArn is required") });
    }

    /**
     * Imports an extension into the CDK using its attributes.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the extension construct. This parameter is required.
     * @param attrs The attributes of the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension fromExtensionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Extension.class, "fromExtensionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IExtension.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The Amazon Resource Name (ARN) of the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExtensionArn() {
        return software.amazon.jsii.Kernel.get(this, "extensionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExtensionId() {
        return software.amazon.jsii.Kernel.get(this, "extensionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getExtensionVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "extensionVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The actions for the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Action> getActions() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.Action>)(software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Action.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The description of the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The latest version number of the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getLatestVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "latestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The name of the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The parameters of the extension.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Parameter> getParameters() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.Parameter>)(software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appconfig.Extension}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appconfig.Extension> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appconfig.ExtensionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appconfig.ExtensionProps.Builder();
        }

        /**
         * A description of the extension.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the extension.
         * <p>
         * Default: - A name is generated.
         * <p>
         * @return {@code this}
         * @param extensionName The name of the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionName(final java.lang.String extensionName) {
            this.props.extensionName(extensionName);
            return this;
        }

        /**
         * The latest version number of the extension.
         * <p>
         * When you create a new version,
         * specify the most recent current version number. For example, you create version 3,
         * enter 2 for this field.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param latestVersionNumber The latest version number of the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestVersionNumber(final java.lang.Number latestVersionNumber) {
            this.props.latestVersionNumber(latestVersionNumber);
            return this;
        }

        /**
         * The parameters accepted for the extension.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param parameters The parameters accepted for the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.List<? extends software.amazon.awscdk.services.appconfig.Parameter> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The actions for the extension.
         * <p>
         * @return {@code this}
         * @param actions The actions for the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<? extends software.amazon.awscdk.services.appconfig.Action> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appconfig.Extension}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appconfig.Extension build() {
            return new software.amazon.awscdk.services.appconfig.Extension(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
