package software.amazon.awscdk.services.appconfig;

/**
 * Defines the rollout strategy for a deployment strategy and includes the growth factor, deployment duration, growth type, and optionally final bake time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DeploymentStrategy.Builder.create(this, "MyDeploymentStrategy")
 *         .rolloutStrategy(RolloutStrategy.linear(RolloutStrategyProps.builder()
 *                 .growthFactor(20)
 *                 .deploymentDuration(Duration.minutes(30))
 *                 .finalBakeTime(Duration.minutes(30))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html">https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.478Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.RolloutStrategy")
public abstract class RolloutStrategy extends software.amazon.jsii.JsiiObject {

    protected RolloutStrategy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RolloutStrategy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL_AT_ONCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.RolloutStrategy.class, "ALL_AT_ONCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.RolloutStrategy.class));
        CANARY_10_PERCENT_20_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.RolloutStrategy.class, "CANARY_10_PERCENT_20_MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.RolloutStrategy.class));
        LINEAR_20_PERCENT_EVERY_6_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.RolloutStrategy.class, "LINEAR_20_PERCENT_EVERY_6_MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.RolloutStrategy.class));
        LINEAR_50_PERCENT_EVERY_30_SECONDS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.RolloutStrategy.class, "LINEAR_50_PERCENT_EVERY_30_SECONDS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.RolloutStrategy.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RolloutStrategy() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Build your own exponential rollout strategy.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.RolloutStrategy exponential(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.RolloutStrategyProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.RolloutStrategy.class, "exponential", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.RolloutStrategy.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Build your own linear rollout strategy.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.RolloutStrategy linear(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.RolloutStrategyProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.RolloutStrategy.class, "linear", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.RolloutStrategy.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * <strong>Quick</strong>.
     * <p>
     * This strategy deploys the configuration to all targets immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.RolloutStrategy ALL_AT_ONCE;

    /**
     * <strong>AWS Recommended</strong>.
     * <p>
     * This strategy processes the deployment exponentially using a 10% growth factor over 20 minutes.
     * AWS AppConfig recommends using this strategy for production deployments because it aligns with AWS best practices
     * for configuration deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.RolloutStrategy CANARY_10_PERCENT_20_MINUTES;

    /**
     * <strong>AWS Recommended</strong>.
     * <p>
     * This strategy deploys the configuration to 20% of all targets every six minutes for a 30 minute deployment.
     * AWS AppConfig recommends using this strategy for production deployments because it aligns with AWS best practices
     * for configuration deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.RolloutStrategy LINEAR_20_PERCENT_EVERY_6_MINUTES;

    /**
     * <strong>Testing/Demonstration</strong>.
     * <p>
     * This strategy deploys the configuration to half of all targets every 30 seconds for a
     * one-minute deployment. AWS AppConfig recommends using this strategy only for testing or demonstration purposes because
     * it has a short duration and bake time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appconfig.RolloutStrategy LINEAR_50_PERCENT_EVERY_30_SECONDS;

    /**
     * The deployment duration of the rollout strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getDeploymentDuration();

    /**
     * The growth factor of the rollout strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Number getGrowthFactor();

    /**
     * The final bake time of the deployment strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getFinalBakeTime();

    /**
     * The growth type of the rollout strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.GrowthType getGrowthType();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appconfig.RolloutStrategy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The deployment duration of the rollout strategy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getDeploymentDuration() {
            return software.amazon.jsii.Kernel.get(this, "deploymentDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * The growth factor of the rollout strategy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Number getGrowthFactor() {
            return software.amazon.jsii.Kernel.get(this, "growthFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The final bake time of the deployment strategy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getFinalBakeTime() {
            return software.amazon.jsii.Kernel.get(this, "finalBakeTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * The growth type of the rollout strategy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.GrowthType getGrowthType() {
            return software.amazon.jsii.Kernel.get(this, "growthType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.GrowthType.class));
        }
    }
}
