package software.amazon.awscdk.services.appflow;

/**
 * The <code>AWS::AppFlow::ConnectorProfile</code> resource is an Amazon AppFlow resource type that specifies the configuration profile for an instance of a connector.
 * <p>
 * This includes the provided name, credentials ARN, connection-mode, and so on. The fields that are common to all types of connector profiles are explicitly specified under the <code>Properties</code> field. The rest of the connector-specific properties are specified under <code>Properties/ConnectorProfileConfig</code> .
 * <p>
 * <blockquote>
 * <p>
 * If you want to use AWS CloudFormation to create a connector profile for connectors that implement OAuth (such as Salesforce, Slack, Zendesk, and Google Analytics), you must fetch the access and refresh tokens. You can do this by implementing your own UI for OAuth, or by retrieving the tokens from elsewhere. Alternatively, you can use the Amazon AppFlow console to create the connector profile, and then use that connector profile in the flow creation CloudFormation template.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * CfnConnectorProfile cfnConnectorProfile = CfnConnectorProfile.Builder.create(this, "MyCfnConnectorProfile")
 *         .connectionMode("connectionMode")
 *         .connectorProfileName("connectorProfileName")
 *         .connectorType("connectorType")
 *         // the properties below are optional
 *         .connectorLabel("connectorLabel")
 *         .connectorProfileConfig(ConnectorProfileConfigProperty.builder()
 *                 .connectorProfileCredentials(ConnectorProfileCredentialsProperty.builder()
 *                         .amplitude(AmplitudeConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .secretKey("secretKey")
 *                                 .build())
 *                         .customConnector(CustomConnectorProfileCredentialsProperty.builder()
 *                                 .authenticationType("authenticationType")
 *                                 // the properties below are optional
 *                                 .apiKey(ApiKeyCredentialsProperty.builder()
 *                                         .apiKey("apiKey")
 *                                         // the properties below are optional
 *                                         .apiSecretKey("apiSecretKey")
 *                                         .build())
 *                                 .basic(BasicAuthCredentialsProperty.builder()
 *                                         .password("password")
 *                                         .username("username")
 *                                         .build())
 *                                 .custom(CustomAuthCredentialsProperty.builder()
 *                                         .customAuthenticationType("customAuthenticationType")
 *                                         // the properties below are optional
 *                                         .credentialsMap(Map.of(
 *                                                 "credentialsMapKey", "credentialsMap"))
 *                                         .build())
 *                                 .oauth2(OAuth2CredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .clientId("clientId")
 *                                         .clientSecret("clientSecret")
 *                                         .oAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                                 .authCode("authCode")
 *                                                 .redirectUri("redirectUri")
 *                                                 .build())
 *                                         .refreshToken("refreshToken")
 *                                         .build())
 *                                 .build())
 *                         .datadog(DatadogConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .applicationKey("applicationKey")
 *                                 .build())
 *                         .dynatrace(DynatraceConnectorProfileCredentialsProperty.builder()
 *                                 .apiToken("apiToken")
 *                                 .build())
 *                         .googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .inforNexus(InforNexusConnectorProfileCredentialsProperty.builder()
 *                                 .accessKeyId("accessKeyId")
 *                                 .datakey("datakey")
 *                                 .secretAccessKey("secretAccessKey")
 *                                 .userId("userId")
 *                                 .build())
 *                         .marketo(MarketoConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .pardot(PardotConnectorProfileCredentialsProperty.builder()
 *                                 .accessToken("accessToken")
 *                                 .clientCredentialsArn("clientCredentialsArn")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .redshift(RedshiftConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .salesforce(SalesforceConnectorProfileCredentialsProperty.builder()
 *                                 .accessToken("accessToken")
 *                                 .clientCredentialsArn("clientCredentialsArn")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .jwtToken("jwtToken")
 *                                 .oAuth2GrantType("oAuth2GrantType")
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .sapoData(SAPODataConnectorProfileCredentialsProperty.builder()
 *                                 .basicAuthCredentials(BasicAuthCredentialsProperty.builder()
 *                                         .password("password")
 *                                         .username("username")
 *                                         .build())
 *                                 .oAuthCredentials(OAuthCredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .clientId("clientId")
 *                                         .clientSecret("clientSecret")
 *                                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                                 .authCode("authCode")
 *                                                 .redirectUri("redirectUri")
 *                                                 .build())
 *                                         .refreshToken("refreshToken")
 *                                         .build())
 *                                 .build())
 *                         .serviceNow(ServiceNowConnectorProfileCredentialsProperty.builder()
 *                                 .oAuth2Credentials(OAuth2CredentialsProperty.builder()
 *                                         .accessToken("accessToken")
 *                                         .clientId("clientId")
 *                                         .clientSecret("clientSecret")
 *                                         .oAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                                 .authCode("authCode")
 *                                                 .redirectUri("redirectUri")
 *                                                 .build())
 *                                         .refreshToken("refreshToken")
 *                                         .build())
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .singular(SingularConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .build())
 *                         .slack(SlackConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .snowflake(SnowflakeConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .trendmicro(TrendmicroConnectorProfileCredentialsProperty.builder()
 *                                 .apiSecretKey("apiSecretKey")
 *                                 .build())
 *                         .veeva(VeevaConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .zendesk(ZendeskConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .connectorProfileProperties(ConnectorProfilePropertiesProperty.builder()
 *                         .customConnector(CustomConnectorProfilePropertiesProperty.builder()
 *                                 .oAuth2Properties(OAuth2PropertiesProperty.builder()
 *                                         .oAuth2GrantType("oAuth2GrantType")
 *                                         .tokenUrl("tokenUrl")
 *                                         .tokenUrlCustomProperties(Map.of(
 *                                                 "tokenUrlCustomPropertiesKey", "tokenUrlCustomProperties"))
 *                                         .build())
 *                                 .profileProperties(Map.of(
 *                                         "profilePropertiesKey", "profileProperties"))
 *                                 .build())
 *                         .datadog(DatadogConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .dynatrace(DynatraceConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .inforNexus(InforNexusConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .marketo(MarketoConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .pardot(PardotConnectorProfilePropertiesProperty.builder()
 *                                 .businessUnitId("businessUnitId")
 *                                 // the properties below are optional
 *                                 .instanceUrl("instanceUrl")
 *                                 .isSandboxEnvironment(false)
 *                                 .build())
 *                         .redshift(RedshiftConnectorProfilePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .clusterIdentifier("clusterIdentifier")
 *                                 .dataApiRoleArn("dataApiRoleArn")
 *                                 .databaseName("databaseName")
 *                                 .databaseUrl("databaseUrl")
 *                                 .isRedshiftServerless(false)
 *                                 .workgroupName("workgroupName")
 *                                 .build())
 *                         .salesforce(SalesforceConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .isSandboxEnvironment(false)
 *                                 .usePrivateLinkForMetadataAndAuthorization(false)
 *                                 .build())
 *                         .sapoData(SAPODataConnectorProfilePropertiesProperty.builder()
 *                                 .applicationHostUrl("applicationHostUrl")
 *                                 .applicationServicePath("applicationServicePath")
 *                                 .clientNumber("clientNumber")
 *                                 .disableSso(false)
 *                                 .logonLanguage("logonLanguage")
 *                                 .oAuthProperties(OAuthPropertiesProperty.builder()
 *                                         .authCodeUrl("authCodeUrl")
 *                                         .oAuthScopes(List.of("oAuthScopes"))
 *                                         .tokenUrl("tokenUrl")
 *                                         .build())
 *                                 .portNumber(123)
 *                                 .privateLinkServiceName("privateLinkServiceName")
 *                                 .build())
 *                         .serviceNow(ServiceNowConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .slack(SlackConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .snowflake(SnowflakeConnectorProfilePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .stage("stage")
 *                                 .warehouse("warehouse")
 *                                 // the properties below are optional
 *                                 .accountName("accountName")
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .privateLinkServiceName("privateLinkServiceName")
 *                                 .region("region")
 *                                 .build())
 *                         .veeva(VeevaConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .zendesk(ZendeskConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .kmsArn("kmsArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.487Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile")
public class CfnConnectorProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnectorProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnectorProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appflow.CfnConnectorProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnectorProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnConnectorProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the connector profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectorProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectorProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the connector profile credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCredentialsArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCredentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Indicates the connection mode and if it is public or private.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectionMode() {
        return software.amazon.jsii.Kernel.get(this, "connectionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the connection mode and if it is public or private.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionMode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectionMode", java.util.Objects.requireNonNull(value, "connectionMode is required"));
    }

    /**
     * The name of the connector profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectorProfileName() {
        return software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the connector profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorProfileName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorProfileName", java.util.Objects.requireNonNull(value, "connectorProfileName is required"));
    }

    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectorType() {
        return software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorType", java.util.Objects.requireNonNull(value, "connectorType is required"));
    }

    /**
     * The label for the connector profile being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectorLabel() {
        return software.amazon.jsii.Kernel.get(this, "connectorLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The label for the connector profile being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorLabel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorLabel", value);
    }

    /**
     * Defines the connector-specific configuration and credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConnectorProfileConfig() {
        return software.amazon.jsii.Kernel.get(this, "connectorProfileConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines the connector-specific configuration and credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorProfileConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectorProfileConfig", value);
    }

    /**
     * Defines the connector-specific configuration and credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorProfileConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectorProfileConfig", value);
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsArn", value);
    }
    /**
     * The connector-specific credentials required when using Amplitude.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * AmplitudeConnectorProfileCredentialsProperty amplitudeConnectorProfileCredentialsProperty = AmplitudeConnectorProfileCredentialsProperty.builder()
     *         .apiKey("apiKey")
     *         .secretKey("secretKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmplitudeConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmplitudeConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-amplitudeconnectorprofilecredentials-apikey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-amplitudeconnectorprofilecredentials-apikey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKey();

        /**
         * The Secret Access Key portion of the credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-amplitudeconnectorprofilecredentials-secretkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-amplitudeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-amplitudeconnectorprofilecredentials-secretkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretKey();

        /**
         * @return a {@link Builder} of {@link AmplitudeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmplitudeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmplitudeConnectorProfileCredentialsProperty> {
            java.lang.String apiKey;
            java.lang.String secretKey;

            /**
             * Sets the value of {@link AmplitudeConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(java.lang.String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Sets the value of {@link AmplitudeConnectorProfileCredentialsProperty#getSecretKey}
             * @param secretKey The Secret Access Key portion of the credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretKey(java.lang.String secretKey) {
                this.secretKey = secretKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmplitudeConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmplitudeConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmplitudeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmplitudeConnectorProfileCredentialsProperty {
            private final java.lang.String apiKey;
            private final java.lang.String secretKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretKey = software.amazon.jsii.Kernel.get(this, "secretKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKey = java.util.Objects.requireNonNull(builder.apiKey, "apiKey is required");
                this.secretKey = java.util.Objects.requireNonNull(builder.secretKey, "secretKey is required");
            }

            @Override
            public final java.lang.String getApiKey() {
                return this.apiKey;
            }

            @Override
            public final java.lang.String getSecretKey() {
                return this.secretKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKey", om.valueToTree(this.getApiKey()));
                data.set("secretKey", om.valueToTree(this.getSecretKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmplitudeConnectorProfileCredentialsProperty.Jsii$Proxy that = (AmplitudeConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!apiKey.equals(that.apiKey)) return false;
                return this.secretKey.equals(that.secretKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiKey.hashCode();
                result = 31 * result + (this.secretKey.hashCode());
                return result;
            }
        }
    }
    /**
     * The API key credentials required for API key authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ApiKeyCredentialsProperty apiKeyCredentialsProperty = ApiKeyCredentialsProperty.builder()
     *         .apiKey("apiKey")
     *         // the properties below are optional
     *         .apiSecretKey("apiSecretKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-apikeycredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-apikeycredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ApiKeyCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiKeyCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiKeyCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The API key required for API key authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-apikeycredentials.html#cfn-appflow-connectorprofile-apikeycredentials-apikey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-apikeycredentials.html#cfn-appflow-connectorprofile-apikeycredentials-apikey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKey();

        /**
         * The API secret key required for API key authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-apikeycredentials.html#cfn-appflow-connectorprofile-apikeycredentials-apisecretkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-apikeycredentials.html#cfn-appflow-connectorprofile-apikeycredentials-apisecretkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApiSecretKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiKeyCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiKeyCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiKeyCredentialsProperty> {
            java.lang.String apiKey;
            java.lang.String apiSecretKey;

            /**
             * Sets the value of {@link ApiKeyCredentialsProperty#getApiKey}
             * @param apiKey The API key required for API key authentication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(java.lang.String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Sets the value of {@link ApiKeyCredentialsProperty#getApiSecretKey}
             * @param apiSecretKey The API secret key required for API key authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSecretKey(java.lang.String apiSecretKey) {
                this.apiSecretKey = apiSecretKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiKeyCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiKeyCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiKeyCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiKeyCredentialsProperty {
            private final java.lang.String apiKey;
            private final java.lang.String apiSecretKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.apiSecretKey = software.amazon.jsii.Kernel.get(this, "apiSecretKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKey = java.util.Objects.requireNonNull(builder.apiKey, "apiKey is required");
                this.apiSecretKey = builder.apiSecretKey;
            }

            @Override
            public final java.lang.String getApiKey() {
                return this.apiKey;
            }

            @Override
            public final java.lang.String getApiSecretKey() {
                return this.apiSecretKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKey", om.valueToTree(this.getApiKey()));
                if (this.getApiSecretKey() != null) {
                    data.set("apiSecretKey", om.valueToTree(this.getApiSecretKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ApiKeyCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiKeyCredentialsProperty.Jsii$Proxy that = (ApiKeyCredentialsProperty.Jsii$Proxy) o;

                if (!apiKey.equals(that.apiKey)) return false;
                return this.apiSecretKey != null ? this.apiSecretKey.equals(that.apiSecretKey) : that.apiSecretKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.apiKey.hashCode();
                result = 31 * result + (this.apiSecretKey != null ? this.apiSecretKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The basic auth credentials required for basic authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * BasicAuthCredentialsProperty basicAuthCredentialsProperty = BasicAuthCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-basicauthcredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-basicauthcredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.BasicAuthCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(BasicAuthCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BasicAuthCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password to use to connect to a resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-basicauthcredentials.html#cfn-appflow-connectorprofile-basicauthcredentials-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-basicauthcredentials.html#cfn-appflow-connectorprofile-basicauthcredentials-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The username to use to connect to a resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-basicauthcredentials.html#cfn-appflow-connectorprofile-basicauthcredentials-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-basicauthcredentials.html#cfn-appflow-connectorprofile-basicauthcredentials-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link BasicAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BasicAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BasicAuthCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link BasicAuthCredentialsProperty#getPassword}
             * @param password The password to use to connect to a resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthCredentialsProperty#getUsername}
             * @param username The username to use to connect to a resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BasicAuthCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BasicAuthCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BasicAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicAuthCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.BasicAuthCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BasicAuthCredentialsProperty.Jsii$Proxy that = (BasicAuthCredentialsProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorOAuthRequestProperty connectorOAuthRequestProperty = ConnectorOAuthRequestProperty.builder()
     *         .authCode("authCode")
     *         .redirectUri("redirectUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorOAuthRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorOAuthRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The code provided by the connector when it has been authenticated via the connected app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html#cfn-appflow-connectorprofile-connectoroauthrequest-authcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html#cfn-appflow-connectorprofile-connectoroauthrequest-authcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthCode() {
            return null;
        }

        /**
         * The URL to which the authentication server redirects the browser after authorization has been granted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html#cfn-appflow-connectorprofile-connectoroauthrequest-redirecturi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectoroauthrequest.html#cfn-appflow-connectorprofile-connectoroauthrequest-redirecturi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRedirectUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorOAuthRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorOAuthRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorOAuthRequestProperty> {
            java.lang.String authCode;
            java.lang.String redirectUri;

            /**
             * Sets the value of {@link ConnectorOAuthRequestProperty#getAuthCode}
             * @param authCode The code provided by the connector when it has been authenticated via the connected app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authCode(java.lang.String authCode) {
                this.authCode = authCode;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOAuthRequestProperty#getRedirectUri}
             * @param redirectUri The URL to which the authentication server redirects the browser after authorization has been granted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectUri(java.lang.String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorOAuthRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorOAuthRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorOAuthRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorOAuthRequestProperty {
            private final java.lang.String authCode;
            private final java.lang.String redirectUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authCode = software.amazon.jsii.Kernel.get(this, "authCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redirectUri = software.amazon.jsii.Kernel.get(this, "redirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authCode = builder.authCode;
                this.redirectUri = builder.redirectUri;
            }

            @Override
            public final java.lang.String getAuthCode() {
                return this.authCode;
            }

            @Override
            public final java.lang.String getRedirectUri() {
                return this.redirectUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthCode() != null) {
                    data.set("authCode", om.valueToTree(this.getAuthCode()));
                }
                if (this.getRedirectUri() != null) {
                    data.set("redirectUri", om.valueToTree(this.getRedirectUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorOAuthRequestProperty.Jsii$Proxy that = (ConnectorOAuthRequestProperty.Jsii$Proxy) o;

                if (this.authCode != null ? !this.authCode.equals(that.authCode) : that.authCode != null) return false;
                return this.redirectUri != null ? this.redirectUri.equals(that.redirectUri) : that.redirectUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authCode != null ? this.authCode.hashCode() : 0;
                result = 31 * result + (this.redirectUri != null ? this.redirectUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the connector-specific configuration and credentials for the connector profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorProfileConfigProperty connectorProfileConfigProperty = ConnectorProfileConfigProperty.builder()
     *         .connectorProfileCredentials(ConnectorProfileCredentialsProperty.builder()
     *                 .amplitude(AmplitudeConnectorProfileCredentialsProperty.builder()
     *                         .apiKey("apiKey")
     *                         .secretKey("secretKey")
     *                         .build())
     *                 .customConnector(CustomConnectorProfileCredentialsProperty.builder()
     *                         .authenticationType("authenticationType")
     *                         // the properties below are optional
     *                         .apiKey(ApiKeyCredentialsProperty.builder()
     *                                 .apiKey("apiKey")
     *                                 // the properties below are optional
     *                                 .apiSecretKey("apiSecretKey")
     *                                 .build())
     *                         .basic(BasicAuthCredentialsProperty.builder()
     *                                 .password("password")
     *                                 .username("username")
     *                                 .build())
     *                         .custom(CustomAuthCredentialsProperty.builder()
     *                                 .customAuthenticationType("customAuthenticationType")
     *                                 // the properties below are optional
     *                                 .credentialsMap(Map.of(
     *                                         "credentialsMapKey", "credentialsMap"))
     *                                 .build())
     *                         .oauth2(OAuth2CredentialsProperty.builder()
     *                                 .accessToken("accessToken")
     *                                 .clientId("clientId")
     *                                 .clientSecret("clientSecret")
     *                                 .oAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                         .authCode("authCode")
     *                                         .redirectUri("redirectUri")
     *                                         .build())
     *                                 .refreshToken("refreshToken")
     *                                 .build())
     *                         .build())
     *                 .datadog(DatadogConnectorProfileCredentialsProperty.builder()
     *                         .apiKey("apiKey")
     *                         .applicationKey("applicationKey")
     *                         .build())
     *                 .dynatrace(DynatraceConnectorProfileCredentialsProperty.builder()
     *                         .apiToken("apiToken")
     *                         .build())
     *                 .googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .inforNexus(InforNexusConnectorProfileCredentialsProperty.builder()
     *                         .accessKeyId("accessKeyId")
     *                         .datakey("datakey")
     *                         .secretAccessKey("secretAccessKey")
     *                         .userId("userId")
     *                         .build())
     *                 .marketo(MarketoConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .build())
     *                 .pardot(PardotConnectorProfileCredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .clientCredentialsArn("clientCredentialsArn")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .redshift(RedshiftConnectorProfileCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .salesforce(SalesforceConnectorProfileCredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .clientCredentialsArn("clientCredentialsArn")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .jwtToken("jwtToken")
     *                         .oAuth2GrantType("oAuth2GrantType")
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .sapoData(SAPODataConnectorProfileCredentialsProperty.builder()
     *                         .basicAuthCredentials(BasicAuthCredentialsProperty.builder()
     *                                 .password("password")
     *                                 .username("username")
     *                                 .build())
     *                         .oAuthCredentials(OAuthCredentialsProperty.builder()
     *                                 .accessToken("accessToken")
     *                                 .clientId("clientId")
     *                                 .clientSecret("clientSecret")
     *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                         .authCode("authCode")
     *                                         .redirectUri("redirectUri")
     *                                         .build())
     *                                 .refreshToken("refreshToken")
     *                                 .build())
     *                         .build())
     *                 .serviceNow(ServiceNowConnectorProfileCredentialsProperty.builder()
     *                         .oAuth2Credentials(OAuth2CredentialsProperty.builder()
     *                                 .accessToken("accessToken")
     *                                 .clientId("clientId")
     *                                 .clientSecret("clientSecret")
     *                                 .oAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                         .authCode("authCode")
     *                                         .redirectUri("redirectUri")
     *                                         .build())
     *                                 .refreshToken("refreshToken")
     *                                 .build())
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .singular(SingularConnectorProfileCredentialsProperty.builder()
     *                         .apiKey("apiKey")
     *                         .build())
     *                 .slack(SlackConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .build())
     *                 .snowflake(SnowflakeConnectorProfileCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .trendmicro(TrendmicroConnectorProfileCredentialsProperty.builder()
     *                         .apiSecretKey("apiSecretKey")
     *                         .build())
     *                 .veeva(VeevaConnectorProfileCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .zendesk(ZendeskConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .connectorProfileProperties(ConnectorProfilePropertiesProperty.builder()
     *                 .customConnector(CustomConnectorProfilePropertiesProperty.builder()
     *                         .oAuth2Properties(OAuth2PropertiesProperty.builder()
     *                                 .oAuth2GrantType("oAuth2GrantType")
     *                                 .tokenUrl("tokenUrl")
     *                                 .tokenUrlCustomProperties(Map.of(
     *                                         "tokenUrlCustomPropertiesKey", "tokenUrlCustomProperties"))
     *                                 .build())
     *                         .profileProperties(Map.of(
     *                                 "profilePropertiesKey", "profileProperties"))
     *                         .build())
     *                 .datadog(DatadogConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .dynatrace(DynatraceConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .inforNexus(InforNexusConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .marketo(MarketoConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .pardot(PardotConnectorProfilePropertiesProperty.builder()
     *                         .businessUnitId("businessUnitId")
     *                         // the properties below are optional
     *                         .instanceUrl("instanceUrl")
     *                         .isSandboxEnvironment(false)
     *                         .build())
     *                 .redshift(RedshiftConnectorProfilePropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .clusterIdentifier("clusterIdentifier")
     *                         .dataApiRoleArn("dataApiRoleArn")
     *                         .databaseName("databaseName")
     *                         .databaseUrl("databaseUrl")
     *                         .isRedshiftServerless(false)
     *                         .workgroupName("workgroupName")
     *                         .build())
     *                 .salesforce(SalesforceConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .isSandboxEnvironment(false)
     *                         .usePrivateLinkForMetadataAndAuthorization(false)
     *                         .build())
     *                 .sapoData(SAPODataConnectorProfilePropertiesProperty.builder()
     *                         .applicationHostUrl("applicationHostUrl")
     *                         .applicationServicePath("applicationServicePath")
     *                         .clientNumber("clientNumber")
     *                         .disableSso(false)
     *                         .logonLanguage("logonLanguage")
     *                         .oAuthProperties(OAuthPropertiesProperty.builder()
     *                                 .authCodeUrl("authCodeUrl")
     *                                 .oAuthScopes(List.of("oAuthScopes"))
     *                                 .tokenUrl("tokenUrl")
     *                                 .build())
     *                         .portNumber(123)
     *                         .privateLinkServiceName("privateLinkServiceName")
     *                         .build())
     *                 .serviceNow(ServiceNowConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .slack(SlackConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .snowflake(SnowflakeConnectorProfilePropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .stage("stage")
     *                         .warehouse("warehouse")
     *                         // the properties below are optional
     *                         .accountName("accountName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .privateLinkServiceName("privateLinkServiceName")
     *                         .region("region")
     *                         .build())
     *                 .veeva(VeevaConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .zendesk(ZendeskConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorProfileConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorProfileConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connector-specific credentials required by each connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html#cfn-appflow-connectorprofile-connectorprofileconfig-connectorprofilecredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html#cfn-appflow-connectorprofile-connectorprofileconfig-connectorprofilecredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorProfileCredentials() {
            return null;
        }

        /**
         * The connector-specific properties of the profile configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html#cfn-appflow-connectorprofile-connectorprofileconfig-connectorprofileproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileconfig.html#cfn-appflow-connectorprofile-connectorprofileconfig-connectorprofileproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorProfileProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorProfileConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorProfileConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorProfileConfigProperty> {
            java.lang.Object connectorProfileCredentials;
            java.lang.Object connectorProfileProperties;

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileCredentials}
             * @param connectorProfileCredentials The connector-specific credentials required by each connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileCredentials(software.amazon.awscdk.IResolvable connectorProfileCredentials) {
                this.connectorProfileCredentials = connectorProfileCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileCredentials}
             * @param connectorProfileCredentials The connector-specific credentials required by each connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileCredentials(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileCredentialsProperty connectorProfileCredentials) {
                this.connectorProfileCredentials = connectorProfileCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileProperties}
             * @param connectorProfileProperties The connector-specific properties of the profile configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileProperties(software.amazon.awscdk.IResolvable connectorProfileProperties) {
                this.connectorProfileProperties = connectorProfileProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileProperties}
             * @param connectorProfileProperties The connector-specific properties of the profile configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileProperties(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfilePropertiesProperty connectorProfileProperties) {
                this.connectorProfileProperties = connectorProfileProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorProfileConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorProfileConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorProfileConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorProfileConfigProperty {
            private final java.lang.Object connectorProfileCredentials;
            private final java.lang.Object connectorProfileProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorProfileCredentials = software.amazon.jsii.Kernel.get(this, "connectorProfileCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectorProfileProperties = software.amazon.jsii.Kernel.get(this, "connectorProfileProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorProfileCredentials = builder.connectorProfileCredentials;
                this.connectorProfileProperties = builder.connectorProfileProperties;
            }

            @Override
            public final java.lang.Object getConnectorProfileCredentials() {
                return this.connectorProfileCredentials;
            }

            @Override
            public final java.lang.Object getConnectorProfileProperties() {
                return this.connectorProfileProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectorProfileCredentials() != null) {
                    data.set("connectorProfileCredentials", om.valueToTree(this.getConnectorProfileCredentials()));
                }
                if (this.getConnectorProfileProperties() != null) {
                    data.set("connectorProfileProperties", om.valueToTree(this.getConnectorProfileProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorProfileConfigProperty.Jsii$Proxy that = (ConnectorProfileConfigProperty.Jsii$Proxy) o;

                if (this.connectorProfileCredentials != null ? !this.connectorProfileCredentials.equals(that.connectorProfileCredentials) : that.connectorProfileCredentials != null) return false;
                return this.connectorProfileProperties != null ? this.connectorProfileProperties.equals(that.connectorProfileProperties) : that.connectorProfileProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorProfileCredentials != null ? this.connectorProfileCredentials.hashCode() : 0;
                result = 31 * result + (this.connectorProfileProperties != null ? this.connectorProfileProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific credentials required by a connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorProfileCredentialsProperty connectorProfileCredentialsProperty = ConnectorProfileCredentialsProperty.builder()
     *         .amplitude(AmplitudeConnectorProfileCredentialsProperty.builder()
     *                 .apiKey("apiKey")
     *                 .secretKey("secretKey")
     *                 .build())
     *         .customConnector(CustomConnectorProfileCredentialsProperty.builder()
     *                 .authenticationType("authenticationType")
     *                 // the properties below are optional
     *                 .apiKey(ApiKeyCredentialsProperty.builder()
     *                         .apiKey("apiKey")
     *                         // the properties below are optional
     *                         .apiSecretKey("apiSecretKey")
     *                         .build())
     *                 .basic(BasicAuthCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .custom(CustomAuthCredentialsProperty.builder()
     *                         .customAuthenticationType("customAuthenticationType")
     *                         // the properties below are optional
     *                         .credentialsMap(Map.of(
     *                                 "credentialsMapKey", "credentialsMap"))
     *                         .build())
     *                 .oauth2(OAuth2CredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         .oAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .build())
     *         .datadog(DatadogConnectorProfileCredentialsProperty.builder()
     *                 .apiKey("apiKey")
     *                 .applicationKey("applicationKey")
     *                 .build())
     *         .dynatrace(DynatraceConnectorProfileCredentialsProperty.builder()
     *                 .apiToken("apiToken")
     *                 .build())
     *         .googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .inforNexus(InforNexusConnectorProfileCredentialsProperty.builder()
     *                 .accessKeyId("accessKeyId")
     *                 .datakey("datakey")
     *                 .secretAccessKey("secretAccessKey")
     *                 .userId("userId")
     *                 .build())
     *         .marketo(MarketoConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .build())
     *         .pardot(PardotConnectorProfileCredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .clientCredentialsArn("clientCredentialsArn")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .redshift(RedshiftConnectorProfileCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .salesforce(SalesforceConnectorProfileCredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .clientCredentialsArn("clientCredentialsArn")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .jwtToken("jwtToken")
     *                 .oAuth2GrantType("oAuth2GrantType")
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .sapoData(SAPODataConnectorProfileCredentialsProperty.builder()
     *                 .basicAuthCredentials(BasicAuthCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .oAuthCredentials(OAuthCredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .build())
     *         .serviceNow(ServiceNowConnectorProfileCredentialsProperty.builder()
     *                 .oAuth2Credentials(OAuth2CredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         .oAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .singular(SingularConnectorProfileCredentialsProperty.builder()
     *                 .apiKey("apiKey")
     *                 .build())
     *         .slack(SlackConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .build())
     *         .snowflake(SnowflakeConnectorProfileCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .trendmicro(TrendmicroConnectorProfileCredentialsProperty.builder()
     *                 .apiSecretKey("apiSecretKey")
     *                 .build())
     *         .veeva(VeevaConnectorProfileCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .zendesk(ZendeskConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connector-specific credentials required when using Amplitude.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-amplitude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-amplitude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmplitude() {
            return null;
        }

        /**
         * The connector-specific profile credentials that are required when using the custom connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-customconnector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-customconnector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConnector() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Datadog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-datadog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-datadog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatadog() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Dynatrace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-dynatrace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-dynatrace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynatrace() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Google Analytics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-googleanalytics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-googleanalytics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGoogleAnalytics() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Infor Nexus.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-infornexus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-infornexus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInforNexus() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Marketo.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-marketo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-marketo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Salesforce Pardot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-pardot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-pardot</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPardot() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-redshift">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-redshift</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshift() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Salesforce.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-salesforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-salesforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * The connector-specific profile credentials required when using SAPOData.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-sapodata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-sapodata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * The connector-specific credentials required when using ServiceNow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-servicenow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-servicenow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNow() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Singular.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-singular">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-singular</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingular() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-slack">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-slack</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlack() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-snowflake">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-snowflake</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflake() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Trend Micro.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-trendmicro">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-trendmicro</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrendmicro() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Veeva.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-veeva">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-veeva</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVeeva() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Zendesk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-zendesk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofilecredentials.html#cfn-appflow-connectorprofile-connectorprofilecredentials-zendesk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorProfileCredentialsProperty> {
            java.lang.Object amplitude;
            java.lang.Object customConnector;
            java.lang.Object datadog;
            java.lang.Object dynatrace;
            java.lang.Object googleAnalytics;
            java.lang.Object inforNexus;
            java.lang.Object marketo;
            java.lang.Object pardot;
            java.lang.Object redshift;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object serviceNow;
            java.lang.Object singular;
            java.lang.Object slack;
            java.lang.Object snowflake;
            java.lang.Object trendmicro;
            java.lang.Object veeva;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getAmplitude}
             * @param amplitude The connector-specific credentials required when using Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.IResolvable amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getAmplitude}
             * @param amplitude The connector-specific credentials required when using Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.services.appflow.CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getCustomConnector}
             * @param customConnector The connector-specific profile credentials that are required when using the custom connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.IResolvable customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getCustomConnector}
             * @param customConnector The connector-specific profile credentials that are required when using the custom connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.services.appflow.CfnConnectorProfile.CustomConnectorProfileCredentialsProperty customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDatadog}
             * @param datadog The connector-specific credentials required when using Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDatadog}
             * @param datadog The connector-specific credentials required when using Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDynatrace}
             * @param dynatrace The connector-specific credentials required when using Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDynatrace}
             * @param dynatrace The connector-specific credentials required when using Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getGoogleAnalytics}
             * @param googleAnalytics The connector-specific credentials required when using Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.IResolvable googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getGoogleAnalytics}
             * @param googleAnalytics The connector-specific credentials required when using Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.services.appflow.CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getInforNexus}
             * @param inforNexus The connector-specific credentials required when using Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getInforNexus}
             * @param inforNexus The connector-specific credentials required when using Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.services.appflow.CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getMarketo}
             * @param marketo The connector-specific credentials required when using Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getMarketo}
             * @param marketo The connector-specific credentials required when using Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getPardot}
             * @param pardot The connector-specific credentials required when using Salesforce Pardot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pardot(software.amazon.awscdk.IResolvable pardot) {
                this.pardot = pardot;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getPardot}
             * @param pardot The connector-specific credentials required when using Salesforce Pardot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pardot(software.amazon.awscdk.services.appflow.CfnConnectorProfile.PardotConnectorProfileCredentialsProperty pardot) {
                this.pardot = pardot;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getRedshift}
             * @param redshift The connector-specific credentials required when using Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getRedshift}
             * @param redshift The connector-specific credentials required when using Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.services.appflow.CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSalesforce}
             * @param salesforce The connector-specific credentials required when using Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSalesforce}
             * @param salesforce The connector-specific credentials required when using Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSapoData}
             * @param sapoData The connector-specific profile credentials required when using SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSapoData}
             * @param sapoData The connector-specific profile credentials required when using SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getServiceNow}
             * @param serviceNow The connector-specific credentials required when using ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getServiceNow}
             * @param serviceNow The connector-specific credentials required when using ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSingular}
             * @param singular The connector-specific credentials required when using Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.IResolvable singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSingular}
             * @param singular The connector-specific credentials required when using Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SingularConnectorProfileCredentialsProperty singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSlack}
             * @param slack The connector-specific credentials required when using Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.IResolvable slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSlack}
             * @param slack The connector-specific credentials required when using Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SlackConnectorProfileCredentialsProperty slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSnowflake}
             * @param snowflake The connector-specific credentials required when using Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSnowflake}
             * @param snowflake The connector-specific credentials required when using Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getTrendmicro}
             * @param trendmicro The connector-specific credentials required when using Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.IResolvable trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getTrendmicro}
             * @param trendmicro The connector-specific credentials required when using Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.services.appflow.CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getVeeva}
             * @param veeva The connector-specific credentials required when using Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getVeeva}
             * @param veeva The connector-specific credentials required when using Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.services.appflow.CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getZendesk}
             * @param zendesk The connector-specific credentials required when using Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getZendesk}
             * @param zendesk The connector-specific credentials required when using Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorProfileCredentialsProperty {
            private final java.lang.Object amplitude;
            private final java.lang.Object customConnector;
            private final java.lang.Object datadog;
            private final java.lang.Object dynatrace;
            private final java.lang.Object googleAnalytics;
            private final java.lang.Object inforNexus;
            private final java.lang.Object marketo;
            private final java.lang.Object pardot;
            private final java.lang.Object redshift;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object serviceNow;
            private final java.lang.Object singular;
            private final java.lang.Object slack;
            private final java.lang.Object snowflake;
            private final java.lang.Object trendmicro;
            private final java.lang.Object veeva;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amplitude = software.amazon.jsii.Kernel.get(this, "amplitude", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.googleAnalytics = software.amazon.jsii.Kernel.get(this, "googleAnalytics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pardot = software.amazon.jsii.Kernel.get(this, "pardot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshift = software.amazon.jsii.Kernel.get(this, "redshift", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singular = software.amazon.jsii.Kernel.get(this, "singular", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflake = software.amazon.jsii.Kernel.get(this, "snowflake", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trendmicro = software.amazon.jsii.Kernel.get(this, "trendmicro", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amplitude = builder.amplitude;
                this.customConnector = builder.customConnector;
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.googleAnalytics = builder.googleAnalytics;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.pardot = builder.pardot;
                this.redshift = builder.redshift;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.singular = builder.singular;
                this.slack = builder.slack;
                this.snowflake = builder.snowflake;
                this.trendmicro = builder.trendmicro;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getAmplitude() {
                return this.amplitude;
            }

            @Override
            public final java.lang.Object getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.Object getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.Object getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.Object getGoogleAnalytics() {
                return this.googleAnalytics;
            }

            @Override
            public final java.lang.Object getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getPardot() {
                return this.pardot;
            }

            @Override
            public final java.lang.Object getRedshift() {
                return this.redshift;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.Object getSingular() {
                return this.singular;
            }

            @Override
            public final java.lang.Object getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.Object getSnowflake() {
                return this.snowflake;
            }

            @Override
            public final java.lang.Object getTrendmicro() {
                return this.trendmicro;
            }

            @Override
            public final java.lang.Object getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmplitude() != null) {
                    data.set("amplitude", om.valueToTree(this.getAmplitude()));
                }
                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getGoogleAnalytics() != null) {
                    data.set("googleAnalytics", om.valueToTree(this.getGoogleAnalytics()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getPardot() != null) {
                    data.set("pardot", om.valueToTree(this.getPardot()));
                }
                if (this.getRedshift() != null) {
                    data.set("redshift", om.valueToTree(this.getRedshift()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSingular() != null) {
                    data.set("singular", om.valueToTree(this.getSingular()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getSnowflake() != null) {
                    data.set("snowflake", om.valueToTree(this.getSnowflake()));
                }
                if (this.getTrendmicro() != null) {
                    data.set("trendmicro", om.valueToTree(this.getTrendmicro()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorProfileCredentialsProperty.Jsii$Proxy that = (ConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.amplitude != null ? !this.amplitude.equals(that.amplitude) : that.amplitude != null) return false;
                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.googleAnalytics != null ? !this.googleAnalytics.equals(that.googleAnalytics) : that.googleAnalytics != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.pardot != null ? !this.pardot.equals(that.pardot) : that.pardot != null) return false;
                if (this.redshift != null ? !this.redshift.equals(that.redshift) : that.redshift != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.singular != null ? !this.singular.equals(that.singular) : that.singular != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.snowflake != null ? !this.snowflake.equals(that.snowflake) : that.snowflake != null) return false;
                if (this.trendmicro != null ? !this.trendmicro.equals(that.trendmicro) : that.trendmicro != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amplitude != null ? this.amplitude.hashCode() : 0;
                result = 31 * result + (this.customConnector != null ? this.customConnector.hashCode() : 0);
                result = 31 * result + (this.datadog != null ? this.datadog.hashCode() : 0);
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.googleAnalytics != null ? this.googleAnalytics.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.pardot != null ? this.pardot.hashCode() : 0);
                result = 31 * result + (this.redshift != null ? this.redshift.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.singular != null ? this.singular.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.snowflake != null ? this.snowflake.hashCode() : 0);
                result = 31 * result + (this.trendmicro != null ? this.trendmicro.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required by each connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorProfilePropertiesProperty connectorProfilePropertiesProperty = ConnectorProfilePropertiesProperty.builder()
     *         .customConnector(CustomConnectorProfilePropertiesProperty.builder()
     *                 .oAuth2Properties(OAuth2PropertiesProperty.builder()
     *                         .oAuth2GrantType("oAuth2GrantType")
     *                         .tokenUrl("tokenUrl")
     *                         .tokenUrlCustomProperties(Map.of(
     *                                 "tokenUrlCustomPropertiesKey", "tokenUrlCustomProperties"))
     *                         .build())
     *                 .profileProperties(Map.of(
     *                         "profilePropertiesKey", "profileProperties"))
     *                 .build())
     *         .datadog(DatadogConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .dynatrace(DynatraceConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .inforNexus(InforNexusConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .marketo(MarketoConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .pardot(PardotConnectorProfilePropertiesProperty.builder()
     *                 .businessUnitId("businessUnitId")
     *                 // the properties below are optional
     *                 .instanceUrl("instanceUrl")
     *                 .isSandboxEnvironment(false)
     *                 .build())
     *         .redshift(RedshiftConnectorProfilePropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .clusterIdentifier("clusterIdentifier")
     *                 .dataApiRoleArn("dataApiRoleArn")
     *                 .databaseName("databaseName")
     *                 .databaseUrl("databaseUrl")
     *                 .isRedshiftServerless(false)
     *                 .workgroupName("workgroupName")
     *                 .build())
     *         .salesforce(SalesforceConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .isSandboxEnvironment(false)
     *                 .usePrivateLinkForMetadataAndAuthorization(false)
     *                 .build())
     *         .sapoData(SAPODataConnectorProfilePropertiesProperty.builder()
     *                 .applicationHostUrl("applicationHostUrl")
     *                 .applicationServicePath("applicationServicePath")
     *                 .clientNumber("clientNumber")
     *                 .disableSso(false)
     *                 .logonLanguage("logonLanguage")
     *                 .oAuthProperties(OAuthPropertiesProperty.builder()
     *                         .authCodeUrl("authCodeUrl")
     *                         .oAuthScopes(List.of("oAuthScopes"))
     *                         .tokenUrl("tokenUrl")
     *                         .build())
     *                 .portNumber(123)
     *                 .privateLinkServiceName("privateLinkServiceName")
     *                 .build())
     *         .serviceNow(ServiceNowConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .slack(SlackConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .snowflake(SnowflakeConnectorProfilePropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .stage("stage")
     *                 .warehouse("warehouse")
     *                 // the properties below are optional
     *                 .accountName("accountName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .privateLinkServiceName("privateLinkServiceName")
     *                 .region("region")
     *                 .build())
     *         .veeva(VeevaConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .zendesk(ZendeskConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties required by the custom connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-customconnector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-customconnector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConnector() {
            return null;
        }

        /**
         * The connector-specific properties required by Datadog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-datadog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-datadog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatadog() {
            return null;
        }

        /**
         * The connector-specific properties required by Dynatrace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-dynatrace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-dynatrace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynatrace() {
            return null;
        }

        /**
         * The connector-specific properties required by Infor Nexus.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-infornexus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-infornexus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInforNexus() {
            return null;
        }

        /**
         * The connector-specific properties required by Marketo.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-marketo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-marketo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * The connector-specific properties required by Salesforce Pardot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-pardot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-pardot</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPardot() {
            return null;
        }

        /**
         * The connector-specific properties required by Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-redshift">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-redshift</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshift() {
            return null;
        }

        /**
         * The connector-specific properties required by Salesforce.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-salesforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-salesforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * The connector-specific profile properties required when using SAPOData.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-sapodata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-sapodata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * The connector-specific properties required by serviceNow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-servicenow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-servicenow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNow() {
            return null;
        }

        /**
         * The connector-specific properties required by Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-slack">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-slack</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlack() {
            return null;
        }

        /**
         * The connector-specific properties required by Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-snowflake">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-snowflake</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflake() {
            return null;
        }

        /**
         * The connector-specific properties required by Veeva.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-veeva">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-veeva</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVeeva() {
            return null;
        }

        /**
         * The connector-specific properties required by Zendesk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-zendesk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-connectorprofileproperties.html#cfn-appflow-connectorprofile-connectorprofileproperties-zendesk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorProfilePropertiesProperty> {
            java.lang.Object customConnector;
            java.lang.Object datadog;
            java.lang.Object dynatrace;
            java.lang.Object inforNexus;
            java.lang.Object marketo;
            java.lang.Object pardot;
            java.lang.Object redshift;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object serviceNow;
            java.lang.Object slack;
            java.lang.Object snowflake;
            java.lang.Object veeva;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getCustomConnector}
             * @param customConnector The properties required by the custom connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.IResolvable customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getCustomConnector}
             * @param customConnector The properties required by the custom connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.services.appflow.CfnConnectorProfile.CustomConnectorProfilePropertiesProperty customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDatadog}
             * @param datadog The connector-specific properties required by Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDatadog}
             * @param datadog The connector-specific properties required by Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDynatrace}
             * @param dynatrace The connector-specific properties required by Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDynatrace}
             * @param dynatrace The connector-specific properties required by Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getInforNexus}
             * @param inforNexus The connector-specific properties required by Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getInforNexus}
             * @param inforNexus The connector-specific properties required by Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.services.appflow.CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getMarketo}
             * @param marketo The connector-specific properties required by Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getMarketo}
             * @param marketo The connector-specific properties required by Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getPardot}
             * @param pardot The connector-specific properties required by Salesforce Pardot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pardot(software.amazon.awscdk.IResolvable pardot) {
                this.pardot = pardot;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getPardot}
             * @param pardot The connector-specific properties required by Salesforce Pardot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pardot(software.amazon.awscdk.services.appflow.CfnConnectorProfile.PardotConnectorProfilePropertiesProperty pardot) {
                this.pardot = pardot;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getRedshift}
             * @param redshift The connector-specific properties required by Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getRedshift}
             * @param redshift The connector-specific properties required by Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.services.appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSalesforce}
             * @param salesforce The connector-specific properties required by Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSalesforce}
             * @param salesforce The connector-specific properties required by Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSapoData}
             * @param sapoData The connector-specific profile properties required when using SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSapoData}
             * @param sapoData The connector-specific profile properties required when using SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getServiceNow}
             * @param serviceNow The connector-specific properties required by serviceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getServiceNow}
             * @param serviceNow The connector-specific properties required by serviceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSlack}
             * @param slack The connector-specific properties required by Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.IResolvable slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSlack}
             * @param slack The connector-specific properties required by Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SlackConnectorProfilePropertiesProperty slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSnowflake}
             * @param snowflake The connector-specific properties required by Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSnowflake}
             * @param snowflake The connector-specific properties required by Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getVeeva}
             * @param veeva The connector-specific properties required by Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getVeeva}
             * @param veeva The connector-specific properties required by Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.services.appflow.CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getZendesk}
             * @param zendesk The connector-specific properties required by Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getZendesk}
             * @param zendesk The connector-specific properties required by Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorProfilePropertiesProperty {
            private final java.lang.Object customConnector;
            private final java.lang.Object datadog;
            private final java.lang.Object dynatrace;
            private final java.lang.Object inforNexus;
            private final java.lang.Object marketo;
            private final java.lang.Object pardot;
            private final java.lang.Object redshift;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object serviceNow;
            private final java.lang.Object slack;
            private final java.lang.Object snowflake;
            private final java.lang.Object veeva;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pardot = software.amazon.jsii.Kernel.get(this, "pardot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshift = software.amazon.jsii.Kernel.get(this, "redshift", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflake = software.amazon.jsii.Kernel.get(this, "snowflake", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customConnector = builder.customConnector;
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.pardot = builder.pardot;
                this.redshift = builder.redshift;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.slack = builder.slack;
                this.snowflake = builder.snowflake;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.Object getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.Object getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.Object getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getPardot() {
                return this.pardot;
            }

            @Override
            public final java.lang.Object getRedshift() {
                return this.redshift;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.Object getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.Object getSnowflake() {
                return this.snowflake;
            }

            @Override
            public final java.lang.Object getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getPardot() != null) {
                    data.set("pardot", om.valueToTree(this.getPardot()));
                }
                if (this.getRedshift() != null) {
                    data.set("redshift", om.valueToTree(this.getRedshift()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getSnowflake() != null) {
                    data.set("snowflake", om.valueToTree(this.getSnowflake()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorProfilePropertiesProperty.Jsii$Proxy that = (ConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.pardot != null ? !this.pardot.equals(that.pardot) : that.pardot != null) return false;
                if (this.redshift != null ? !this.redshift.equals(that.redshift) : that.redshift != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.snowflake != null ? !this.snowflake.equals(that.snowflake) : that.snowflake != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customConnector != null ? this.customConnector.hashCode() : 0;
                result = 31 * result + (this.datadog != null ? this.datadog.hashCode() : 0);
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.pardot != null ? this.pardot.hashCode() : 0);
                result = 31 * result + (this.redshift != null ? this.redshift.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.snowflake != null ? this.snowflake.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The custom credentials required for custom authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * CustomAuthCredentialsProperty customAuthCredentialsProperty = CustomAuthCredentialsProperty.builder()
     *         .customAuthenticationType("customAuthenticationType")
     *         // the properties below are optional
     *         .credentialsMap(Map.of(
     *                 "credentialsMapKey", "credentialsMap"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customauthcredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customauthcredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.CustomAuthCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomAuthCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomAuthCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom authentication type that the connector uses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customauthcredentials.html#cfn-appflow-connectorprofile-customauthcredentials-customauthenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customauthcredentials.html#cfn-appflow-connectorprofile-customauthcredentials-customauthenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCustomAuthenticationType();

        /**
         * A map that holds custom authentication credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customauthcredentials.html#cfn-appflow-connectorprofile-customauthcredentials-credentialsmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customauthcredentials.html#cfn-appflow-connectorprofile-customauthcredentials-credentialsmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCredentialsMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomAuthCredentialsProperty> {
            java.lang.String customAuthenticationType;
            java.lang.Object credentialsMap;

            /**
             * Sets the value of {@link CustomAuthCredentialsProperty#getCustomAuthenticationType}
             * @param customAuthenticationType The custom authentication type that the connector uses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAuthenticationType(java.lang.String customAuthenticationType) {
                this.customAuthenticationType = customAuthenticationType;
                return this;
            }

            /**
             * Sets the value of {@link CustomAuthCredentialsProperty#getCredentialsMap}
             * @param credentialsMap A map that holds custom authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsMap(java.util.Map<java.lang.String, java.lang.String> credentialsMap) {
                this.credentialsMap = credentialsMap;
                return this;
            }

            /**
             * Sets the value of {@link CustomAuthCredentialsProperty#getCredentialsMap}
             * @param credentialsMap A map that holds custom authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsMap(software.amazon.awscdk.IResolvable credentialsMap) {
                this.credentialsMap = credentialsMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomAuthCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomAuthCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomAuthCredentialsProperty {
            private final java.lang.String customAuthenticationType;
            private final java.lang.Object credentialsMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customAuthenticationType = software.amazon.jsii.Kernel.get(this, "customAuthenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialsMap = software.amazon.jsii.Kernel.get(this, "credentialsMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customAuthenticationType = java.util.Objects.requireNonNull(builder.customAuthenticationType, "customAuthenticationType is required");
                this.credentialsMap = builder.credentialsMap;
            }

            @Override
            public final java.lang.String getCustomAuthenticationType() {
                return this.customAuthenticationType;
            }

            @Override
            public final java.lang.Object getCredentialsMap() {
                return this.credentialsMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customAuthenticationType", om.valueToTree(this.getCustomAuthenticationType()));
                if (this.getCredentialsMap() != null) {
                    data.set("credentialsMap", om.valueToTree(this.getCredentialsMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.CustomAuthCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomAuthCredentialsProperty.Jsii$Proxy that = (CustomAuthCredentialsProperty.Jsii$Proxy) o;

                if (!customAuthenticationType.equals(that.customAuthenticationType)) return false;
                return this.credentialsMap != null ? this.credentialsMap.equals(that.credentialsMap) : that.credentialsMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customAuthenticationType.hashCode();
                result = 31 * result + (this.credentialsMap != null ? this.credentialsMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials that are required when using the custom connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * CustomConnectorProfileCredentialsProperty customConnectorProfileCredentialsProperty = CustomConnectorProfileCredentialsProperty.builder()
     *         .authenticationType("authenticationType")
     *         // the properties below are optional
     *         .apiKey(ApiKeyCredentialsProperty.builder()
     *                 .apiKey("apiKey")
     *                 // the properties below are optional
     *                 .apiSecretKey("apiSecretKey")
     *                 .build())
     *         .basic(BasicAuthCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .custom(CustomAuthCredentialsProperty.builder()
     *                 .customAuthenticationType("customAuthenticationType")
     *                 // the properties below are optional
     *                 .credentialsMap(Map.of(
     *                         "credentialsMapKey", "credentialsMap"))
     *                 .build())
     *         .oauth2(OAuth2CredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 .oAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.CustomConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authentication type that the custom connector uses for authenticating while creating a connector profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-authenticationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

        /**
         * The API keys required for the authentication of the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-apikey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-apikey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApiKey() {
            return null;
        }

        /**
         * The basic credentials that are required for the authentication of the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-basic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-basic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasic() {
            return null;
        }

        /**
         * If the connector uses the custom authentication mechanism, this holds the required credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-custom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-custom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustom() {
            return null;
        }

        /**
         * The OAuth 2.0 credentials required for the authentication of the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-oauth2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofilecredentials.html#cfn-appflow-connectorprofile-customconnectorprofilecredentials-oauth2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOauth2() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomConnectorProfileCredentialsProperty> {
            java.lang.String authenticationType;
            java.lang.Object apiKey;
            java.lang.Object basic;
            java.lang.Object custom;
            java.lang.Object oauth2;

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getAuthenticationType}
             * @param authenticationType The authentication type that the custom connector uses for authenticating while creating a connector profile. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey The API keys required for the authentication of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(software.amazon.awscdk.IResolvable apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey The API keys required for the authentication of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ApiKeyCredentialsProperty apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getBasic}
             * @param basic The basic credentials that are required for the authentication of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basic(software.amazon.awscdk.IResolvable basic) {
                this.basic = basic;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getBasic}
             * @param basic The basic credentials that are required for the authentication of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basic(software.amazon.awscdk.services.appflow.CfnConnectorProfile.BasicAuthCredentialsProperty basic) {
                this.basic = basic;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getCustom}
             * @param custom If the connector uses the custom authentication mechanism, this holds the required credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(software.amazon.awscdk.IResolvable custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getCustom}
             * @param custom If the connector uses the custom authentication mechanism, this holds the required credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(software.amazon.awscdk.services.appflow.CfnConnectorProfile.CustomAuthCredentialsProperty custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getOauth2}
             * @param oauth2 The OAuth 2.0 credentials required for the authentication of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oauth2(software.amazon.awscdk.IResolvable oauth2) {
                this.oauth2 = oauth2;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfileCredentialsProperty#getOauth2}
             * @param oauth2 The OAuth 2.0 credentials required for the authentication of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oauth2(software.amazon.awscdk.services.appflow.CfnConnectorProfile.OAuth2CredentialsProperty oauth2) {
                this.oauth2 = oauth2;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomConnectorProfileCredentialsProperty {
            private final java.lang.String authenticationType;
            private final java.lang.Object apiKey;
            private final java.lang.Object basic;
            private final java.lang.Object custom;
            private final java.lang.Object oauth2;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.basic = software.amazon.jsii.Kernel.get(this, "basic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.custom = software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oauth2 = software.amazon.jsii.Kernel.get(this, "oauth2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
                this.apiKey = builder.apiKey;
                this.basic = builder.basic;
                this.custom = builder.custom;
                this.oauth2 = builder.oauth2;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getApiKey() {
                return this.apiKey;
            }

            @Override
            public final java.lang.Object getBasic() {
                return this.basic;
            }

            @Override
            public final java.lang.Object getCustom() {
                return this.custom;
            }

            @Override
            public final java.lang.Object getOauth2() {
                return this.oauth2;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                if (this.getApiKey() != null) {
                    data.set("apiKey", om.valueToTree(this.getApiKey()));
                }
                if (this.getBasic() != null) {
                    data.set("basic", om.valueToTree(this.getBasic()));
                }
                if (this.getCustom() != null) {
                    data.set("custom", om.valueToTree(this.getCustom()));
                }
                if (this.getOauth2() != null) {
                    data.set("oauth2", om.valueToTree(this.getOauth2()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.CustomConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomConnectorProfileCredentialsProperty.Jsii$Proxy that = (CustomConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!authenticationType.equals(that.authenticationType)) return false;
                if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) return false;
                if (this.basic != null ? !this.basic.equals(that.basic) : that.basic != null) return false;
                if (this.custom != null ? !this.custom.equals(that.custom) : that.custom != null) return false;
                return this.oauth2 != null ? this.oauth2.equals(that.oauth2) : that.oauth2 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationType.hashCode();
                result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
                result = 31 * result + (this.basic != null ? this.basic.hashCode() : 0);
                result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
                result = 31 * result + (this.oauth2 != null ? this.oauth2.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The profile properties required by the custom connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * CustomConnectorProfilePropertiesProperty customConnectorProfilePropertiesProperty = CustomConnectorProfilePropertiesProperty.builder()
     *         .oAuth2Properties(OAuth2PropertiesProperty.builder()
     *                 .oAuth2GrantType("oAuth2GrantType")
     *                 .tokenUrl("tokenUrl")
     *                 .tokenUrlCustomProperties(Map.of(
     *                         "tokenUrlCustomPropertiesKey", "tokenUrlCustomProperties"))
     *                 .build())
     *         .profileProperties(Map.of(
     *                 "profilePropertiesKey", "profileProperties"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.CustomConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The OAuth 2.0 properties required for OAuth 2.0 authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofileproperties.html#cfn-appflow-connectorprofile-customconnectorprofileproperties-oauth2properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofileproperties.html#cfn-appflow-connectorprofile-customconnectorprofileproperties-oauth2properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2Properties() {
            return null;
        }

        /**
         * A map of properties that are required to create a profile for the custom connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofileproperties.html#cfn-appflow-connectorprofile-customconnectorprofileproperties-profileproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-customconnectorprofileproperties.html#cfn-appflow-connectorprofile-customconnectorprofileproperties-profileproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProfileProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomConnectorProfilePropertiesProperty> {
            java.lang.Object oAuth2Properties;
            java.lang.Object profileProperties;

            /**
             * Sets the value of {@link CustomConnectorProfilePropertiesProperty#getOAuth2Properties}
             * @param oAuth2Properties The OAuth 2.0 properties required for OAuth 2.0 authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Properties(software.amazon.awscdk.IResolvable oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfilePropertiesProperty#getOAuth2Properties}
             * @param oAuth2Properties The OAuth 2.0 properties required for OAuth 2.0 authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Properties(software.amazon.awscdk.services.appflow.CfnConnectorProfile.OAuth2PropertiesProperty oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfilePropertiesProperty#getProfileProperties}
             * @param profileProperties A map of properties that are required to create a profile for the custom connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileProperties(java.util.Map<java.lang.String, java.lang.String> profileProperties) {
                this.profileProperties = profileProperties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorProfilePropertiesProperty#getProfileProperties}
             * @param profileProperties A map of properties that are required to create a profile for the custom connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileProperties(software.amazon.awscdk.IResolvable profileProperties) {
                this.profileProperties = profileProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomConnectorProfilePropertiesProperty {
            private final java.lang.Object oAuth2Properties;
            private final java.lang.Object profileProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.oAuth2Properties = software.amazon.jsii.Kernel.get(this, "oAuth2Properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.profileProperties = software.amazon.jsii.Kernel.get(this, "profileProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.oAuth2Properties = builder.oAuth2Properties;
                this.profileProperties = builder.profileProperties;
            }

            @Override
            public final java.lang.Object getOAuth2Properties() {
                return this.oAuth2Properties;
            }

            @Override
            public final java.lang.Object getProfileProperties() {
                return this.profileProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOAuth2Properties() != null) {
                    data.set("oAuth2Properties", om.valueToTree(this.getOAuth2Properties()));
                }
                if (this.getProfileProperties() != null) {
                    data.set("profileProperties", om.valueToTree(this.getProfileProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.CustomConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomConnectorProfilePropertiesProperty.Jsii$Proxy that = (CustomConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (this.oAuth2Properties != null ? !this.oAuth2Properties.equals(that.oAuth2Properties) : that.oAuth2Properties != null) return false;
                return this.profileProperties != null ? this.profileProperties.equals(that.profileProperties) : that.profileProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.oAuth2Properties != null ? this.oAuth2Properties.hashCode() : 0;
                result = 31 * result + (this.profileProperties != null ? this.profileProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific credentials required by Datadog.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DatadogConnectorProfileCredentialsProperty datadogConnectorProfileCredentialsProperty = DatadogConnectorProfileCredentialsProperty.builder()
     *         .apiKey("apiKey")
     *         .applicationKey("applicationKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(DatadogConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatadogConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html#cfn-appflow-connectorprofile-datadogconnectorprofilecredentials-apikey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html#cfn-appflow-connectorprofile-datadogconnectorprofilecredentials-apikey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKey();

        /**
         * Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API.
         * <p>
         * Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html#cfn-appflow-connectorprofile-datadogconnectorprofilecredentials-applicationkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofilecredentials.html#cfn-appflow-connectorprofile-datadogconnectorprofilecredentials-applicationkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApplicationKey();

        /**
         * @return a {@link Builder} of {@link DatadogConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatadogConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatadogConnectorProfileCredentialsProperty> {
            java.lang.String apiKey;
            java.lang.String applicationKey;

            /**
             * Sets the value of {@link DatadogConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(java.lang.String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Sets the value of {@link DatadogConnectorProfileCredentialsProperty#getApplicationKey}
             * @param applicationKey Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. This parameter is required.
             *                       Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationKey(java.lang.String applicationKey) {
                this.applicationKey = applicationKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatadogConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatadogConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatadogConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatadogConnectorProfileCredentialsProperty {
            private final java.lang.String apiKey;
            private final java.lang.String applicationKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationKey = software.amazon.jsii.Kernel.get(this, "applicationKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKey = java.util.Objects.requireNonNull(builder.apiKey, "apiKey is required");
                this.applicationKey = java.util.Objects.requireNonNull(builder.applicationKey, "applicationKey is required");
            }

            @Override
            public final java.lang.String getApiKey() {
                return this.apiKey;
            }

            @Override
            public final java.lang.String getApplicationKey() {
                return this.applicationKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKey", om.valueToTree(this.getApiKey()));
                data.set("applicationKey", om.valueToTree(this.getApplicationKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatadogConnectorProfileCredentialsProperty.Jsii$Proxy that = (DatadogConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!apiKey.equals(that.apiKey)) return false;
                return this.applicationKey.equals(that.applicationKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiKey.hashCode();
                result = 31 * result + (this.applicationKey.hashCode());
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required by Datadog.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DatadogConnectorProfilePropertiesProperty datadogConnectorProfilePropertiesProperty = DatadogConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DatadogConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatadogConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Datadog resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofileproperties.html#cfn-appflow-connectorprofile-datadogconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-datadogconnectorprofileproperties.html#cfn-appflow-connectorprofile-datadogconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link DatadogConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatadogConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatadogConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link DatadogConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Datadog resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatadogConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatadogConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatadogConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatadogConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatadogConnectorProfilePropertiesProperty.Jsii$Proxy that = (DatadogConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required by Dynatrace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DynatraceConnectorProfileCredentialsProperty dynatraceConnectorProfileCredentialsProperty = DynatraceConnectorProfileCredentialsProperty.builder()
     *         .apiToken("apiToken")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(DynatraceConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynatraceConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The API tokens used by Dynatrace API to authenticate various API calls.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-dynatraceconnectorprofilecredentials-apitoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-dynatraceconnectorprofilecredentials-apitoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiToken();

        /**
         * @return a {@link Builder} of {@link DynatraceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynatraceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynatraceConnectorProfileCredentialsProperty> {
            java.lang.String apiToken;

            /**
             * Sets the value of {@link DynatraceConnectorProfileCredentialsProperty#getApiToken}
             * @param apiToken The API tokens used by Dynatrace API to authenticate various API calls. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiToken(java.lang.String apiToken) {
                this.apiToken = apiToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynatraceConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynatraceConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynatraceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynatraceConnectorProfileCredentialsProperty {
            private final java.lang.String apiToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiToken = software.amazon.jsii.Kernel.get(this, "apiToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiToken = java.util.Objects.requireNonNull(builder.apiToken, "apiToken is required");
            }

            @Override
            public final java.lang.String getApiToken() {
                return this.apiToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiToken", om.valueToTree(this.getApiToken()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynatraceConnectorProfileCredentialsProperty.Jsii$Proxy that = (DynatraceConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                return this.apiToken.equals(that.apiToken);
            }

            @Override
            public final int hashCode() {
                int result = this.apiToken.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required by Dynatrace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DynatraceConnectorProfilePropertiesProperty dynatraceConnectorProfilePropertiesProperty = DynatraceConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DynatraceConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynatraceConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Dynatrace resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofileproperties.html#cfn-appflow-connectorprofile-dynatraceconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-dynatraceconnectorprofileproperties.html#cfn-appflow-connectorprofile-dynatraceconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link DynatraceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynatraceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynatraceConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link DynatraceConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Dynatrace resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynatraceConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynatraceConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynatraceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynatraceConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynatraceConnectorProfilePropertiesProperty.Jsii$Proxy that = (DynatraceConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required by Google Analytics.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * GoogleAnalyticsConnectorProfileCredentialsProperty googleAnalyticsConnectorProfileCredentialsProperty = GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(GoogleAnalyticsConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GoogleAnalyticsConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the desired client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Google Analytics resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-connectoroauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-connectoroauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * The credentials used to acquire new access tokens.
         * <p>
         * This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials.html#cfn-appflow-connectorprofile-googleanalyticsconnectorprofilecredentials-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GoogleAnalyticsConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Google Analytics resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getRefreshToken}
             * @param refreshToken The credentials used to acquire new access tokens.
             *                     This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GoogleAnalyticsConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GoogleAnalyticsConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GoogleAnalyticsConnectorProfileCredentialsProperty.Jsii$Proxy that = (GoogleAnalyticsConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.connectorOAuthRequest != null ? !this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required by Infor Nexus.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * InforNexusConnectorProfileCredentialsProperty inforNexusConnectorProfileCredentialsProperty = InforNexusConnectorProfileCredentialsProperty.builder()
     *         .accessKeyId("accessKeyId")
     *         .datakey("datakey")
     *         .secretAccessKey("secretAccessKey")
     *         .userId("userId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(InforNexusConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InforNexusConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Access Key portion of the credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-accesskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-accesskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccessKeyId();

        /**
         * The encryption keys used to encrypt data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-datakey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-datakey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatakey();

        /**
         * The secret key used to sign requests.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-secretaccesskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-secretaccesskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretAccessKey();

        /**
         * The identifier for the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-userid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofilecredentials.html#cfn-appflow-connectorprofile-infornexusconnectorprofilecredentials-userid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserId();

        /**
         * @return a {@link Builder} of {@link InforNexusConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InforNexusConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InforNexusConnectorProfileCredentialsProperty> {
            java.lang.String accessKeyId;
            java.lang.String datakey;
            java.lang.String secretAccessKey;
            java.lang.String userId;

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getAccessKeyId}
             * @param accessKeyId The Access Key portion of the credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessKeyId(java.lang.String accessKeyId) {
                this.accessKeyId = accessKeyId;
                return this;
            }

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getDatakey}
             * @param datakey The encryption keys used to encrypt data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datakey(java.lang.String datakey) {
                this.datakey = datakey;
                return this;
            }

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getSecretAccessKey}
             * @param secretAccessKey The secret key used to sign requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretAccessKey(java.lang.String secretAccessKey) {
                this.secretAccessKey = secretAccessKey;
                return this;
            }

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getUserId}
             * @param userId The identifier for the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userId(java.lang.String userId) {
                this.userId = userId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InforNexusConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InforNexusConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InforNexusConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InforNexusConnectorProfileCredentialsProperty {
            private final java.lang.String accessKeyId;
            private final java.lang.String datakey;
            private final java.lang.String secretAccessKey;
            private final java.lang.String userId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessKeyId = software.amazon.jsii.Kernel.get(this, "accessKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datakey = software.amazon.jsii.Kernel.get(this, "datakey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretAccessKey = software.amazon.jsii.Kernel.get(this, "secretAccessKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userId = software.amazon.jsii.Kernel.get(this, "userId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessKeyId = java.util.Objects.requireNonNull(builder.accessKeyId, "accessKeyId is required");
                this.datakey = java.util.Objects.requireNonNull(builder.datakey, "datakey is required");
                this.secretAccessKey = java.util.Objects.requireNonNull(builder.secretAccessKey, "secretAccessKey is required");
                this.userId = java.util.Objects.requireNonNull(builder.userId, "userId is required");
            }

            @Override
            public final java.lang.String getAccessKeyId() {
                return this.accessKeyId;
            }

            @Override
            public final java.lang.String getDatakey() {
                return this.datakey;
            }

            @Override
            public final java.lang.String getSecretAccessKey() {
                return this.secretAccessKey;
            }

            @Override
            public final java.lang.String getUserId() {
                return this.userId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessKeyId", om.valueToTree(this.getAccessKeyId()));
                data.set("datakey", om.valueToTree(this.getDatakey()));
                data.set("secretAccessKey", om.valueToTree(this.getSecretAccessKey()));
                data.set("userId", om.valueToTree(this.getUserId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InforNexusConnectorProfileCredentialsProperty.Jsii$Proxy that = (InforNexusConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!accessKeyId.equals(that.accessKeyId)) return false;
                if (!datakey.equals(that.datakey)) return false;
                if (!secretAccessKey.equals(that.secretAccessKey)) return false;
                return this.userId.equals(that.userId);
            }

            @Override
            public final int hashCode() {
                int result = this.accessKeyId.hashCode();
                result = 31 * result + (this.datakey.hashCode());
                result = 31 * result + (this.secretAccessKey.hashCode());
                result = 31 * result + (this.userId.hashCode());
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required by Infor Nexus.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * InforNexusConnectorProfilePropertiesProperty inforNexusConnectorProfilePropertiesProperty = InforNexusConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(InforNexusConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InforNexusConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Infor Nexus resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofileproperties.html#cfn-appflow-connectorprofile-infornexusconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-infornexusconnectorprofileproperties.html#cfn-appflow-connectorprofile-infornexusconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link InforNexusConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InforNexusConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InforNexusConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link InforNexusConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Infor Nexus resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InforNexusConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InforNexusConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InforNexusConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InforNexusConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InforNexusConnectorProfilePropertiesProperty.Jsii$Proxy that = (InforNexusConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required by Marketo.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoConnectorProfileCredentialsProperty marketoConnectorProfileCredentialsProperty = MarketoConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the desired client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Marketo resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-connectoroauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofilecredentials.html#cfn-appflow-connectorprofile-marketoconnectorprofilecredentials-connectoroauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MarketoConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Marketo resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoConnectorProfileCredentialsProperty.Jsii$Proxy that = (MarketoConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                return this.connectorOAuthRequest != null ? this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using Marketo.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoConnectorProfilePropertiesProperty marketoConnectorProfilePropertiesProperty = MarketoConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Marketo resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofileproperties.html#cfn-appflow-connectorprofile-marketoconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-marketoconnectorprofileproperties.html#cfn-appflow-connectorprofile-marketoconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link MarketoConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link MarketoConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Marketo resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoConnectorProfilePropertiesProperty.Jsii$Proxy that = (MarketoConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The OAuth 2.0 credentials required for OAuth 2.0 authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * OAuth2CredentialsProperty oAuth2CredentialsProperty = OAuth2CredentialsProperty.builder()
     *         .accessToken("accessToken")
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         .oAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuth2CredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2CredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2CredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access token used to access the connector on your behalf.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * The identifier for the desired client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientSecret() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-oauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-oauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthRequest() {
            return null;
        }

        /**
         * The refresh token used to refresh an expired access token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2credentials.html#cfn-appflow-connectorprofile-oauth2credentials-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2CredentialsProperty> {
            java.lang.String accessToken;
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.Object oAuthRequest;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getAccessToken}
             * @param accessToken The access token used to access the connector on your behalf.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getOAuthRequest}
             * @param oAuthRequest the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthRequest(software.amazon.awscdk.IResolvable oAuthRequest) {
                this.oAuthRequest = oAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getOAuthRequest}
             * @param oAuthRequest the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty oAuthRequest) {
                this.oAuthRequest = oAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2CredentialsProperty#getRefreshToken}
             * @param refreshToken The refresh token used to refresh an expired access token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2CredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2CredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2CredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2CredentialsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.Object oAuthRequest;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthRequest = software.amazon.jsii.Kernel.get(this, "oAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.clientId = builder.clientId;
                this.clientSecret = builder.clientSecret;
                this.oAuthRequest = builder.oAuthRequest;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.Object getOAuthRequest() {
                return this.oAuthRequest;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getClientSecret() != null) {
                    data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                }
                if (this.getOAuthRequest() != null) {
                    data.set("oAuthRequest", om.valueToTree(this.getOAuthRequest()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuth2CredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2CredentialsProperty.Jsii$Proxy that = (OAuth2CredentialsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
                if (this.oAuthRequest != null ? !this.oAuthRequest.equals(that.oAuthRequest) : that.oAuthRequest != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
                result = 31 * result + (this.oAuthRequest != null ? this.oAuthRequest.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OAuth 2.0 properties required for OAuth 2.0 authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * OAuth2PropertiesProperty oAuth2PropertiesProperty = OAuth2PropertiesProperty.builder()
     *         .oAuth2GrantType("oAuth2GrantType")
     *         .tokenUrl("tokenUrl")
     *         .tokenUrlCustomProperties(Map.of(
     *                 "tokenUrlCustomPropertiesKey", "tokenUrlCustomProperties"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuth2PropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2PropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2PropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html#cfn-appflow-connectorprofile-oauth2properties-oauth2granttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html#cfn-appflow-connectorprofile-oauth2properties-oauth2granttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOAuth2GrantType() {
            return null;
        }

        /**
         * The token URL required for OAuth 2.0 authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html#cfn-appflow-connectorprofile-oauth2properties-tokenurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html#cfn-appflow-connectorprofile-oauth2properties-tokenurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenUrl() {
            return null;
        }

        /**
         * Associates your token URL with a map of properties that you define.
         * <p>
         * Use this parameter to provide any additional details that the connector requires to authenticate your request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html#cfn-appflow-connectorprofile-oauth2properties-tokenurlcustomproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauth2properties.html#cfn-appflow-connectorprofile-oauth2properties-tokenurlcustomproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTokenUrlCustomProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2PropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2PropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2PropertiesProperty> {
            java.lang.String oAuth2GrantType;
            java.lang.String tokenUrl;
            java.lang.Object tokenUrlCustomProperties;

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getOAuth2GrantType}
             * @param oAuth2GrantType The OAuth 2.0 grant type used by connector for OAuth 2.0 authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2GrantType(java.lang.String oAuth2GrantType) {
                this.oAuth2GrantType = oAuth2GrantType;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getTokenUrl}
             * @param tokenUrl The token URL required for OAuth 2.0 authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrl(java.lang.String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getTokenUrlCustomProperties}
             * @param tokenUrlCustomProperties Associates your token URL with a map of properties that you define.
             *                                 Use this parameter to provide any additional details that the connector requires to authenticate your request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrlCustomProperties(java.util.Map<java.lang.String, java.lang.String> tokenUrlCustomProperties) {
                this.tokenUrlCustomProperties = tokenUrlCustomProperties;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2PropertiesProperty#getTokenUrlCustomProperties}
             * @param tokenUrlCustomProperties Associates your token URL with a map of properties that you define.
             *                                 Use this parameter to provide any additional details that the connector requires to authenticate your request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrlCustomProperties(software.amazon.awscdk.IResolvable tokenUrlCustomProperties) {
                this.tokenUrlCustomProperties = tokenUrlCustomProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2PropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2PropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2PropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2PropertiesProperty {
            private final java.lang.String oAuth2GrantType;
            private final java.lang.String tokenUrl;
            private final java.lang.Object tokenUrlCustomProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.oAuth2GrantType = software.amazon.jsii.Kernel.get(this, "oAuth2GrantType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenUrl = software.amazon.jsii.Kernel.get(this, "tokenUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenUrlCustomProperties = software.amazon.jsii.Kernel.get(this, "tokenUrlCustomProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.oAuth2GrantType = builder.oAuth2GrantType;
                this.tokenUrl = builder.tokenUrl;
                this.tokenUrlCustomProperties = builder.tokenUrlCustomProperties;
            }

            @Override
            public final java.lang.String getOAuth2GrantType() {
                return this.oAuth2GrantType;
            }

            @Override
            public final java.lang.String getTokenUrl() {
                return this.tokenUrl;
            }

            @Override
            public final java.lang.Object getTokenUrlCustomProperties() {
                return this.tokenUrlCustomProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOAuth2GrantType() != null) {
                    data.set("oAuth2GrantType", om.valueToTree(this.getOAuth2GrantType()));
                }
                if (this.getTokenUrl() != null) {
                    data.set("tokenUrl", om.valueToTree(this.getTokenUrl()));
                }
                if (this.getTokenUrlCustomProperties() != null) {
                    data.set("tokenUrlCustomProperties", om.valueToTree(this.getTokenUrlCustomProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuth2PropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2PropertiesProperty.Jsii$Proxy that = (OAuth2PropertiesProperty.Jsii$Proxy) o;

                if (this.oAuth2GrantType != null ? !this.oAuth2GrantType.equals(that.oAuth2GrantType) : that.oAuth2GrantType != null) return false;
                if (this.tokenUrl != null ? !this.tokenUrl.equals(that.tokenUrl) : that.tokenUrl != null) return false;
                return this.tokenUrlCustomProperties != null ? this.tokenUrlCustomProperties.equals(that.tokenUrlCustomProperties) : that.tokenUrlCustomProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.oAuth2GrantType != null ? this.oAuth2GrantType.hashCode() : 0;
                result = 31 * result + (this.tokenUrl != null ? this.tokenUrl.hashCode() : 0);
                result = 31 * result + (this.tokenUrlCustomProperties != null ? this.tokenUrlCustomProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OAuth credentials required for OAuth type authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * OAuthCredentialsProperty oAuthCredentialsProperty = OAuthCredentialsProperty.builder()
     *         .accessToken("accessToken")
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuthCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuthCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuthCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access token used to access protected SAPOData resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * The identifier for the desired client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientSecret() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-connectoroauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-connectoroauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * The refresh token used to refresh expired access token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthcredentials.html#cfn-appflow-connectorprofile-oauthcredentials-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuthCredentialsProperty> {
            java.lang.String accessToken;
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.Object connectorOAuthRequest;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link OAuthCredentialsProperty#getAccessToken}
             * @param accessToken The access token used to access protected SAPOData resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialsProperty#getRefreshToken}
             * @param refreshToken The refresh token used to refresh expired access token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuthCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuthCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuthCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthCredentialsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.Object connectorOAuthRequest;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.clientId = builder.clientId;
                this.clientSecret = builder.clientSecret;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getClientSecret() != null) {
                    data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuthCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuthCredentialsProperty.Jsii$Proxy that = (OAuthCredentialsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
                if (this.connectorOAuthRequest != null ? !this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OAuth properties required for OAuth type authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * OAuthPropertiesProperty oAuthPropertiesProperty = OAuthPropertiesProperty.builder()
     *         .authCodeUrl("authCodeUrl")
     *         .oAuthScopes(List.of("oAuthScopes"))
     *         .tokenUrl("tokenUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuthPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuthPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuthPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html#cfn-appflow-connectorprofile-oauthproperties-authcodeurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html#cfn-appflow-connectorprofile-oauthproperties-authcodeurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthCodeUrl() {
            return null;
        }

        /**
         * The OAuth scopes required for OAuth type authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html#cfn-appflow-connectorprofile-oauthproperties-oauthscopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html#cfn-appflow-connectorprofile-oauthproperties-oauthscopes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOAuthScopes() {
            return null;
        }

        /**
         * The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html#cfn-appflow-connectorprofile-oauthproperties-tokenurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-oauthproperties.html#cfn-appflow-connectorprofile-oauthproperties-tokenurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuthPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuthPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuthPropertiesProperty> {
            java.lang.String authCodeUrl;
            java.util.List<java.lang.String> oAuthScopes;
            java.lang.String tokenUrl;

            /**
             * Sets the value of {@link OAuthPropertiesProperty#getAuthCodeUrl}
             * @param authCodeUrl The authorization code url required to redirect to SAP Login Page to fetch authorization code for OAuth type authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authCodeUrl(java.lang.String authCodeUrl) {
                this.authCodeUrl = authCodeUrl;
                return this;
            }

            /**
             * Sets the value of {@link OAuthPropertiesProperty#getOAuthScopes}
             * @param oAuthScopes The OAuth scopes required for OAuth type authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthScopes(java.util.List<java.lang.String> oAuthScopes) {
                this.oAuthScopes = oAuthScopes;
                return this;
            }

            /**
             * Sets the value of {@link OAuthPropertiesProperty#getTokenUrl}
             * @param tokenUrl The token url required to fetch access/refresh tokens using authorization code and also to refresh expired access token using refresh token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrl(java.lang.String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuthPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuthPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuthPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthPropertiesProperty {
            private final java.lang.String authCodeUrl;
            private final java.util.List<java.lang.String> oAuthScopes;
            private final java.lang.String tokenUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authCodeUrl = software.amazon.jsii.Kernel.get(this, "authCodeUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthScopes = software.amazon.jsii.Kernel.get(this, "oAuthScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tokenUrl = software.amazon.jsii.Kernel.get(this, "tokenUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authCodeUrl = builder.authCodeUrl;
                this.oAuthScopes = builder.oAuthScopes;
                this.tokenUrl = builder.tokenUrl;
            }

            @Override
            public final java.lang.String getAuthCodeUrl() {
                return this.authCodeUrl;
            }

            @Override
            public final java.util.List<java.lang.String> getOAuthScopes() {
                return this.oAuthScopes;
            }

            @Override
            public final java.lang.String getTokenUrl() {
                return this.tokenUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthCodeUrl() != null) {
                    data.set("authCodeUrl", om.valueToTree(this.getAuthCodeUrl()));
                }
                if (this.getOAuthScopes() != null) {
                    data.set("oAuthScopes", om.valueToTree(this.getOAuthScopes()));
                }
                if (this.getTokenUrl() != null) {
                    data.set("tokenUrl", om.valueToTree(this.getTokenUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuthPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuthPropertiesProperty.Jsii$Proxy that = (OAuthPropertiesProperty.Jsii$Proxy) o;

                if (this.authCodeUrl != null ? !this.authCodeUrl.equals(that.authCodeUrl) : that.authCodeUrl != null) return false;
                if (this.oAuthScopes != null ? !this.oAuthScopes.equals(that.oAuthScopes) : that.oAuthScopes != null) return false;
                return this.tokenUrl != null ? this.tokenUrl.equals(that.tokenUrl) : that.tokenUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authCodeUrl != null ? this.authCodeUrl.hashCode() : 0;
                result = 31 * result + (this.oAuthScopes != null ? this.oAuthScopes.hashCode() : 0);
                result = 31 * result + (this.tokenUrl != null ? this.tokenUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Salesforce Pardot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * PardotConnectorProfileCredentialsProperty pardotConnectorProfileCredentialsProperty = PardotConnectorProfileCredentialsProperty.builder()
     *         .accessToken("accessToken")
     *         .clientCredentialsArn("clientCredentialsArn")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.PardotConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(PardotConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PardotConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credentials used to access protected Salesforce Pardot resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * The secret manager ARN, which contains the client ID and client secret of the connected app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-clientcredentialsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-clientcredentialsarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCredentialsArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-connectoroauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-connectoroauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * The credentials used to acquire new access tokens.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofilecredentials.html#cfn-appflow-connectorprofile-pardotconnectorprofilecredentials-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PardotConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PardotConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PardotConnectorProfileCredentialsProperty> {
            java.lang.String accessToken;
            java.lang.String clientCredentialsArn;
            java.lang.Object connectorOAuthRequest;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link PardotConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Salesforce Pardot resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link PardotConnectorProfileCredentialsProperty#getClientCredentialsArn}
             * @param clientCredentialsArn The secret manager ARN, which contains the client ID and client secret of the connected app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCredentialsArn(java.lang.String clientCredentialsArn) {
                this.clientCredentialsArn = clientCredentialsArn;
                return this;
            }

            /**
             * Sets the value of {@link PardotConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link PardotConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link PardotConnectorProfileCredentialsProperty#getRefreshToken}
             * @param refreshToken The credentials used to acquire new access tokens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PardotConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PardotConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PardotConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PardotConnectorProfileCredentialsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String clientCredentialsArn;
            private final java.lang.Object connectorOAuthRequest;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientCredentialsArn = software.amazon.jsii.Kernel.get(this, "clientCredentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.clientCredentialsArn = builder.clientCredentialsArn;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getClientCredentialsArn() {
                return this.clientCredentialsArn;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getClientCredentialsArn() != null) {
                    data.set("clientCredentialsArn", om.valueToTree(this.getClientCredentialsArn()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.PardotConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PardotConnectorProfileCredentialsProperty.Jsii$Proxy that = (PardotConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.clientCredentialsArn != null ? !this.clientCredentialsArn.equals(that.clientCredentialsArn) : that.clientCredentialsArn != null) return false;
                if (this.connectorOAuthRequest != null ? !this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.clientCredentialsArn != null ? this.clientCredentialsArn.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using Salesforce Pardot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * PardotConnectorProfilePropertiesProperty pardotConnectorProfilePropertiesProperty = PardotConnectorProfilePropertiesProperty.builder()
     *         .businessUnitId("businessUnitId")
     *         // the properties below are optional
     *         .instanceUrl("instanceUrl")
     *         .isSandboxEnvironment(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.PardotConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(PardotConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PardotConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The business unit id of Salesforce Pardot instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html#cfn-appflow-connectorprofile-pardotconnectorprofileproperties-businessunitid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html#cfn-appflow-connectorprofile-pardotconnectorprofileproperties-businessunitid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBusinessUnitId();

        /**
         * The location of the Salesforce Pardot resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html#cfn-appflow-connectorprofile-pardotconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html#cfn-appflow-connectorprofile-pardotconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceUrl() {
            return null;
        }

        /**
         * Indicates whether the connector profile applies to a sandbox or production environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html#cfn-appflow-connectorprofile-pardotconnectorprofileproperties-issandboxenvironment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-pardotconnectorprofileproperties.html#cfn-appflow-connectorprofile-pardotconnectorprofileproperties-issandboxenvironment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsSandboxEnvironment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PardotConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PardotConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PardotConnectorProfilePropertiesProperty> {
            java.lang.String businessUnitId;
            java.lang.String instanceUrl;
            java.lang.Object isSandboxEnvironment;

            /**
             * Sets the value of {@link PardotConnectorProfilePropertiesProperty#getBusinessUnitId}
             * @param businessUnitId The business unit id of Salesforce Pardot instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessUnitId(java.lang.String businessUnitId) {
                this.businessUnitId = businessUnitId;
                return this;
            }

            /**
             * Sets the value of {@link PardotConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Salesforce Pardot resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Sets the value of {@link PardotConnectorProfilePropertiesProperty#getIsSandboxEnvironment}
             * @param isSandboxEnvironment Indicates whether the connector profile applies to a sandbox or production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSandboxEnvironment(java.lang.Boolean isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            /**
             * Sets the value of {@link PardotConnectorProfilePropertiesProperty#getIsSandboxEnvironment}
             * @param isSandboxEnvironment Indicates whether the connector profile applies to a sandbox or production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSandboxEnvironment(software.amazon.awscdk.IResolvable isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PardotConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PardotConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PardotConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PardotConnectorProfilePropertiesProperty {
            private final java.lang.String businessUnitId;
            private final java.lang.String instanceUrl;
            private final java.lang.Object isSandboxEnvironment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.businessUnitId = software.amazon.jsii.Kernel.get(this, "businessUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isSandboxEnvironment = software.amazon.jsii.Kernel.get(this, "isSandboxEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.businessUnitId = java.util.Objects.requireNonNull(builder.businessUnitId, "businessUnitId is required");
                this.instanceUrl = builder.instanceUrl;
                this.isSandboxEnvironment = builder.isSandboxEnvironment;
            }

            @Override
            public final java.lang.String getBusinessUnitId() {
                return this.businessUnitId;
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            public final java.lang.Object getIsSandboxEnvironment() {
                return this.isSandboxEnvironment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("businessUnitId", om.valueToTree(this.getBusinessUnitId()));
                if (this.getInstanceUrl() != null) {
                    data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));
                }
                if (this.getIsSandboxEnvironment() != null) {
                    data.set("isSandboxEnvironment", om.valueToTree(this.getIsSandboxEnvironment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.PardotConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PardotConnectorProfilePropertiesProperty.Jsii$Proxy that = (PardotConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (!businessUnitId.equals(that.businessUnitId)) return false;
                if (this.instanceUrl != null ? !this.instanceUrl.equals(that.instanceUrl) : that.instanceUrl != null) return false;
                return this.isSandboxEnvironment != null ? this.isSandboxEnvironment.equals(that.isSandboxEnvironment) : that.isSandboxEnvironment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.businessUnitId.hashCode();
                result = 31 * result + (this.instanceUrl != null ? this.instanceUrl.hashCode() : 0);
                result = 31 * result + (this.isSandboxEnvironment != null ? this.isSandboxEnvironment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * RedshiftConnectorProfileCredentialsProperty redshiftConnectorProfileCredentialsProperty = RedshiftConnectorProfileCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password that corresponds to the user name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html#cfn-appflow-connectorprofile-redshiftconnectorprofilecredentials-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html#cfn-appflow-connectorprofile-redshiftconnectorprofilecredentials-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The name of the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html#cfn-appflow-connectorprofile-redshiftconnectorprofilecredentials-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofilecredentials.html#cfn-appflow-connectorprofile-redshiftconnectorprofilecredentials-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftConnectorProfileCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link RedshiftConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftConnectorProfileCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = builder.password;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftConnectorProfileCredentialsProperty.Jsii$Proxy that = (RedshiftConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.password != null ? this.password.hashCode() : 0;
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties when using Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * RedshiftConnectorProfilePropertiesProperty redshiftConnectorProfilePropertiesProperty = RedshiftConnectorProfilePropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .clusterIdentifier("clusterIdentifier")
     *         .dataApiRoleArn("dataApiRoleArn")
     *         .databaseName("databaseName")
     *         .databaseUrl("databaseUrl")
     *         .isRedshiftServerless(false)
     *         .workgroupName("workgroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the associated Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3.
         * <p>
         * For more information, and for the polices that you attach to this role, see <a href="https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3">Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The unique ID that's assigned to an Amazon Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-clusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-clusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterIdentifier() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon Redshift database through the Data API.
         * <p>
         * For more information, and for the polices that you attach to this role, see <a href="https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift">Allow Amazon AppFlow to access Amazon Redshift databases with the Data API</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-dataapirolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-dataapirolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataApiRoleArn() {
            return null;
        }

        /**
         * The name of an Amazon Redshift database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * The JDBC URL of the Amazon Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-databaseurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-databaseurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseUrl() {
            return null;
        }

        /**
         * Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data warehouse.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-isredshiftserverless">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-isredshiftserverless</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsRedshiftServerless() {
            return null;
        }

        /**
         * The name of an Amazon Redshift workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-workgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-redshiftconnectorprofileproperties.html#cfn-appflow-connectorprofile-redshiftconnectorprofileproperties-workgroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkgroupName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftConnectorProfilePropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String roleArn;
            java.lang.String bucketPrefix;
            java.lang.String clusterIdentifier;
            java.lang.String dataApiRoleArn;
            java.lang.String databaseName;
            java.lang.String databaseUrl;
            java.lang.Object isRedshiftServerless;
            java.lang.String workgroupName;

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getBucketName}
             * @param bucketName A name for the associated Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3. This parameter is required.
             *                For more information, and for the polices that you attach to this role, see <a href="https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3">Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getClusterIdentifier}
             * @param clusterIdentifier The unique ID that's assigned to an Amazon Redshift cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getDataApiRoleArn}
             * @param dataApiRoleArn The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon Redshift database through the Data API.
             *                       For more information, and for the polices that you attach to this role, see <a href="https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift">Allow Amazon AppFlow to access Amazon Redshift databases with the Data API</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataApiRoleArn(java.lang.String dataApiRoleArn) {
                this.dataApiRoleArn = dataApiRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getDatabaseName}
             * @param databaseName The name of an Amazon Redshift database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getDatabaseUrl}
             * @param databaseUrl The JDBC URL of the Amazon Redshift cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseUrl(java.lang.String databaseUrl) {
                this.databaseUrl = databaseUrl;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getIsRedshiftServerless}
             * @param isRedshiftServerless Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data warehouse.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isRedshiftServerless(java.lang.Boolean isRedshiftServerless) {
                this.isRedshiftServerless = isRedshiftServerless;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getIsRedshiftServerless}
             * @param isRedshiftServerless Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data warehouse.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isRedshiftServerless(software.amazon.awscdk.IResolvable isRedshiftServerless) {
                this.isRedshiftServerless = isRedshiftServerless;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getWorkgroupName}
             * @param workgroupName The name of an Amazon Redshift workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupName(java.lang.String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftConnectorProfilePropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String roleArn;
            private final java.lang.String bucketPrefix;
            private final java.lang.String clusterIdentifier;
            private final java.lang.String dataApiRoleArn;
            private final java.lang.String databaseName;
            private final java.lang.String databaseUrl;
            private final java.lang.Object isRedshiftServerless;
            private final java.lang.String workgroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataApiRoleArn = software.amazon.jsii.Kernel.get(this, "dataApiRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseUrl = software.amazon.jsii.Kernel.get(this, "databaseUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isRedshiftServerless = software.amazon.jsii.Kernel.get(this, "isRedshiftServerless", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workgroupName = software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.clusterIdentifier = builder.clusterIdentifier;
                this.dataApiRoleArn = builder.dataApiRoleArn;
                this.databaseName = builder.databaseName;
                this.databaseUrl = builder.databaseUrl;
                this.isRedshiftServerless = builder.isRedshiftServerless;
                this.workgroupName = builder.workgroupName;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.String getClusterIdentifier() {
                return this.clusterIdentifier;
            }

            @Override
            public final java.lang.String getDataApiRoleArn() {
                return this.dataApiRoleArn;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getDatabaseUrl() {
                return this.databaseUrl;
            }

            @Override
            public final java.lang.Object getIsRedshiftServerless() {
                return this.isRedshiftServerless;
            }

            @Override
            public final java.lang.String getWorkgroupName() {
                return this.workgroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getClusterIdentifier() != null) {
                    data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
                }
                if (this.getDataApiRoleArn() != null) {
                    data.set("dataApiRoleArn", om.valueToTree(this.getDataApiRoleArn()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getDatabaseUrl() != null) {
                    data.set("databaseUrl", om.valueToTree(this.getDatabaseUrl()));
                }
                if (this.getIsRedshiftServerless() != null) {
                    data.set("isRedshiftServerless", om.valueToTree(this.getIsRedshiftServerless()));
                }
                if (this.getWorkgroupName() != null) {
                    data.set("workgroupName", om.valueToTree(this.getWorkgroupName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftConnectorProfilePropertiesProperty.Jsii$Proxy that = (RedshiftConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                if (this.clusterIdentifier != null ? !this.clusterIdentifier.equals(that.clusterIdentifier) : that.clusterIdentifier != null) return false;
                if (this.dataApiRoleArn != null ? !this.dataApiRoleArn.equals(that.dataApiRoleArn) : that.dataApiRoleArn != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.databaseUrl != null ? !this.databaseUrl.equals(that.databaseUrl) : that.databaseUrl != null) return false;
                if (this.isRedshiftServerless != null ? !this.isRedshiftServerless.equals(that.isRedshiftServerless) : that.isRedshiftServerless != null) return false;
                return this.workgroupName != null ? this.workgroupName.equals(that.workgroupName) : that.workgroupName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.clusterIdentifier != null ? this.clusterIdentifier.hashCode() : 0);
                result = 31 * result + (this.dataApiRoleArn != null ? this.dataApiRoleArn.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.databaseUrl != null ? this.databaseUrl.hashCode() : 0);
                result = 31 * result + (this.isRedshiftServerless != null ? this.isRedshiftServerless.hashCode() : 0);
                result = 31 * result + (this.workgroupName != null ? this.workgroupName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using SAPOData.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataConnectorProfileCredentialsProperty sAPODataConnectorProfileCredentialsProperty = SAPODataConnectorProfileCredentialsProperty.builder()
     *         .basicAuthCredentials(BasicAuthCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .oAuthCredentials(OAuthCredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The SAPOData basic authentication credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofilecredentials.html#cfn-appflow-connectorprofile-sapodataconnectorprofilecredentials-basicauthcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofilecredentials.html#cfn-appflow-connectorprofile-sapodataconnectorprofilecredentials-basicauthcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthCredentials() {
            return null;
        }

        /**
         * The SAPOData OAuth type authentication credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofilecredentials.html#cfn-appflow-connectorprofile-sapodataconnectorprofilecredentials-oauthcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofilecredentials.html#cfn-appflow-connectorprofile-sapodataconnectorprofilecredentials-oauthcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthCredentials() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAPODataConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataConnectorProfileCredentialsProperty> {
            java.lang.Object basicAuthCredentials;
            java.lang.Object oAuthCredentials;

            /**
             * Sets the value of {@link SAPODataConnectorProfileCredentialsProperty#getBasicAuthCredentials}
             * @param basicAuthCredentials The SAPOData basic authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthCredentials(software.amazon.awscdk.IResolvable basicAuthCredentials) {
                this.basicAuthCredentials = basicAuthCredentials;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfileCredentialsProperty#getBasicAuthCredentials}
             * @param basicAuthCredentials The SAPOData basic authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthCredentials(software.amazon.awscdk.services.appflow.CfnConnectorProfile.BasicAuthCredentialsProperty basicAuthCredentials) {
                this.basicAuthCredentials = basicAuthCredentials;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfileCredentialsProperty#getOAuthCredentials}
             * @param oAuthCredentials The SAPOData OAuth type authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthCredentials(software.amazon.awscdk.IResolvable oAuthCredentials) {
                this.oAuthCredentials = oAuthCredentials;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfileCredentialsProperty#getOAuthCredentials}
             * @param oAuthCredentials The SAPOData OAuth type authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthCredentials(software.amazon.awscdk.services.appflow.CfnConnectorProfile.OAuthCredentialsProperty oAuthCredentials) {
                this.oAuthCredentials = oAuthCredentials;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataConnectorProfileCredentialsProperty {
            private final java.lang.Object basicAuthCredentials;
            private final java.lang.Object oAuthCredentials;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basicAuthCredentials = software.amazon.jsii.Kernel.get(this, "basicAuthCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuthCredentials = software.amazon.jsii.Kernel.get(this, "oAuthCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basicAuthCredentials = builder.basicAuthCredentials;
                this.oAuthCredentials = builder.oAuthCredentials;
            }

            @Override
            public final java.lang.Object getBasicAuthCredentials() {
                return this.basicAuthCredentials;
            }

            @Override
            public final java.lang.Object getOAuthCredentials() {
                return this.oAuthCredentials;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBasicAuthCredentials() != null) {
                    data.set("basicAuthCredentials", om.valueToTree(this.getBasicAuthCredentials()));
                }
                if (this.getOAuthCredentials() != null) {
                    data.set("oAuthCredentials", om.valueToTree(this.getOAuthCredentials()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataConnectorProfileCredentialsProperty.Jsii$Proxy that = (SAPODataConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.basicAuthCredentials != null ? !this.basicAuthCredentials.equals(that.basicAuthCredentials) : that.basicAuthCredentials != null) return false;
                return this.oAuthCredentials != null ? this.oAuthCredentials.equals(that.oAuthCredentials) : that.oAuthCredentials == null;
            }

            @Override
            public final int hashCode() {
                int result = this.basicAuthCredentials != null ? this.basicAuthCredentials.hashCode() : 0;
                result = 31 * result + (this.oAuthCredentials != null ? this.oAuthCredentials.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using SAPOData.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataConnectorProfilePropertiesProperty sAPODataConnectorProfilePropertiesProperty = SAPODataConnectorProfilePropertiesProperty.builder()
     *         .applicationHostUrl("applicationHostUrl")
     *         .applicationServicePath("applicationServicePath")
     *         .clientNumber("clientNumber")
     *         .disableSso(false)
     *         .logonLanguage("logonLanguage")
     *         .oAuthProperties(OAuthPropertiesProperty.builder()
     *                 .authCodeUrl("authCodeUrl")
     *                 .oAuthScopes(List.of("oAuthScopes"))
     *                 .tokenUrl("tokenUrl")
     *                 .build())
     *         .portNumber(123)
     *         .privateLinkServiceName("privateLinkServiceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the SAPOData resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-applicationhosturl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-applicationhosturl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationHostUrl() {
            return null;
        }

        /**
         * The application path to catalog service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-applicationservicepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-applicationservicepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationServicePath() {
            return null;
        }

        /**
         * The client number for the client creating the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-clientnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-clientnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientNumber() {
            return null;
        }

        /**
         * If you set this parameter to <code>true</code> , Amazon AppFlow bypasses the single sign-on (SSO) settings in your SAP account when it accesses your SAP OData instance.
         * <p>
         * Whether you need this option depends on the types of credentials that you applied to your SAP OData connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon AppFlow from connecting to your account with your username and password. In this case, bypassing SSO makes it possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth credentials, this parameter has no affect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-disablesso">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-disablesso</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableSso() {
            return null;
        }

        /**
         * The logon language of SAPOData instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-logonlanguage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-logonlanguage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogonLanguage() {
            return null;
        }

        /**
         * The SAPOData OAuth properties required for OAuth type authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-oauthproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-oauthproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthProperties() {
            return null;
        }

        /**
         * The port number of the SAPOData instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-portnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-portnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPortNumber() {
            return null;
        }

        /**
         * The SAPOData Private Link service name to be used for private data transfers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-privatelinkservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-sapodataconnectorprofileproperties.html#cfn-appflow-connectorprofile-sapodataconnectorprofileproperties-privatelinkservicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateLinkServiceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAPODataConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataConnectorProfilePropertiesProperty> {
            java.lang.String applicationHostUrl;
            java.lang.String applicationServicePath;
            java.lang.String clientNumber;
            java.lang.Object disableSso;
            java.lang.String logonLanguage;
            java.lang.Object oAuthProperties;
            java.lang.Number portNumber;
            java.lang.String privateLinkServiceName;

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getApplicationHostUrl}
             * @param applicationHostUrl The location of the SAPOData resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationHostUrl(java.lang.String applicationHostUrl) {
                this.applicationHostUrl = applicationHostUrl;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getApplicationServicePath}
             * @param applicationServicePath The application path to catalog service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationServicePath(java.lang.String applicationServicePath) {
                this.applicationServicePath = applicationServicePath;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getClientNumber}
             * @param clientNumber The client number for the client creating the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientNumber(java.lang.String clientNumber) {
                this.clientNumber = clientNumber;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getDisableSso}
             * @param disableSso If you set this parameter to <code>true</code> , Amazon AppFlow bypasses the single sign-on (SSO) settings in your SAP account when it accesses your SAP OData instance.
             *                   Whether you need this option depends on the types of credentials that you applied to your SAP OData connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon AppFlow from connecting to your account with your username and password. In this case, bypassing SSO makes it possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth credentials, this parameter has no affect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableSso(java.lang.Boolean disableSso) {
                this.disableSso = disableSso;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getDisableSso}
             * @param disableSso If you set this parameter to <code>true</code> , Amazon AppFlow bypasses the single sign-on (SSO) settings in your SAP account when it accesses your SAP OData instance.
             *                   Whether you need this option depends on the types of credentials that you applied to your SAP OData connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon AppFlow from connecting to your account with your username and password. In this case, bypassing SSO makes it possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth credentials, this parameter has no affect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableSso(software.amazon.awscdk.IResolvable disableSso) {
                this.disableSso = disableSso;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getLogonLanguage}
             * @param logonLanguage The logon language of SAPOData instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logonLanguage(java.lang.String logonLanguage) {
                this.logonLanguage = logonLanguage;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getOAuthProperties}
             * @param oAuthProperties The SAPOData OAuth properties required for OAuth type authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthProperties(software.amazon.awscdk.IResolvable oAuthProperties) {
                this.oAuthProperties = oAuthProperties;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getOAuthProperties}
             * @param oAuthProperties The SAPOData OAuth properties required for OAuth type authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthProperties(software.amazon.awscdk.services.appflow.CfnConnectorProfile.OAuthPropertiesProperty oAuthProperties) {
                this.oAuthProperties = oAuthProperties;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getPortNumber}
             * @param portNumber The port number of the SAPOData instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portNumber(java.lang.Number portNumber) {
                this.portNumber = portNumber;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getPrivateLinkServiceName}
             * @param privateLinkServiceName The SAPOData Private Link service name to be used for private data transfers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateLinkServiceName(java.lang.String privateLinkServiceName) {
                this.privateLinkServiceName = privateLinkServiceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataConnectorProfilePropertiesProperty {
            private final java.lang.String applicationHostUrl;
            private final java.lang.String applicationServicePath;
            private final java.lang.String clientNumber;
            private final java.lang.Object disableSso;
            private final java.lang.String logonLanguage;
            private final java.lang.Object oAuthProperties;
            private final java.lang.Number portNumber;
            private final java.lang.String privateLinkServiceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationHostUrl = software.amazon.jsii.Kernel.get(this, "applicationHostUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationServicePath = software.amazon.jsii.Kernel.get(this, "applicationServicePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientNumber = software.amazon.jsii.Kernel.get(this, "clientNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disableSso = software.amazon.jsii.Kernel.get(this, "disableSso", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logonLanguage = software.amazon.jsii.Kernel.get(this, "logonLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthProperties = software.amazon.jsii.Kernel.get(this, "oAuthProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portNumber = software.amazon.jsii.Kernel.get(this, "portNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.privateLinkServiceName = software.amazon.jsii.Kernel.get(this, "privateLinkServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationHostUrl = builder.applicationHostUrl;
                this.applicationServicePath = builder.applicationServicePath;
                this.clientNumber = builder.clientNumber;
                this.disableSso = builder.disableSso;
                this.logonLanguage = builder.logonLanguage;
                this.oAuthProperties = builder.oAuthProperties;
                this.portNumber = builder.portNumber;
                this.privateLinkServiceName = builder.privateLinkServiceName;
            }

            @Override
            public final java.lang.String getApplicationHostUrl() {
                return this.applicationHostUrl;
            }

            @Override
            public final java.lang.String getApplicationServicePath() {
                return this.applicationServicePath;
            }

            @Override
            public final java.lang.String getClientNumber() {
                return this.clientNumber;
            }

            @Override
            public final java.lang.Object getDisableSso() {
                return this.disableSso;
            }

            @Override
            public final java.lang.String getLogonLanguage() {
                return this.logonLanguage;
            }

            @Override
            public final java.lang.Object getOAuthProperties() {
                return this.oAuthProperties;
            }

            @Override
            public final java.lang.Number getPortNumber() {
                return this.portNumber;
            }

            @Override
            public final java.lang.String getPrivateLinkServiceName() {
                return this.privateLinkServiceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationHostUrl() != null) {
                    data.set("applicationHostUrl", om.valueToTree(this.getApplicationHostUrl()));
                }
                if (this.getApplicationServicePath() != null) {
                    data.set("applicationServicePath", om.valueToTree(this.getApplicationServicePath()));
                }
                if (this.getClientNumber() != null) {
                    data.set("clientNumber", om.valueToTree(this.getClientNumber()));
                }
                if (this.getDisableSso() != null) {
                    data.set("disableSso", om.valueToTree(this.getDisableSso()));
                }
                if (this.getLogonLanguage() != null) {
                    data.set("logonLanguage", om.valueToTree(this.getLogonLanguage()));
                }
                if (this.getOAuthProperties() != null) {
                    data.set("oAuthProperties", om.valueToTree(this.getOAuthProperties()));
                }
                if (this.getPortNumber() != null) {
                    data.set("portNumber", om.valueToTree(this.getPortNumber()));
                }
                if (this.getPrivateLinkServiceName() != null) {
                    data.set("privateLinkServiceName", om.valueToTree(this.getPrivateLinkServiceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataConnectorProfilePropertiesProperty.Jsii$Proxy that = (SAPODataConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (this.applicationHostUrl != null ? !this.applicationHostUrl.equals(that.applicationHostUrl) : that.applicationHostUrl != null) return false;
                if (this.applicationServicePath != null ? !this.applicationServicePath.equals(that.applicationServicePath) : that.applicationServicePath != null) return false;
                if (this.clientNumber != null ? !this.clientNumber.equals(that.clientNumber) : that.clientNumber != null) return false;
                if (this.disableSso != null ? !this.disableSso.equals(that.disableSso) : that.disableSso != null) return false;
                if (this.logonLanguage != null ? !this.logonLanguage.equals(that.logonLanguage) : that.logonLanguage != null) return false;
                if (this.oAuthProperties != null ? !this.oAuthProperties.equals(that.oAuthProperties) : that.oAuthProperties != null) return false;
                if (this.portNumber != null ? !this.portNumber.equals(that.portNumber) : that.portNumber != null) return false;
                return this.privateLinkServiceName != null ? this.privateLinkServiceName.equals(that.privateLinkServiceName) : that.privateLinkServiceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationHostUrl != null ? this.applicationHostUrl.hashCode() : 0;
                result = 31 * result + (this.applicationServicePath != null ? this.applicationServicePath.hashCode() : 0);
                result = 31 * result + (this.clientNumber != null ? this.clientNumber.hashCode() : 0);
                result = 31 * result + (this.disableSso != null ? this.disableSso.hashCode() : 0);
                result = 31 * result + (this.logonLanguage != null ? this.logonLanguage.hashCode() : 0);
                result = 31 * result + (this.oAuthProperties != null ? this.oAuthProperties.hashCode() : 0);
                result = 31 * result + (this.portNumber != null ? this.portNumber.hashCode() : 0);
                result = 31 * result + (this.privateLinkServiceName != null ? this.privateLinkServiceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Salesforce.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceConnectorProfileCredentialsProperty salesforceConnectorProfileCredentialsProperty = SalesforceConnectorProfileCredentialsProperty.builder()
     *         .accessToken("accessToken")
     *         .clientCredentialsArn("clientCredentialsArn")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .jwtToken("jwtToken")
     *         .oAuth2GrantType("oAuth2GrantType")
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credentials used to access protected Salesforce resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * The secret manager ARN, which contains the client ID and client secret of the connected app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-clientcredentialsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-clientcredentialsarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCredentialsArn() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-connectoroauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-connectoroauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-jwttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-jwttoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJwtToken() {
            return null;
        }

        /**
         * Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         * <p>
         * You can specify one of the following values:
         * <p>
         * <ul>
         * <li><strong>AUTHORIZATION_CODE</strong> - Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon AppFlow to access your records.</li>
         * <li><strong>JWT_BEARER</strong> - Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The CLIENT_CREDENTIALS value is not supported for Salesforce.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-oauth2granttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-oauth2granttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOAuth2GrantType() {
            return null;
        }

        /**
         * The credentials used to acquire new access tokens.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-refreshtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofilecredentials.html#cfn-appflow-connectorprofile-salesforceconnectorprofilecredentials-refreshtoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceConnectorProfileCredentialsProperty> {
            java.lang.String accessToken;
            java.lang.String clientCredentialsArn;
            java.lang.Object connectorOAuthRequest;
            java.lang.String jwtToken;
            java.lang.String oAuth2GrantType;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Salesforce resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getClientCredentialsArn}
             * @param clientCredentialsArn The secret manager ARN, which contains the client ID and client secret of the connected app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCredentialsArn(java.lang.String clientCredentialsArn) {
                this.clientCredentialsArn = clientCredentialsArn;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getJwtToken}
             * @param jwtToken A JSON web token (JWT) that authorizes Amazon AppFlow to access your Salesforce records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jwtToken(java.lang.String jwtToken) {
                this.jwtToken = jwtToken;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getOAuth2GrantType}
             * @param oAuth2GrantType Specifies the OAuth 2.0 grant type that Amazon AppFlow uses when it requests an access token from Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
             *                        You can specify one of the following values:
             *                        <p>
             *                        <ul>
             *                        <li><strong>AUTHORIZATION_CODE</strong> - Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon AppFlow to access your records.</li>
             *                        <li><strong>JWT_BEARER</strong> - Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.</li>
             *                        </ul>
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        The CLIENT_CREDENTIALS value is not supported for Salesforce.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2GrantType(java.lang.String oAuth2GrantType) {
                this.oAuth2GrantType = oAuth2GrantType;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getRefreshToken}
             * @param refreshToken The credentials used to acquire new access tokens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceConnectorProfileCredentialsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String clientCredentialsArn;
            private final java.lang.Object connectorOAuthRequest;
            private final java.lang.String jwtToken;
            private final java.lang.String oAuth2GrantType;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientCredentialsArn = software.amazon.jsii.Kernel.get(this, "clientCredentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jwtToken = software.amazon.jsii.Kernel.get(this, "jwtToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuth2GrantType = software.amazon.jsii.Kernel.get(this, "oAuth2GrantType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.clientCredentialsArn = builder.clientCredentialsArn;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
                this.jwtToken = builder.jwtToken;
                this.oAuth2GrantType = builder.oAuth2GrantType;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getClientCredentialsArn() {
                return this.clientCredentialsArn;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getJwtToken() {
                return this.jwtToken;
            }

            @Override
            public final java.lang.String getOAuth2GrantType() {
                return this.oAuth2GrantType;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getClientCredentialsArn() != null) {
                    data.set("clientCredentialsArn", om.valueToTree(this.getClientCredentialsArn()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }
                if (this.getJwtToken() != null) {
                    data.set("jwtToken", om.valueToTree(this.getJwtToken()));
                }
                if (this.getOAuth2GrantType() != null) {
                    data.set("oAuth2GrantType", om.valueToTree(this.getOAuth2GrantType()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceConnectorProfileCredentialsProperty.Jsii$Proxy that = (SalesforceConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.clientCredentialsArn != null ? !this.clientCredentialsArn.equals(that.clientCredentialsArn) : that.clientCredentialsArn != null) return false;
                if (this.connectorOAuthRequest != null ? !this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest != null) return false;
                if (this.jwtToken != null ? !this.jwtToken.equals(that.jwtToken) : that.jwtToken != null) return false;
                if (this.oAuth2GrantType != null ? !this.oAuth2GrantType.equals(that.oAuth2GrantType) : that.oAuth2GrantType != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.clientCredentialsArn != null ? this.clientCredentialsArn.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                result = 31 * result + (this.jwtToken != null ? this.jwtToken.hashCode() : 0);
                result = 31 * result + (this.oAuth2GrantType != null ? this.oAuth2GrantType.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using Salesforce.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceConnectorProfilePropertiesProperty salesforceConnectorProfilePropertiesProperty = SalesforceConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .isSandboxEnvironment(false)
     *         .usePrivateLinkForMetadataAndAuthorization(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Salesforce resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceUrl() {
            return null;
        }

        /**
         * Indicates whether the connector profile applies to a sandbox or production environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-issandboxenvironment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-issandboxenvironment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsSandboxEnvironment() {
            return null;
        }

        /**
         * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the private network to send metadata and authorization calls to Salesforce.
         * <p>
         * Amazon AppFlow sends private calls through AWS PrivateLink . These calls travel through AWS infrastructure without being exposed to the public internet.
         * <p>
         * Set either of the following values:
         * <p>
         * <ul>
         * <li><strong>true</strong> - Amazon AppFlow sends all calls to Salesforce over the private network.</li>
         * </ul>
         * <p>
         * These private calls are:
         * <p>
         * <ul>
         * <li>Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their fields.</li>
         * <li>Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.</li>
         * <li>Calls to transfer your Salesforce records as part of a flow run.</li>
         * <li><strong>false</strong> - The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public internet.</li>
         * </ul>
         * <p>
         * The public calls are:
         * <p>
         * <ul>
         * <li>Calls to get metadata about your Salesforce records.</li>
         * <li>Calls to get or refresh access tokens.</li>
         * </ul>
         * <p>
         * The private calls are:
         * <p>
         * <ul>
         * <li>Calls to transfer your Salesforce records as part of a flow run.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-useprivatelinkformetadataandauthorization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-salesforceconnectorprofileproperties.html#cfn-appflow-connectorprofile-salesforceconnectorprofileproperties-useprivatelinkformetadataandauthorization</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUsePrivateLinkForMetadataAndAuthorization() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;
            java.lang.Object isSandboxEnvironment;
            java.lang.Object usePrivateLinkForMetadataAndAuthorization;

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Salesforce resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getIsSandboxEnvironment}
             * @param isSandboxEnvironment Indicates whether the connector profile applies to a sandbox or production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSandboxEnvironment(java.lang.Boolean isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getIsSandboxEnvironment}
             * @param isSandboxEnvironment Indicates whether the connector profile applies to a sandbox or production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSandboxEnvironment(software.amazon.awscdk.IResolvable isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getUsePrivateLinkForMetadataAndAuthorization}
             * @param usePrivateLinkForMetadataAndAuthorization If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the private network to send metadata and authorization calls to Salesforce.
             *                                                  Amazon AppFlow sends private calls through AWS PrivateLink . These calls travel through AWS infrastructure without being exposed to the public internet.
             *                                                  <p>
             *                                                  Set either of the following values:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li><strong>true</strong> - Amazon AppFlow sends all calls to Salesforce over the private network.</li>
             *                                                  </ul>
             *                                                  <p>
             *                                                  These private calls are:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li>Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their fields.</li>
             *                                                  <li>Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.</li>
             *                                                  <li>Calls to transfer your Salesforce records as part of a flow run.</li>
             *                                                  <li><strong>false</strong> - The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public internet.</li>
             *                                                  </ul>
             *                                                  <p>
             *                                                  The public calls are:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li>Calls to get metadata about your Salesforce records.</li>
             *                                                  <li>Calls to get or refresh access tokens.</li>
             *                                                  </ul>
             *                                                  <p>
             *                                                  The private calls are:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li>Calls to transfer your Salesforce records as part of a flow run.</li>
             *                                                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usePrivateLinkForMetadataAndAuthorization(java.lang.Boolean usePrivateLinkForMetadataAndAuthorization) {
                this.usePrivateLinkForMetadataAndAuthorization = usePrivateLinkForMetadataAndAuthorization;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getUsePrivateLinkForMetadataAndAuthorization}
             * @param usePrivateLinkForMetadataAndAuthorization If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the private network to send metadata and authorization calls to Salesforce.
             *                                                  Amazon AppFlow sends private calls through AWS PrivateLink . These calls travel through AWS infrastructure without being exposed to the public internet.
             *                                                  <p>
             *                                                  Set either of the following values:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li><strong>true</strong> - Amazon AppFlow sends all calls to Salesforce over the private network.</li>
             *                                                  </ul>
             *                                                  <p>
             *                                                  These private calls are:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li>Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their fields.</li>
             *                                                  <li>Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.</li>
             *                                                  <li>Calls to transfer your Salesforce records as part of a flow run.</li>
             *                                                  <li><strong>false</strong> - The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public internet.</li>
             *                                                  </ul>
             *                                                  <p>
             *                                                  The public calls are:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li>Calls to get metadata about your Salesforce records.</li>
             *                                                  <li>Calls to get or refresh access tokens.</li>
             *                                                  </ul>
             *                                                  <p>
             *                                                  The private calls are:
             *                                                  <p>
             *                                                  <ul>
             *                                                  <li>Calls to transfer your Salesforce records as part of a flow run.</li>
             *                                                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usePrivateLinkForMetadataAndAuthorization(software.amazon.awscdk.IResolvable usePrivateLinkForMetadataAndAuthorization) {
                this.usePrivateLinkForMetadataAndAuthorization = usePrivateLinkForMetadataAndAuthorization;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;
            private final java.lang.Object isSandboxEnvironment;
            private final java.lang.Object usePrivateLinkForMetadataAndAuthorization;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isSandboxEnvironment = software.amazon.jsii.Kernel.get(this, "isSandboxEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.usePrivateLinkForMetadataAndAuthorization = software.amazon.jsii.Kernel.get(this, "usePrivateLinkForMetadataAndAuthorization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = builder.instanceUrl;
                this.isSandboxEnvironment = builder.isSandboxEnvironment;
                this.usePrivateLinkForMetadataAndAuthorization = builder.usePrivateLinkForMetadataAndAuthorization;
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            public final java.lang.Object getIsSandboxEnvironment() {
                return this.isSandboxEnvironment;
            }

            @Override
            public final java.lang.Object getUsePrivateLinkForMetadataAndAuthorization() {
                return this.usePrivateLinkForMetadataAndAuthorization;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceUrl() != null) {
                    data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));
                }
                if (this.getIsSandboxEnvironment() != null) {
                    data.set("isSandboxEnvironment", om.valueToTree(this.getIsSandboxEnvironment()));
                }
                if (this.getUsePrivateLinkForMetadataAndAuthorization() != null) {
                    data.set("usePrivateLinkForMetadataAndAuthorization", om.valueToTree(this.getUsePrivateLinkForMetadataAndAuthorization()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceConnectorProfilePropertiesProperty.Jsii$Proxy that = (SalesforceConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (this.instanceUrl != null ? !this.instanceUrl.equals(that.instanceUrl) : that.instanceUrl != null) return false;
                if (this.isSandboxEnvironment != null ? !this.isSandboxEnvironment.equals(that.isSandboxEnvironment) : that.isSandboxEnvironment != null) return false;
                return this.usePrivateLinkForMetadataAndAuthorization != null ? this.usePrivateLinkForMetadataAndAuthorization.equals(that.usePrivateLinkForMetadataAndAuthorization) : that.usePrivateLinkForMetadataAndAuthorization == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl != null ? this.instanceUrl.hashCode() : 0;
                result = 31 * result + (this.isSandboxEnvironment != null ? this.isSandboxEnvironment.hashCode() : 0);
                result = 31 * result + (this.usePrivateLinkForMetadataAndAuthorization != null ? this.usePrivateLinkForMetadataAndAuthorization.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using ServiceNow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ServiceNowConnectorProfileCredentialsProperty serviceNowConnectorProfileCredentialsProperty = ServiceNowConnectorProfileCredentialsProperty.builder()
     *         .oAuth2Credentials(OAuth2CredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 .oAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The OAuth 2.0 credentials required to authenticate the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-oauth2credentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-oauth2credentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2Credentials() {
            return null;
        }

        /**
         * The password that corresponds to the user name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The name of the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofilecredentials.html#cfn-appflow-connectorprofile-servicenowconnectorprofilecredentials-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceNowConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowConnectorProfileCredentialsProperty> {
            java.lang.Object oAuth2Credentials;
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link ServiceNowConnectorProfileCredentialsProperty#getOAuth2Credentials}
             * @param oAuth2Credentials The OAuth 2.0 credentials required to authenticate the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Credentials(software.amazon.awscdk.IResolvable oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConnectorProfileCredentialsProperty#getOAuth2Credentials}
             * @param oAuth2Credentials The OAuth 2.0 credentials required to authenticate the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2Credentials(software.amazon.awscdk.services.appflow.CfnConnectorProfile.OAuth2CredentialsProperty oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowConnectorProfileCredentialsProperty {
            private final java.lang.Object oAuth2Credentials;
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.oAuth2Credentials = software.amazon.jsii.Kernel.get(this, "oAuth2Credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.oAuth2Credentials = builder.oAuth2Credentials;
                this.password = builder.password;
                this.username = builder.username;
            }

            @Override
            public final java.lang.Object getOAuth2Credentials() {
                return this.oAuth2Credentials;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOAuth2Credentials() != null) {
                    data.set("oAuth2Credentials", om.valueToTree(this.getOAuth2Credentials()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowConnectorProfileCredentialsProperty.Jsii$Proxy that = (ServiceNowConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.oAuth2Credentials != null ? !this.oAuth2Credentials.equals(that.oAuth2Credentials) : that.oAuth2Credentials != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.oAuth2Credentials != null ? this.oAuth2Credentials.hashCode() : 0;
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using ServiceNow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ServiceNowConnectorProfilePropertiesProperty serviceNowConnectorProfilePropertiesProperty = ServiceNowConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the ServiceNow resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofileproperties.html#cfn-appflow-connectorprofile-servicenowconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-servicenowconnectorprofileproperties.html#cfn-appflow-connectorprofile-servicenowconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link ServiceNowConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link ServiceNowConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the ServiceNow resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowConnectorProfilePropertiesProperty.Jsii$Proxy that = (ServiceNowConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Singular.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SingularConnectorProfileCredentialsProperty singularConnectorProfileCredentialsProperty = SingularConnectorProfileCredentialsProperty.builder()
     *         .apiKey("apiKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-singularconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-singularconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SingularConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SingularConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingularConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-singularconnectorprofilecredentials.html#cfn-appflow-connectorprofile-singularconnectorprofilecredentials-apikey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-singularconnectorprofilecredentials.html#cfn-appflow-connectorprofile-singularconnectorprofilecredentials-apikey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKey();

        /**
         * @return a {@link Builder} of {@link SingularConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingularConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingularConnectorProfileCredentialsProperty> {
            java.lang.String apiKey;

            /**
             * Sets the value of {@link SingularConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(java.lang.String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingularConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingularConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingularConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingularConnectorProfileCredentialsProperty {
            private final java.lang.String apiKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKey = java.util.Objects.requireNonNull(builder.apiKey, "apiKey is required");
            }

            @Override
            public final java.lang.String getApiKey() {
                return this.apiKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKey", om.valueToTree(this.getApiKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SingularConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingularConnectorProfileCredentialsProperty.Jsii$Proxy that = (SingularConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                return this.apiKey.equals(that.apiKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiKey.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Slack.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SlackConnectorProfileCredentialsProperty slackConnectorProfileCredentialsProperty = SlackConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SlackConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlackConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Slack resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-connectoroauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofilecredentials.html#cfn-appflow-connectorprofile-slackconnectorprofilecredentials-connectoroauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlackConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlackConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlackConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Slack resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlackConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlackConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlackConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlackConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlackConnectorProfileCredentialsProperty.Jsii$Proxy that = (SlackConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                return this.connectorOAuthRequest != null ? this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using Slack.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SlackConnectorProfilePropertiesProperty slackConnectorProfilePropertiesProperty = SlackConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SlackConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlackConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Slack resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofileproperties.html#cfn-appflow-connectorprofile-slackconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-slackconnectorprofileproperties.html#cfn-appflow-connectorprofile-slackconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link SlackConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlackConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlackConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link SlackConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Slack resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlackConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlackConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlackConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlackConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlackConnectorProfilePropertiesProperty.Jsii$Proxy that = (SlackConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Snowflake.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SnowflakeConnectorProfileCredentialsProperty snowflakeConnectorProfileCredentialsProperty = SnowflakeConnectorProfileCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password that corresponds to the user name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-snowflakeconnectorprofilecredentials-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-snowflakeconnectorprofilecredentials-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The name of the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-snowflakeconnectorprofilecredentials-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofilecredentials.html#cfn-appflow-connectorprofile-snowflakeconnectorprofilecredentials-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link SnowflakeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeConnectorProfileCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link SnowflakeConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeConnectorProfileCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeConnectorProfileCredentialsProperty.Jsii$Proxy that = (SnowflakeConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using Snowflake.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SnowflakeConnectorProfilePropertiesProperty snowflakeConnectorProfilePropertiesProperty = SnowflakeConnectorProfilePropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .stage("stage")
     *         .warehouse("warehouse")
     *         // the properties below are optional
     *         .accountName("accountName")
     *         .bucketPrefix("bucketPrefix")
     *         .privateLinkServiceName("privateLinkServiceName")
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket associated with Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account.
         * <p>
         * This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<Stage Name>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-stage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-stage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStage();

        /**
         * The name of the Snowflake warehouse.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-warehouse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-warehouse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWarehouse();

        /**
         * The name of the account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-accountname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-accountname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountName() {
            return null;
        }

        /**
         * The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The Snowflake Private Link service name to be used for private data transfers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-privatelinkservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-privatelinkservicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateLinkServiceName() {
            return null;
        }

        /**
         * The AWS Region of the Snowflake account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-snowflakeconnectorprofileproperties.html#cfn-appflow-connectorprofile-snowflakeconnectorprofileproperties-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeConnectorProfilePropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String stage;
            java.lang.String warehouse;
            java.lang.String accountName;
            java.lang.String bucketPrefix;
            java.lang.String privateLinkServiceName;
            java.lang.String region;

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket associated with Snowflake. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getStage}
             * @param stage The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This parameter is required.
             *              This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<Stage Name>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stage(java.lang.String stage) {
                this.stage = stage;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getWarehouse}
             * @param warehouse The name of the Snowflake warehouse. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warehouse(java.lang.String warehouse) {
                this.warehouse = warehouse;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getAccountName}
             * @param accountName The name of the account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountName(java.lang.String accountName) {
                this.accountName = accountName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getPrivateLinkServiceName}
             * @param privateLinkServiceName The Snowflake Private Link service name to be used for private data transfers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateLinkServiceName(java.lang.String privateLinkServiceName) {
                this.privateLinkServiceName = privateLinkServiceName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getRegion}
             * @param region The AWS Region of the Snowflake account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeConnectorProfilePropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String stage;
            private final java.lang.String warehouse;
            private final java.lang.String accountName;
            private final java.lang.String bucketPrefix;
            private final java.lang.String privateLinkServiceName;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.warehouse = software.amazon.jsii.Kernel.get(this, "warehouse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accountName = software.amazon.jsii.Kernel.get(this, "accountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateLinkServiceName = software.amazon.jsii.Kernel.get(this, "privateLinkServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.stage = java.util.Objects.requireNonNull(builder.stage, "stage is required");
                this.warehouse = java.util.Objects.requireNonNull(builder.warehouse, "warehouse is required");
                this.accountName = builder.accountName;
                this.bucketPrefix = builder.bucketPrefix;
                this.privateLinkServiceName = builder.privateLinkServiceName;
                this.region = builder.region;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getStage() {
                return this.stage;
            }

            @Override
            public final java.lang.String getWarehouse() {
                return this.warehouse;
            }

            @Override
            public final java.lang.String getAccountName() {
                return this.accountName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.String getPrivateLinkServiceName() {
                return this.privateLinkServiceName;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("stage", om.valueToTree(this.getStage()));
                data.set("warehouse", om.valueToTree(this.getWarehouse()));
                if (this.getAccountName() != null) {
                    data.set("accountName", om.valueToTree(this.getAccountName()));
                }
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getPrivateLinkServiceName() != null) {
                    data.set("privateLinkServiceName", om.valueToTree(this.getPrivateLinkServiceName()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeConnectorProfilePropertiesProperty.Jsii$Proxy that = (SnowflakeConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!stage.equals(that.stage)) return false;
                if (!warehouse.equals(that.warehouse)) return false;
                if (this.accountName != null ? !this.accountName.equals(that.accountName) : that.accountName != null) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                if (this.privateLinkServiceName != null ? !this.privateLinkServiceName.equals(that.privateLinkServiceName) : that.privateLinkServiceName != null) return false;
                return this.region != null ? this.region.equals(that.region) : that.region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.stage.hashCode());
                result = 31 * result + (this.warehouse.hashCode());
                result = 31 * result + (this.accountName != null ? this.accountName.hashCode() : 0);
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.privateLinkServiceName != null ? this.privateLinkServiceName.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Trend Micro.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TrendmicroConnectorProfileCredentialsProperty trendmicroConnectorProfileCredentialsProperty = TrendmicroConnectorProfileCredentialsProperty.builder()
     *         .apiSecretKey("apiSecretKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-trendmicroconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-trendmicroconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(TrendmicroConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrendmicroConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Secret Access Key portion of the credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-trendmicroconnectorprofilecredentials.html#cfn-appflow-connectorprofile-trendmicroconnectorprofilecredentials-apisecretkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-trendmicroconnectorprofilecredentials.html#cfn-appflow-connectorprofile-trendmicroconnectorprofilecredentials-apisecretkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiSecretKey();

        /**
         * @return a {@link Builder} of {@link TrendmicroConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrendmicroConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrendmicroConnectorProfileCredentialsProperty> {
            java.lang.String apiSecretKey;

            /**
             * Sets the value of {@link TrendmicroConnectorProfileCredentialsProperty#getApiSecretKey}
             * @param apiSecretKey The Secret Access Key portion of the credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSecretKey(java.lang.String apiSecretKey) {
                this.apiSecretKey = apiSecretKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrendmicroConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrendmicroConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrendmicroConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrendmicroConnectorProfileCredentialsProperty {
            private final java.lang.String apiSecretKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiSecretKey = software.amazon.jsii.Kernel.get(this, "apiSecretKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiSecretKey = java.util.Objects.requireNonNull(builder.apiSecretKey, "apiSecretKey is required");
            }

            @Override
            public final java.lang.String getApiSecretKey() {
                return this.apiSecretKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiSecretKey", om.valueToTree(this.getApiSecretKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrendmicroConnectorProfileCredentialsProperty.Jsii$Proxy that = (TrendmicroConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                return this.apiSecretKey.equals(that.apiSecretKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiSecretKey.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Veeva.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * VeevaConnectorProfileCredentialsProperty veevaConnectorProfileCredentialsProperty = VeevaConnectorProfileCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(VeevaConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VeevaConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password that corresponds to the user name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html#cfn-appflow-connectorprofile-veevaconnectorprofilecredentials-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html#cfn-appflow-connectorprofile-veevaconnectorprofilecredentials-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The name of the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html#cfn-appflow-connectorprofile-veevaconnectorprofilecredentials-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofilecredentials.html#cfn-appflow-connectorprofile-veevaconnectorprofilecredentials-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link VeevaConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VeevaConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VeevaConnectorProfileCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link VeevaConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link VeevaConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VeevaConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VeevaConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VeevaConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VeevaConnectorProfileCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VeevaConnectorProfileCredentialsProperty.Jsii$Proxy that = (VeevaConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using Veeva.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * VeevaConnectorProfilePropertiesProperty veevaConnectorProfilePropertiesProperty = VeevaConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(VeevaConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VeevaConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Veeva resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofileproperties.html#cfn-appflow-connectorprofile-veevaconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-veevaconnectorprofileproperties.html#cfn-appflow-connectorprofile-veevaconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link VeevaConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VeevaConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VeevaConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link VeevaConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Veeva resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VeevaConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VeevaConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VeevaConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VeevaConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VeevaConnectorProfilePropertiesProperty.Jsii$Proxy that = (VeevaConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The connector-specific profile credentials required when using Zendesk.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskConnectorProfileCredentialsProperty zendeskConnectorProfileCredentialsProperty = ZendeskConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the desired client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Zendesk resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-accesstoken</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-connectoroauthrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofilecredentials.html#cfn-appflow-connectorprofile-zendeskconnectorprofilecredentials-connectoroauthrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZendeskConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Zendesk resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskConnectorProfileCredentialsProperty.Jsii$Proxy that = (ZendeskConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                return this.connectorOAuthRequest != null ? this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connector-specific profile properties required when using Zendesk.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskConnectorProfilePropertiesProperty zendeskConnectorProfilePropertiesProperty = ZendeskConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofileproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofileproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Zendesk resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofileproperties.html#cfn-appflow-connectorprofile-zendeskconnectorprofileproperties-instanceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-connectorprofile-zendeskconnectorprofileproperties.html#cfn-appflow-connectorprofile-zendeskconnectorprofileproperties-instanceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link ZendeskConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link ZendeskConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Zendesk resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskConnectorProfilePropertiesProperty.Jsii$Proxy that = (ZendeskConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appflow.CfnConnectorProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appflow.CfnConnectorProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appflow.CfnConnectorProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appflow.CfnConnectorProfileProps.Builder();
        }

        /**
         * Indicates the connection mode and if it is public or private.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectionmode</a>
         * @param connectionMode Indicates the connection mode and if it is public or private. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionMode(final java.lang.String connectionMode) {
            this.props.connectionMode(connectionMode);
            return this;
        }

        /**
         * The name of the connector profile.
         * <p>
         * The name is unique for each <code>ConnectorProfile</code> in the AWS account .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofilename</a>
         * @param connectorProfileName The name of the connector profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileName(final java.lang.String connectorProfileName) {
            this.props.connectorProfileName(connectorProfileName);
            return this;
        }

        /**
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectortype</a>
         * @param connectorType The type of connector, such as Salesforce, Amplitude, and so on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorType(final java.lang.String connectorType) {
            this.props.connectorType(connectorType);
            return this;
        }

        /**
         * The label for the connector profile being created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorlabel</a>
         * @param connectorLabel The label for the connector profile being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorLabel(final java.lang.String connectorLabel) {
            this.props.connectorLabel(connectorLabel);
            return this;
        }

        /**
         * Defines the connector-specific configuration and credentials.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig</a>
         * @param connectorProfileConfig Defines the connector-specific configuration and credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileConfig(final software.amazon.awscdk.IResolvable connectorProfileConfig) {
            this.props.connectorProfileConfig(connectorProfileConfig);
            return this;
        }
        /**
         * Defines the connector-specific configuration and credentials.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-connectorprofileconfig</a>
         * @param connectorProfileConfig Defines the connector-specific configuration and credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileConfig(final software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileConfigProperty connectorProfileConfig) {
            this.props.connectorProfileConfig(connectorProfileConfig);
            return this;
        }

        /**
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         * <p>
         * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-kmsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connectorprofile.html#cfn-appflow-connectorprofile-kmsarn</a>
         * @param kmsArn The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsArn(final java.lang.String kmsArn) {
            this.props.kmsArn(kmsArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appflow.CfnConnectorProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appflow.CfnConnectorProfile build() {
            return new software.amazon.awscdk.services.appflow.CfnConnectorProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
