package software.amazon.awscdk.services.appmesh;

/**
 * Creates a virtual gateway.
 * <p>
 * A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself.
 * <p>
 * For more information about virtual gateways, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnVirtualGateway cfnVirtualGateway = CfnVirtualGateway.Builder.create(this, "MyCfnVirtualGateway")
 *         .meshName("meshName")
 *         .spec(VirtualGatewaySpecProperty.builder()
 *                 .listeners(List.of(VirtualGatewayListenerProperty.builder()
 *                         .portMapping(VirtualGatewayPortMappingProperty.builder()
 *                                 .port(123)
 *                                 .protocol("protocol")
 *                                 .build())
 *                         // the properties below are optional
 *                         .connectionPool(VirtualGatewayConnectionPoolProperty.builder()
 *                                 .grpc(VirtualGatewayGrpcConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .http(VirtualGatewayHttpConnectionPoolProperty.builder()
 *                                         .maxConnections(123)
 *                                         // the properties below are optional
 *                                         .maxPendingRequests(123)
 *                                         .build())
 *                                 .http2(VirtualGatewayHttp2ConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .build())
 *                         .healthCheck(VirtualGatewayHealthCheckPolicyProperty.builder()
 *                                 .healthyThreshold(123)
 *                                 .intervalMillis(123)
 *                                 .protocol("protocol")
 *                                 .timeoutMillis(123)
 *                                 .unhealthyThreshold(123)
 *                                 // the properties below are optional
 *                                 .path("path")
 *                                 .port(123)
 *                                 .build())
 *                         .tls(VirtualGatewayListenerTlsProperty.builder()
 *                                 .certificate(VirtualGatewayListenerTlsCertificateProperty.builder()
 *                                         .acm(VirtualGatewayListenerTlsAcmCertificateProperty.builder()
 *                                                 .certificateArn("certificateArn")
 *                                                 .build())
 *                                         .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
 *                                                 .certificateChain("certificateChain")
 *                                                 .privateKey("privateKey")
 *                                                 .build())
 *                                         .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
 *                                                 .secretName("secretName")
 *                                                 .build())
 *                                         .build())
 *                                 .mode("mode")
 *                                 // the properties below are optional
 *                                 .validation(VirtualGatewayListenerTlsValidationContextProperty.builder()
 *                                         .trust(VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
 *                                                 .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .build())
 *                                                 .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                         .exact(List.of("exact"))
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .backendDefaults(VirtualGatewayBackendDefaultsProperty.builder()
 *                         .clientPolicy(VirtualGatewayClientPolicyProperty.builder()
 *                                 .tls(VirtualGatewayClientPolicyTlsProperty.builder()
 *                                         .validation(VirtualGatewayTlsValidationContextProperty.builder()
 *                                                 .trust(VirtualGatewayTlsValidationContextTrustProperty.builder()
 *                                                         .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
 *                                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 *                                                                 .build())
 *                                                         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
 *                                                                 .certificateChain("certificateChain")
 *                                                                 .build())
 *                                                         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
 *                                                                 .secretName("secretName")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                         .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                                 .exact(List.of("exact"))
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .certificate(VirtualGatewayClientTlsCertificateProperty.builder()
 *                                                 .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .privateKey("privateKey")
 *                                                         .build())
 *                                                 .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         .enforce(false)
 *                                         .ports(List.of(123))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .logging(VirtualGatewayLoggingProperty.builder()
 *                         .accessLog(VirtualGatewayAccessLogProperty.builder()
 *                                 .file(VirtualGatewayFileAccessLogProperty.builder()
 *                                         .path("path")
 *                                         // the properties below are optional
 *                                         .format(LoggingFormatProperty.builder()
 *                                                 .json(List.of(JsonFormatRefProperty.builder()
 *                                                         .key("key")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .text("text")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .meshOwner("meshOwner")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualGatewayName("virtualGatewayName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.760Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway")
public class CfnVirtualGateway extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnVirtualGateway(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVirtualGateway(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVirtualGateway(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualGatewayProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The full Amazon Resource Name (ARN) for the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh that the virtual gateway resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshName() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the resource owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUid() {
        return software.amazon.jsii.Kernel.get(this, "attrUid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVirtualGatewayName() {
        return software.amazon.jsii.Kernel.get(this, "attrVirtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the service mesh that the virtual gateway resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMeshName() {
        return software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh that the virtual gateway resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshName", java.util.Objects.requireNonNull(value, "meshName is required"));
    }

    /**
     * The specifications of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSpec() {
        return software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The specifications of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The specifications of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewaySpecProperty value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshOwner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshOwner", value);
    }

    /**
     * Optional metadata that you can apply to the virtual gateway to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Optional metadata that you can apply to the virtual gateway to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The name of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVirtualGatewayName() {
        return software.amazon.jsii.Kernel.get(this, "virtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVirtualGatewayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "virtualGatewayName", value);
    }
    /**
     * An object that represents the key value pairs for the JSON.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * JsonFormatRefProperty jsonFormatRefProperty = JsonFormatRefProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-jsonformatref.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-jsonformatref.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.JsonFormatRefProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonFormatRefProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonFormatRefProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specified key for the JSON.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-jsonformatref.html#cfn-appmesh-virtualgateway-jsonformatref-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-jsonformatref.html#cfn-appmesh-virtualgateway-jsonformatref-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The specified value for the JSON.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-jsonformatref.html#cfn-appmesh-virtualgateway-jsonformatref-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-jsonformatref.html#cfn-appmesh-virtualgateway-jsonformatref-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link JsonFormatRefProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonFormatRefProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonFormatRefProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link JsonFormatRefProperty#getKey}
             * @param key The specified key for the JSON. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link JsonFormatRefProperty#getValue}
             * @param value The specified value for the JSON. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonFormatRefProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonFormatRefProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonFormatRefProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonFormatRefProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.JsonFormatRefProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonFormatRefProperty.Jsii$Proxy that = (JsonFormatRefProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the format for the logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * LoggingFormatProperty loggingFormatProperty = LoggingFormatProperty.builder()
     *         .json(List.of(JsonFormatRefProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-loggingformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-loggingformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.LoggingFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The logging format for JSON.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-loggingformat.html#cfn-appmesh-virtualgateway-loggingformat-json">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-loggingformat.html#cfn-appmesh-virtualgateway-loggingformat-json</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJson() {
            return null;
        }

        /**
         * The logging format for text.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-loggingformat.html#cfn-appmesh-virtualgateway-loggingformat-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-loggingformat.html#cfn-appmesh-virtualgateway-loggingformat-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingFormatProperty> {
            java.lang.Object json;
            java.lang.String text;

            /**
             * Sets the value of {@link LoggingFormatProperty#getJson}
             * @param json The logging format for JSON.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.IResolvable json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link LoggingFormatProperty#getJson}
             * @param json The logging format for JSON.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(java.util.List<? extends java.lang.Object> json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link LoggingFormatProperty#getText}
             * @param text The logging format for text.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingFormatProperty {
            private final java.lang.Object json;
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.json = software.amazon.jsii.Kernel.get(this, "json", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.json = builder.json;
                this.text = builder.text;
            }

            @Override
            public final java.lang.Object getJson() {
                return this.json;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJson() != null) {
                    data.set("json", om.valueToTree(this.getJson()));
                }
                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.LoggingFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingFormatProperty.Jsii$Proxy that = (LoggingFormatProperty.Jsii$Proxy) o;

                if (this.json != null ? !this.json.equals(that.json) : that.json != null) return false;
                return this.text != null ? this.text.equals(that.text) : that.text == null;
            }

            @Override
            public final int hashCode() {
                int result = this.json != null ? this.json.hashCode() : 0;
                result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the methods by which a subject alternative name on a peer Transport Layer Security (TLS) certificate can be matched.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * SubjectAlternativeNameMatchersProperty subjectAlternativeNameMatchersProperty = SubjectAlternativeNameMatchersProperty.builder()
     *         .exact(List.of("exact"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenamematchers.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenamematchers.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.SubjectAlternativeNameMatchersProperty")
    @software.amazon.jsii.Jsii.Proxy(SubjectAlternativeNameMatchersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectAlternativeNameMatchersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The values sent must match the specified values exactly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenamematchers.html#cfn-appmesh-virtualgateway-subjectalternativenamematchers-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenamematchers.html#cfn-appmesh-virtualgateway-subjectalternativenamematchers-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExact() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubjectAlternativeNameMatchersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectAlternativeNameMatchersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectAlternativeNameMatchersProperty> {
            java.util.List<java.lang.String> exact;

            /**
             * Sets the value of {@link SubjectAlternativeNameMatchersProperty#getExact}
             * @param exact The values sent must match the specified values exactly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.util.List<java.lang.String> exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectAlternativeNameMatchersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectAlternativeNameMatchersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectAlternativeNameMatchersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectAlternativeNameMatchersProperty {
            private final java.util.List<java.lang.String> exact;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
            }

            @Override
            public final java.util.List<java.lang.String> getExact() {
                return this.exact;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.SubjectAlternativeNameMatchersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectAlternativeNameMatchersProperty.Jsii$Proxy that = (SubjectAlternativeNameMatchersProperty.Jsii$Proxy) o;

                return this.exact != null ? this.exact.equals(that.exact) : that.exact == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the subject alternative names secured by the certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * SubjectAlternativeNamesProperty subjectAlternativeNamesProperty = SubjectAlternativeNamesProperty.builder()
     *         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                 .exact(List.of("exact"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenames.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenames.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.SubjectAlternativeNamesProperty")
    @software.amazon.jsii.Jsii.Proxy(SubjectAlternativeNamesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectAlternativeNamesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the criteria for determining a SANs match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenames.html#cfn-appmesh-virtualgateway-subjectalternativenames-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-subjectalternativenames.html#cfn-appmesh-virtualgateway-subjectalternativenames-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatch();

        /**
         * @return a {@link Builder} of {@link SubjectAlternativeNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectAlternativeNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectAlternativeNamesProperty> {
            java.lang.Object match;

            /**
             * Sets the value of {@link SubjectAlternativeNamesProperty#getMatch}
             * @param match An object that represents the criteria for determining a SANs match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link SubjectAlternativeNamesProperty#getMatch}
             * @param match An object that represents the criteria for determining a SANs match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.SubjectAlternativeNameMatchersProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectAlternativeNamesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectAlternativeNamesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectAlternativeNamesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectAlternativeNamesProperty {
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("match", om.valueToTree(this.getMatch()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.SubjectAlternativeNamesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectAlternativeNamesProperty.Jsii$Proxy that = (SubjectAlternativeNamesProperty.Jsii$Proxy) o;

                return this.match.equals(that.match);
            }

            @Override
            public final int hashCode() {
                int result = this.match.hashCode();
                return result;
            }
        }
    }
    /**
     * The access log configuration for a virtual gateway.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayAccessLogProperty virtualGatewayAccessLogProperty = VirtualGatewayAccessLogProperty.builder()
     *         .file(VirtualGatewayFileAccessLogProperty.builder()
     *                 .path("path")
     *                 // the properties below are optional
     *                 .format(LoggingFormatProperty.builder()
     *                         .json(List.of(JsonFormatRefProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .text("text")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayAccessLogProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayAccessLogProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayAccessLogProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file object to send virtual gateway access logs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayaccesslog-file">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayaccesslog-file</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayAccessLogProperty> {
            java.lang.Object file;

            /**
             * Sets the value of {@link VirtualGatewayAccessLogProperty#getFile}
             * @param file The file object to send virtual gateway access logs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayAccessLogProperty#getFile}
             * @param file The file object to send virtual gateway access logs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayFileAccessLogProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayAccessLogProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayAccessLogProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayAccessLogProperty {
            private final java.lang.Object file;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = builder.file;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayAccessLogProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayAccessLogProperty.Jsii$Proxy that = (VirtualGatewayAccessLogProperty.Jsii$Proxy) o;

                return this.file != null ? this.file.equals(that.file) : that.file == null;
            }

            @Override
            public final int hashCode() {
                int result = this.file != null ? this.file.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the default properties for a backend.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayBackendDefaultsProperty virtualGatewayBackendDefaultsProperty = VirtualGatewayBackendDefaultsProperty.builder()
     *         .clientPolicy(VirtualGatewayClientPolicyProperty.builder()
     *                 .tls(VirtualGatewayClientPolicyTlsProperty.builder()
     *                         .validation(VirtualGatewayTlsValidationContextProperty.builder()
     *                                 .trust(VirtualGatewayTlsValidationContextTrustProperty.builder()
     *                                         .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
     *                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                                 .build())
     *                                         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .build())
     *                                         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                 .exact(List.of("exact"))
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .certificate(VirtualGatewayClientTlsCertificateProperty.builder()
     *                                 .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .privateKey("privateKey")
     *                                         .build())
     *                                 .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         .enforce(false)
     *                         .ports(List.of(123))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayBackendDefaultsProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayBackendDefaultsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayBackendDefaultsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a client policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html#cfn-appmesh-virtualgateway-virtualgatewaybackenddefaults-clientpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaybackenddefaults.html#cfn-appmesh-virtualgateway-virtualgatewaybackenddefaults-clientpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayBackendDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayBackendDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayBackendDefaultsProperty> {
            java.lang.Object clientPolicy;

            /**
             * Sets the value of {@link VirtualGatewayBackendDefaultsProperty#getClientPolicy}
             * @param clientPolicy A reference to an object that represents a client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientPolicy(software.amazon.awscdk.IResolvable clientPolicy) {
                this.clientPolicy = clientPolicy;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayBackendDefaultsProperty#getClientPolicy}
             * @param clientPolicy A reference to an object that represents a client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientPolicy(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyProperty clientPolicy) {
                this.clientPolicy = clientPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayBackendDefaultsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayBackendDefaultsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayBackendDefaultsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayBackendDefaultsProperty {
            private final java.lang.Object clientPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientPolicy = software.amazon.jsii.Kernel.get(this, "clientPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientPolicy = builder.clientPolicy;
            }

            @Override
            public final java.lang.Object getClientPolicy() {
                return this.clientPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientPolicy() != null) {
                    data.set("clientPolicy", om.valueToTree(this.getClientPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayBackendDefaultsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayBackendDefaultsProperty.Jsii$Proxy that = (VirtualGatewayBackendDefaultsProperty.Jsii$Proxy) o;

                return this.clientPolicy != null ? this.clientPolicy.equals(that.clientPolicy) : that.clientPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientPolicy != null ? this.clientPolicy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a client policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayClientPolicyProperty virtualGatewayClientPolicyProperty = VirtualGatewayClientPolicyProperty.builder()
     *         .tls(VirtualGatewayClientPolicyTlsProperty.builder()
     *                 .validation(VirtualGatewayTlsValidationContextProperty.builder()
     *                         .trust(VirtualGatewayTlsValidationContextTrustProperty.builder()
     *                                 .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
     *                                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                         .build())
     *                                 .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .build())
     *                                 .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                         .exact(List.of("exact"))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .certificate(VirtualGatewayClientTlsCertificateProperty.builder()
     *                         .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .privateKey("privateKey")
     *                                 .build())
     *                         .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 .enforce(false)
     *                 .ports(List.of(123))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayClientPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayClientPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a Transport Layer Security (TLS) client policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicy-tls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicy-tls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayClientPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayClientPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayClientPolicyProperty> {
            java.lang.Object tls;

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyProperty#getTls}
             * @param tls A reference to an object that represents a Transport Layer Security (TLS) client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.IResolvable tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyProperty#getTls}
             * @param tls A reference to an object that represents a Transport Layer Security (TLS) client policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayClientPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayClientPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayClientPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayClientPolicyProperty {
            private final java.lang.Object tls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tls = builder.tls;
            }

            @Override
            public final java.lang.Object getTls() {
                return this.tls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTls() != null) {
                    data.set("tls", om.valueToTree(this.getTls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayClientPolicyProperty.Jsii$Proxy that = (VirtualGatewayClientPolicyProperty.Jsii$Proxy) o;

                return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tls != null ? this.tls.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) client policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayClientPolicyTlsProperty virtualGatewayClientPolicyTlsProperty = VirtualGatewayClientPolicyTlsProperty.builder()
     *         .validation(VirtualGatewayTlsValidationContextProperty.builder()
     *                 .trust(VirtualGatewayTlsValidationContextTrustProperty.builder()
     *                         .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
     *                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                 .build())
     *                         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .build())
     *                         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                 .exact(List.of("exact"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .certificate(VirtualGatewayClientTlsCertificateProperty.builder()
     *                 .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .privateKey("privateKey")
     *                         .build())
     *                 .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         .enforce(false)
     *         .ports(List.of(123))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayClientPolicyTlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayClientPolicyTlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a Transport Layer Security (TLS) validation context.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-validation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-validation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValidation();

        /**
         * A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS) certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-certificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-certificate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCertificate() {
            return null;
        }

        /**
         * Whether the policy is enforced.
         * <p>
         * The default is <code>True</code> , if a value isn't specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-enforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-enforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforce() {
            return null;
        }

        /**
         * One or more ports that the policy is enforced for.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-ports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclientpolicytls.html#cfn-appmesh-virtualgateway-virtualgatewayclientpolicytls-ports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPorts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayClientPolicyTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayClientPolicyTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayClientPolicyTlsProperty> {
            java.lang.Object validation;
            java.lang.Object certificate;
            java.lang.Object enforce;
            java.lang.Object ports;

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getValidation}
             * @param validation A reference to an object that represents a Transport Layer Security (TLS) validation context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.IResolvable validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getValidation}
             * @param validation A reference to an object that represents a Transport Layer Security (TLS) validation context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getCertificate}
             * @param certificate A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS) certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.IResolvable certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getCertificate}
             * @param certificate A reference to an object that represents a virtual gateway's client's Transport Layer Security (TLS) certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayClientTlsCertificateProperty certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getEnforce}
             * @param enforce Whether the policy is enforced.
             *                The default is <code>True</code> , if a value isn't specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforce(java.lang.Boolean enforce) {
                this.enforce = enforce;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getEnforce}
             * @param enforce Whether the policy is enforced.
             *                The default is <code>True</code> , if a value isn't specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforce(software.amazon.awscdk.IResolvable enforce) {
                this.enforce = enforce;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getPorts}
             * @param ports One or more ports that the policy is enforced for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(java.util.List<? extends java.lang.Number> ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientPolicyTlsProperty#getPorts}
             * @param ports One or more ports that the policy is enforced for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ports(software.amazon.awscdk.IResolvable ports) {
                this.ports = ports;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayClientPolicyTlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayClientPolicyTlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayClientPolicyTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayClientPolicyTlsProperty {
            private final java.lang.Object validation;
            private final java.lang.Object certificate;
            private final java.lang.Object enforce;
            private final java.lang.Object ports;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforce = software.amazon.jsii.Kernel.get(this, "enforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.validation = java.util.Objects.requireNonNull(builder.validation, "validation is required");
                this.certificate = builder.certificate;
                this.enforce = builder.enforce;
                this.ports = builder.ports;
            }

            @Override
            public final java.lang.Object getValidation() {
                return this.validation;
            }

            @Override
            public final java.lang.Object getCertificate() {
                return this.certificate;
            }

            @Override
            public final java.lang.Object getEnforce() {
                return this.enforce;
            }

            @Override
            public final java.lang.Object getPorts() {
                return this.ports;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("validation", om.valueToTree(this.getValidation()));
                if (this.getCertificate() != null) {
                    data.set("certificate", om.valueToTree(this.getCertificate()));
                }
                if (this.getEnforce() != null) {
                    data.set("enforce", om.valueToTree(this.getEnforce()));
                }
                if (this.getPorts() != null) {
                    data.set("ports", om.valueToTree(this.getPorts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayClientPolicyTlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayClientPolicyTlsProperty.Jsii$Proxy that = (VirtualGatewayClientPolicyTlsProperty.Jsii$Proxy) o;

                if (!validation.equals(that.validation)) return false;
                if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
                if (this.enforce != null ? !this.enforce.equals(that.enforce) : that.enforce != null) return false;
                return this.ports != null ? this.ports.equals(that.ports) : that.ports == null;
            }

            @Override
            public final int hashCode() {
                int result = this.validation.hashCode();
                result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
                result = 31 * result + (this.enforce != null ? this.enforce.hashCode() : 0);
                result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the virtual gateway's client's Transport Layer Security (TLS) certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayClientTlsCertificateProperty virtualGatewayClientTlsCertificateProperty = VirtualGatewayClientTlsCertificateProperty.builder()
     *         .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .privateKey("privateKey")
     *                 .build())
     *         .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayClientTlsCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayClientTlsCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayClientTlsCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a local file certificate.
         * <p>
         * The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewayclienttlscertificate-file">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewayclienttlscertificate-file</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a virtual gateway's client's Secret Discovery Service certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewayclienttlscertificate-sds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayclienttlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewayclienttlscertificate-sds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayClientTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayClientTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayClientTlsCertificateProperty> {
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link VirtualGatewayClientTlsCertificateProperty#getFile}
             * @param file An object that represents a local file certificate.
             *             The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientTlsCertificateProperty#getFile}
             * @param file An object that represents a local file certificate.
             *             The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">Transport Layer Security (TLS)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's client's Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayClientTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's client's Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsSdsCertificateProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayClientTlsCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayClientTlsCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayClientTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayClientTlsCertificateProperty {
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayClientTlsCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayClientTlsCertificateProperty.Jsii$Proxy that = (VirtualGatewayClientTlsCertificateProperty.Jsii$Proxy) o;

                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.file != null ? this.file.hashCode() : 0;
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the type of virtual gateway connection pool.
     * <p>
     * Only one protocol is used at a time and should be the same protocol as the one chosen under port mapping.
     * <p>
     * If not present the default value for <code>maxPendingRequests</code> is <code>2147483647</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayConnectionPoolProperty virtualGatewayConnectionPoolProperty = VirtualGatewayConnectionPoolProperty.builder()
     *         .grpc(VirtualGatewayGrpcConnectionPoolProperty.builder()
     *                 .maxRequests(123)
     *                 .build())
     *         .http(VirtualGatewayHttpConnectionPoolProperty.builder()
     *                 .maxConnections(123)
     *                 // the properties below are optional
     *                 .maxPendingRequests(123)
     *                 .build())
     *         .http2(VirtualGatewayHttp2ConnectionPoolProperty.builder()
     *                 .maxRequests(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a type of connection pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-grpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-grpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrpc() {
            return null;
        }

        /**
         * An object that represents a type of connection pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-http">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-http</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp() {
            return null;
        }

        /**
         * An object that represents a type of connection pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-http2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayconnectionpool-http2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp2() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayConnectionPoolProperty> {
            java.lang.Object grpc;
            java.lang.Object http;
            java.lang.Object http2;

            /**
             * Sets the value of {@link VirtualGatewayConnectionPoolProperty#getGrpc}
             * @param grpc An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpc(software.amazon.awscdk.IResolvable grpc) {
                this.grpc = grpc;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayConnectionPoolProperty#getGrpc}
             * @param grpc An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpc(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayGrpcConnectionPoolProperty grpc) {
                this.grpc = grpc;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayConnectionPoolProperty#getHttp}
             * @param http An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.IResolvable http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayConnectionPoolProperty#getHttp}
             * @param http An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayHttpConnectionPoolProperty http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayConnectionPoolProperty#getHttp2}
             * @param http2 An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2(software.amazon.awscdk.IResolvable http2) {
                this.http2 = http2;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayConnectionPoolProperty#getHttp2}
             * @param http2 An object that represents a type of connection pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayHttp2ConnectionPoolProperty http2) {
                this.http2 = http2;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayConnectionPoolProperty {
            private final java.lang.Object grpc;
            private final java.lang.Object http;
            private final java.lang.Object http2;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grpc = software.amazon.jsii.Kernel.get(this, "grpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http = software.amazon.jsii.Kernel.get(this, "http", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http2 = software.amazon.jsii.Kernel.get(this, "http2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grpc = builder.grpc;
                this.http = builder.http;
                this.http2 = builder.http2;
            }

            @Override
            public final java.lang.Object getGrpc() {
                return this.grpc;
            }

            @Override
            public final java.lang.Object getHttp() {
                return this.http;
            }

            @Override
            public final java.lang.Object getHttp2() {
                return this.http2;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrpc() != null) {
                    data.set("grpc", om.valueToTree(this.getGrpc()));
                }
                if (this.getHttp() != null) {
                    data.set("http", om.valueToTree(this.getHttp()));
                }
                if (this.getHttp2() != null) {
                    data.set("http2", om.valueToTree(this.getHttp2()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayConnectionPoolProperty.Jsii$Proxy that = (VirtualGatewayConnectionPoolProperty.Jsii$Proxy) o;

                if (this.grpc != null ? !this.grpc.equals(that.grpc) : that.grpc != null) return false;
                if (this.http != null ? !this.http.equals(that.http) : that.http != null) return false;
                return this.http2 != null ? this.http2.equals(that.http2) : that.http2 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grpc != null ? this.grpc.hashCode() : 0;
                result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
                result = 31 * result + (this.http2 != null ? this.http2.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents an access log file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayFileAccessLogProperty virtualGatewayFileAccessLogProperty = VirtualGatewayFileAccessLogProperty.builder()
     *         .path("path")
     *         // the properties below are optional
     *         .format(LoggingFormatProperty.builder()
     *                 .json(List.of(JsonFormatRefProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .text("text")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayFileAccessLogProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayFileAccessLogProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayFileAccessLogProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file path to write access logs to.
         * <p>
         * You can use <code>/dev/stdout</code> to send access logs to standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code> , to export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's file system to write the files to disk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayfileaccesslog-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayfileaccesslog-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * The specified format for the virtual gateway access logs.
         * <p>
         * It can be either <code>json_format</code> or <code>text_format</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayfileaccesslog-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayfileaccesslog.html#cfn-appmesh-virtualgateway-virtualgatewayfileaccesslog-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayFileAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayFileAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayFileAccessLogProperty> {
            java.lang.String path;
            java.lang.Object format;

            /**
             * Sets the value of {@link VirtualGatewayFileAccessLogProperty#getPath}
             * @param path The file path to write access logs to. This parameter is required.
             *             You can use <code>/dev/stdout</code> to send access logs to standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code> , to export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's file system to write the files to disk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayFileAccessLogProperty#getFormat}
             * @param format The specified format for the virtual gateway access logs.
             *               It can be either <code>json_format</code> or <code>text_format</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(software.amazon.awscdk.IResolvable format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayFileAccessLogProperty#getFormat}
             * @param format The specified format for the virtual gateway access logs.
             *               It can be either <code>json_format</code> or <code>text_format</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.LoggingFormatProperty format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayFileAccessLogProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayFileAccessLogProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayFileAccessLogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayFileAccessLogProperty {
            private final java.lang.String path;
            private final java.lang.Object format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.format = builder.format;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Object getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("path", om.valueToTree(this.getPath()));
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayFileAccessLogProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayFileAccessLogProperty.Jsii$Proxy that = (VirtualGatewayFileAccessLogProperty.Jsii$Proxy) o;

                if (!path.equals(that.path)) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path.hashCode();
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a type of connection pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayGrpcConnectionPoolProperty virtualGatewayGrpcConnectionPoolProperty = VirtualGatewayGrpcConnectionPoolProperty.builder()
     *         .maxRequests(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayGrpcConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayGrpcConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayGrpcConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool-maxrequests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewaygrpcconnectionpool-maxrequests</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRequests();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayGrpcConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayGrpcConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayGrpcConnectionPoolProperty> {
            java.lang.Number maxRequests;

            /**
             * Sets the value of {@link VirtualGatewayGrpcConnectionPoolProperty#getMaxRequests}
             * @param maxRequests Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRequests(java.lang.Number maxRequests) {
                this.maxRequests = maxRequests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayGrpcConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayGrpcConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayGrpcConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayGrpcConnectionPoolProperty {
            private final java.lang.Number maxRequests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRequests = software.amazon.jsii.Kernel.get(this, "maxRequests", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRequests = java.util.Objects.requireNonNull(builder.maxRequests, "maxRequests is required");
            }

            @Override
            public final java.lang.Number getMaxRequests() {
                return this.maxRequests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRequests", om.valueToTree(this.getMaxRequests()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayGrpcConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayGrpcConnectionPoolProperty.Jsii$Proxy that = (VirtualGatewayGrpcConnectionPoolProperty.Jsii$Proxy) o;

                return this.maxRequests.equals(that.maxRequests);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRequests.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents the health check policy for a virtual gateway's listener.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayHealthCheckPolicyProperty virtualGatewayHealthCheckPolicyProperty = VirtualGatewayHealthCheckPolicyProperty.builder()
     *         .healthyThreshold(123)
     *         .intervalMillis(123)
     *         .protocol("protocol")
     *         .timeoutMillis(123)
     *         .unhealthyThreshold(123)
     *         // the properties below are optional
     *         .path("path")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayHealthCheckPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayHealthCheckPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of consecutive successful health checks that must occur before declaring the listener healthy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-healthythreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-healthythreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHealthyThreshold();

        /**
         * The time period in milliseconds between each health check execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-intervalmillis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-intervalmillis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getIntervalMillis();

        /**
         * The protocol for the health check request.
         * <p>
         * If you specify <code>grpc</code> , then your service must conform to the <a href="https://docs.aws.amazon.com/https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * The amount of time to wait when receiving a response from the health check, in milliseconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-timeoutmillis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-timeoutmillis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutMillis();

        /**
         * The number of consecutive failed health checks that must occur before declaring a virtual gateway unhealthy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-unhealthythreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-unhealthythreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getUnhealthyThreshold();

        /**
         * The destination path for the health check request.
         * <p>
         * This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The destination port for the health check request.
         * <p>
         * This port must match the port defined in the <code>PortMapping</code> for the listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy.html#cfn-appmesh-virtualgateway-virtualgatewayhealthcheckpolicy-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayHealthCheckPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayHealthCheckPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayHealthCheckPolicyProperty> {
            java.lang.Number healthyThreshold;
            java.lang.Number intervalMillis;
            java.lang.String protocol;
            java.lang.Number timeoutMillis;
            java.lang.Number unhealthyThreshold;
            java.lang.String path;
            java.lang.Number port;

            /**
             * Sets the value of {@link VirtualGatewayHealthCheckPolicyProperty#getHealthyThreshold}
             * @param healthyThreshold The number of consecutive successful health checks that must occur before declaring the listener healthy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthyThreshold(java.lang.Number healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayHealthCheckPolicyProperty#getIntervalMillis}
             * @param intervalMillis The time period in milliseconds between each health check execution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalMillis(java.lang.Number intervalMillis) {
                this.intervalMillis = intervalMillis;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayHealthCheckPolicyProperty#getProtocol}
             * @param protocol The protocol for the health check request. This parameter is required.
             *                 If you specify <code>grpc</code> , then your service must conform to the <a href="https://docs.aws.amazon.com/https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayHealthCheckPolicyProperty#getTimeoutMillis}
             * @param timeoutMillis The amount of time to wait when receiving a response from the health check, in milliseconds. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMillis(java.lang.Number timeoutMillis) {
                this.timeoutMillis = timeoutMillis;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayHealthCheckPolicyProperty#getUnhealthyThreshold}
             * @param unhealthyThreshold The number of consecutive failed health checks that must occur before declaring a virtual gateway unhealthy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unhealthyThreshold(java.lang.Number unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayHealthCheckPolicyProperty#getPath}
             * @param path The destination path for the health check request.
             *             This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayHealthCheckPolicyProperty#getPort}
             * @param port The destination port for the health check request.
             *             This port must match the port defined in the <code>PortMapping</code> for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayHealthCheckPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayHealthCheckPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayHealthCheckPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayHealthCheckPolicyProperty {
            private final java.lang.Number healthyThreshold;
            private final java.lang.Number intervalMillis;
            private final java.lang.String protocol;
            private final java.lang.Number timeoutMillis;
            private final java.lang.Number unhealthyThreshold;
            private final java.lang.String path;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthyThreshold = software.amazon.jsii.Kernel.get(this, "healthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalMillis = software.amazon.jsii.Kernel.get(this, "intervalMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutMillis = software.amazon.jsii.Kernel.get(this, "timeoutMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unhealthyThreshold = software.amazon.jsii.Kernel.get(this, "unhealthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthyThreshold = java.util.Objects.requireNonNull(builder.healthyThreshold, "healthyThreshold is required");
                this.intervalMillis = java.util.Objects.requireNonNull(builder.intervalMillis, "intervalMillis is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.timeoutMillis = java.util.Objects.requireNonNull(builder.timeoutMillis, "timeoutMillis is required");
                this.unhealthyThreshold = java.util.Objects.requireNonNull(builder.unhealthyThreshold, "unhealthyThreshold is required");
                this.path = builder.path;
                this.port = builder.port;
            }

            @Override
            public final java.lang.Number getHealthyThreshold() {
                return this.healthyThreshold;
            }

            @Override
            public final java.lang.Number getIntervalMillis() {
                return this.intervalMillis;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getTimeoutMillis() {
                return this.timeoutMillis;
            }

            @Override
            public final java.lang.Number getUnhealthyThreshold() {
                return this.unhealthyThreshold;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
                data.set("intervalMillis", om.valueToTree(this.getIntervalMillis()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("timeoutMillis", om.valueToTree(this.getTimeoutMillis()));
                data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayHealthCheckPolicyProperty.Jsii$Proxy that = (VirtualGatewayHealthCheckPolicyProperty.Jsii$Proxy) o;

                if (!healthyThreshold.equals(that.healthyThreshold)) return false;
                if (!intervalMillis.equals(that.intervalMillis)) return false;
                if (!protocol.equals(that.protocol)) return false;
                if (!timeoutMillis.equals(that.timeoutMillis)) return false;
                if (!unhealthyThreshold.equals(that.unhealthyThreshold)) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthyThreshold.hashCode();
                result = 31 * result + (this.intervalMillis.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.timeoutMillis.hashCode());
                result = 31 * result + (this.unhealthyThreshold.hashCode());
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a type of connection pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayHttp2ConnectionPoolProperty virtualGatewayHttp2ConnectionPoolProperty = VirtualGatewayHttp2ConnectionPoolProperty.builder()
     *         .maxRequests(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttp2connectionpool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttp2connectionpool.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayHttp2ConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayHttp2ConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayHttp2ConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttp2connectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttp2connectionpool-maxrequests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttp2connectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttp2connectionpool-maxrequests</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRequests();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayHttp2ConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayHttp2ConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayHttp2ConnectionPoolProperty> {
            java.lang.Number maxRequests;

            /**
             * Sets the value of {@link VirtualGatewayHttp2ConnectionPoolProperty#getMaxRequests}
             * @param maxRequests Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRequests(java.lang.Number maxRequests) {
                this.maxRequests = maxRequests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayHttp2ConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayHttp2ConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayHttp2ConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayHttp2ConnectionPoolProperty {
            private final java.lang.Number maxRequests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRequests = software.amazon.jsii.Kernel.get(this, "maxRequests", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRequests = java.util.Objects.requireNonNull(builder.maxRequests, "maxRequests is required");
            }

            @Override
            public final java.lang.Number getMaxRequests() {
                return this.maxRequests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRequests", om.valueToTree(this.getMaxRequests()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayHttp2ConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayHttp2ConnectionPoolProperty.Jsii$Proxy that = (VirtualGatewayHttp2ConnectionPoolProperty.Jsii$Proxy) o;

                return this.maxRequests.equals(that.maxRequests);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRequests.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a type of connection pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayHttpConnectionPoolProperty virtualGatewayHttpConnectionPoolProperty = VirtualGatewayHttpConnectionPoolProperty.builder()
     *         .maxConnections(123)
     *         // the properties below are optional
     *         .maxPendingRequests(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayHttpConnectionPoolProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayHttpConnectionPoolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayHttpConnectionPoolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttpconnectionpool-maxconnections">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttpconnectionpool-maxconnections</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxConnections();

        /**
         * Number of overflowing requests after <code>max_connections</code> Envoy will queue to upstream cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttpconnectionpool-maxpendingrequests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayhttpconnectionpool.html#cfn-appmesh-virtualgateway-virtualgatewayhttpconnectionpool-maxpendingrequests</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPendingRequests() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayHttpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayHttpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayHttpConnectionPoolProperty> {
            java.lang.Number maxConnections;
            java.lang.Number maxPendingRequests;

            /**
             * Sets the value of {@link VirtualGatewayHttpConnectionPoolProperty#getMaxConnections}
             * @param maxConnections Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConnections(java.lang.Number maxConnections) {
                this.maxConnections = maxConnections;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayHttpConnectionPoolProperty#getMaxPendingRequests}
             * @param maxPendingRequests Number of overflowing requests after <code>max_connections</code> Envoy will queue to upstream cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPendingRequests(java.lang.Number maxPendingRequests) {
                this.maxPendingRequests = maxPendingRequests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayHttpConnectionPoolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayHttpConnectionPoolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayHttpConnectionPoolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayHttpConnectionPoolProperty {
            private final java.lang.Number maxConnections;
            private final java.lang.Number maxPendingRequests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConnections = software.amazon.jsii.Kernel.get(this, "maxConnections", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxPendingRequests = software.amazon.jsii.Kernel.get(this, "maxPendingRequests", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConnections = java.util.Objects.requireNonNull(builder.maxConnections, "maxConnections is required");
                this.maxPendingRequests = builder.maxPendingRequests;
            }

            @Override
            public final java.lang.Number getMaxConnections() {
                return this.maxConnections;
            }

            @Override
            public final java.lang.Number getMaxPendingRequests() {
                return this.maxPendingRequests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxConnections", om.valueToTree(this.getMaxConnections()));
                if (this.getMaxPendingRequests() != null) {
                    data.set("maxPendingRequests", om.valueToTree(this.getMaxPendingRequests()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayHttpConnectionPoolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayHttpConnectionPoolProperty.Jsii$Proxy that = (VirtualGatewayHttpConnectionPoolProperty.Jsii$Proxy) o;

                if (!maxConnections.equals(that.maxConnections)) return false;
                return this.maxPendingRequests != null ? this.maxPendingRequests.equals(that.maxPendingRequests) : that.maxPendingRequests == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxConnections.hashCode();
                result = 31 * result + (this.maxPendingRequests != null ? this.maxPendingRequests.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a listener for a virtual gateway.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerProperty virtualGatewayListenerProperty = VirtualGatewayListenerProperty.builder()
     *         .portMapping(VirtualGatewayPortMappingProperty.builder()
     *                 .port(123)
     *                 .protocol("protocol")
     *                 .build())
     *         // the properties below are optional
     *         .connectionPool(VirtualGatewayConnectionPoolProperty.builder()
     *                 .grpc(VirtualGatewayGrpcConnectionPoolProperty.builder()
     *                         .maxRequests(123)
     *                         .build())
     *                 .http(VirtualGatewayHttpConnectionPoolProperty.builder()
     *                         .maxConnections(123)
     *                         // the properties below are optional
     *                         .maxPendingRequests(123)
     *                         .build())
     *                 .http2(VirtualGatewayHttp2ConnectionPoolProperty.builder()
     *                         .maxRequests(123)
     *                         .build())
     *                 .build())
     *         .healthCheck(VirtualGatewayHealthCheckPolicyProperty.builder()
     *                 .healthyThreshold(123)
     *                 .intervalMillis(123)
     *                 .protocol("protocol")
     *                 .timeoutMillis(123)
     *                 .unhealthyThreshold(123)
     *                 // the properties below are optional
     *                 .path("path")
     *                 .port(123)
     *                 .build())
     *         .tls(VirtualGatewayListenerTlsProperty.builder()
     *                 .certificate(VirtualGatewayListenerTlsCertificateProperty.builder()
     *                         .acm(VirtualGatewayListenerTlsAcmCertificateProperty.builder()
     *                                 .certificateArn("certificateArn")
     *                                 .build())
     *                         .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .privateKey("privateKey")
     *                                 .build())
     *                         .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 .mode("mode")
     *                 // the properties below are optional
     *                 .validation(VirtualGatewayListenerTlsValidationContextProperty.builder()
     *                         .trust(VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
     *                                 .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .build())
     *                                 .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                         .exact(List.of("exact"))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port mapping information for the listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-portmapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-portmapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPortMapping();

        /**
         * The connection pool information for the listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-connectionpool">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-connectionpool</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionPool() {
            return null;
        }

        /**
         * The health check information for the listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-healthcheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-healthcheck</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheck() {
            return null;
        }

        /**
         * A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-tls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistener.html#cfn-appmesh-virtualgateway-virtualgatewaylistener-tls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerProperty> {
            java.lang.Object portMapping;
            java.lang.Object connectionPool;
            java.lang.Object healthCheck;
            java.lang.Object tls;

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getPortMapping}
             * @param portMapping The port mapping information for the listener. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portMapping(software.amazon.awscdk.IResolvable portMapping) {
                this.portMapping = portMapping;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getPortMapping}
             * @param portMapping The port mapping information for the listener. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portMapping(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayPortMappingProperty portMapping) {
                this.portMapping = portMapping;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getConnectionPool}
             * @param connectionPool The connection pool information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionPool(software.amazon.awscdk.IResolvable connectionPool) {
                this.connectionPool = connectionPool;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getConnectionPool}
             * @param connectionPool The connection pool information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionPool(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayConnectionPoolProperty connectionPool) {
                this.connectionPool = connectionPool;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getHealthCheck}
             * @param healthCheck The health check information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.IResolvable healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getHealthCheck}
             * @param healthCheck The health check information for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getTls}
             * @param tls A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.IResolvable tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerProperty#getTls}
             * @param tls A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsProperty tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerProperty {
            private final java.lang.Object portMapping;
            private final java.lang.Object connectionPool;
            private final java.lang.Object healthCheck;
            private final java.lang.Object tls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.portMapping = software.amazon.jsii.Kernel.get(this, "portMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionPool = software.amazon.jsii.Kernel.get(this, "connectionPool", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.portMapping = java.util.Objects.requireNonNull(builder.portMapping, "portMapping is required");
                this.connectionPool = builder.connectionPool;
                this.healthCheck = builder.healthCheck;
                this.tls = builder.tls;
            }

            @Override
            public final java.lang.Object getPortMapping() {
                return this.portMapping;
            }

            @Override
            public final java.lang.Object getConnectionPool() {
                return this.connectionPool;
            }

            @Override
            public final java.lang.Object getHealthCheck() {
                return this.healthCheck;
            }

            @Override
            public final java.lang.Object getTls() {
                return this.tls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("portMapping", om.valueToTree(this.getPortMapping()));
                if (this.getConnectionPool() != null) {
                    data.set("connectionPool", om.valueToTree(this.getConnectionPool()));
                }
                if (this.getHealthCheck() != null) {
                    data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                }
                if (this.getTls() != null) {
                    data.set("tls", om.valueToTree(this.getTls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerProperty.Jsii$Proxy that = (VirtualGatewayListenerProperty.Jsii$Proxy) o;

                if (!portMapping.equals(that.portMapping)) return false;
                if (this.connectionPool != null ? !this.connectionPool.equals(that.connectionPool) : that.connectionPool != null) return false;
                if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
                return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.portMapping.hashCode();
                result = 31 * result + (this.connectionPool != null ? this.connectionPool.hashCode() : 0);
                result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
                result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents an AWS Certificate Manager certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerTlsAcmCertificateProperty virtualGatewayListenerTlsAcmCertificateProperty = VirtualGatewayListenerTlsAcmCertificateProperty.builder()
     *         .certificateArn("certificateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsAcmCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerTlsAcmCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerTlsAcmCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the certificate.
         * <p>
         * The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsacmcertificate-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerTlsAcmCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerTlsAcmCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerTlsAcmCertificateProperty> {
            java.lang.String certificateArn;

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsAcmCertificateProperty#getCertificateArn}
             * @param certificateArn The Amazon Resource Name (ARN) for the certificate. This parameter is required.
             *                       The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerTlsAcmCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerTlsAcmCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerTlsAcmCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerTlsAcmCertificateProperty {
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = java.util.Objects.requireNonNull(builder.certificateArn, "certificateArn is required");
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateArn", om.valueToTree(this.getCertificateArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsAcmCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerTlsAcmCertificateProperty.Jsii$Proxy that = (VirtualGatewayListenerTlsAcmCertificateProperty.Jsii$Proxy) o;

                return this.certificateArn.equals(that.certificateArn);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a listener's Transport Layer Security (TLS) certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerTlsCertificateProperty virtualGatewayListenerTlsCertificateProperty = VirtualGatewayListenerTlsCertificateProperty.builder()
     *         .acm(VirtualGatewayListenerTlsAcmCertificateProperty.builder()
     *                 .certificateArn("certificateArn")
     *                 .build())
     *         .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .privateKey("privateKey")
     *                 .build())
     *         .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerTlsCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerTlsCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents an AWS Certificate Manager certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-acm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-acm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcm() {
            return null;
        }

        /**
         * A reference to an object that represents a local file certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-file">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-file</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-sds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlscertificate-sds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerTlsCertificateProperty> {
            java.lang.Object acm;
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsCertificateProperty#getAcm}
             * @param acm A reference to an object that represents an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.IResolvable acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsCertificateProperty#getAcm}
             * @param acm A reference to an object that represents an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsAcmCertificateProperty acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsCertificateProperty#getFile}
             * @param file A reference to an object that represents a local file certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsCertificateProperty#getFile}
             * @param file A reference to an object that represents a local file certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsCertificateProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's listener's Secret Discovery Service certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsSdsCertificateProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerTlsCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerTlsCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerTlsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerTlsCertificateProperty {
            private final java.lang.Object acm;
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acm = software.amazon.jsii.Kernel.get(this, "acm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acm = builder.acm;
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getAcm() {
                return this.acm;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcm() != null) {
                    data.set("acm", om.valueToTree(this.getAcm()));
                }
                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerTlsCertificateProperty.Jsii$Proxy that = (VirtualGatewayListenerTlsCertificateProperty.Jsii$Proxy) o;

                if (this.acm != null ? !this.acm.equals(that.acm) : that.acm != null) return false;
                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acm != null ? this.acm.hashCode() : 0;
                result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a local file certificate.
     * <p>
     * The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerTlsFileCertificateProperty virtualGatewayListenerTlsFileCertificateProperty = VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *         .certificateChain("certificateChain")
     *         .privateKey("privateKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerTlsFileCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerTlsFileCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The certificate chain for the certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-certificatechain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-certificatechain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateChain();

        /**
         * The private key for a certificate stored on the file system of the mesh endpoint that the proxy is running on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-privatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsfilecertificate-privatekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrivateKey();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerTlsFileCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerTlsFileCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerTlsFileCertificateProperty> {
            java.lang.String certificateChain;
            java.lang.String privateKey;

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsFileCertificateProperty#getCertificateChain}
             * @param certificateChain The certificate chain for the certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateChain(java.lang.String certificateChain) {
                this.certificateChain = certificateChain;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsFileCertificateProperty#getPrivateKey}
             * @param privateKey The private key for a certificate stored on the file system of the mesh endpoint that the proxy is running on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKey(java.lang.String privateKey) {
                this.privateKey = privateKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerTlsFileCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerTlsFileCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerTlsFileCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerTlsFileCertificateProperty {
            private final java.lang.String certificateChain;
            private final java.lang.String privateKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateChain = software.amazon.jsii.Kernel.get(this, "certificateChain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateKey = software.amazon.jsii.Kernel.get(this, "privateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateChain = java.util.Objects.requireNonNull(builder.certificateChain, "certificateChain is required");
                this.privateKey = java.util.Objects.requireNonNull(builder.privateKey, "privateKey is required");
            }

            @Override
            public final java.lang.String getCertificateChain() {
                return this.certificateChain;
            }

            @Override
            public final java.lang.String getPrivateKey() {
                return this.privateKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateChain", om.valueToTree(this.getCertificateChain()));
                data.set("privateKey", om.valueToTree(this.getPrivateKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsFileCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerTlsFileCertificateProperty.Jsii$Proxy that = (VirtualGatewayListenerTlsFileCertificateProperty.Jsii$Proxy) o;

                if (!certificateChain.equals(that.certificateChain)) return false;
                return this.privateKey.equals(that.privateKey);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateChain.hashCode();
                result = 31 * result + (this.privateKey.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the Transport Layer Security (TLS) properties for a listener.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerTlsProperty virtualGatewayListenerTlsProperty = VirtualGatewayListenerTlsProperty.builder()
     *         .certificate(VirtualGatewayListenerTlsCertificateProperty.builder()
     *                 .acm(VirtualGatewayListenerTlsAcmCertificateProperty.builder()
     *                         .certificateArn("certificateArn")
     *                         .build())
     *                 .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .privateKey("privateKey")
     *                         .build())
     *                 .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         .mode("mode")
     *         // the properties below are optional
     *         .validation(VirtualGatewayListenerTlsValidationContextProperty.builder()
     *                 .trust(VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
     *                         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                                 .certificateChain("certificateChain")
     *                                 .build())
     *                         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                                 .secretName("secretName")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                 .exact(List.of("exact"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerTlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerTlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a Transport Layer Security (TLS) certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-certificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-certificate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCertificate();

        /**
         * Specify one of the following modes.
         * <p>
         * <ul>
         * <li>** STRICT – Listener only accepts connections with TLS enabled.</li>
         * <li>** PERMISSIVE – Listener accepts connections with or without TLS enabled.</li>
         * <li>** DISABLED – Listener only accepts connections without TLS.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation context.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-validation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertls.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertls-validation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerTlsProperty> {
            java.lang.Object certificate;
            java.lang.String mode;
            java.lang.Object validation;

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsProperty#getCertificate}
             * @param certificate An object that represents a Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.IResolvable certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsProperty#getCertificate}
             * @param certificate An object that represents a Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsCertificateProperty certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsProperty#getMode}
             * @param mode Specify one of the following modes. This parameter is required.
             *             <ul>
             *             <li>** STRICT – Listener only accepts connections with TLS enabled.</li>
             *             <li>** PERMISSIVE – Listener accepts connections with or without TLS enabled.</li>
             *             <li>** DISABLED – Listener only accepts connections without TLS.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsProperty#getValidation}
             * @param validation A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.IResolvable validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsProperty#getValidation}
             * @param validation A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validation(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextProperty validation) {
                this.validation = validation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerTlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerTlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerTlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerTlsProperty {
            private final java.lang.Object certificate;
            private final java.lang.String mode;
            private final java.lang.Object validation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificate = java.util.Objects.requireNonNull(builder.certificate, "certificate is required");
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.validation = builder.validation;
            }

            @Override
            public final java.lang.Object getCertificate() {
                return this.certificate;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Object getValidation() {
                return this.validation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificate", om.valueToTree(this.getCertificate()));
                data.set("mode", om.valueToTree(this.getMode()));
                if (this.getValidation() != null) {
                    data.set("validation", om.valueToTree(this.getValidation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerTlsProperty.Jsii$Proxy that = (VirtualGatewayListenerTlsProperty.Jsii$Proxy) o;

                if (!certificate.equals(that.certificate)) return false;
                if (!mode.equals(that.mode)) return false;
                return this.validation != null ? this.validation.equals(that.validation) : that.validation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificate.hashCode();
                result = 31 * result + (this.mode.hashCode());
                result = 31 * result + (this.validation != null ? this.validation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the virtual gateway's listener's Secret Discovery Service certificate.The proxy must be configured with a local SDS provider via a Unix Domain Socket. See App Mesh <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS documentation</a> for more info.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerTlsSdsCertificateProperty virtualGatewayListenerTlsSdsCertificateProperty = VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *         .secretName("secretName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsSdsCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerTlsSdsCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerTlsSdsCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents the name of the secret secret requested from the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or certificate chain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate-secretname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlssdscertificate-secretname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretName();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerTlsSdsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerTlsSdsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerTlsSdsCertificateProperty> {
            java.lang.String secretName;

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsSdsCertificateProperty#getSecretName}
             * @param secretName A reference to an object that represents the name of the secret secret requested from the Secret Discovery Service provider representing Transport Layer Security (TLS) materials like a certificate or certificate chain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretName(java.lang.String secretName) {
                this.secretName = secretName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerTlsSdsCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerTlsSdsCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerTlsSdsCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerTlsSdsCertificateProperty {
            private final java.lang.String secretName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretName = java.util.Objects.requireNonNull(builder.secretName, "secretName is required");
            }

            @Override
            public final java.lang.String getSecretName() {
                return this.secretName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretName", om.valueToTree(this.getSecretName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsSdsCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerTlsSdsCertificateProperty.Jsii$Proxy that = (VirtualGatewayListenerTlsSdsCertificateProperty.Jsii$Proxy) o;

                return this.secretName.equals(that.secretName);
            }

            @Override
            public final int hashCode() {
                int result = this.secretName.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation context.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerTlsValidationContextProperty virtualGatewayListenerTlsValidationContextProperty = VirtualGatewayListenerTlsValidationContextProperty.builder()
     *         .trust(VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
     *                 .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .build())
     *                 .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                         .exact(List.of("exact"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerTlsValidationContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerTlsValidationContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext-trust">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext-trust</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrust();

        /**
         * A reference to an object that represents the SANs for a virtual gateway listener's Transport Layer Security (TLS) validation context.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext-subjectalternativenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontext-subjectalternativenames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubjectAlternativeNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerTlsValidationContextProperty> {
            java.lang.Object trust;
            java.lang.Object subjectAlternativeNames;

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.IResolvable trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextTrustProperty trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a virtual gateway listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.IResolvable subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a virtual gateway listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.SubjectAlternativeNamesProperty subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerTlsValidationContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerTlsValidationContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerTlsValidationContextProperty {
            private final java.lang.Object trust;
            private final java.lang.Object subjectAlternativeNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trust = software.amazon.jsii.Kernel.get(this, "trust", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trust = java.util.Objects.requireNonNull(builder.trust, "trust is required");
                this.subjectAlternativeNames = builder.subjectAlternativeNames;
            }

            @Override
            public final java.lang.Object getTrust() {
                return this.trust;
            }

            @Override
            public final java.lang.Object getSubjectAlternativeNames() {
                return this.subjectAlternativeNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("trust", om.valueToTree(this.getTrust()));
                if (this.getSubjectAlternativeNames() != null) {
                    data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerTlsValidationContextProperty.Jsii$Proxy that = (VirtualGatewayListenerTlsValidationContextProperty.Jsii$Proxy) o;

                if (!trust.equals(that.trust)) return false;
                return this.subjectAlternativeNames != null ? this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.trust.hashCode();
                result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation context trust.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayListenerTlsValidationContextTrustProperty virtualGatewayListenerTlsValidationContextTrustProperty = VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
     *         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .build())
     *         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayListenerTlsValidationContextTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayListenerTlsValidationContextTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust-file">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust-file</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust-sds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaylistenertlsvalidationcontexttrust-sds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayListenerTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayListenerTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayListenerTlsValidationContextTrustProperty> {
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayListenerTlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextSdsTrustProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayListenerTlsValidationContextTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayListenerTlsValidationContextTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayListenerTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayListenerTlsValidationContextTrustProperty {
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayListenerTlsValidationContextTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayListenerTlsValidationContextTrustProperty.Jsii$Proxy that = (VirtualGatewayListenerTlsValidationContextTrustProperty.Jsii$Proxy) o;

                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.file != null ? this.file.hashCode() : 0;
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents logging information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayLoggingProperty virtualGatewayLoggingProperty = VirtualGatewayLoggingProperty.builder()
     *         .accessLog(VirtualGatewayAccessLogProperty.builder()
     *                 .file(VirtualGatewayFileAccessLogProperty.builder()
     *                         .path("path")
     *                         // the properties below are optional
     *                         .format(LoggingFormatProperty.builder()
     *                                 .json(List.of(JsonFormatRefProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .text("text")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayLoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayLoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayLoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The access log configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html#cfn-appmesh-virtualgateway-virtualgatewaylogging-accesslog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaylogging.html#cfn-appmesh-virtualgateway-virtualgatewaylogging-accesslog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLog() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayLoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayLoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayLoggingProperty> {
            java.lang.Object accessLog;

            /**
             * Sets the value of {@link VirtualGatewayLoggingProperty#getAccessLog}
             * @param accessLog The access log configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLog(software.amazon.awscdk.IResolvable accessLog) {
                this.accessLog = accessLog;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayLoggingProperty#getAccessLog}
             * @param accessLog The access log configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessLog(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayAccessLogProperty accessLog) {
                this.accessLog = accessLog;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayLoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayLoggingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayLoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayLoggingProperty {
            private final java.lang.Object accessLog;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessLog = software.amazon.jsii.Kernel.get(this, "accessLog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessLog = builder.accessLog;
            }

            @Override
            public final java.lang.Object getAccessLog() {
                return this.accessLog;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessLog() != null) {
                    data.set("accessLog", om.valueToTree(this.getAccessLog()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayLoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayLoggingProperty.Jsii$Proxy that = (VirtualGatewayLoggingProperty.Jsii$Proxy) o;

                return this.accessLog != null ? this.accessLog.equals(that.accessLog) : that.accessLog == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessLog != null ? this.accessLog.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a port mapping.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayPortMappingProperty virtualGatewayPortMappingProperty = VirtualGatewayPortMappingProperty.builder()
     *         .port(123)
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayPortMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayPortMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayPortMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port used for the port mapping.
         * <p>
         * Specify one protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The protocol used for the port mapping.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayportmapping.html#cfn-appmesh-virtualgateway-virtualgatewayportmapping-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayPortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayPortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayPortMappingProperty> {
            java.lang.Number port;
            java.lang.String protocol;

            /**
             * Sets the value of {@link VirtualGatewayPortMappingProperty#getPort}
             * @param port The port used for the port mapping. This parameter is required.
             *             Specify one protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayPortMappingProperty#getProtocol}
             * @param protocol The protocol used for the port mapping. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayPortMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayPortMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayPortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayPortMappingProperty {
            private final java.lang.Number port;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayPortMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayPortMappingProperty.Jsii$Proxy that = (VirtualGatewayPortMappingProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                return this.protocol.equals(that.protocol);
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.protocol.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the specification of a service mesh resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewaySpecProperty virtualGatewaySpecProperty = VirtualGatewaySpecProperty.builder()
     *         .listeners(List.of(VirtualGatewayListenerProperty.builder()
     *                 .portMapping(VirtualGatewayPortMappingProperty.builder()
     *                         .port(123)
     *                         .protocol("protocol")
     *                         .build())
     *                 // the properties below are optional
     *                 .connectionPool(VirtualGatewayConnectionPoolProperty.builder()
     *                         .grpc(VirtualGatewayGrpcConnectionPoolProperty.builder()
     *                                 .maxRequests(123)
     *                                 .build())
     *                         .http(VirtualGatewayHttpConnectionPoolProperty.builder()
     *                                 .maxConnections(123)
     *                                 // the properties below are optional
     *                                 .maxPendingRequests(123)
     *                                 .build())
     *                         .http2(VirtualGatewayHttp2ConnectionPoolProperty.builder()
     *                                 .maxRequests(123)
     *                                 .build())
     *                         .build())
     *                 .healthCheck(VirtualGatewayHealthCheckPolicyProperty.builder()
     *                         .healthyThreshold(123)
     *                         .intervalMillis(123)
     *                         .protocol("protocol")
     *                         .timeoutMillis(123)
     *                         .unhealthyThreshold(123)
     *                         // the properties below are optional
     *                         .path("path")
     *                         .port(123)
     *                         .build())
     *                 .tls(VirtualGatewayListenerTlsProperty.builder()
     *                         .certificate(VirtualGatewayListenerTlsCertificateProperty.builder()
     *                                 .acm(VirtualGatewayListenerTlsAcmCertificateProperty.builder()
     *                                         .certificateArn("certificateArn")
     *                                         .build())
     *                                 .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                                         .certificateChain("certificateChain")
     *                                         .privateKey("privateKey")
     *                                         .build())
     *                                 .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                                         .secretName("secretName")
     *                                         .build())
     *                                 .build())
     *                         .mode("mode")
     *                         // the properties below are optional
     *                         .validation(VirtualGatewayListenerTlsValidationContextProperty.builder()
     *                                 .trust(VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
     *                                         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .build())
     *                                         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                         .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                 .exact(List.of("exact"))
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .backendDefaults(VirtualGatewayBackendDefaultsProperty.builder()
     *                 .clientPolicy(VirtualGatewayClientPolicyProperty.builder()
     *                         .tls(VirtualGatewayClientPolicyTlsProperty.builder()
     *                                 .validation(VirtualGatewayTlsValidationContextProperty.builder()
     *                                         .trust(VirtualGatewayTlsValidationContextTrustProperty.builder()
     *                                                 .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
     *                                                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                                                         .build())
     *                                                 .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                                                         .certificateChain("certificateChain")
     *                                                         .build())
     *                                                 .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                                                         .secretName("secretName")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                                                         .exact(List.of("exact"))
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .certificate(VirtualGatewayClientTlsCertificateProperty.builder()
     *                                         .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
     *                                                 .certificateChain("certificateChain")
     *                                                 .privateKey("privateKey")
     *                                                 .build())
     *                                         .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
     *                                                 .secretName("secretName")
     *                                                 .build())
     *                                         .build())
     *                                 .enforce(false)
     *                                 .ports(List.of(123))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .logging(VirtualGatewayLoggingProperty.builder()
     *                 .accessLog(VirtualGatewayAccessLogProperty.builder()
     *                         .file(VirtualGatewayFileAccessLogProperty.builder()
     *                                 .path("path")
     *                                 // the properties below are optional
     *                                 .format(LoggingFormatProperty.builder()
     *                                         .json(List.of(JsonFormatRefProperty.builder()
     *                                                 .key("key")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .text("text")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewaySpecProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewaySpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewaySpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The listeners that the mesh endpoint is expected to receive inbound traffic from.
         * <p>
         * You can specify one listener.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-listeners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-listeners</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getListeners();

        /**
         * A reference to an object that represents the defaults for backends.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-backenddefaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-backenddefaults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBackendDefaults() {
            return null;
        }

        /**
         * An object that represents logging information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewayspec.html#cfn-appmesh-virtualgateway-virtualgatewayspec-logging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewaySpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewaySpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewaySpecProperty> {
            java.lang.Object listeners;
            java.lang.Object backendDefaults;
            java.lang.Object logging;

            /**
             * Sets the value of {@link VirtualGatewaySpecProperty#getListeners}
             * @param listeners The listeners that the mesh endpoint is expected to receive inbound traffic from. This parameter is required.
             *                  You can specify one listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listeners(software.amazon.awscdk.IResolvable listeners) {
                this.listeners = listeners;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewaySpecProperty#getListeners}
             * @param listeners The listeners that the mesh endpoint is expected to receive inbound traffic from. This parameter is required.
             *                  You can specify one listener.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listeners(java.util.List<? extends java.lang.Object> listeners) {
                this.listeners = listeners;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewaySpecProperty#getBackendDefaults}
             * @param backendDefaults A reference to an object that represents the defaults for backends.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backendDefaults(software.amazon.awscdk.IResolvable backendDefaults) {
                this.backendDefaults = backendDefaults;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewaySpecProperty#getBackendDefaults}
             * @param backendDefaults A reference to an object that represents the defaults for backends.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backendDefaults(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayBackendDefaultsProperty backendDefaults) {
                this.backendDefaults = backendDefaults;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewaySpecProperty#getLogging}
             * @param logging An object that represents logging information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.IResolvable logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewaySpecProperty#getLogging}
             * @param logging An object that represents logging information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayLoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewaySpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewaySpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewaySpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewaySpecProperty {
            private final java.lang.Object listeners;
            private final java.lang.Object backendDefaults;
            private final java.lang.Object logging;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.listeners = software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.backendDefaults = software.amazon.jsii.Kernel.get(this, "backendDefaults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.listeners = java.util.Objects.requireNonNull(builder.listeners, "listeners is required");
                this.backendDefaults = builder.backendDefaults;
                this.logging = builder.logging;
            }

            @Override
            public final java.lang.Object getListeners() {
                return this.listeners;
            }

            @Override
            public final java.lang.Object getBackendDefaults() {
                return this.backendDefaults;
            }

            @Override
            public final java.lang.Object getLogging() {
                return this.logging;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("listeners", om.valueToTree(this.getListeners()));
                if (this.getBackendDefaults() != null) {
                    data.set("backendDefaults", om.valueToTree(this.getBackendDefaults()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewaySpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewaySpecProperty.Jsii$Proxy that = (VirtualGatewaySpecProperty.Jsii$Proxy) o;

                if (!listeners.equals(that.listeners)) return false;
                if (this.backendDefaults != null ? !this.backendDefaults.equals(that.backendDefaults) : that.backendDefaults != null) return false;
                return this.logging != null ? this.logging.equals(that.logging) : that.logging == null;
            }

            @Override
            public final int hashCode() {
                int result = this.listeners.hashCode();
                result = 31 * result + (this.backendDefaults != null ? this.backendDefaults.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayTlsValidationContextAcmTrustProperty virtualGatewayTlsValidationContextAcmTrustProperty = VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
     *         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextAcmTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayTlsValidationContextAcmTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayTlsValidationContextAcmTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more ACM Amazon Resource Name (ARN)s.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust-certificateauthorityarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextacmtrust-certificateauthorityarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCertificateAuthorityArns();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayTlsValidationContextAcmTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayTlsValidationContextAcmTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayTlsValidationContextAcmTrustProperty> {
            java.util.List<java.lang.String> certificateAuthorityArns;

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextAcmTrustProperty#getCertificateAuthorityArns}
             * @param certificateAuthorityArns One or more ACM Amazon Resource Name (ARN)s. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateAuthorityArns(java.util.List<java.lang.String> certificateAuthorityArns) {
                this.certificateAuthorityArns = certificateAuthorityArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayTlsValidationContextAcmTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayTlsValidationContextAcmTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayTlsValidationContextAcmTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayTlsValidationContextAcmTrustProperty {
            private final java.util.List<java.lang.String> certificateAuthorityArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateAuthorityArns = software.amazon.jsii.Kernel.get(this, "certificateAuthorityArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateAuthorityArns = java.util.Objects.requireNonNull(builder.certificateAuthorityArns, "certificateAuthorityArns is required");
            }

            @Override
            public final java.util.List<java.lang.String> getCertificateAuthorityArns() {
                return this.certificateAuthorityArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateAuthorityArns", om.valueToTree(this.getCertificateAuthorityArns()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextAcmTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayTlsValidationContextAcmTrustProperty.Jsii$Proxy that = (VirtualGatewayTlsValidationContextAcmTrustProperty.Jsii$Proxy) o;

                return this.certificateAuthorityArns.equals(that.certificateAuthorityArns);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateAuthorityArns.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayTlsValidationContextFileTrustProperty virtualGatewayTlsValidationContextFileTrustProperty = VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *         .certificateChain("certificateChain")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayTlsValidationContextFileTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayTlsValidationContextFileTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is running on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust-certificatechain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextfiletrust-certificatechain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateChain();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayTlsValidationContextFileTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayTlsValidationContextFileTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayTlsValidationContextFileTrustProperty> {
            java.lang.String certificateChain;

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextFileTrustProperty#getCertificateChain}
             * @param certificateChain The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is running on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateChain(java.lang.String certificateChain) {
                this.certificateChain = certificateChain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayTlsValidationContextFileTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayTlsValidationContextFileTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayTlsValidationContextFileTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayTlsValidationContextFileTrustProperty {
            private final java.lang.String certificateChain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateChain = software.amazon.jsii.Kernel.get(this, "certificateChain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateChain = java.util.Objects.requireNonNull(builder.certificateChain, "certificateChain is required");
            }

            @Override
            public final java.lang.String getCertificateChain() {
                return this.certificateChain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateChain", om.valueToTree(this.getCertificateChain()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayTlsValidationContextFileTrustProperty.Jsii$Proxy that = (VirtualGatewayTlsValidationContextFileTrustProperty.Jsii$Proxy) o;

                return this.certificateChain.equals(that.certificateChain);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateChain.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) validation context.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayTlsValidationContextProperty virtualGatewayTlsValidationContextProperty = VirtualGatewayTlsValidationContextProperty.builder()
     *         .trust(VirtualGatewayTlsValidationContextTrustProperty.builder()
     *                 .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
     *                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                         .build())
     *                 .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                         .certificateChain("certificateChain")
     *                         .build())
     *                 .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                         .secretName("secretName")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
     *                 .match(SubjectAlternativeNameMatchersProperty.builder()
     *                         .exact(List.of("exact"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayTlsValidationContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayTlsValidationContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext-trust">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext-trust</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrust();

        /**
         * A reference to an object that represents the SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext-subjectalternativenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontext-subjectalternativenames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubjectAlternativeNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayTlsValidationContextProperty> {
            java.lang.Object trust;
            java.lang.Object subjectAlternativeNames;

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.IResolvable trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextProperty#getTrust}
             * @param trust A reference to where to retrieve the trust chain when validating a peer’s Transport Layer Security (TLS) certificate. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trust(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty trust) {
                this.trust = trust;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.IResolvable subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames A reference to an object that represents the SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.SubjectAlternativeNamesProperty subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayTlsValidationContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayTlsValidationContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayTlsValidationContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayTlsValidationContextProperty {
            private final java.lang.Object trust;
            private final java.lang.Object subjectAlternativeNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trust = software.amazon.jsii.Kernel.get(this, "trust", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trust = java.util.Objects.requireNonNull(builder.trust, "trust is required");
                this.subjectAlternativeNames = builder.subjectAlternativeNames;
            }

            @Override
            public final java.lang.Object getTrust() {
                return this.trust;
            }

            @Override
            public final java.lang.Object getSubjectAlternativeNames() {
                return this.subjectAlternativeNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("trust", om.valueToTree(this.getTrust()));
                if (this.getSubjectAlternativeNames() != null) {
                    data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayTlsValidationContextProperty.Jsii$Proxy that = (VirtualGatewayTlsValidationContextProperty.Jsii$Proxy) o;

                if (!trust.equals(that.trust)) return false;
                return this.subjectAlternativeNames != null ? this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.trust.hashCode();
                result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
     * <p>
     * The proxy must be configured with a local SDS provider via a Unix Domain Socket. See App Mesh <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html">TLS documentation</a> for more info.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayTlsValidationContextSdsTrustProperty virtualGatewayTlsValidationContextSdsTrustProperty = VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *         .secretName("secretName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextSdsTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayTlsValidationContextSdsTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayTlsValidationContextSdsTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents the name of the secret for a virtual gateway's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust-secretname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontextsdstrust-secretname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretName();

        /**
         * @return a {@link Builder} of {@link VirtualGatewayTlsValidationContextSdsTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayTlsValidationContextSdsTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayTlsValidationContextSdsTrustProperty> {
            java.lang.String secretName;

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextSdsTrustProperty#getSecretName}
             * @param secretName A reference to an object that represents the name of the secret for a virtual gateway's Transport Layer Security (TLS) Secret Discovery Service validation context trust. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretName(java.lang.String secretName) {
                this.secretName = secretName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayTlsValidationContextSdsTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayTlsValidationContextSdsTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayTlsValidationContextSdsTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayTlsValidationContextSdsTrustProperty {
            private final java.lang.String secretName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretName = java.util.Objects.requireNonNull(builder.secretName, "secretName is required");
            }

            @Override
            public final java.lang.String getSecretName() {
                return this.secretName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretName", om.valueToTree(this.getSecretName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextSdsTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayTlsValidationContextSdsTrustProperty.Jsii$Proxy that = (VirtualGatewayTlsValidationContextSdsTrustProperty.Jsii$Proxy) o;

                return this.secretName.equals(that.secretName);
            }

            @Override
            public final int hashCode() {
                int result = this.secretName.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents a Transport Layer Security (TLS) validation context trust.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * VirtualGatewayTlsValidationContextTrustProperty virtualGatewayTlsValidationContextTrustProperty = VirtualGatewayTlsValidationContextTrustProperty.builder()
     *         .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
     *                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
     *                 .build())
     *         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
     *                 .certificateChain("certificateChain")
     *                 .build())
     *         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
     *                 .secretName("secretName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty")
    @software.amazon.jsii.Jsii.Proxy(VirtualGatewayTlsValidationContextTrustProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VirtualGatewayTlsValidationContextTrustProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-acm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-acm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcm() {
            return null;
        }

        /**
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-file">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-file</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFile() {
            return null;
        }

        /**
         * A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-sds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust.html#cfn-appmesh-virtualgateway-virtualgatewaytlsvalidationcontexttrust-sds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VirtualGatewayTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VirtualGatewayTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VirtualGatewayTlsValidationContextTrustProperty> {
            java.lang.Object acm;
            java.lang.Object file;
            java.lang.Object sds;

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextTrustProperty#getAcm}
             * @param acm A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.IResolvable acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextTrustProperty#getAcm}
             * @param acm A reference to an object that represents a Transport Layer Security (TLS) validation context trust for an AWS Certificate Manager certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acm(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextAcmTrustProperty acm) {
                this.acm = acm;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextTrustProperty#getFile}
             * @param file An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextFileTrustProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.IResolvable sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Sets the value of {@link VirtualGatewayTlsValidationContextTrustProperty#getSds}
             * @param sds A reference to an object that represents a virtual gateway's Transport Layer Security (TLS) Secret Discovery Service validation context trust.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sds(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextSdsTrustProperty sds) {
                this.sds = sds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VirtualGatewayTlsValidationContextTrustProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VirtualGatewayTlsValidationContextTrustProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VirtualGatewayTlsValidationContextTrustProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualGatewayTlsValidationContextTrustProperty {
            private final java.lang.Object acm;
            private final java.lang.Object file;
            private final java.lang.Object sds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acm = software.amazon.jsii.Kernel.get(this, "acm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sds = software.amazon.jsii.Kernel.get(this, "sds", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acm = builder.acm;
                this.file = builder.file;
                this.sds = builder.sds;
            }

            @Override
            public final java.lang.Object getAcm() {
                return this.acm;
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            public final java.lang.Object getSds() {
                return this.sds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcm() != null) {
                    data.set("acm", om.valueToTree(this.getAcm()));
                }
                if (this.getFile() != null) {
                    data.set("file", om.valueToTree(this.getFile()));
                }
                if (this.getSds() != null) {
                    data.set("sds", om.valueToTree(this.getSds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGateway.VirtualGatewayTlsValidationContextTrustProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VirtualGatewayTlsValidationContextTrustProperty.Jsii$Proxy that = (VirtualGatewayTlsValidationContextTrustProperty.Jsii$Proxy) o;

                if (this.acm != null ? !this.acm.equals(that.acm) : that.acm != null) return false;
                if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
                return this.sds != null ? this.sds.equals(that.sds) : that.sds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acm != null ? this.acm.hashCode() : 0;
                result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
                result = 31 * result + (this.sds != null ? this.sds.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.CfnVirtualGateway}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.CfnVirtualGateway> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.CfnVirtualGatewayProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.CfnVirtualGatewayProps.Builder();
        }

        /**
         * The name of the service mesh that the virtual gateway resides in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshname</a>
         * @param meshName The name of the service mesh that the virtual gateway resides in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(final java.lang.String meshName) {
            this.props.meshName(meshName);
            return this;
        }

        /**
         * The specifications of the virtual gateway.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec</a>
         * @param spec The specifications of the virtual gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.IResolvable spec) {
            this.props.spec(spec);
            return this;
        }
        /**
         * The specifications of the virtual gateway.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-spec</a>
         * @param spec The specifications of the virtual gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewaySpecProperty spec) {
            this.props.spec(spec);
            return this;
        }

        /**
         * The AWS IAM account ID of the service mesh owner.
         * <p>
         * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-meshowner</a>
         * @param meshOwner The AWS IAM account ID of the service mesh owner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(final java.lang.String meshOwner) {
            this.props.meshOwner(meshOwner);
            return this;
        }

        /**
         * Optional metadata that you can apply to the virtual gateway to assist with categorization and organization.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-tags</a>
         * @param tags Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The name of the virtual gateway.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-virtualgatewayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualgateway.html#cfn-appmesh-virtualgateway-virtualgatewayname</a>
         * @param virtualGatewayName The name of the virtual gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayName(final java.lang.String virtualGatewayName) {
            this.props.virtualGatewayName(virtualGatewayName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appmesh.CfnVirtualGateway}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.CfnVirtualGateway build() {
            return new software.amazon.awscdk.services.appmesh.CfnVirtualGateway(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
