package software.amazon.awscdk.services.appmesh;

/**
 * All Properties for Route Specs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * RouteSpecConfig routeSpecConfig = RouteSpecConfig.builder()
 *         .grpcRouteSpec(GrpcRouteProperty.builder()
 *                 .action(GrpcRouteActionProperty.builder()
 *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                 .virtualNode("virtualNode")
 *                                 .weight(123)
 *                                 // the properties below are optional
 *                                 .port(123)
 *                                 .build()))
 *                         .build())
 *                 .match(GrpcRouteMatchProperty.builder()
 *                         .metadata(List.of(GrpcRouteMetadataProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .invert(false)
 *                                 .match(GrpcRouteMetadataMatchMethodProperty.builder()
 *                                         .exact("exact")
 *                                         .prefix("prefix")
 *                                         .range(MatchRangeProperty.builder()
 *                                                 .end(123)
 *                                                 .start(123)
 *                                                 .build())
 *                                         .regex("regex")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .build()))
 *                         .methodName("methodName")
 *                         .port(123)
 *                         .serviceName("serviceName")
 *                         .build())
 *                 // the properties below are optional
 *                 .retryPolicy(GrpcRetryPolicyProperty.builder()
 *                         .maxRetries(123)
 *                         .perRetryTimeout(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .grpcRetryEvents(List.of("grpcRetryEvents"))
 *                         .httpRetryEvents(List.of("httpRetryEvents"))
 *                         .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                         .build())
 *                 .timeout(GrpcTimeoutProperty.builder()
 *                         .idle(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .perRequest(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .http2RouteSpec(HttpRouteProperty.builder()
 *                 .action(HttpRouteActionProperty.builder()
 *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                 .virtualNode("virtualNode")
 *                                 .weight(123)
 *                                 // the properties below are optional
 *                                 .port(123)
 *                                 .build()))
 *                         .build())
 *                 .match(HttpRouteMatchProperty.builder()
 *                         .headers(List.of(HttpRouteHeaderProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .invert(false)
 *                                 .match(HeaderMatchMethodProperty.builder()
 *                                         .exact("exact")
 *                                         .prefix("prefix")
 *                                         .range(MatchRangeProperty.builder()
 *                                                 .end(123)
 *                                                 .start(123)
 *                                                 .build())
 *                                         .regex("regex")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .build()))
 *                         .method("method")
 *                         .path(HttpPathMatchProperty.builder()
 *                                 .exact("exact")
 *                                 .regex("regex")
 *                                 .build())
 *                         .port(123)
 *                         .prefix("prefix")
 *                         .queryParameters(List.of(QueryParameterProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .match(HttpQueryParameterMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .build())
 *                                 .build()))
 *                         .scheme("scheme")
 *                         .build())
 *                 // the properties below are optional
 *                 .retryPolicy(HttpRetryPolicyProperty.builder()
 *                         .maxRetries(123)
 *                         .perRetryTimeout(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .httpRetryEvents(List.of("httpRetryEvents"))
 *                         .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                         .build())
 *                 .timeout(HttpTimeoutProperty.builder()
 *                         .idle(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .perRequest(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .httpRouteSpec(HttpRouteProperty.builder()
 *                 .action(HttpRouteActionProperty.builder()
 *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                 .virtualNode("virtualNode")
 *                                 .weight(123)
 *                                 // the properties below are optional
 *                                 .port(123)
 *                                 .build()))
 *                         .build())
 *                 .match(HttpRouteMatchProperty.builder()
 *                         .headers(List.of(HttpRouteHeaderProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .invert(false)
 *                                 .match(HeaderMatchMethodProperty.builder()
 *                                         .exact("exact")
 *                                         .prefix("prefix")
 *                                         .range(MatchRangeProperty.builder()
 *                                                 .end(123)
 *                                                 .start(123)
 *                                                 .build())
 *                                         .regex("regex")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .build()))
 *                         .method("method")
 *                         .path(HttpPathMatchProperty.builder()
 *                                 .exact("exact")
 *                                 .regex("regex")
 *                                 .build())
 *                         .port(123)
 *                         .prefix("prefix")
 *                         .queryParameters(List.of(QueryParameterProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .match(HttpQueryParameterMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .build())
 *                                 .build()))
 *                         .scheme("scheme")
 *                         .build())
 *                 // the properties below are optional
 *                 .retryPolicy(HttpRetryPolicyProperty.builder()
 *                         .maxRetries(123)
 *                         .perRetryTimeout(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .httpRetryEvents(List.of("httpRetryEvents"))
 *                         .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                         .build())
 *                 .timeout(HttpTimeoutProperty.builder()
 *                         .idle(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .perRequest(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .priority(123)
 *         .tcpRouteSpec(TcpRouteProperty.builder()
 *                 .action(TcpRouteActionProperty.builder()
 *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                 .virtualNode("virtualNode")
 *                                 .weight(123)
 *                                 // the properties below are optional
 *                                 .port(123)
 *                                 .build()))
 *                         .build())
 *                 // the properties below are optional
 *                 .match(TcpRouteMatchProperty.builder()
 *                         .port(123)
 *                         .build())
 *                 .timeout(TcpTimeoutProperty.builder()
 *                         .idle(DurationProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.888Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.RouteSpecConfig")
@software.amazon.jsii.Jsii.Proxy(RouteSpecConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteSpecConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The spec for a grpc route.
     * <p>
     * Default: - no grpc spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteProperty getGrpcRouteSpec() {
        return null;
    }

    /**
     * The spec for an http2 route.
     * <p>
     * Default: - no http2 spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty getHttp2RouteSpec() {
        return null;
    }

    /**
     * The spec for an http route.
     * <p>
     * Default: - no http spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty getHttpRouteSpec() {
        return null;
    }

    /**
     * The priority for the route.
     * <p>
     * When a Virtual Router has multiple routes, route match is performed in the
     * order of specified value, where 0 is the highest priority, and first matched route is selected.
     * <p>
     * Default: - no particular priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * The spec for a tcp route.
     * <p>
     * Default: - no tcp spec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteProperty getTcpRouteSpec() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RouteSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteSpecConfig> {
        software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteProperty grpcRouteSpec;
        software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty http2RouteSpec;
        software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty httpRouteSpec;
        java.lang.Number priority;
        software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteProperty tcpRouteSpec;

        /**
         * Sets the value of {@link RouteSpecConfig#getGrpcRouteSpec}
         * @param grpcRouteSpec The spec for a grpc route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grpcRouteSpec(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteProperty grpcRouteSpec) {
            this.grpcRouteSpec = grpcRouteSpec;
            return this;
        }

        /**
         * Sets the value of {@link RouteSpecConfig#getHttp2RouteSpec}
         * @param http2RouteSpec The spec for an http2 route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder http2RouteSpec(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty http2RouteSpec) {
            this.http2RouteSpec = http2RouteSpec;
            return this;
        }

        /**
         * Sets the value of {@link RouteSpecConfig#getHttpRouteSpec}
         * @param httpRouteSpec The spec for an http route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpRouteSpec(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty httpRouteSpec) {
            this.httpRouteSpec = httpRouteSpec;
            return this;
        }

        /**
         * Sets the value of {@link RouteSpecConfig#getPriority}
         * @param priority The priority for the route.
         *                 When a Virtual Router has multiple routes, route match is performed in the
         *                 order of specified value, where 0 is the highest priority, and first matched route is selected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link RouteSpecConfig#getTcpRouteSpec}
         * @param tcpRouteSpec The spec for a tcp route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tcpRouteSpec(software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteProperty tcpRouteSpec) {
            this.tcpRouteSpec = tcpRouteSpec;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteSpecConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteSpecConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteSpecConfig {
        private final software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteProperty grpcRouteSpec;
        private final software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty http2RouteSpec;
        private final software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty httpRouteSpec;
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteProperty tcpRouteSpec;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.grpcRouteSpec = software.amazon.jsii.Kernel.get(this, "grpcRouteSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteProperty.class));
            this.http2RouteSpec = software.amazon.jsii.Kernel.get(this, "http2RouteSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty.class));
            this.httpRouteSpec = software.amazon.jsii.Kernel.get(this, "httpRouteSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tcpRouteSpec = software.amazon.jsii.Kernel.get(this, "tcpRouteSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.grpcRouteSpec = builder.grpcRouteSpec;
            this.http2RouteSpec = builder.http2RouteSpec;
            this.httpRouteSpec = builder.httpRouteSpec;
            this.priority = builder.priority;
            this.tcpRouteSpec = builder.tcpRouteSpec;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteProperty getGrpcRouteSpec() {
            return this.grpcRouteSpec;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty getHttp2RouteSpec() {
            return this.http2RouteSpec;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty getHttpRouteSpec() {
            return this.httpRouteSpec;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteProperty getTcpRouteSpec() {
            return this.tcpRouteSpec;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGrpcRouteSpec() != null) {
                data.set("grpcRouteSpec", om.valueToTree(this.getGrpcRouteSpec()));
            }
            if (this.getHttp2RouteSpec() != null) {
                data.set("http2RouteSpec", om.valueToTree(this.getHttp2RouteSpec()));
            }
            if (this.getHttpRouteSpec() != null) {
                data.set("httpRouteSpec", om.valueToTree(this.getHttpRouteSpec()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getTcpRouteSpec() != null) {
                data.set("tcpRouteSpec", om.valueToTree(this.getTcpRouteSpec()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.RouteSpecConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteSpecConfig.Jsii$Proxy that = (RouteSpecConfig.Jsii$Proxy) o;

            if (this.grpcRouteSpec != null ? !this.grpcRouteSpec.equals(that.grpcRouteSpec) : that.grpcRouteSpec != null) return false;
            if (this.http2RouteSpec != null ? !this.http2RouteSpec.equals(that.http2RouteSpec) : that.http2RouteSpec != null) return false;
            if (this.httpRouteSpec != null ? !this.httpRouteSpec.equals(that.httpRouteSpec) : that.httpRouteSpec != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            return this.tcpRouteSpec != null ? this.tcpRouteSpec.equals(that.tcpRouteSpec) : that.tcpRouteSpec == null;
        }

        @Override
        public final int hashCode() {
            int result = this.grpcRouteSpec != null ? this.grpcRouteSpec.hashCode() : 0;
            result = 31 * result + (this.http2RouteSpec != null ? this.http2RouteSpec.hashCode() : 0);
            result = 31 * result + (this.httpRouteSpec != null ? this.httpRouteSpec.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.tcpRouteSpec != null ? this.tcpRouteSpec.hashCode() : 0);
            return result;
        }
    }
}
