package software.amazon.awscdk.services.appstream;

/**
 * Properties for defining a <code>CfnApplication</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appstream.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .appBlockArn("appBlockArn")
 *         .iconS3Location(S3LocationProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .build())
 *         .instanceFamilies(List.of("instanceFamilies"))
 *         .launchPath("launchPath")
 *         .name("name")
 *         .platforms(List.of("platforms"))
 *         // the properties below are optional
 *         .attributesToDelete(List.of("attributesToDelete"))
 *         .description("description")
 *         .displayName("displayName")
 *         .launchParameters("launchParameters")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:42.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The app block ARN with which the application should be associated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-appblockarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-appblockarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppBlockArn();

    /**
     * The icon S3 location of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-icons3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-icons3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIconS3Location();

    /**
     * The instance families the application supports.
     * <p>
     * <em>Allowed Values</em> : <code>GENERAL_PURPOSE</code> | <code>GRAPHICS_G4</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-instancefamilies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-instancefamilies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceFamilies();

    /**
     * The launch path of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-launchpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-launchpath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLaunchPath();

    /**
     * The name of the application.
     * <p>
     * This name is visible to users when a name is not specified in the DisplayName property.
     * <p>
     * <em>Pattern</em> : <code>^[a-zA-Z0-9][a-zA-Z0-9_.-]{0,100}$</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The platforms the application supports.
     * <p>
     * <em>Allowed Values</em> : <code>WINDOWS_SERVER_2019</code> | <code>AMAZON_LINUX2</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-platforms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-platforms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPlatforms();

    /**
     * A list of attributes to delete from an application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-attributestodelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-attributestodelete</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAttributesToDelete() {
        return null;
    }

    /**
     * The description of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The display name of the application.
     * <p>
     * This name is visible to users in the application catalog.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The launch parameters of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-launchparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-launchparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLaunchParameters() {
        return null;
    }

    /**
     * The tags of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The working directory of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-workingdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-application.html#cfn-appstream-application-workingdirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String appBlockArn;
        java.lang.Object iconS3Location;
        java.util.List<java.lang.String> instanceFamilies;
        java.lang.String launchPath;
        java.lang.String name;
        java.util.List<java.lang.String> platforms;
        java.util.List<java.lang.String> attributesToDelete;
        java.lang.String description;
        java.lang.String displayName;
        java.lang.String launchParameters;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link CfnApplicationProps#getAppBlockArn}
         * @param appBlockArn The app block ARN with which the application should be associated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appBlockArn(java.lang.String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getIconS3Location}
         * @param iconS3Location The icon S3 location of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iconS3Location(software.amazon.awscdk.IResolvable iconS3Location) {
            this.iconS3Location = iconS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getIconS3Location}
         * @param iconS3Location The icon S3 location of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iconS3Location(software.amazon.awscdk.services.appstream.CfnApplication.S3LocationProperty iconS3Location) {
            this.iconS3Location = iconS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getInstanceFamilies}
         * @param instanceFamilies The instance families the application supports. This parameter is required.
         *                         <em>Allowed Values</em> : <code>GENERAL_PURPOSE</code> | <code>GRAPHICS_G4</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceFamilies(java.util.List<java.lang.String> instanceFamilies) {
            this.instanceFamilies = instanceFamilies;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getLaunchPath}
         * @param launchPath The launch path of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchPath(java.lang.String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getName}
         * @param name The name of the application. This parameter is required.
         *             This name is visible to users when a name is not specified in the DisplayName property.
         *             <p>
         *             <em>Pattern</em> : <code>^[a-zA-Z0-9][a-zA-Z0-9_.-]{0,100}$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getPlatforms}
         * @param platforms The platforms the application supports. This parameter is required.
         *                  <em>Allowed Values</em> : <code>WINDOWS_SERVER_2019</code> | <code>AMAZON_LINUX2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platforms(java.util.List<java.lang.String> platforms) {
            this.platforms = platforms;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAttributesToDelete}
         * @param attributesToDelete A list of attributes to delete from an application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributesToDelete(java.util.List<java.lang.String> attributesToDelete) {
            this.attributesToDelete = attributesToDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getDescription}
         * @param description The description of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getDisplayName}
         * @param displayName The display name of the application.
         *                    This name is visible to users in the application catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getLaunchParameters}
         * @param launchParameters The launch parameters of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchParameters(java.lang.String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags The tags of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getWorkingDirectory}
         * @param workingDirectory The working directory of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String appBlockArn;
        private final java.lang.Object iconS3Location;
        private final java.util.List<java.lang.String> instanceFamilies;
        private final java.lang.String launchPath;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> platforms;
        private final java.util.List<java.lang.String> attributesToDelete;
        private final java.lang.String description;
        private final java.lang.String displayName;
        private final java.lang.String launchParameters;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appBlockArn = software.amazon.jsii.Kernel.get(this, "appBlockArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iconS3Location = software.amazon.jsii.Kernel.get(this, "iconS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceFamilies = software.amazon.jsii.Kernel.get(this, "instanceFamilies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.launchPath = software.amazon.jsii.Kernel.get(this, "launchPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.platforms = software.amazon.jsii.Kernel.get(this, "platforms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.attributesToDelete = software.amazon.jsii.Kernel.get(this, "attributesToDelete", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.launchParameters = software.amazon.jsii.Kernel.get(this, "launchParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appBlockArn = java.util.Objects.requireNonNull(builder.appBlockArn, "appBlockArn is required");
            this.iconS3Location = java.util.Objects.requireNonNull(builder.iconS3Location, "iconS3Location is required");
            this.instanceFamilies = java.util.Objects.requireNonNull(builder.instanceFamilies, "instanceFamilies is required");
            this.launchPath = java.util.Objects.requireNonNull(builder.launchPath, "launchPath is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.platforms = java.util.Objects.requireNonNull(builder.platforms, "platforms is required");
            this.attributesToDelete = builder.attributesToDelete;
            this.description = builder.description;
            this.displayName = builder.displayName;
            this.launchParameters = builder.launchParameters;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.String getAppBlockArn() {
            return this.appBlockArn;
        }

        @Override
        public final java.lang.Object getIconS3Location() {
            return this.iconS3Location;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceFamilies() {
            return this.instanceFamilies;
        }

        @Override
        public final java.lang.String getLaunchPath() {
            return this.launchPath;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getPlatforms() {
            return this.platforms;
        }

        @Override
        public final java.util.List<java.lang.String> getAttributesToDelete() {
            return this.attributesToDelete;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getLaunchParameters() {
            return this.launchParameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appBlockArn", om.valueToTree(this.getAppBlockArn()));
            data.set("iconS3Location", om.valueToTree(this.getIconS3Location()));
            data.set("instanceFamilies", om.valueToTree(this.getInstanceFamilies()));
            data.set("launchPath", om.valueToTree(this.getLaunchPath()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("platforms", om.valueToTree(this.getPlatforms()));
            if (this.getAttributesToDelete() != null) {
                data.set("attributesToDelete", om.valueToTree(this.getAttributesToDelete()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getLaunchParameters() != null) {
                data.set("launchParameters", om.valueToTree(this.getLaunchParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!appBlockArn.equals(that.appBlockArn)) return false;
            if (!iconS3Location.equals(that.iconS3Location)) return false;
            if (!instanceFamilies.equals(that.instanceFamilies)) return false;
            if (!launchPath.equals(that.launchPath)) return false;
            if (!name.equals(that.name)) return false;
            if (!platforms.equals(that.platforms)) return false;
            if (this.attributesToDelete != null ? !this.attributesToDelete.equals(that.attributesToDelete) : that.attributesToDelete != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.launchParameters != null ? !this.launchParameters.equals(that.launchParameters) : that.launchParameters != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appBlockArn.hashCode();
            result = 31 * result + (this.iconS3Location.hashCode());
            result = 31 * result + (this.instanceFamilies.hashCode());
            result = 31 * result + (this.launchPath.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.platforms.hashCode());
            result = 31 * result + (this.attributesToDelete != null ? this.attributesToDelete.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.launchParameters != null ? this.launchParameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
