package software.amazon.awscdk.services.autoscaling;

/**
 * Additional Heath checks options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .healthChecks(HealthChecks.withAdditionalChecks(AdditionalHealthChecksOptions.builder()
 *                 .gracePeriod(Duration.seconds(100))
 *                 .additionalTypes(List.of(AdditionalHealthCheckType.EBS, AdditionalHealthCheckType.ELB, AdditionalHealthCheckType.VPC_LATTICE))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:43.273Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.AdditionalHealthChecksOptions")
@software.amazon.jsii.Jsii.Proxy(AdditionalHealthChecksOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AdditionalHealthChecksOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * One or more health check types other than EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType> getAdditionalTypes();

    /**
     * Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.
     * <p>
     * Default: Duration.seconds(0)
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getGracePeriod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AdditionalHealthChecksOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AdditionalHealthChecksOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AdditionalHealthChecksOptions> {
        java.util.List<software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType> additionalTypes;
        software.amazon.awscdk.Duration gracePeriod;

        /**
         * Sets the value of {@link AdditionalHealthChecksOptions#getAdditionalTypes}
         * @param additionalTypes One or more health check types other than EC2. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder additionalTypes(java.util.List<? extends software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType> additionalTypes) {
            this.additionalTypes = (java.util.List<software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType>)additionalTypes;
            return this;
        }

        /**
         * Sets the value of {@link AdditionalHealthChecksOptions#getGracePeriod}
         * @param gracePeriod Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gracePeriod(software.amazon.awscdk.Duration gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AdditionalHealthChecksOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AdditionalHealthChecksOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AdditionalHealthChecksOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdditionalHealthChecksOptions {
        private final java.util.List<software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType> additionalTypes;
        private final software.amazon.awscdk.Duration gracePeriod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalTypes = software.amazon.jsii.Kernel.get(this, "additionalTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType.class)));
            this.gracePeriod = software.amazon.jsii.Kernel.get(this, "gracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalTypes = (java.util.List<software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType>)java.util.Objects.requireNonNull(builder.additionalTypes, "additionalTypes is required");
            this.gracePeriod = builder.gracePeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.AdditionalHealthCheckType> getAdditionalTypes() {
            return this.additionalTypes;
        }

        @Override
        public final software.amazon.awscdk.Duration getGracePeriod() {
            return this.gracePeriod;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("additionalTypes", om.valueToTree(this.getAdditionalTypes()));
            if (this.getGracePeriod() != null) {
                data.set("gracePeriod", om.valueToTree(this.getGracePeriod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.AdditionalHealthChecksOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AdditionalHealthChecksOptions.Jsii$Proxy that = (AdditionalHealthChecksOptions.Jsii$Proxy) o;

            if (!additionalTypes.equals(that.additionalTypes)) return false;
            return this.gracePeriod != null ? this.gracePeriod.equals(that.gracePeriod) : that.gracePeriod == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalTypes.hashCode();
            result = 31 * result + (this.gracePeriod != null ? this.gracePeriod.hashCode() : 0);
            return result;
        }
    }
}
