package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for a scheduled scaling action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AutoScalingGroup autoScalingGroup;
 * autoScalingGroup.scaleOnSchedule("PrescaleInTheMorning", BasicScheduledActionProps.builder()
 *         .schedule(Schedule.cron(CronOptions.builder().hour("8").minute("0").build()))
 *         .minCapacity(20)
 *         .build());
 * autoScalingGroup.scaleOnSchedule("AllowDownscalingAtNight", BasicScheduledActionProps.builder()
 *         .schedule(Schedule.cron(CronOptions.builder().hour("20").minute("0").build()))
 *         .minCapacity(1)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:43.296Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.BasicScheduledActionProps")
@software.amazon.jsii.Jsii.Proxy(BasicScheduledActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BasicScheduledActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * When to perform this action.
     * <p>
     * Supports cron expressions.
     * <p>
     * For more information about cron expressions, see https://en.wikipedia.org/wiki/Cron.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.Schedule getSchedule();

    /**
     * The new desired capacity.
     * <p>
     * At the scheduled time, set the desired capacity to the given capacity.
     * <p>
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     * <p>
     * Default: - No new desired capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCapacity() {
        return null;
    }

    /**
     * When this scheduled action expires.
     * <p>
     * Default: - The rule never expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getEndTime() {
        return null;
    }

    /**
     * The new maximum capacity.
     * <p>
     * At the scheduled time, set the maximum capacity to the given capacity.
     * <p>
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     * <p>
     * Default: - No new maximum capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * The new minimum capacity.
     * <p>
     * At the scheduled time, set the minimum capacity to the given capacity.
     * <p>
     * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
     * <p>
     * Default: - No new minimum capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
        return null;
    }

    /**
     * When this scheduled action becomes active.
     * <p>
     * Default: - The rule is activate immediately.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getStartTime() {
        return null;
    }

    /**
     * Specifies the time zone for a cron expression.
     * <p>
     * If a time zone is not provided, UTC is used by default.
     * <p>
     * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as Etc/GMT+9 or Pacific/Tahiti).
     * <p>
     * For more information, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
     * <p>
     * Default: - UTC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BasicScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasicScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BasicScheduledActionProps> {
        software.amazon.awscdk.services.autoscaling.Schedule schedule;
        java.lang.Number desiredCapacity;
        java.time.Instant endTime;
        java.lang.Number maxCapacity;
        java.lang.Number minCapacity;
        java.time.Instant startTime;
        java.lang.String timeZone;

        /**
         * Sets the value of {@link BasicScheduledActionProps#getSchedule}
         * @param schedule When to perform this action. This parameter is required.
         *                 Supports cron expressions.
         *                 <p>
         *                 For more information about cron expressions, see https://en.wikipedia.org/wiki/Cron.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.autoscaling.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link BasicScheduledActionProps#getDesiredCapacity}
         * @param desiredCapacity The new desired capacity.
         *                        At the scheduled time, set the desired capacity to the given capacity.
         *                        <p>
         *                        At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(java.lang.Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link BasicScheduledActionProps#getEndTime}
         * @param endTime When this scheduled action expires.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endTime(java.time.Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        /**
         * Sets the value of {@link BasicScheduledActionProps#getMaxCapacity}
         * @param maxCapacity The new maximum capacity.
         *                    At the scheduled time, set the maximum capacity to the given capacity.
         *                    <p>
         *                    At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link BasicScheduledActionProps#getMinCapacity}
         * @param minCapacity The new minimum capacity.
         *                    At the scheduled time, set the minimum capacity to the given capacity.
         *                    <p>
         *                    At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link BasicScheduledActionProps#getStartTime}
         * @param startTime When this scheduled action becomes active.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(java.time.Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Sets the value of {@link BasicScheduledActionProps#getTimeZone}
         * @param timeZone Specifies the time zone for a cron expression.
         *                 If a time zone is not provided, UTC is used by default.
         *                 <p>
         *                 Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as Etc/GMT+9 or Pacific/Tahiti).
         *                 <p>
         *                 For more information, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(java.lang.String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasicScheduledActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BasicScheduledActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BasicScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicScheduledActionProps {
        private final software.amazon.awscdk.services.autoscaling.Schedule schedule;
        private final java.lang.Number desiredCapacity;
        private final java.time.Instant endTime;
        private final java.lang.Number maxCapacity;
        private final java.lang.Number minCapacity;
        private final java.time.Instant startTime;
        private final java.lang.String timeZone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Schedule.class));
            this.desiredCapacity = software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.desiredCapacity = builder.desiredCapacity;
            this.endTime = builder.endTime;
            this.maxCapacity = builder.maxCapacity;
            this.minCapacity = builder.minCapacity;
            this.startTime = builder.startTime;
            this.timeZone = builder.timeZone;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.Number getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final java.time.Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.time.Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final java.lang.String getTimeZone() {
            return this.timeZone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getEndTime() != null) {
                data.set("endTime", om.valueToTree(this.getEndTime()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getStartTime() != null) {
                data.set("startTime", om.valueToTree(this.getStartTime()));
            }
            if (this.getTimeZone() != null) {
                data.set("timeZone", om.valueToTree(this.getTimeZone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.BasicScheduledActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasicScheduledActionProps.Jsii$Proxy that = (BasicScheduledActionProps.Jsii$Proxy) o;

            if (!schedule.equals(that.schedule)) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) return false;
            return this.timeZone != null ? this.timeZone.equals(that.timeZone) : that.timeZone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schedule.hashCode();
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            return result;
        }
    }
}
