package software.amazon.awscdk.services.autoscaling;

/**
 * The strategies for when launches fail in an Availability Zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .azCapacityDistributionStrategy(CapacityDistributionStrategy.BALANCED_ONLY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:43.299Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CapacityDistributionStrategy")
public enum CapacityDistributionStrategy {
    /**
     * If launches fail in an Availability Zone, Auto Scaling will continue to attempt to launch in the unhealthy zone to preserve a balanced distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BALANCED_ONLY,
    /**
     * If launches fail in an Availability Zone, Auto Scaling will attempt to launch in another healthy Availability Zone instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BALANCED_BEST_EFFORT,
}
