package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnPrompt</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * Object additionalModelRequestFields;
 * Object any;
 * Object auto;
 * Object json;
 * CfnPromptProps cfnPromptProps = CfnPromptProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .customerEncryptionKeyArn("customerEncryptionKeyArn")
 *         .defaultVariant("defaultVariant")
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .variants(List.of(PromptVariantProperty.builder()
 *                 .name("name")
 *                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
 *                         .chat(ChatPromptTemplateConfigurationProperty.builder()
 *                                 .messages(List.of(MessageProperty.builder()
 *                                         .content(List.of(ContentBlockProperty.builder()
 *                                                 .cachePoint(CachePointBlockProperty.builder()
 *                                                         .type("type")
 *                                                         .build())
 *                                                 .text("text")
 *                                                 .build()))
 *                                         .role("role")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
 *                                         .name("name")
 *                                         .build()))
 *                                 .system(List.of(SystemContentBlockProperty.builder()
 *                                         .cachePoint(CachePointBlockProperty.builder()
 *                                                 .type("type")
 *                                                 .build())
 *                                         .text("text")
 *                                         .build()))
 *                                 .toolConfiguration(ToolConfigurationProperty.builder()
 *                                         .tools(List.of(ToolProperty.builder()
 *                                                 .cachePoint(CachePointBlockProperty.builder()
 *                                                         .type("type")
 *                                                         .build())
 *                                                 .toolSpec(ToolSpecificationProperty.builder()
 *                                                         .inputSchema(ToolInputSchemaProperty.builder()
 *                                                                 .json(json)
 *                                                                 .build())
 *                                                         .name("name")
 *                                                         // the properties below are optional
 *                                                         .description("description")
 *                                                         .build())
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .toolChoice(ToolChoiceProperty.builder()
 *                                                 .any(any)
 *                                                 .auto(auto)
 *                                                 .tool(SpecificToolChoiceProperty.builder()
 *                                                         .name("name")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .text(TextPromptTemplateConfigurationProperty.builder()
 *                                 .cachePoint(CachePointBlockProperty.builder()
 *                                         .type("type")
 *                                         .build())
 *                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
 *                                         .name("name")
 *                                         .build()))
 *                                 .text("text")
 *                                 .textS3Location(TextS3LocationProperty.builder()
 *                                         .bucket("bucket")
 *                                         .key("key")
 *                                         // the properties below are optional
 *                                         .version("version")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .templateType("templateType")
 *                 // the properties below are optional
 *                 .additionalModelRequestFields(additionalModelRequestFields)
 *                 .genAiResource(PromptGenAiResourceProperty.builder()
 *                         .agent(PromptAgentResourceProperty.builder()
 *                                 .agentIdentifier("agentIdentifier")
 *                                 .build())
 *                         .build())
 *                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
 *                         .text(PromptModelInferenceConfigurationProperty.builder()
 *                                 .maxTokens(123)
 *                                 .stopSequences(List.of("stopSequences"))
 *                                 .temperature(123)
 *                                 .topP(123)
 *                                 .build())
 *                         .build())
 *                 .metadata(List.of(PromptMetadataEntryProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .modelId("modelId")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:43.965Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPromptProps")
@software.amazon.jsii.Jsii.Proxy(CfnPromptProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPromptProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-customerencryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-customerencryptionkeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerEncryptionKeyArn() {
        return null;
    }

    /**
     * The name of the default variant for the prompt.
     * <p>
     * This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-defaultvariant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-defaultvariant</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultVariant() {
        return null;
    }

    /**
     * The description of the prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * A list of objects, each containing details about a variant of the prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-variants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-variants</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVariants() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPromptProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPromptProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPromptProps> {
        java.lang.String name;
        java.lang.String customerEncryptionKeyArn;
        java.lang.String defaultVariant;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object variants;

        /**
         * Sets the value of {@link CfnPromptProps#getName}
         * @param name The name of the prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPromptProps#getCustomerEncryptionKeyArn}
         * @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerEncryptionKeyArn(java.lang.String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPromptProps#getDefaultVariant}
         * @param defaultVariant The name of the default variant for the prompt.
         *                       This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultVariant(java.lang.String defaultVariant) {
            this.defaultVariant = defaultVariant;
            return this;
        }

        /**
         * Sets the value of {@link CfnPromptProps#getDescription}
         * @param description The description of the prompt.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPromptProps#getTags}
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         *             <ul>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPromptProps#getVariants}
         * @param variants A list of objects, each containing details about a variant of the prompt.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(software.amazon.awscdk.IResolvable variants) {
            this.variants = variants;
            return this;
        }

        /**
         * Sets the value of {@link CfnPromptProps#getVariants}
         * @param variants A list of objects, each containing details about a variant of the prompt.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(java.util.List<? extends java.lang.Object> variants) {
            this.variants = variants;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPromptProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPromptProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPromptProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPromptProps {
        private final java.lang.String name;
        private final java.lang.String customerEncryptionKeyArn;
        private final java.lang.String defaultVariant;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object variants;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerEncryptionKeyArn = software.amazon.jsii.Kernel.get(this, "customerEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultVariant = software.amazon.jsii.Kernel.get(this, "defaultVariant", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.variants = software.amazon.jsii.Kernel.get(this, "variants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
            this.defaultVariant = builder.defaultVariant;
            this.description = builder.description;
            this.tags = builder.tags;
            this.variants = builder.variants;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        @Override
        public final java.lang.String getDefaultVariant() {
            return this.defaultVariant;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVariants() {
            return this.variants;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getCustomerEncryptionKeyArn() != null) {
                data.set("customerEncryptionKeyArn", om.valueToTree(this.getCustomerEncryptionKeyArn()));
            }
            if (this.getDefaultVariant() != null) {
                data.set("defaultVariant", om.valueToTree(this.getDefaultVariant()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVariants() != null) {
                data.set("variants", om.valueToTree(this.getVariants()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPromptProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPromptProps.Jsii$Proxy that = (CfnPromptProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.customerEncryptionKeyArn != null ? !this.customerEncryptionKeyArn.equals(that.customerEncryptionKeyArn) : that.customerEncryptionKeyArn != null) return false;
            if (this.defaultVariant != null ? !this.defaultVariant.equals(that.defaultVariant) : that.defaultVariant != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.variants != null ? this.variants.equals(that.variants) : that.variants == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.customerEncryptionKeyArn != null ? this.customerEncryptionKeyArn.hashCode() : 0);
            result = 31 * result + (this.defaultVariant != null ? this.defaultVariant.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.variants != null ? this.variants.hashCode() : 0);
            return result;
        }
    }
}
