package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for your certificate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // To use your own domain name in a Distribution, you must associate a certificate
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.route53.*;
 * HostedZone hostedZone;
 * Bucket myBucket;
 * Certificate myCertificate = Certificate.Builder.create(this, "mySiteCert")
 *         .domainName("www.example.com")
 *         .validation(CertificateValidation.fromDns(hostedZone))
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(new S3Origin(myBucket)).build())
 *         .domainNames(List.of("www.example.com"))
 *         .certificate(myCertificate)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:44.068Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_certificatemanager.CertificateProps")
@software.amazon.jsii.Jsii.Proxy(CertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Fully-qualified domain name to request a certificate for.
     * <p>
     * May contain wildcards, such as <code>*.domain.com</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The Certificate name.
     * <p>
     * Since the Certificate resource doesn't support providing a physical name, the value provided here will be recorded in the <code>Name</code> tag
     * <p>
     * Default: the full, absolute path of this construct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateName() {
        return null;
    }

    /**
     * Specifies the algorithm of the public and private key pair that your certificate uses to encrypt data.
     * <p>
     * Default: KeyAlgorithm.RSA_2048
     * <p>
     * @see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-certificate.html#algorithms.title">https://docs.aws.amazon.com/acm/latest/userguide/acm-certificate.html#algorithms.title</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.KeyAlgorithm getKeyAlgorithm() {
        return null;
    }

    /**
     * Alternative domain names on your certificate.
     * <p>
     * Use this to register alternative domain names that represent the same site.
     * <p>
     * Default: - No additional FQDNs will be included as alternative domain names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubjectAlternativeNames() {
        return null;
    }

    /**
     * Enable or disable transparency logging for this certificate.
     * <p>
     * Once a certificate has been logged, it cannot be removed from the log.
     * Opting out at that point will have no effect. If you opt out of logging
     * when you request a certificate and then choose later to opt back in,
     * your certificate will not be logged until it is renewed.
     * If you want the certificate to be logged immediately, we recommend that you issue a new one.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency">https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTransparencyLoggingEnabled() {
        return null;
    }

    /**
     * How to validate this certificate.
     * <p>
     * Default: CertificateValidation.fromEmail()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.CertificateValidation getValidation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CertificateProps> {
        java.lang.String domainName;
        java.lang.String certificateName;
        software.amazon.awscdk.services.certificatemanager.KeyAlgorithm keyAlgorithm;
        java.util.List<java.lang.String> subjectAlternativeNames;
        java.lang.Boolean transparencyLoggingEnabled;
        software.amazon.awscdk.services.certificatemanager.CertificateValidation validation;

        /**
         * Sets the value of {@link CertificateProps#getDomainName}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         *                   May contain wildcards, such as <code>*.domain.com</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getCertificateName}
         * @param certificateName The Certificate name.
         *                        Since the Certificate resource doesn't support providing a physical name, the value provided here will be recorded in the <code>Name</code> tag
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(java.lang.String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getKeyAlgorithm}
         * @param keyAlgorithm Specifies the algorithm of the public and private key pair that your certificate uses to encrypt data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAlgorithm(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getSubjectAlternativeNames}
         * @param subjectAlternativeNames Alternative domain names on your certificate.
         *                                Use this to register alternative domain names that represent the same site.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getTransparencyLoggingEnabled}
         * @param transparencyLoggingEnabled Enable or disable transparency logging for this certificate.
         *                                   Once a certificate has been logged, it cannot be removed from the log.
         *                                   Opting out at that point will have no effect. If you opt out of logging
         *                                   when you request a certificate and then choose later to opt back in,
         *                                   your certificate will not be logged until it is renewed.
         *                                   If you want the certificate to be logged immediately, we recommend that you issue a new one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transparencyLoggingEnabled(java.lang.Boolean transparencyLoggingEnabled) {
            this.transparencyLoggingEnabled = transparencyLoggingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CertificateProps#getValidation}
         * @param validation How to validate this certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validation(software.amazon.awscdk.services.certificatemanager.CertificateValidation validation) {
            this.validation = validation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProps {
        private final java.lang.String domainName;
        private final java.lang.String certificateName;
        private final software.amazon.awscdk.services.certificatemanager.KeyAlgorithm keyAlgorithm;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final java.lang.Boolean transparencyLoggingEnabled;
        private final software.amazon.awscdk.services.certificatemanager.CertificateValidation validation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyAlgorithm = software.amazon.jsii.Kernel.get(this, "keyAlgorithm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
            this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.transparencyLoggingEnabled = software.amazon.jsii.Kernel.get(this, "transparencyLoggingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.certificateName = builder.certificateName;
            this.keyAlgorithm = builder.keyAlgorithm;
            this.subjectAlternativeNames = builder.subjectAlternativeNames;
            this.transparencyLoggingEnabled = builder.transparencyLoggingEnabled;
            this.validation = builder.validation;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.KeyAlgorithm getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final java.lang.Boolean getTransparencyLoggingEnabled() {
            return this.transparencyLoggingEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.CertificateValidation getValidation() {
            return this.validation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getCertificateName() != null) {
                data.set("certificateName", om.valueToTree(this.getCertificateName()));
            }
            if (this.getKeyAlgorithm() != null) {
                data.set("keyAlgorithm", om.valueToTree(this.getKeyAlgorithm()));
            }
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getTransparencyLoggingEnabled() != null) {
                data.set("transparencyLoggingEnabled", om.valueToTree(this.getTransparencyLoggingEnabled()));
            }
            if (this.getValidation() != null) {
                data.set("validation", om.valueToTree(this.getValidation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_certificatemanager.CertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CertificateProps.Jsii$Proxy that = (CertificateProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
            if (this.keyAlgorithm != null ? !this.keyAlgorithm.equals(that.keyAlgorithm) : that.keyAlgorithm != null) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.transparencyLoggingEnabled != null ? !this.transparencyLoggingEnabled.equals(that.transparencyLoggingEnabled) : that.transparencyLoggingEnabled != null) return false;
            return this.validation != null ? this.validation.equals(that.validation) : that.validation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.certificateName != null ? this.certificateName.hashCode() : 0);
            result = 31 * result + (this.keyAlgorithm != null ? this.keyAlgorithm.hashCode() : 0);
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.transparencyLoggingEnabled != null ? this.transparencyLoggingEnabled.hashCode() : 0);
            result = 31 * result + (this.validation != null ? this.validation.hashCode() : 0);
            return result;
        }
    }
}
