package software.amazon.awscdk.services.cloudfront;

/**
 * An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * OriginAccessIdentity myOai = OriginAccessIdentity.Builder.create(this, "myOAI")
 *         .comment("My custom OAI")
 *         .build();
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessIdentity(myBucket, S3BucketOriginWithOAIProps.builder()
 *         .originAccessIdentity(myOai)
 *         .build());
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:44.423Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginAccessIdentity")
public class OriginAccessIdentity extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity {

    protected OriginAccessIdentity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OriginAccessIdentity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OriginAccessIdentity(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginAccessIdentityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OriginAccessIdentity(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Creates a OriginAccessIdentity by providing the OriginAccessIdentityId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param originAccessIdentityId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity fromOriginAccessIdentityId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String originAccessIdentityId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginAccessIdentity.class, "fromOriginAccessIdentityId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(originAccessIdentityId, "originAccessIdentityId is required") });
    }

    /**
     * (deprecated) Creates a OriginAccessIdentity by providing the OriginAccessIdentityId.
     * <p>
     * It is misnamed and superseded by the correctly named fromOriginAccessIdentityId.
     * <p>
     * @deprecated use <code>fromOriginAccessIdentityId</code>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param originAccessIdentityName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity fromOriginAccessIdentityName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String originAccessIdentityName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginAccessIdentity.class, "fromOriginAccessIdentityName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(originAccessIdentityName, "originAccessIdentityName is required") });
    }

    /**
     * The ARN to include in S3 bucket policy to allow CloudFront access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String arn() {
        return software.amazon.jsii.Kernel.call(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read permission to an object in Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCloudFrontOriginAccessIdentityS3CanonicalUserId() {
        return software.amazon.jsii.Kernel.get(this, "cloudFrontOriginAccessIdentityS3CanonicalUserId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Derived principal value for bucket access.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The Origin Access Identity Id (physical id) This was called originAccessIdentityName before.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessIdentityId() {
        return software.amazon.jsii.Kernel.get(this, "originAccessIdentityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) The Origin Access Identity Id (physical id) It is misnamed and superseded by the correctly named originAccessIdentityId.
     * <p>
     * @deprecated use originAccessIdentityId instead
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessIdentityName() {
        return software.amazon.jsii.Kernel.get(this, "originAccessIdentityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.OriginAccessIdentity}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.OriginAccessIdentity> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudfront.OriginAccessIdentityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Any comments you want to include about the origin access identity.
         * <p>
         * Default: "Allows CloudFront to reach the bucket"
         * <p>
         * @return {@code this}
         * @param comment Any comments you want to include about the origin access identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.OriginAccessIdentity}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.OriginAccessIdentity build() {
            return new software.amazon.awscdk.services.cloudfront.OriginAccessIdentity(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.OriginAccessIdentityProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.OriginAccessIdentityProps.Builder();
            }
            return this.props;
        }
    }
}
