package software.amazon.awscdk.services.codedeploy;

/**
 * Specify how the deployment behaves and how traffic is routed to the ECS service during a blue-green ECS deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsApplication myApplication;
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition;
 * ITargetGroup blueTargetGroup;
 * ITargetGroup greenTargetGroup;
 * IApplicationListener listener;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.CODE_DEPLOY)
 *                 .build())
 *         .build();
 * EcsDeploymentGroup.Builder.create(this, "BlueGreenDG")
 *         .service(service)
 *         .blueGreenDeploymentConfig(EcsBlueGreenDeploymentConfig.builder()
 *                 .blueTargetGroup(blueTargetGroup)
 *                 .greenTargetGroup(greenTargetGroup)
 *                 .listener(listener)
 *                 .build())
 *         .deploymentConfig(EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs">https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:44.906Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.EcsBlueGreenDeploymentConfig")
@software.amazon.jsii.Jsii.Proxy(EcsBlueGreenDeploymentConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsBlueGreenDeploymentConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The target group that will be associated with the 'blue' ECS task set during a blue-green deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup getBlueTargetGroup();

    /**
     * The target group that will be associated with the 'green' ECS task set during a blue-green deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup getGreenTargetGroup();

    /**
     * The load balancer listener used to serve production traffic and to shift production traffic from the 'blue' ECS task set to the 'green' ECS task set during a blue-green deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IListener getListener();

    /**
     * Specify how long CodeDeploy waits for approval to continue a blue-green deployment before it stops the deployment.
     * <p>
     * After provisioning the 'green' ECS task set and re-routing test traffic, CodeDeploy can wait for approval before
     * continuing the deployment and re-routing production traffic.  During this wait time, validation such as manual
     * testing or running integration tests can occur using the test traffic port, prior to exposing the new 'green' task
     * set to production traffic.  To approve the deployment, validation steps use the CodeDeploy
     * [ContinueDeployment API(https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ContinueDeployment.html).
     * If the ContinueDeployment API is not called within the wait time period, CodeDeploy will stop the deployment.
     * <p>
     * By default, CodeDeploy will not wait for deployment approval.  After re-routing test traffic to the 'green' ECS task set
     * and running any 'AfterAllowTestTraffic' and 'BeforeAllowTraffic' lifecycle hooks, the deployment will immediately
     * re-route production traffic to the 'green' ECS task set.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDeploymentApprovalWaitTime() {
        return null;
    }

    /**
     * Specify how long CodeDeploy waits before it terminates the original 'blue' ECS task set when a blue-green deployment is complete.
     * <p>
     * During this wait time, CodeDeploy will continue to monitor any CloudWatch alarms specified for the deployment group,
     * and the deployment group can be configured to automatically roll back if those alarms fire.  Once CodeDeploy begins to
     * terminate the 'blue' ECS task set, the deployment can no longer be rolled back, manually or automatically.
     * <p>
     * By default, the deployment will immediately terminate the 'blue' ECS task set after production traffic is successfully
     * routed to the 'green' ECS task set.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTerminationWaitTime() {
        return null;
    }

    /**
     * The load balancer listener used to route test traffic to the 'green' ECS task set during a blue-green deployment.
     * <p>
     * During a blue-green deployment, validation can occur after test traffic has been re-routed and before production
     * traffic has been re-routed to the 'green' ECS task set.  You can specify one or more Lambda functions in the
     * deployment's AppSpec file that run during the AfterAllowTestTraffic hook. The functions can run validation tests.
     * If a validation test fails, a deployment rollback is triggered. If the validation tests succeed, the next hook in
     * the deployment lifecycle, BeforeAllowTraffic, is triggered.
     * <p>
     * If a test listener is not specified, the deployment will proceed to routing the production listener to the 'green' ECS task set
     * and will skip the AfterAllowTestTraffic hook.
     * <p>
     * Default: No test listener will be added
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IListener getTestListener() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsBlueGreenDeploymentConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsBlueGreenDeploymentConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsBlueGreenDeploymentConfig> {
        software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup blueTargetGroup;
        software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup greenTargetGroup;
        software.amazon.awscdk.services.elasticloadbalancingv2.IListener listener;
        software.amazon.awscdk.Duration deploymentApprovalWaitTime;
        software.amazon.awscdk.Duration terminationWaitTime;
        software.amazon.awscdk.services.elasticloadbalancingv2.IListener testListener;

        /**
         * Sets the value of {@link EcsBlueGreenDeploymentConfig#getBlueTargetGroup}
         * @param blueTargetGroup The target group that will be associated with the 'blue' ECS task set during a blue-green deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueTargetGroup(software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup blueTargetGroup) {
            this.blueTargetGroup = blueTargetGroup;
            return this;
        }

        /**
         * Sets the value of {@link EcsBlueGreenDeploymentConfig#getGreenTargetGroup}
         * @param greenTargetGroup The target group that will be associated with the 'green' ECS task set during a blue-green deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder greenTargetGroup(software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup greenTargetGroup) {
            this.greenTargetGroup = greenTargetGroup;
            return this;
        }

        /**
         * Sets the value of {@link EcsBlueGreenDeploymentConfig#getListener}
         * @param listener The load balancer listener used to serve production traffic and to shift production traffic from the 'blue' ECS task set to the 'green' ECS task set during a blue-green deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.elasticloadbalancingv2.IListener listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Sets the value of {@link EcsBlueGreenDeploymentConfig#getDeploymentApprovalWaitTime}
         * @param deploymentApprovalWaitTime Specify how long CodeDeploy waits for approval to continue a blue-green deployment before it stops the deployment.
         *                                   After provisioning the 'green' ECS task set and re-routing test traffic, CodeDeploy can wait for approval before
         *                                   continuing the deployment and re-routing production traffic.  During this wait time, validation such as manual
         *                                   testing or running integration tests can occur using the test traffic port, prior to exposing the new 'green' task
         *                                   set to production traffic.  To approve the deployment, validation steps use the CodeDeploy
         *                                   [ContinueDeployment API(https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ContinueDeployment.html).
         *                                   If the ContinueDeployment API is not called within the wait time period, CodeDeploy will stop the deployment.
         *                                   <p>
         *                                   By default, CodeDeploy will not wait for deployment approval.  After re-routing test traffic to the 'green' ECS task set
         *                                   and running any 'AfterAllowTestTraffic' and 'BeforeAllowTraffic' lifecycle hooks, the deployment will immediately
         *                                   re-route production traffic to the 'green' ECS task set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentApprovalWaitTime(software.amazon.awscdk.Duration deploymentApprovalWaitTime) {
            this.deploymentApprovalWaitTime = deploymentApprovalWaitTime;
            return this;
        }

        /**
         * Sets the value of {@link EcsBlueGreenDeploymentConfig#getTerminationWaitTime}
         * @param terminationWaitTime Specify how long CodeDeploy waits before it terminates the original 'blue' ECS task set when a blue-green deployment is complete.
         *                            During this wait time, CodeDeploy will continue to monitor any CloudWatch alarms specified for the deployment group,
         *                            and the deployment group can be configured to automatically roll back if those alarms fire.  Once CodeDeploy begins to
         *                            terminate the 'blue' ECS task set, the deployment can no longer be rolled back, manually or automatically.
         *                            <p>
         *                            By default, the deployment will immediately terminate the 'blue' ECS task set after production traffic is successfully
         *                            routed to the 'green' ECS task set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationWaitTime(software.amazon.awscdk.Duration terminationWaitTime) {
            this.terminationWaitTime = terminationWaitTime;
            return this;
        }

        /**
         * Sets the value of {@link EcsBlueGreenDeploymentConfig#getTestListener}
         * @param testListener The load balancer listener used to route test traffic to the 'green' ECS task set during a blue-green deployment.
         *                     During a blue-green deployment, validation can occur after test traffic has been re-routed and before production
         *                     traffic has been re-routed to the 'green' ECS task set.  You can specify one or more Lambda functions in the
         *                     deployment's AppSpec file that run during the AfterAllowTestTraffic hook. The functions can run validation tests.
         *                     If a validation test fails, a deployment rollback is triggered. If the validation tests succeed, the next hook in
         *                     the deployment lifecycle, BeforeAllowTraffic, is triggered.
         *                     <p>
         *                     If a test listener is not specified, the deployment will proceed to routing the production listener to the 'green' ECS task set
         *                     and will skip the AfterAllowTestTraffic hook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testListener(software.amazon.awscdk.services.elasticloadbalancingv2.IListener testListener) {
            this.testListener = testListener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsBlueGreenDeploymentConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsBlueGreenDeploymentConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsBlueGreenDeploymentConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsBlueGreenDeploymentConfig {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup blueTargetGroup;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup greenTargetGroup;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IListener listener;
        private final software.amazon.awscdk.Duration deploymentApprovalWaitTime;
        private final software.amazon.awscdk.Duration terminationWaitTime;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IListener testListener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blueTargetGroup = software.amazon.jsii.Kernel.get(this, "blueTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup.class));
            this.greenTargetGroup = software.amazon.jsii.Kernel.get(this, "greenTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup.class));
            this.listener = software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IListener.class));
            this.deploymentApprovalWaitTime = software.amazon.jsii.Kernel.get(this, "deploymentApprovalWaitTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.terminationWaitTime = software.amazon.jsii.Kernel.get(this, "terminationWaitTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.testListener = software.amazon.jsii.Kernel.get(this, "testListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IListener.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blueTargetGroup = java.util.Objects.requireNonNull(builder.blueTargetGroup, "blueTargetGroup is required");
            this.greenTargetGroup = java.util.Objects.requireNonNull(builder.greenTargetGroup, "greenTargetGroup is required");
            this.listener = java.util.Objects.requireNonNull(builder.listener, "listener is required");
            this.deploymentApprovalWaitTime = builder.deploymentApprovalWaitTime;
            this.terminationWaitTime = builder.terminationWaitTime;
            this.testListener = builder.testListener;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup getBlueTargetGroup() {
            return this.blueTargetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup getGreenTargetGroup() {
            return this.greenTargetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IListener getListener() {
            return this.listener;
        }

        @Override
        public final software.amazon.awscdk.Duration getDeploymentApprovalWaitTime() {
            return this.deploymentApprovalWaitTime;
        }

        @Override
        public final software.amazon.awscdk.Duration getTerminationWaitTime() {
            return this.terminationWaitTime;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IListener getTestListener() {
            return this.testListener;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("blueTargetGroup", om.valueToTree(this.getBlueTargetGroup()));
            data.set("greenTargetGroup", om.valueToTree(this.getGreenTargetGroup()));
            data.set("listener", om.valueToTree(this.getListener()));
            if (this.getDeploymentApprovalWaitTime() != null) {
                data.set("deploymentApprovalWaitTime", om.valueToTree(this.getDeploymentApprovalWaitTime()));
            }
            if (this.getTerminationWaitTime() != null) {
                data.set("terminationWaitTime", om.valueToTree(this.getTerminationWaitTime()));
            }
            if (this.getTestListener() != null) {
                data.set("testListener", om.valueToTree(this.getTestListener()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.EcsBlueGreenDeploymentConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsBlueGreenDeploymentConfig.Jsii$Proxy that = (EcsBlueGreenDeploymentConfig.Jsii$Proxy) o;

            if (!blueTargetGroup.equals(that.blueTargetGroup)) return false;
            if (!greenTargetGroup.equals(that.greenTargetGroup)) return false;
            if (!listener.equals(that.listener)) return false;
            if (this.deploymentApprovalWaitTime != null ? !this.deploymentApprovalWaitTime.equals(that.deploymentApprovalWaitTime) : that.deploymentApprovalWaitTime != null) return false;
            if (this.terminationWaitTime != null ? !this.terminationWaitTime.equals(that.terminationWaitTime) : that.terminationWaitTime != null) return false;
            return this.testListener != null ? this.testListener.equals(that.testListener) : that.testListener == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blueTargetGroup.hashCode();
            result = 31 * result + (this.greenTargetGroup.hashCode());
            result = 31 * result + (this.listener.hashCode());
            result = 31 * result + (this.deploymentApprovalWaitTime != null ? this.deploymentApprovalWaitTime.hashCode() : 0);
            result = 31 * result + (this.terminationWaitTime != null ? this.terminationWaitTime.hashCode() : 0);
            result = 31 * result + (this.testListener != null ? this.testListener.hashCode() : 0);
            return result;
        }
    }
}
