package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of <code>EcsDeploymentConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsDeploymentConfig.Builder.create(this, "CustomConfig")
 *         .trafficRouting(TimeBasedCanaryTrafficRouting.Builder.create()
 *                 .interval(Duration.minutes(15))
 *                 .percentage(5)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:44.907Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.EcsDeploymentConfigProps")
@software.amazon.jsii.Jsii.Proxy(EcsDeploymentConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codedeploy.BaseDeploymentConfigOptions {

    /**
     * The configuration that specifies how traffic is shifted from the 'blue' target group to the 'green' target group during a deployment.
     * <p>
     * Default: AllAtOnce
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.TrafficRouting getTrafficRouting() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsDeploymentConfigProps> {
        software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting;
        java.lang.String deploymentConfigName;

        /**
         * Sets the value of {@link EcsDeploymentConfigProps#getTrafficRouting}
         * @param trafficRouting The configuration that specifies how traffic is shifted from the 'blue' target group to the 'green' target group during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRouting(software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting) {
            this.trafficRouting = trafficRouting;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeploymentConfigProps#getDeploymentConfigName}
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsDeploymentConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsDeploymentConfigProps {
        private final software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting;
        private final java.lang.String deploymentConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.trafficRouting = software.amazon.jsii.Kernel.get(this, "trafficRouting", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.TrafficRouting.class));
            this.deploymentConfigName = software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.trafficRouting = builder.trafficRouting;
            this.deploymentConfigName = builder.deploymentConfigName;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.TrafficRouting getTrafficRouting() {
            return this.trafficRouting;
        }

        @Override
        public final java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTrafficRouting() != null) {
                data.set("trafficRouting", om.valueToTree(this.getTrafficRouting()));
            }
            if (this.getDeploymentConfigName() != null) {
                data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.EcsDeploymentConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsDeploymentConfigProps.Jsii$Proxy that = (EcsDeploymentConfigProps.Jsii$Proxy) o;

            if (this.trafficRouting != null ? !this.trafficRouting.equals(that.trafficRouting) : that.trafficRouting != null) return false;
            return this.deploymentConfigName != null ? this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.trafficRouting != null ? this.trafficRouting.hashCode() : 0;
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            return result;
        }
    }
}
