package software.amazon.awscdk.services.codedeploy;

/**
 * A CodeDeploy deployment group that orchestrates ECS blue-green deployments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsApplication myApplication;
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition;
 * ITargetGroup blueTargetGroup;
 * ITargetGroup greenTargetGroup;
 * IApplicationListener listener;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.CODE_DEPLOY)
 *                 .build())
 *         .build();
 * EcsDeploymentGroup.Builder.create(this, "BlueGreenDG")
 *         .service(service)
 *         .blueGreenDeploymentConfig(EcsBlueGreenDeploymentConfig.builder()
 *                 .blueTargetGroup(blueTargetGroup)
 *                 .greenTargetGroup(greenTargetGroup)
 *                 .listener(listener)
 *                 .build())
 *         .deploymentConfig(EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:44.908Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.EcsDeploymentGroup")
public class EcsDeploymentGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codedeploy.IEcsDeploymentGroup {

    protected EcsDeploymentGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsDeploymentGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsDeploymentGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.EcsDeploymentGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Reference an ECS Deployment Group defined outside the CDK app.
     * <p>
     * Account and region for the DeploymentGroup are taken from the application.
     * <p>
     * @return a Construct representing a reference to an existing Deployment Group
     * @param scope the parent Construct for this new Construct. This parameter is required.
     * @param id the logical ID of this new Construct. This parameter is required.
     * @param attrs the properties of the referenced Deployment Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IEcsDeploymentGroup fromEcsDeploymentGroupAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.EcsDeploymentGroupAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.EcsDeploymentGroup.class, "fromEcsDeploymentGroupAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Associates an additional alarm with this Deployment Group.
     * <p>
     * @param alarm the alarm to associate with this Deployment Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAlarm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm alarm) {
        software.amazon.jsii.Kernel.call(this, "addAlarm", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(alarm, "alarm is required") });
    }

    /**
     * The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IEcsApplication getApplication() {
        return software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsApplication.class));
    }

    /**
     * The Deployment Configuration this Group uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig getDeploymentConfig() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.class));
    }

    /**
     * The ARN of the Deployment Group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "deploymentGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Deployment Group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentGroupName() {
        return software.amazon.jsii.Kernel.get(this, "deploymentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service Role of this Deployment Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.EcsDeploymentGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.EcsDeploymentGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codedeploy.EcsDeploymentGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codedeploy.EcsDeploymentGroupProps.Builder();
        }

        /**
         * The configuration options for blue-green ECS deployments.
         * <p>
         * @return {@code this}
         * @param blueGreenDeploymentConfig The configuration options for blue-green ECS deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueGreenDeploymentConfig(final software.amazon.awscdk.services.codedeploy.EcsBlueGreenDeploymentConfig blueGreenDeploymentConfig) {
            this.props.blueGreenDeploymentConfig(blueGreenDeploymentConfig);
            return this;
        }

        /**
         * The ECS service to deploy with this Deployment Group.
         * <p>
         * @return {@code this}
         * @param service The ECS service to deploy with this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final software.amazon.awscdk.services.ecs.IBaseService service) {
            this.props.service(service);
            return this;
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group.
         * <p>
         * CodeDeploy will stop (and optionally roll back)
         * a deployment if during it any of the alarms trigger.
         * <p>
         * Alarms can also be added after the Deployment Group is created using the <code>#addAlarm</code> method.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html">https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html</a>
         * @param alarms The CloudWatch alarms associated with this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarms(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IAlarm> alarms) {
            this.props.alarms(alarms);
            return this;
        }

        /**
         * The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
         * <p>
         * Default: One will be created for you.
         * <p>
         * @return {@code this}
         * @param application The reference to the CodeDeploy ECS Application that this Deployment Group belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(final software.amazon.awscdk.services.codedeploy.IEcsApplication application) {
            this.props.application(application);
            return this;
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         * <p>
         * Default: - default AutoRollbackConfig.
         * <p>
         * @return {@code this}
         * @param autoRollback The auto-rollback configuration for this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollback(final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback) {
            this.props.autoRollback(autoRollback);
            return this;
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * <p>
         * Default: EcsDeploymentConfig.ALL_AT_ONCE
         * <p>
         * @return {@code this}
         * @param deploymentConfig The Deployment Configuration this Deployment Group uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(final software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig deploymentConfig) {
            this.props.deploymentConfig(deploymentConfig);
            return this;
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * <p>
         * Default: An auto-generated name will be used.
         * <p>
         * @return {@code this}
         * @param deploymentGroupName The physical, human-readable name of the CodeDeploy Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(final java.lang.String deploymentGroupName) {
            this.props.deploymentGroupName(deploymentGroupName);
            return this;
        }

        /**
         * Whether to skip the step of checking CloudWatch alarms during the deployment process.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param ignoreAlarmConfiguration Whether to skip the step of checking CloudWatch alarms during the deployment process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreAlarmConfiguration(final java.lang.Boolean ignoreAlarmConfiguration) {
            this.props.ignoreAlarmConfiguration(ignoreAlarmConfiguration);
            return this;
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ignorePollAlarmsFailure Whether to continue a deployment even if fetching the alarm status from CloudWatch failed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignorePollAlarmsFailure(final java.lang.Boolean ignorePollAlarmsFailure) {
            this.props.ignorePollAlarmsFailure(ignorePollAlarmsFailure);
            return this;
        }

        /**
         * The service Role of this Deployment Group.
         * <p>
         * Default: - A new Role will be created.
         * <p>
         * @return {@code this}
         * @param role The service Role of this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codedeploy.EcsDeploymentGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.EcsDeploymentGroup build() {
            return new software.amazon.awscdk.services.codedeploy.EcsDeploymentGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
