package software.amazon.awscdk.services.codedeploy;

/**
 * A CodeDeploy Deployment Group that deploys to EC2/on-premise instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationLoadBalancer alb;
 * ApplicationListener listener = alb.addListener("Listener", BaseApplicationListenerProps.builder().port(80).build());
 * ApplicationTargetGroup targetGroup = listener.addTargets("Fleet", AddApplicationTargetsProps.builder().port(80).build());
 * ServerDeploymentGroup deploymentGroup = ServerDeploymentGroup.Builder.create(this, "DeploymentGroup")
 *         .loadBalancer(LoadBalancer.application(targetGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:44.935Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.ServerDeploymentGroup")
public class ServerDeploymentGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup {

    protected ServerDeploymentGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServerDeploymentGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServerDeploymentGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServerDeploymentGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an EC2/on-premise Deployment Group defined either outside the CDK app, or in a different region.
     * <p>
     * @return a Construct representing a reference to an existing Deployment Group
     * @param scope the parent Construct for this new Construct. This parameter is required.
     * @param id the logical ID of this new Construct. This parameter is required.
     * @param attrs the properties of the referenced Deployment Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup fromServerDeploymentGroupAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.ServerDeploymentGroup.class, "fromServerDeploymentGroupAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Associates an additional alarm with this Deployment Group.
     * <p>
     * @param alarm the alarm to associate with this Deployment Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAlarm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm alarm) {
        software.amazon.jsii.Kernel.call(this, "addAlarm", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(alarm, "alarm is required") });
    }

    /**
     * Adds an additional auto-scaling group to this Deployment Group.
     * <p>
     * @param asg the auto-scaling group to add to this Deployment Group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAutoScalingGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup asg) {
        software.amazon.jsii.Kernel.call(this, "addAutoScalingGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(asg, "asg is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
        return software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerApplication.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class));
    }

    /**
     * The ARN of the Deployment Group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "deploymentGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Deployment Group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentGroupName() {
        return software.amazon.jsii.Kernel.get(this, "deploymentGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> getAutoScalingGroups() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.autoscaling.IAutoScalingGroup>)(software.amazon.jsii.Kernel.get(this, "autoScalingGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The service Role of this Deployment Group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.ServerDeploymentGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.ServerDeploymentGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group.
         * <p>
         * CodeDeploy will stop (and optionally roll back)
         * a deployment if during it any of the alarms trigger.
         * <p>
         * Alarms can also be added after the Deployment Group is created using the <code>#addAlarm</code> method.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html">https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html</a>
         * @param alarms The CloudWatch alarms associated with this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarms(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IAlarm> alarms) {
            this.props().alarms(alarms);
            return this;
        }

        /**
         * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
         * <p>
         * Default: - A new Application will be created.
         * <p>
         * @return {@code this}
         * @param application The CodeDeploy EC2/on-premise Application this Deployment Group belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(final software.amazon.awscdk.services.codedeploy.IServerApplication application) {
            this.props().application(application);
            return this;
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         * <p>
         * Default: - default AutoRollbackConfig.
         * <p>
         * @return {@code this}
         * @param autoRollback The auto-rollback configuration for this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRollback(final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig autoRollback) {
            this.props().autoRollback(autoRollback);
            return this;
        }

        /**
         * The auto-scaling groups belonging to this Deployment Group.
         * <p>
         * Auto-scaling groups can also be added after the Deployment Group is created
         * using the <code>#addAutoScalingGroup</code> method.
         * <p>
         * [disable-awslint:ref-via-interface] is needed because we update userdata
         * for ASGs to install the codedeploy agent.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param autoScalingGroups The auto-scaling groups belonging to this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroups(final java.util.List<? extends software.amazon.awscdk.services.autoscaling.IAutoScalingGroup> autoScalingGroups) {
            this.props().autoScalingGroups(autoScalingGroups);
            return this;
        }

        /**
         * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
         * <p>
         * Default: ServerDeploymentConfig#OneAtATime
         * <p>
         * @return {@code this}
         * @param deploymentConfig The EC2/on-premise Deployment Configuration to use for this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig) {
            this.props().deploymentConfig(deploymentConfig);
            return this;
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * <p>
         * Default: - An auto-generated name will be used.
         * <p>
         * @return {@code this}
         * @param deploymentGroupName The physical, human-readable name of the CodeDeploy Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupName(final java.lang.String deploymentGroupName) {
            this.props().deploymentGroupName(deploymentGroupName);
            return this;
        }

        /**
         * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * <p>
         * Default: - No additional EC2 instances will be added to the Deployment Group.
         * <p>
         * @return {@code this}
         * @param ec2InstanceTags All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InstanceTags(final software.amazon.awscdk.services.codedeploy.InstanceTagSet ec2InstanceTags) {
            this.props().ec2InstanceTags(ec2InstanceTags);
            return this;
        }

        /**
         * Whether to skip the step of checking CloudWatch alarms during the deployment process.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param ignoreAlarmConfiguration Whether to skip the step of checking CloudWatch alarms during the deployment process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreAlarmConfiguration(final java.lang.Boolean ignoreAlarmConfiguration) {
            this.props().ignoreAlarmConfiguration(ignoreAlarmConfiguration);
            return this;
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ignorePollAlarmsFailure Whether to continue a deployment even if fetching the alarm status from CloudWatch failed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignorePollAlarmsFailure(final java.lang.Boolean ignorePollAlarmsFailure) {
            this.props().ignorePollAlarmsFailure(ignorePollAlarmsFailure);
            return this;
        }

        /**
         * If you've provided any auto-scaling groups with the <code>#autoScalingGroups</code> property, you can set this property to add User Data that installs the CodeDeploy agent on the instances.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html">https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html</a>
         * @param installAgent If you've provided any auto-scaling groups with the <code>#autoScalingGroups</code> property, you can set this property to add User Data that installs the CodeDeploy agent on the instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installAgent(final java.lang.Boolean installAgent) {
            this.props().installAgent(installAgent);
            return this;
        }

        /**
         * (deprecated) The load balancer to place in front of this Deployment Group.
         * <p>
         * Can be created from either a classic Elastic Load Balancer,
         * or an Application Load Balancer / Network Load Balancer Target Group.
         * <p>
         * Default: - Deployment Group will not have a load balancer defined.
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>Use <code>loadBalancers</code> instead.</li>
         * </ul>
         * @param loadBalancer The load balancer to place in front of this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder loadBalancer(final software.amazon.awscdk.services.codedeploy.LoadBalancer loadBalancer) {
            this.props().loadBalancer(loadBalancer);
            return this;
        }

        /**
         * CodeDeploy supports the deployment to multiple load balancers.
         * <p>
         * Specify either multiple Classic Load Balancers, or
         * Application Load Balancers / Network Load Balancers Target Groups.
         * <p>
         * Default: - Deployment Group will not have load balancers defined.
         * <p>
         * @return {@code this}
         * @param loadBalancers CodeDeploy supports the deployment to multiple load balancers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final java.util.List<? extends software.amazon.awscdk.services.codedeploy.LoadBalancer> loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        /**
         * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * <p>
         * Default: - No additional on-premise instances will be added to the Deployment Group.
         * <p>
         * @return {@code this}
         * @param onPremiseInstanceTags All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onPremiseInstanceTags(final software.amazon.awscdk.services.codedeploy.InstanceTagSet onPremiseInstanceTags) {
            this.props().onPremiseInstanceTags(onPremiseInstanceTags);
            return this;
        }

        /**
         * The service Role of this Deployment Group.
         * <p>
         * Default: - A new Role will be created.
         * <p>
         * @return {@code this}
         * @param role The service Role of this Deployment Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * Indicates whether the deployment group was configured to have CodeDeploy install a termination hook into an Auto Scaling group.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors">https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors</a>
         * @param terminationHook Indicates whether the deployment group was configured to have CodeDeploy install a termination hook into an Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationHook(final java.lang.Boolean terminationHook) {
            this.props().terminationHook(terminationHook);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codedeploy.ServerDeploymentGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.ServerDeploymentGroup build() {
            return new software.amazon.awscdk.services.codedeploy.ServerDeploymentGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps.Builder();
            }
            return this.props;
        }
    }
}
