package software.amazon.awscdk.services.codepipeline;

/**
 * Git configuration for trigger.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 .build()))
 *         .triggers(List.of(TriggerProps.builder()
 *                 .providerType(ProviderType.CODE_STAR_SOURCE_CONNECTION)
 *                 .gitConfiguration(GitConfiguration.builder()
 *                         .sourceAction(sourceAction)
 *                         .pushFilter(List.of(GitPushFilter.builder()
 *                                 .tagsExcludes(List.of("exclude1", "exclude2"))
 *                                 .tagsIncludes(List.of("include*"))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:45.016Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.GitConfiguration")
@software.amazon.jsii.Jsii.Proxy(GitConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GitConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The pipeline source action where the trigger configuration, such as Git tags.
     * <p>
     * The trigger configuration will start the pipeline upon the specified change only.
     * You can only specify one trigger configuration per source action.
     * <p>
     * Since the provider for <code>sourceAction</code> must be <code>CodeStarSourceConnection</code>, you can use
     * <code>CodeStarConnectionsSourceAction</code> construct in <code>aws-codepipeline-actions</code> module.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IAction getSourceAction();

    /**
     * The field where the repository event that will start the pipeline is specified as pull requests.
     * <p>
     * The length must be less than or equal to 3.
     * <p>
     * Default: - no filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestFilter> getPullRequestFilter() {
        return null;
    }

    /**
     * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
     * <p>
     * Git tags, file paths and branches are supported event type.
     * <p>
     * The length must be less than or equal to 3.
     * <p>
     * Default: - no filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.GitPushFilter> getPushFilter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GitConfiguration> {
        software.amazon.awscdk.services.codepipeline.IAction sourceAction;
        java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestFilter> pullRequestFilter;
        java.util.List<software.amazon.awscdk.services.codepipeline.GitPushFilter> pushFilter;

        /**
         * Sets the value of {@link GitConfiguration#getSourceAction}
         * @param sourceAction The pipeline source action where the trigger configuration, such as Git tags. This parameter is required.
         *                     The trigger configuration will start the pipeline upon the specified change only.
         *                     You can only specify one trigger configuration per source action.
         *                     <p>
         *                     Since the provider for <code>sourceAction</code> must be <code>CodeStarSourceConnection</code>, you can use
         *                     <code>CodeStarConnectionsSourceAction</code> construct in <code>aws-codepipeline-actions</code> module.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAction(software.amazon.awscdk.services.codepipeline.IAction sourceAction) {
            this.sourceAction = sourceAction;
            return this;
        }

        /**
         * Sets the value of {@link GitConfiguration#getPullRequestFilter}
         * @param pullRequestFilter The field where the repository event that will start the pipeline is specified as pull requests.
         *                          The length must be less than or equal to 3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder pullRequestFilter(java.util.List<? extends software.amazon.awscdk.services.codepipeline.GitPullRequestFilter> pullRequestFilter) {
            this.pullRequestFilter = (java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestFilter>)pullRequestFilter;
            return this;
        }

        /**
         * Sets the value of {@link GitConfiguration#getPushFilter}
         * @param pushFilter The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
         *                   Git tags, file paths and branches are supported event type.
         *                   <p>
         *                   The length must be less than or equal to 3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder pushFilter(java.util.List<? extends software.amazon.awscdk.services.codepipeline.GitPushFilter> pushFilter) {
            this.pushFilter = (java.util.List<software.amazon.awscdk.services.codepipeline.GitPushFilter>)pushFilter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GitConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitConfiguration {
        private final software.amazon.awscdk.services.codepipeline.IAction sourceAction;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestFilter> pullRequestFilter;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.GitPushFilter> pushFilter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceAction = software.amazon.jsii.Kernel.get(this, "sourceAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IAction.class));
            this.pullRequestFilter = software.amazon.jsii.Kernel.get(this, "pullRequestFilter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.GitPullRequestFilter.class)));
            this.pushFilter = software.amazon.jsii.Kernel.get(this, "pushFilter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.GitPushFilter.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceAction = java.util.Objects.requireNonNull(builder.sourceAction, "sourceAction is required");
            this.pullRequestFilter = (java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestFilter>)builder.pullRequestFilter;
            this.pushFilter = (java.util.List<software.amazon.awscdk.services.codepipeline.GitPushFilter>)builder.pushFilter;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.IAction getSourceAction() {
            return this.sourceAction;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestFilter> getPullRequestFilter() {
            return this.pullRequestFilter;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.GitPushFilter> getPushFilter() {
            return this.pushFilter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceAction", om.valueToTree(this.getSourceAction()));
            if (this.getPullRequestFilter() != null) {
                data.set("pullRequestFilter", om.valueToTree(this.getPullRequestFilter()));
            }
            if (this.getPushFilter() != null) {
                data.set("pushFilter", om.valueToTree(this.getPushFilter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.GitConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitConfiguration.Jsii$Proxy that = (GitConfiguration.Jsii$Proxy) o;

            if (!sourceAction.equals(that.sourceAction)) return false;
            if (this.pullRequestFilter != null ? !this.pullRequestFilter.equals(that.pullRequestFilter) : that.pullRequestFilter != null) return false;
            return this.pushFilter != null ? this.pushFilter.equals(that.pushFilter) : that.pushFilter == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceAction.hashCode();
            result = 31 * result + (this.pullRequestFilter != null ? this.pullRequestFilter.hashCode() : 0);
            result = 31 * result + (this.pushFilter != null ? this.pushFilter.hashCode() : 0);
            return result;
        }
    }
}
