package software.amazon.awscdk.services.config;

/**
 * A new custom policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String samplePolicyText = "\n# This rule checks if point in time recovery (PITR) is enabled on active Amazon DynamoDB tables\nlet status = ['ACTIVE']\n\nrule tableisactive when\n    resourceType == \"AWS::DynamoDB::Table\" {\n    configuration.tableStatus == %status\n}\n\nrule checkcompliance when\n    resourceType == \"AWS::DynamoDB::Table\"\n    tableisactive {\n        let pitr = supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus\n        %pitr == \"ENABLED\"\n}\n";
 * CustomPolicy.Builder.create(this, "Custom")
 *         .policyText(samplePolicyText)
 *         .enableDebugLog(true)
 *         .ruleScope(RuleScope.fromResources(List.of(ResourceType.DYNAMODB_TABLE)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:45.469Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CustomPolicy")
public class CustomPolicy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.config.IRule {

    protected CustomPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.CustomPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an existing rule.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param configRuleName the name of the rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.IRule fromConfigRuleName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String configRuleName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.CustomPolicy.class, "fromConfigRuleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.IRule.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(configRuleName, "configRuleName is required") });
    }

    /**
     * Defines an EventBridge event rule which triggers for rule compliance events.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onComplianceChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onComplianceChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an EventBridge event rule which triggers for rule compliance events.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onComplianceChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onComplianceChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an EventBridge event rule which triggers for rule events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an EventBridge event rule which triggers for rule events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an EventBridge event rule which triggers for rule re-evaluation status events.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReEvaluationStatus(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onReEvaluationStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines an EventBridge event rule which triggers for rule re-evaluation status events.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReEvaluationStatus(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onReEvaluationStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The arn of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "configRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compliance status of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigRuleComplianceType() {
        return software.amazon.jsii.Kernel.get(this, "configRuleComplianceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The id of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigRuleId() {
        return software.amazon.jsii.Kernel.get(this, "configRuleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigRuleName() {
        return software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getIsCustomWithChanges() {
        return software.amazon.jsii.Kernel.get(this, "isCustomWithChanges", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setIsCustomWithChanges(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isCustomWithChanges", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getIsManaged() {
        return software.amazon.jsii.Kernel.get(this, "isManaged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setIsManaged(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isManaged", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.RuleScope getRuleScope() {
        return software.amazon.jsii.Kernel.get(this, "ruleScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setRuleScope(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.RuleScope value) {
        software.amazon.jsii.Kernel.set(this, "ruleScope", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CustomPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CustomPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.config.CustomPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.config.CustomPolicyProps.Builder();
        }

        /**
         * A name for the AWS Config rule.
         * <p>
         * Default: - CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param configRuleName A name for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(final java.lang.String configRuleName) {
            this.props.configRuleName(configRuleName);
            return this;
        }

        /**
         * A description about this AWS Config rule.
         * <p>
         * Default: - No description
         * <p>
         * @return {@code this}
         * @param description A description about this AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The modes the AWS Config rule can be evaluated in.
         * <p>
         * The valid values are distinct objects.
         * <p>
         * Default: - Detective evaluation mode only
         * <p>
         * @return {@code this}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(final software.amazon.awscdk.services.config.EvaluationMode evaluationModes) {
            this.props.evaluationModes(evaluationModes);
            return this;
        }

        /**
         * Input parameter values that are passed to the AWS Config rule.
         * <p>
         * Default: - No input parameters
         * <p>
         * @return {@code this}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputParameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.props.inputParameters(inputParameters);
            return this;
        }

        /**
         * The maximum frequency at which the AWS Config rule runs evaluations.
         * <p>
         * Default: MaximumExecutionFrequency.TWENTY_FOUR_HOURS
         * <p>
         * @return {@code this}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.props.maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        /**
         * Defines which resources trigger an evaluation for an AWS Config rule.
         * <p>
         * Default: - evaluations for the rule are triggered when any resource in the recording group changes.
         * <p>
         * @return {@code this}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleScope(final software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.props.ruleScope(ruleScope);
            return this;
        }

        /**
         * The policy definition containing the logic for your AWS Config Custom Policy rule.
         * <p>
         * @return {@code this}
         * @param policyText The policy definition containing the logic for your AWS Config Custom Policy rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyText(final java.lang.String policyText) {
            this.props.policyText(policyText);
            return this;
        }

        /**
         * The boolean expression for enabling debug logging for your AWS Config Custom Policy rule.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableDebugLog The boolean expression for enabling debug logging for your AWS Config Custom Policy rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDebugLog(final java.lang.Boolean enableDebugLog) {
            this.props.enableDebugLog(enableDebugLog);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.config.CustomPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CustomPolicy build() {
            return new software.amazon.awscdk.services.config.CustomPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
