package software.amazon.awscdk.services.config;

/**
 * Resources types that are supported by AWS Config.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Lambda function containing logic that evaluates compliance with the rule.
 * Function evalComplianceFn = Function.Builder.create(this, "CustomFunction")
 *         .code(AssetCode.fromInline("exports.handler = (event) =&gt; console.log(event);"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .build();
 * // A custom rule that runs on configuration changes of EC2 instances
 * CustomRule customRule = CustomRule.Builder.create(this, "Custom")
 *         .configurationChanges(true)
 *         .lambdaFunction(evalComplianceFn)
 *         .ruleScope(RuleScope.fromResource(ResourceType.EC2_INSTANCE))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html">https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:45.480Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.ResourceType")
public class ResourceType extends software.amazon.jsii.JsiiObject {

    protected ResourceType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResourceType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACM_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ACM_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ACMPCA_CERTIFICATE_AUTHORITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ACMPCA_CERTIFICATE_AUTHORITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ACMPCA_CERTIFICATE_AUTHORITY_ACTIVATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ACMPCA_CERTIFICATE_AUTHORITY_ACTIVATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AMAZON_MQ_BROKER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AMAZON_MQ_BROKER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AMPLIFY_APP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AMPLIFY_APP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AMPLIFY_BRANCH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AMPLIFY_BRANCH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAY_REST_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAY_REST_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAY_STAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAY_STAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAYV2_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAYV2_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAYV2_STAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAYV2_STAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_CONFIG_DEPLOYMENT_STRATEGY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_CONFIG_DEPLOYMENT_STRATEGY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_CONFIG_HOSTED_CONFIGURATION_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_CONFIG_HOSTED_CONFIGURATION_VERSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_FLOW_FLOW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_FLOW_FLOW", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_INTEGRATIONS_EVENT_INTEGRATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_INTEGRATIONS_EVENT_INTEGRATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_MESH_GATEWAY_ROUTE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_MESH_GATEWAY_ROUTE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_MESH_MESH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_MESH_MESH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_MESH_ROUTE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_MESH_ROUTE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_MESH_VIRTUAL_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_MESH_VIRTUAL_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_MESH_VIRTUAL_NODE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_MESH_VIRTUAL_NODE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_MESH_VIRTUAL_ROUTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_MESH_VIRTUAL_ROUTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_MESH_VIRTUAL_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_MESH_VIRTUAL_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_RUNNER_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_RUNNER_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_RUNNER_VPC_CONNECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_RUNNER_VPC_CONNECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_STREAM_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_STREAM_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_STREAM_DIRECTORY_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_STREAM_DIRECTORY_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_STREAM_FLEET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_STREAM_FLEET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APP_STREAM_STACK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APP_STREAM_STACK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPCONFIG_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPCONFIG_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPCONFIG_CONFIGURATION_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPCONFIG_CONFIGURATION_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPCONFIG_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPCONFIG_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPSYNC_GRAPHQL_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPSYNC_GRAPHQL_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APS_RULE_GROUPS_NAMESPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APS_RULE_GROUPS_NAMESPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ATHENA_PREPARED_STATEMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ATHENA_PREPARED_STATEMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUDIT_MANAGER_ASSESSMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUDIT_MANAGER_ASSESSMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_LAUNCH_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_LAUNCH_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_SCHEDULED_ACTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_SCHEDULED_ACTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_WARM_POOL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_WARM_POOL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_SELECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_SELECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_VAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_VAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_RECOVERY_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_RECOVERY_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_REPORT_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_REPORT_PLAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BATCH_COMPUTE_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BATCH_COMPUTE_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BATCH_JOB_QUEUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BATCH_JOB_QUEUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BATCH_SCHEDULING_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BATCH_SCHEDULING_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BUDGETS_BUDGETS_ACTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BUDGETS_BUDGETS_ACTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CASSANDRA_KEYSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CASSANDRA_KEYSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUD_WATCH_METRIC_STREAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUD_WATCH_METRIC_STREAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUD9_ENVIRONMENT_EC2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUD9_ENVIRONMENT_EC2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFORMATION_STACK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFORMATION_STACK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFRONT_DISTRIBUTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFRONT_DISTRIBUTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFRONT_STREAMING_DISTRIBUTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFRONT_STREAMING_DISTRIBUTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDTRAIL_TRAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDTRAIL_TRAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDWATCH_ALARM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDWATCH_ALARM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDWATCH_RUM_APP_MONITOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDWATCH_RUM_APP_MONITOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODE_ARTIFACT_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODE_ARTIFACT_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODE_BUILD_REPORT_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODE_BUILD_REPORT_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODE_GURU_PROFILER_PROFILING_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODE_GURU_PROFILER_PROFILING_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODE_GURU_REVIEWER_REPOSITORY_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODE_GURU_REVIEWER_REPOSITORY_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEBUILD_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEBUILD_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_DEPLOYMENT_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_DEPLOYMENT_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_DEPLOYMENT_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_DEPLOYMENT_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEPIPELINE_PIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEPIPELINE_PIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONFIG_CONFORMANCE_PACK_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONFIG_CONFORMANCE_PACK_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONFIG_RESOURCE_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONFIG_RESOURCE_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONNECT_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONNECT_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONNECT_PHONE_NUMBER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONNECT_PHONE_NUMBER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONNECT_QUICK_CONNECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONNECT_QUICK_CONNECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CUSTOMER_PROFILES_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CUSTOMER_PROFILES_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CUSTOMER_PROFILES_OBJECT_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CUSTOMER_PROFILES_OBJECT_TYPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_EFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_EFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_FSX_LUSTRE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_FSX_LUSTRE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_FSX_WINDOWS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_FSX_WINDOWS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_HDFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_HDFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_NFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_NFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_OBJECT_STORAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_OBJECT_STORAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_S3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_S3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_SMB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_SMB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_TASK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_TASK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DEVICE_FARM_INSTANCE_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DEVICE_FARM_INSTANCE_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DEVICE_FARM_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DEVICE_FARM_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DEVICE_FARM_TEST_GRID_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DEVICE_FARM_TEST_GRID_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DMS_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DMS_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DMS_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DMS_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DMS_REPLICATION_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DMS_REPLICATION_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DYNAMODB_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DYNAMODB_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EBS_VOLUME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EBS_VOLUME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_CAPACITY_RESERVATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_CAPACITY_RESERVATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_CARRIER_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_CARRIER_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_CLIENT_VPN_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_CLIENT_VPN_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_CUSTOMER_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_CUSTOMER_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_DHCP_OPTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_DHCP_OPTIONS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_EC2_FLEET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_EC2_FLEET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_EGRESS_ONLY_INTERNET_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_EGRESS_ONLY_INTERNET_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_EIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_EIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_FLOW_LOG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_FLOW_LOG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_HOST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_HOST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_INTERNET_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_INTERNET_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_IPAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_IPAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_IPAM_POOL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_IPAM_POOL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_IPAM_SCOPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_IPAM_SCOPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_LAUNCH_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_LAUNCH_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NAT_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NAT_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_INSIGHTS_PATH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_INSIGHTS_PATH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_INTERFACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_INTERFACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_PREFIX_LIST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_PREFIX_LIST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_REGISTERED_HA_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_REGISTERED_HA_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_ROUTE_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_ROUTE_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SPOT_FLEET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SPOT_FLEET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SUBNET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SUBNET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SUBNET_ROUTE_TABLE_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SUBNET_ROUTE_TABLE_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRAFFIC_MIRROR_FILTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRAFFIC_MIRROR_FILTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRAFFIC_MIRROR_SESSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRAFFIC_MIRROR_SESSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRAFFIC_MIRROR_TARGET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRAFFIC_MIRROR_TARGET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_ATTACHMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_ATTACHMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_CONNECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_CONNECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_MULTICAST_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_MULTICAST_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_ROUTE_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_ROUTE_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_ENDPOINT_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_ENDPOINT_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_PEERING_CONNECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_PEERING_CONNECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPN_CONNECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPN_CONNECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPN_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPN_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_PUBLIC_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_PUBLIC_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_PULL_THROUGH_CACHE_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_PULL_THROUGH_CACHE_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_REGISTRY_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_REGISTRY_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_CAPACITY_PROVIDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_CAPACITY_PROVIDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_TASK_DEFINITION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_TASK_DEFINITION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_TASK_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_TASK_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EFS_ACCESS_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EFS_ACCESS_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EFS_FILE_SYSTEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EFS_FILE_SYSTEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EKS_ADDON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EKS_ADDON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EKS_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EKS_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EKS_IDENTITY_PROVIDER_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EKS_IDENTITY_PROVIDER_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_APPLICATION_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_APPLICATION_VERSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTICSEARCH_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTICSEARCH_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELB_LOAD_BALANCER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELB_LOAD_BALANCER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELBV2_LISTENER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELBV2_LISTENER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELBV2_LOAD_BALANCER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELBV2_LOAD_BALANCER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EMR_SECURITY_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EMR_SECURITY_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENT_SCHEMAS_SCHEMA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENT_SCHEMAS_SCHEMA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_API_DESTINATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_API_DESTINATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_ARCHIVE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_ARCHIVE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_EVENTBUS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_EVENTBUS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTS_CONNECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTS_CONNECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTS_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTS_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTSCHEMAS_DISCOVERER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTSCHEMAS_DISCOVERER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTSCHEMAS_REGISTRY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTSCHEMAS_REGISTRY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTSCHEMAS_REGISTRY_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTSCHEMAS_REGISTRY_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVIDENTLY_LAUNCH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVIDENTLY_LAUNCH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVIDENTLY_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVIDENTLY_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FIS_EXPERIMENT_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FIS_EXPERIMENT_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FORECAST_DATASET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FORECAST_DATASET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FORECAST_DATASET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FORECAST_DATASET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_ENTITY_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_ENTITY_TYPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_LABEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_LABEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_OUTCOME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_OUTCOME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_VARIABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_VARIABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_ACCELERATOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_ACCELERATOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_ENDPOINT_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_ENDPOINT_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_LISTENER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_LISTENER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLUE_CLASSIFIER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLUE_CLASSIFIER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLUE_JOB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLUE_JOB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLUE_ML_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLUE_ML_TRANSFORM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GRAFANA_WORKSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GRAFANA_WORKSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GREENGRASSV2_COMPONENT_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GREENGRASSV2_COMPONENT_VERSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GROUND_STATION_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GROUND_STATION_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GROUNDSTATION_MISSION_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GROUNDSTATION_MISSION_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_DETECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_DETECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_FILTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_FILTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_IP_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_IP_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_THREAT_INTEL_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_THREAT_INTEL_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        HEALTH_LAKE_FHIR_DATASTORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "HEALTH_LAKE_FHIR_DATASTORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_ACCESSANALYZER_ANALYZER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_ACCESSANALYZER_ANALYZER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_INSTANCE_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_INSTANCE_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_ROLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_ROLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_SAML_PROVIDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_SAML_PROVIDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_SERVER_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_SERVER_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IMAGE_BUILDER_IMAGE_PIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IMAGE_BUILDER_IMAGE_PIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IMAGEBUILDER_CONTAINER_RECIPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IMAGEBUILDER_CONTAINER_RECIPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IMAGEBUILDER_DISTRIBUTION_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IMAGEBUILDER_DISTRIBUTION_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IMAGEBUILDER_INFRASTRUCTURE_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IMAGEBUILDER_INFRASTRUCTURE_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        INSPECTORV2_FILTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "INSPECTORV2_FILTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ACCOUNT_AUDIT_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ACCOUNT_AUDIT_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_CHANNEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_CHANNEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_DATASET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_DATASET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_DATASTORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_DATASTORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_PIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_PIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_AUTHORIZER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_AUTHORIZER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_CA_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_CA_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_CUSTOM_METRIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_CUSTOM_METRIC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_DIMENSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_DIMENSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_EVENTS_ALARM_MODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_EVENTS_ALARM_MODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_EVENTS_DETECTOR_MODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_EVENTS_DETECTOR_MODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_EVENTS_INPUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_EVENTS_INPUT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_FLEET_METRIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_FLEET_METRIC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_JOB_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_JOB_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_MITIGATION_ACTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_MITIGATION_ACTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_PROVISIONING_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_PROVISIONING_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ROLE_ALIAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ROLE_ALIAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SCHEDULED_AUDIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SCHEDULED_AUDIT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SECURITY_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SECURITY_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_ASSETMODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_ASSETMODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_DASHBOARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_DASHBOARD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_PORTAL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_PORTAL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_TWIN_MAKER_COMPONENT_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_TWIN_MAKER_COMPONENT_TYPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_TWIN_MAKER_SCENE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_TWIN_MAKER_SCENE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_TWIN_MAKER_SYNC_JOB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_TWIN_MAKER_SYNC_JOB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_TWINMAKER_ENTITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_TWINMAKER_ENTITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_TWINMAKER_WORKSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_TWINMAKER_WORKSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_WIRELESS_FUOTA_TASK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_WIRELESS_FUOTA_TASK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_WIRELESS_MULTICAST_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_WIRELESS_MULTICAST_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_WIRELESS_SERVICE_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_WIRELESS_SERVICE_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IVS_CHANNEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IVS_CHANNEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IVS_PLAYBACK_KEYPAIR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IVS_PLAYBACK_KEYPAIR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IVS_RECORDING_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IVS_RECORDING_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KAFKA_CONNECT_CONNECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KAFKA_CONNECT_CONNECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KENDRA_INDEX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KENDRA_INDEX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_ANALYTICS_V2_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_ANALYTICS_V2_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_FIREHOSE_DELIVERY_STREAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_FIREHOSE_DELIVERY_STREAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_STREAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_STREAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_STREAM_CONSUMER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_STREAM_CONSUMER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_VIDEO_SIGNALING_CHANNEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_VIDEO_SIGNALING_CHANNEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_VIDEO_STREAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_VIDEO_STREAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KMS_ALIAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KMS_ALIAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KMS_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KMS_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LAMBDA_CODE_SIGNING_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LAMBDA_CODE_SIGNING_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LAMBDA_FUNCTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LAMBDA_FUNCTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LEX_BOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LEX_BOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LEX_BOT_ALIAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LEX_BOT_ALIAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_BUCKET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_BUCKET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_DISK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_DISK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_STATIC_IP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_STATIC_IP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LOGS_DESTINATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LOGS_DESTINATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LOOKOUT_METRICS_ALERT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LOOKOUT_METRICS_ALERT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LOOKOUT_VISION_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LOOKOUT_VISION_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MEDIA_CONNECT_FLOW_SOURCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MEDIA_CONNECT_FLOW_SOURCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MEDIA_PACKAGE_PACKAGING_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MEDIA_PACKAGE_PACKAGING_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MEDIACONNECT_FLOW_ENTITLEMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MEDIACONNECT_FLOW_ENTITLEMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MEDIACONNECT_FLOW_VPC_INTERFACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MEDIACONNECT_FLOW_VPC_INTERFACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MEDIAPACKAGE_PACKAGING_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MEDIAPACKAGE_PACKAGING_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MEDIATAILOR_PLAYBACK_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MEDIATAILOR_PLAYBACK_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MSK_BATCH_SCRAM_SECRET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MSK_BATCH_SCRAM_SECRET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MSK_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MSK_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MSK_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MSK_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_FIREWALL_FIREWALL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_FIREWALL_FIREWALL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_FIREWALL_FIREWALL_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_FIREWALL_FIREWALL_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_FIREWALL_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_FIREWALL_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_FIREWALL_TLS_INSPECTION_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_FIREWALL_TLS_INSPECTION_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_CONNECT_PEER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_CONNECT_PEER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_CUSTOMER_GATEWAY_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_CUSTOMER_GATEWAY_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_DEVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_DEVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_GLOBAL_NETWORK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_GLOBAL_NETWORK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_LINK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_LINK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_LINK_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_LINK_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_SITE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_SITE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_MANAGER_TRANSIT_GATEWAY_REGISTRATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_MANAGER_TRANSIT_GATEWAY_REGISTRATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        OPENSEARCH_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "OPENSEARCH_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PANORAMA_PACKAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PANORAMA_PACKAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PERSONALIZE_DATASET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PERSONALIZE_DATASET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PERSONALIZE_DATASET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PERSONALIZE_DATASET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PERSONALIZE_SCHEMA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PERSONALIZE_SCHEMA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PERSONALIZE_SOLUTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PERSONALIZE_SOLUTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_APP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_APP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_APPLICATION_SETTINGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_APPLICATION_SETTINGS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_CAMPAIGN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_CAMPAIGN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_EMAIL_CHANNEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_EMAIL_CHANNEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_EMAIL_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_EMAIL_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_EVENT_STREAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_EVENT_STREAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_IN_APP_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_IN_APP_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        PINPOINT_SEGMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "PINPOINT_SEGMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        QLDB_LEDGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "QLDB_LEDGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_CLUSTER_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_CLUSTER_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_GLOBAL_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_GLOBAL_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_OPTION_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_OPTION_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_PARAMETER_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_PARAMETER_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_SCHEDULED_ACTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_SCHEDULED_ACTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RESILIENCEHUB_APP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RESILIENCEHUB_APP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RESILIENCEHUB_RESILIENCY_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RESILIENCEHUB_RESILIENCY_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RESOURCE_EXPLORER2_INDEX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RESOURCE_EXPLORER2_INDEX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROBO_MAKER_ROBOT_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROBO_MAKER_ROBOT_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROBO_MAKER_ROBOT_APPLICATION_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROBO_MAKER_ROBOT_APPLICATION_VERSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROBO_MAKER_SIMULATION_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROBO_MAKER_SIMULATION_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_HEALTH_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_HEALTH_CHECK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_HOSTED_ZONE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_HOSTED_ZONE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_CONTROL_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_CONTROL_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_CONTROL_CONTROL_PANEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_CONTROL_CONTROL_PANEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_CONTROL_ROUTING_CONTROL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_CONTROL_ROUTING_CONTROL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_CONTROL_SAFETY_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_CONTROL_SAFETY_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_READINESS_CELL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_READINESS_CELL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_READINESS_READINESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_READINESS_READINESS_CHECK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_READINESS_RECOVERY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_READINESS_RECOVERY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_READINESS_RESOURCE_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_READINESS_RESOURCE_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_FIREWALL_DOMAIN_LIST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_FIREWALL_DOMAIN_LIST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_FIREWALL_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_FIREWALL_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_FIREWALL_RULE_GROUP_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_FIREWALL_RULE_GROUP_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_QUERY_LOGGING_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_QUERY_LOGGING_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_QUERY_LOGGING_CONFIG_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_QUERY_LOGGING_CONFIG_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_ACCESS_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_ACCESS_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_ACCOUNT_PUBLIC_ACCESS_BLOCK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_ACCOUNT_PUBLIC_ACCESS_BLOCK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_BUCKET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_BUCKET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_MULTIREGION_ACCESS_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_MULTIREGION_ACCESS_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_STORAGE_LENS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_STORAGE_LENS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGE_MAKER_APP_IMAGE_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGE_MAKER_APP_IMAGE_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGE_MAKER_IMAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGE_MAKER_IMAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_CODE_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_CODE_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_FEATURE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_FEATURE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_MODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_MODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_NOTEBOOK_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_NOTEBOOK_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_WORKTEAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_WORKTEAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SECRETS_MANAGER_SECRET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SECRETS_MANAGER_SECRET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_CLOUDFORMATION_PRODUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_CLOUDFORMATION_PRODUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_PORTFOLIO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_PORTFOLIO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_DISCOVERY_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_DISCOVERY_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_HTTP_NAMESPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_HTTP_NAMESPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_CONFIGURATION_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_CONFIGURATION_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_CONTACT_LIST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_CONTACT_LIST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_RECEIPT_FILTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_RECEIPT_FILTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_RECEIPT_RECEIPT_RULE_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_RECEIPT_RECEIPT_RULE_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SHIELD_PROTECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SHIELD_PROTECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SHIELD_REGIONAL_PROTECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SHIELD_REGIONAL_PROTECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SIGNER_SIGNING_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SIGNER_SIGNING_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SNS_TOPIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SNS_TOPIC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SQS_QUEUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SQS_QUEUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        STEPFUNCTIONS_ACTIVITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "STEPFUNCTIONS_ACTIVITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        STEPFUNCTIONS_STATE_MACHINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "STEPFUNCTIONS_STATE_MACHINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_FILE_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_FILE_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_PATCH_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_PATCH_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        TRANSFER_AGREEMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "TRANSFER_AGREEMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        TRANSFER_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "TRANSFER_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        TRANSFER_CONNECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "TRANSFER_CONNECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        TRANSFER_WORKFLOW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "TRANSFER_WORKFLOW", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RATE_BASED_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RATE_BASED_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RATE_BASED_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RATE_BASED_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_IP_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_IP_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_MANAGED_RULE_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_MANAGED_RULE_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_REGEX_PATTERN_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_REGEX_PATTERN_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WORKSPACES_CONNECTION_ALIAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WORKSPACES_CONNECTION_ALIAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WORKSPACES_WORKSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WORKSPACES_WORKSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        XRAY_ENCRYPTION_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "XRAY_ENCRYPTION_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
    }

    /**
     * A custom resource type to support future cases.
     * <p>
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.ResourceType of(final @org.jetbrains.annotations.NotNull java.lang.String type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.ResourceType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * AWS Certificate manager certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ACM_CERTIFICATE;

    /**
     * AWS Private Certificate Authority CertificateAuthority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ACMPCA_CERTIFICATE_AUTHORITY;

    /**
     * AWS Private Certificate Authority CertificateAuthorityActivation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ACMPCA_CERTIFICATE_AUTHORITY_ACTIVATION;

    /**
     * Amazon MQ broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AMAZON_MQ_BROKER;

    /**
     * AWS Amplify App.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AMPLIFY_APP;

    /**
     * AWS Amplify Branch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AMPLIFY_BRANCH;

    /**
     * API Gateway REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAY_REST_API;

    /**
     * API Gateway Stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAY_STAGE;

    /**
     * API Gatewayv2 API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAYV2_API;

    /**
     * API Gatewayv2 Stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAYV2_STAGE;

    /**
     * AWS AppConfig Deployment Strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_CONFIG_DEPLOYMENT_STRATEGY;

    /**
     * AWS AppConfig HostedConfigurationVersion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_CONFIG_HOSTED_CONFIGURATION_VERSION;

    /**
     * Amazon AppFlow Flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_FLOW_FLOW;

    /**
     * Amazon AppIntegrations EventIntegration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_INTEGRATIONS_EVENT_INTEGRATION;

    /**
     * AWS AppMesh GatewayRoute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_MESH_GATEWAY_ROUTE;

    /**
     * AWS AppMesh Mesh.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_MESH_MESH;

    /**
     * AWS AppMesh Route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_MESH_ROUTE;

    /**
     * AWS AppMesh VirtualGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_MESH_VIRTUAL_GATEWAY;

    /**
     * AWS AppMesh VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_MESH_VIRTUAL_NODE;

    /**
     * AWS AppMesh VirtualRouter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_MESH_VIRTUAL_ROUTER;

    /**
     * AWS AppMesh VirtualService.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_MESH_VIRTUAL_SERVICE;

    /**
     * AWS AppRunner Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_RUNNER_SERVICE;

    /**
     * AWS AppRunner VpcConnector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_RUNNER_VPC_CONNECTOR;

    /**
     * Amazon AppStream Application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_STREAM_APPLICATION;

    /**
     * Amazon AppStream Directory Config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_STREAM_DIRECTORY_CONFIG;

    /**
     * Amazon AppStream Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_STREAM_FLEET;

    /**
     * Amazon AppStream Stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APP_STREAM_STACK;

    /**
     * AWS AppConfig application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPCONFIG_APPLICATION;

    /**
     * AWS AppConfig configuration profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPCONFIG_CONFIGURATION_PROFILE;

    /**
     * AWS AppConfig environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPCONFIG_ENVIRONMENT;

    /**
     * AWS AppSync GraphQL Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPSYNC_GRAPHQL_API;

    /**
     * Amazon Managed Service for Prometheus RuleGroupsNamespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APS_RULE_GROUPS_NAMESPACE;

    /**
     * Amazon Athena PreparedStatement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ATHENA_PREPARED_STATEMENT;

    /**
     * AWS AuditManager Assessment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUDIT_MANAGER_ASSESSMENT;

    /**
     * AWS Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_GROUP;

    /**
     * AWS Auto Scaling launch configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_LAUNCH_CONFIGURATION;

    /**
     * AWS Auto Scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_POLICY;

    /**
     * AWS Auto Scaling scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_SCHEDULED_ACTION;

    /**
     * EC2 Auto Scaling Warm Pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_WARM_POOL;

    /**
     * AWS Backup backup plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_PLAN;

    /**
     * AWS Backup backup selection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_SELECTION;

    /**
     * AWS Backup backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_VAULT;

    /**
     * AWS Backup recovery point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_RECOVERY_POINT;

    /**
     * AWS Backup report plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_REPORT_PLAN;

    /**
     * AWS Batch compute environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BATCH_COMPUTE_ENVIRONMENT;

    /**
     * AWS Batch job queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BATCH_JOB_QUEUE;

    /**
     * AWS Batch SchedulingPolicy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BATCH_SCHEDULING_POLICY;

    /**
     * AWS Budgets Budgets Action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BUDGETS_BUDGETS_ACTION;

    /**
     * Amazon KeySpaces Cassandra Keyspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CASSANDRA_KEYSPACE;

    /**
     * Amazon CloudWatch Metric Stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUD_WATCH_METRIC_STREAM;

    /**
     * AWS Cloud9 environment EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUD9_ENVIRONMENT_EC2;

    /**
     * AWS CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFORMATION_STACK;

    /**
     * Amazon CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFRONT_DISTRIBUTION;

    /**
     * Amazon CloudFront streaming distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFRONT_STREAMING_DISTRIBUTION;

    /**
     * AWS CloudTrail trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDTRAIL_TRAIL;

    /**
     * Amazon CloudWatch Alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDWATCH_ALARM;

    /**
     * Amazon CloudWatch RUM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDWATCH_RUM_APP_MONITOR;

    /**
     * AWS CodeArtifact Repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODE_ARTIFACT_REPOSITORY;

    /**
     * AWS CodeBuild ReportGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODE_BUILD_REPORT_GROUP;

    /**
     * Amazon CodeGuruP rofiler ProfilingGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODE_GURU_PROFILER_PROFILING_GROUP;

    /**
     * Amazon CodeGuru Reviewer Repository Association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODE_GURU_REVIEWER_REPOSITORY_ASSOCIATION;

    /**
     * AWS CodeBuild project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEBUILD_PROJECT;

    /**
     * AWS CodeDeploy application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_APPLICATION;

    /**
     * AWS CodeDeploy deployment config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_DEPLOYMENT_CONFIG;

    /**
     * AWS CodeDeploy deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_DEPLOYMENT_GROUP;

    /**
     * AWS CodePipeline pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEPIPELINE_PIPELINE;

    /**
     * AWS Config conformance pack compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONFIG_CONFORMANCE_PACK_COMPLIANCE;

    /**
     * AWS Config resource compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONFIG_RESOURCE_COMPLIANCE;

    /**
     * Amazon Connect Instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONNECT_INSTANCE;

    /**
     * Amazon Connect Phone Number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONNECT_PHONE_NUMBER;

    /**
     * Amazon Connect QuickConnect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONNECT_QUICK_CONNECT;

    /**
     * Amazon Connect Customer Profiles Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CUSTOMER_PROFILES_DOMAIN;

    /**
     * Amazon Connect CustomerProfiles ObjectType.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CUSTOMER_PROFILES_OBJECT_TYPE;

    /**
     * AWS DataSync location EFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_EFS;

    /**
     * AWS DataSync location FSx Lustre.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_FSX_LUSTRE;

    /**
     * AWS DataSync location FSx Windows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_FSX_WINDOWS;

    /**
     * AWS DataSync location HDFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_HDFS;

    /**
     * AWS DataSync location NFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_NFS;

    /**
     * AWS DataSync location object storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_OBJECT_STORAGE;

    /**
     * AWS DataSync location S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_S3;

    /**
     * AWS DataSync location SMB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_SMB;

    /**
     * AWS DataSync task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_TASK;

    /**
     * AWS DeviceFarm Instance Profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DEVICE_FARM_INSTANCE_PROFILE;

    /**
     * AWS DeviceFarm Project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DEVICE_FARM_PROJECT;

    /**
     * AWS Device Farm Test Grid Project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DEVICE_FARM_TEST_GRID_PROJECT;

    /**
     * AWS DMS Endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DMS_ENDPOINT;

    /**
     * AWS DMS event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DMS_EVENT_SUBSCRIPTION;

    /**
     * AWS DMS replication subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DMS_REPLICATION_SUBNET_GROUP;

    /**
     * Amazon DynamoDB Table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DYNAMODB_TABLE;

    /**
     * Elastic Block Store (EBS) volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EBS_VOLUME;

    /**
     * EC2 CapacityReservation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_CAPACITY_RESERVATION;

    /**
     * EC2 CarrierGateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_CARRIER_GATEWAY;

    /**
     * EC2 ClientVpnEndpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_CLIENT_VPN_ENDPOINT;

    /**
     * Amazon EC2 customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_CUSTOMER_GATEWAY;

    /**
     * EC2 DHCP Options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_DHCP_OPTIONS;

    /**
     * EC2 EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_EC2_FLEET;

    /**
     * EC2 Egress only internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_EGRESS_ONLY_INTERNET_GATEWAY;

    /**
     * EC2 Elastic IP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_EIP;

    /**
     * EC2 flow log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_FLOW_LOG;

    /**
     * EC2 host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_HOST;

    /**
     * EC2 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_INSTANCE;

    /**
     * Amazon EC2 internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_INTERNET_GATEWAY;

    /**
     * EC2 IPAM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_IPAM;

    /**
     * EC2 IPAMPool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_IPAM_POOL;

    /**
     * EC2 IPAMScope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_IPAM_SCOPE;

    /**
     * EC2 launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_LAUNCH_TEMPLATE;

    /**
     * EC2 NAT gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NAT_GATEWAY;

    /**
     * Amazon EC2 network ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_ACL;

    /**
     * EC2 Network Insights Access Scope Analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS;

    /**
     * EC2 Network Insights Path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_INSIGHTS_PATH;

    /**
     * EC2 Network Interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_INTERFACE;

    /**
     * EC2 PrefixList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_PREFIX_LIST;

    /**
     * EC2 registered HA instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_REGISTERED_HA_INSTANCE;

    /**
     * Amazon EC2 route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_ROUTE_TABLE;

    /**
     * EC2 security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SECURITY_GROUP;

    /**
     * EC2 SpotFleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SPOT_FLEET;

    /**
     * Amazon EC2 subnet table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SUBNET;

    /**
     * EC2 Subnet Route Table Association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SUBNET_ROUTE_TABLE_ASSOCIATION;

    /**
     * EC2 Traffic Mirror Filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRAFFIC_MIRROR_FILTER;

    /**
     * EC2 Traffic Mirror Session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRAFFIC_MIRROR_SESSION;

    /**
     * EC2 Traffic Mirror Target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRAFFIC_MIRROR_TARGET;

    /**
     * EC2 transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY;

    /**
     * EC2 transit gateway attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_ATTACHMENT;

    /**
     * EC2 TransitGatewayConnect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_CONNECT;

    /**
     * EC2 TransitGatewayMulticastDomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_MULTICAST_DOMAIN;

    /**
     * EC2 transit gateway route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_ROUTE_TABLE;

    /**
     * Amazon EC2 VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC;

    /**
     * EC2 VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_ENDPOINT;

    /**
     * EC2 VPC endpoint service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_ENDPOINT_SERVICE;

    /**
     * EC2 VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_PEERING_CONNECTION;

    /**
     * Amazon EC2 VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPN_CONNECTION;

    /**
     * Amazon EC2 VPN gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPN_GATEWAY;

    /**
     * Amazon ECR public repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_PUBLIC_REPOSITORY;

    /**
     * Amazon ECR PullThrough Cache Rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_PULL_THROUGH_CACHE_RULE;

    /**
     * Amazon ECR registry policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_REGISTRY_POLICY;

    /**
     * Amazon ECR repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_REPOSITORY;

    /**
     * Amazon ECS CapacityProvider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_CAPACITY_PROVIDER;

    /**
     * Amazon ECS cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_CLUSTER;

    /**
     * Amazon ECS service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_SERVICE;

    /**
     * Amazon ECS task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_TASK_DEFINITION;

    /**
     * Amazon ECS TaskSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_TASK_SET;

    /**
     * Amazon EFS access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EFS_ACCESS_POINT;

    /**
     * Amazon EFS file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EFS_FILE_SYSTEM;

    /**
     * Amazon Elastic Kubernetes Service addon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EKS_ADDON;

    /**
     * Amazon Elastic Kubernetes Service cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EKS_CLUSTER;

    /**
     * Amazon Elastic Kubernetes Service identity provider config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EKS_IDENTITY_PROVIDER_CONFIG;

    /**
     * AWS Elastic Beanstalk (EB) application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_APPLICATION;

    /**
     * AWS Elastic Beanstalk (EB) application version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_APPLICATION_VERSION;

    /**
     * AWS Elastic Beanstalk (EB) environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_ENVIRONMENT;

    /**
     * Amazon ElasticSearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTICSEARCH_DOMAIN;

    /**
     * AWS ELB classic load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELB_LOAD_BALANCER;

    /**
     * AWS ELBv2 application load balancer listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELBV2_LISTENER;

    /**
     * AWS ELBv2 network load balancer or AWS ELBv2 application load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELBV2_LOAD_BALANCER;

    /**
     * Amazon EMR security configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EMR_SECURITY_CONFIGURATION;

    /**
     * Amazon EventBridge Schemas Schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENT_SCHEMAS_SCHEMA;

    /**
     * Amazon EventBridge Api Destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_API_DESTINATION;

    /**
     * Amazon EventBridge Archive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_ARCHIVE;

    /**
     * Amazon EventBridge Endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_ENDPOINT;

    /**
     * Amazon EventBridge EventBus.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_EVENTBUS;

    /**
     * Amazon EventBridge Connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTS_CONNECTION;

    /**
     * Amazon EventBridge Events Rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTS_RULE;

    /**
     * Amazon EventBridge EventSchemas discoverer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTSCHEMAS_DISCOVERER;

    /**
     * Amazon EventBridge EventSchemas registry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTSCHEMAS_REGISTRY;

    /**
     * Amazon EventBridge EventSchemas registry policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTSCHEMAS_REGISTRY_POLICY;

    /**
     * Amazon CloudWatch Evidently Launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVIDENTLY_LAUNCH;

    /**
     * Amazon CloudWatch Evidently Project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVIDENTLY_PROJECT;

    /**
     * AWS Fault Injection Simulator Experiment_Template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FIS_EXPERIMENT_TEMPLATE;

    /**
     * Amazon Forecast Dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FORECAST_DATASET;

    /**
     * Amazon Forecast DatasetGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FORECAST_DATASET_GROUP;

    /**
     * AWS FraudDetector entity type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_ENTITY_TYPE;

    /**
     * AWS FraudDetector label.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_LABEL;

    /**
     * AWS FraudDetector outcome.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_OUTCOME;

    /**
     * AWS FraudDetector variable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_VARIABLE;

    /**
     * AWS GlobalAccelerator accelerator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_ACCELERATOR;

    /**
     * AWS GlobalAccelerator endpoint group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_ENDPOINT_GROUP;

    /**
     * AWS GlobalAccelerator listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_LISTENER;

    /**
     * AWS Glue Classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLUE_CLASSIFIER;

    /**
     * AWS Glue Job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLUE_JOB;

    /**
     * AWS Glue machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLUE_ML_TRANSFORM;

    /**
     * Amazon Managed Grafana Workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GRAFANA_WORKSPACE;

    /**
     * AWS IoT Greengrass Version2 ComponentVersion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GREENGRASSV2_COMPONENT_VERSION;

    /**
     * AWS GroundStation Config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GROUND_STATION_CONFIG;

    /**
     * AWS GroundStation MissionProfile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GROUNDSTATION_MISSION_PROFILE;

    /**
     * Amazon GuardDuty detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_DETECTOR;

    /**
     * Amazon GuardDuty Filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_FILTER;

    /**
     * Amazon GuardDuty IP Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_IP_SET;

    /**
     * Amazon GuardDuty Threat Intel Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_THREAT_INTEL_SET;

    /**
     * AWS HealthLake FHIR Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType HEALTH_LAKE_FHIR_DATASTORE;

    /**
     * AWS IAM AccessAnalyzer analyzer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_ACCESSANALYZER_ANALYZER;

    /**
     * AWS IAM group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_GROUP;

    /**
     * AWS IAM InstanceProfile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_INSTANCE_PROFILE;

    /**
     * AWS IAM policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_POLICY;

    /**
     * AWS IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_ROLE;

    /**
     * AWS IAM SAMLProvider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_SAML_PROVIDER;

    /**
     * AWS IAM ServerCertificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_SERVER_CERTIFICATE;

    /**
     * AWS IAM user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_USER;

    /**
     * EC2 Image Builder Image Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IMAGE_BUILDER_IMAGE_PIPELINE;

    /**
     * EC2 Image Builder ContainerRecipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IMAGEBUILDER_CONTAINER_RECIPE;

    /**
     * EC2 Image Builder DistributionConfiguration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IMAGEBUILDER_DISTRIBUTION_CONFIGURATION;

    /**
     * EC2 Image Builder InfrastructureConfiguration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IMAGEBUILDER_INFRASTRUCTURE_CONFIGURATION;

    /**
     * Amazon Inspector Filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType INSPECTORV2_FILTER;

    /**
     * AWS IoT Account Audit Configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ACCOUNT_AUDIT_CONFIGURATION;

    /**
     * AWS IoT Analytics channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_CHANNEL;

    /**
     * AWS IoT Analytics dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_DATASET;

    /**
     * AWS IoT Analytics datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_DATASTORE;

    /**
     * AWS IoT Analytics pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_PIPELINE;

    /**
     * AWS IoT authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_AUTHORIZER;

    /**
     * AWS IoT CACertificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_CA_CERTIFICATE;

    /**
     * AWS IoT Custom Metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_CUSTOM_METRIC;

    /**
     * AWS IoT dimension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_DIMENSION;

    /**
     * AWS IoT Events Alarm Model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_EVENTS_ALARM_MODEL;

    /**
     * AWS IoT Events Detector Model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_EVENTS_DETECTOR_MODEL;

    /**
     * AWS IoT Events Input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_EVENTS_INPUT;

    /**
     * AWS IoT Fleet Metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_FLEET_METRIC;

    /**
     * AWS IoT JobTemplate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_JOB_TEMPLATE;

    /**
     * AWS IoT mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_MITIGATION_ACTION;

    /**
     * AWS IoT policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_POLICY;

    /**
     * AWS IoT ProvisioningTemplate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_PROVISIONING_TEMPLATE;

    /**
     * AWS IoT role alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ROLE_ALIAS;

    /**
     * AWS IoT Scheduled Audit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SCHEDULED_AUDIT;

    /**
     * AWS IoT security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SECURITY_PROFILE;

    /**
     * AWS IoT SiteWise asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_ASSETMODEL;

    /**
     * AWS IoT SiteWise dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_DASHBOARD;

    /**
     * AWS IoT SiteWise Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_GATEWAY;

    /**
     * AWS IoT SiteWise portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_PORTAL;

    /**
     * AWS IoT SiteWise project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_PROJECT;

    /**
     * AWS IoT TwinMaker ComponentType.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_TWIN_MAKER_COMPONENT_TYPE;

    /**
     * AWS IoT Twin Maker Scene.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_TWIN_MAKER_SCENE;

    /**
     * AWS IoT TwinMaker SyncJob.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_TWIN_MAKER_SYNC_JOB;

    /**
     * AWS IoT TwinMaker entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_TWINMAKER_ENTITY;

    /**
     * AWS IoT TwinMaker workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_TWINMAKER_WORKSPACE;

    /**
     * AWS IoT Wireless FuotaTask.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_WIRELESS_FUOTA_TASK;

    /**
     * AWS IoT Wireless MulticastGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_WIRELESS_MULTICAST_GROUP;

    /**
     * AWS IoTWireless Service Profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_WIRELESS_SERVICE_PROFILE;

    /**
     * Amazon Interactive Video Service (IVS) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IVS_CHANNEL;

    /**
     * Amazon Interactive Video Service (IVS) playback key pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IVS_PLAYBACK_KEYPAIR;

    /**
     * Amazon Interactive Video Service (IVS) recording configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IVS_RECORDING_CONFIGURATION;

    /**
     * Amazon Managed Streaming for Apache Kafka Connect Connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KAFKA_CONNECT_CONNECTOR;

    /**
     * Amazon Kendra Index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KENDRA_INDEX;

    /**
     * Amazon Kinesis Analytics V2 application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_ANALYTICS_V2_APPLICATION;

    /**
     * Amazon Data Firehose DeliveryStream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_FIREHOSE_DELIVERY_STREAM;

    /**
     * Amazon Kinesis stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_STREAM;

    /**
     * Amazon Kinesis stream consumer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_STREAM_CONSUMER;

    /**
     * Amazon Kinesis Video Streams Signaling Channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_VIDEO_SIGNALING_CHANNEL;

    /**
     * Amazon Kinesis Video Stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_VIDEO_STREAM;

    /**
     * AWS KMS Alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KMS_ALIAS;

    /**
     * AWS KMS Key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KMS_KEY;

    /**
     * AWS Lambda CodeSigningConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LAMBDA_CODE_SIGNING_CONFIG;

    /**
     * AWS Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LAMBDA_FUNCTION;

    /**
     * Amazon Lex Bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LEX_BOT;

    /**
     * Amazon Lex Bot Alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LEX_BOT_ALIAS;

    /**
     * AWS Lightsail bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_BUCKET;

    /**
     * Amazon Lightsail Certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_CERTIFICATE;

    /**
     * Amazon Lightsail Disk.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_DISK;

    /**
     * AWS Lightsail static IP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_STATIC_IP;

    /**
     * Amazon CloudWatch Logs Destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LOGS_DESTINATION;

    /**
     * AWS Lookout Metrics Alert.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LOOKOUT_METRICS_ALERT;

    /**
     * Amazon Lookout Vision Project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LOOKOUT_VISION_PROJECT;

    /**
     * AWS Elemental MediaConnect FlowSource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MEDIA_CONNECT_FLOW_SOURCE;

    /**
     * AWS Elemental MediaPackage Packaging Configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MEDIA_PACKAGE_PACKAGING_CONFIGURATION;

    /**
     * AWS Elemental MediaConnect FlowEntitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MEDIACONNECT_FLOW_ENTITLEMENT;

    /**
     * AWS Elemental MediaConnect FlowVpcInterface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MEDIACONNECT_FLOW_VPC_INTERFACE;

    /**
     * AWS Elemental MediaPackage packaging group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MEDIAPACKAGE_PACKAGING_GROUP;

    /**
     * AWS Elemental MediaTailor PlaybackConfiguration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MEDIATAILOR_PLAYBACK_CONFIGURATION;

    /**
     * Amazon MSK BatchScramSecret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MSK_BATCH_SCRAM_SECRET;

    /**
     * Amazon MSK cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MSK_CLUSTER;

    /**
     * Amazon MSK Configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MSK_CONFIGURATION;

    /**
     * AWS Network Firewall Firewall.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_FIREWALL_FIREWALL;

    /**
     * AWS Network Firewall Firewall Policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_FIREWALL_FIREWALL_POLICY;

    /**
     * AWS Network Firewall Rule Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_FIREWALL_RULE_GROUP;

    /**
     * AWS NetworkFirewall TLSInspectionConfiguration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_FIREWALL_TLS_INSPECTION_CONFIGURATION;

    /**
     * AWS NetworkManager ConnectPeer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_CONNECT_PEER;

    /**
     * AWS NetworkManager CustomerGatewayAssociation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_CUSTOMER_GATEWAY_ASSOCIATION;

    /**
     * AWS Network Manager Device.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_DEVICE;

    /**
     * AWS Network Manager Global Network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_GLOBAL_NETWORK;

    /**
     * AWS NetworkManager Link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_LINK;

    /**
     * AWS NetworkManager LinkAssociation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_LINK_ASSOCIATION;

    /**
     * AWS NetworkManager Site.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_SITE;

    /**
     * AWS Network Manager Transit Gateway Registration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_MANAGER_TRANSIT_GATEWAY_REGISTRATION;

    /**
     * Amazon OpenSearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType OPENSEARCH_DOMAIN;

    /**
     * AWS Panorama Package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PANORAMA_PACKAGE;

    /**
     * Amazon Personalize Dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PERSONALIZE_DATASET;

    /**
     * Amazon Personalize DatasetGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PERSONALIZE_DATASET_GROUP;

    /**
     * Amazon Personalize Schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PERSONALIZE_SCHEMA;

    /**
     * Amazon Personalize Solution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PERSONALIZE_SOLUTION;

    /**
     * Amazon Pinpoint App.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_APP;

    /**
     * Amazon Pinpoint Application Settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_APPLICATION_SETTINGS;

    /**
     * Amazon Pinpoint Campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_CAMPAIGN;

    /**
     * Amazon Pinpoint EmailChannel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_EMAIL_CHANNEL;

    /**
     * Amazon Pinpoint EmailTemplate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_EMAIL_TEMPLATE;

    /**
     * Amazon Pinpoint EventStream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_EVENT_STREAM;

    /**
     * Amazon Pinpoint InAppTemplate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_IN_APP_TEMPLATE;

    /**
     * Amazon Pinpoint Segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType PINPOINT_SEGMENT;

    /**
     * Amazon QLDB ledger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType QLDB_LEDGER;

    /**
     * Amazon RDS database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_CLUSTER;

    /**
     * Amazon RDS database cluster snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_CLUSTER_SNAPSHOT;

    /**
     * Amazon RDS database instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_INSTANCE;

    /**
     * Amazon RDS database security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SECURITY_GROUP;

    /**
     * Amazon RDS database snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SNAPSHOT;

    /**
     * Amazon RDS database subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SUBNET_GROUP;

    /**
     * Amazon RDS event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_EVENT_SUBSCRIPTION;

    /**
     * Amazon RDS global cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_GLOBAL_CLUSTER;

    /**
     * Amazon RDS OptionGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_OPTION_GROUP;

    /**
     * Amazon Redshift cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER;

    /**
     * Amazon Redshift cluster parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_PARAMETER_GROUP;

    /**
     * Amazon Redshift cluster security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SECURITY_GROUP;

    /**
     * Amazon Redshift cluster snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SNAPSHOT;

    /**
     * Amazon Redshift cluster subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SUBNET_GROUP;

    /**
     * Amazon Redshift event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_EVENT_SUBSCRIPTION;

    /**
     * Amazon Redshift Scheduled Action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_SCHEDULED_ACTION;

    /**
     * AWS ResilienceHub App.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RESILIENCEHUB_APP;

    /**
     * AWS ResilienceHub resiliency policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RESILIENCEHUB_RESILIENCY_POLICY;

    /**
     * AWS Resource Explorer Index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RESOURCE_EXPLORER2_INDEX;

    /**
     * AWS RoboMaker Robot Application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROBO_MAKER_ROBOT_APPLICATION;

    /**
     * AWS RoboMaker Robot Application Version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROBO_MAKER_ROBOT_APPLICATION_VERSION;

    /**
     * AWS RoboMaker Simulation Application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROBO_MAKER_SIMULATION_APPLICATION;

    /**
     * Amazon Route53 Health Check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_HEALTH_CHECK;

    /**
     * Amazon Route53 Hosted Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_HOSTED_ZONE;

    /**
     * Amazon Route53 Recovery Control Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_CONTROL_CLUSTER;

    /**
     * Amazon Route53 Recovery Control Control Panel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_CONTROL_CONTROL_PANEL;

    /**
     * Amazon Route53 Recovery Control Routing Control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_CONTROL_ROUTING_CONTROL;

    /**
     * Amazon Route53 Recovery Control Safety Rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_CONTROL_SAFETY_RULE;

    /**
     * Amazon Route 53 Application Recovery Controller Cell.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_READINESS_CELL;

    /**
     * Amazon Route 53 Application Recovery Controller Readiness Check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_READINESS_READINESS_CHECK;

    /**
     * Amazon Route53 recovery readiness recovery group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_READINESS_RECOVERY_GROUP;

    /**
     * Amazon Route53 Recovery Readiness Resource Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_READINESS_RESOURCE_SET;

    /**
     * Amazon Route53 Resolver Firewall Domain List.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_FIREWALL_DOMAIN_LIST;

    /**
     * AWS Route53 Resolver FirewallRuleGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_FIREWALL_RULE_GROUP;

    /**
     * Amazon Route53 Resolver Firewall Rule Group Association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_FIREWALL_RULE_GROUP_ASSOCIATION;

    /**
     * Amazon Route53 Resolver ResolverQueryLoggingConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_QUERY_LOGGING_CONFIG;

    /**
     * Amazon Route53 Resolver ResolverQueryLoggingConfigAssociation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_QUERY_LOGGING_CONFIG_ASSOCIATION;

    /**
     * Amazon Route53 resolver resolver endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_ENDPOINT;

    /**
     * Amazon Route53 resolver resolver rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_RULE;

    /**
     * Amazon Route53 resolver resolver rule association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION;

    /**
     * Amazon S3 AccessPoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_ACCESS_POINT;

    /**
     * Amazon S3 account public access block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_ACCOUNT_PUBLIC_ACCESS_BLOCK;

    /**
     * Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_BUCKET;

    /**
     * Amazon S3 Multi-Region Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_MULTIREGION_ACCESS_POINT;

    /**
     * Amazon S3 Storage Lens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_STORAGE_LENS;

    /**
     * Amazon SageMaker AppImageConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGE_MAKER_APP_IMAGE_CONFIG;

    /**
     * Amazon SageMaker Image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGE_MAKER_IMAGE;

    /**
     * Amazon SageMaker code repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_CODE_REPOSITORY;

    /**
     * Amazon SageMaker Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_DOMAIN;

    /**
     * Amazon SageMaker FeatureGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_FEATURE_GROUP;

    /**
     * Amazon SageMaker model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_MODEL;

    /**
     * Amazon SageMaker notebook instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_NOTEBOOK_INSTANCE;

    /**
     * Amazon SageMaker workteam.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_WORKTEAM;

    /**
     * AWS Secrets Manager secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SECRETS_MANAGER_SECRET;

    /**
     * AWS Service Catalog CloudFormation product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_CLOUDFORMATION_PRODUCT;

    /**
     * AWS Service Catalog CloudFormation provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT;

    /**
     * AWS Service Catalog portfolio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_PORTFOLIO;

    /**
     * AWS Cloud Map Instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_DISCOVERY_INSTANCE;

    /**
     * AWS Cloud Map(ServiceDiscovery) Http Namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_HTTP_NAMESPACE;

    /**
     * AWS Cloud Map(ServiceDiscovery) Public Dns Namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE;

    /**
     * AWS Cloud Map(ServiceDiscovery) service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_SERVICE;

    /**
     * Amazon SES Configuration Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_CONFIGURATION_SET;

    /**
     * Amazon SES Contact List.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_CONTACT_LIST;

    /**
     * Amazon SES ReceiptFilter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_RECEIPT_FILTER;

    /**
     * Amazon SES ReceiptRuleSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_RECEIPT_RECEIPT_RULE_SET;

    /**
     * Amazon SES Template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_TEMPLATE;

    /**
     * AWS Shield protection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SHIELD_PROTECTION;

    /**
     * AWS Shield regional protection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SHIELD_REGIONAL_PROTECTION;

    /**
     * AWS Signer SigningProfile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SIGNER_SIGNING_PROFILE;

    /**
     * Amazon SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SNS_TOPIC;

    /**
     * Amazon SQS queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SQS_QUEUE;

    /**
     * AWS StepFunctions activity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType STEPFUNCTIONS_ACTIVITY;

    /**
     * AWS StepFunctions state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType STEPFUNCTIONS_STATE_MACHINE;

    /**
     * AWS Systems Manager association compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE;

    /**
     * AWS Systems Manager file data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_FILE_DATA;

    /**
     * AWS Systems Manager managed instance inventory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY;

    /**
     * AWS Systems Manager patch compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_PATCH_COMPLIANCE;

    /**
     * AWS Transfer Agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType TRANSFER_AGREEMENT;

    /**
     * AWS Transfer Family Certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType TRANSFER_CERTIFICATE;

    /**
     * AWS Transfer Connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType TRANSFER_CONNECTOR;

    /**
     * AWS Transfer workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType TRANSFER_WORKFLOW;

    /**
     * AWS WAF rate based rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RATE_BASED_RULE;

    /**
     * AWS WAF regional rate based rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RATE_BASED_RULE;

    /**
     * AWS WAF regional rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RULE;

    /**
     * AWS WAF regional rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RULE_GROUP;

    /**
     * AWS WAF web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_WEB_ACL;

    /**
     * AWS WAF rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RULE;

    /**
     * AWS WAF rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RULE_GROUP;

    /**
     * AWS WAF web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_WEB_ACL;

    /**
     * AWS WAFv2 ip set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_IP_SET;

    /**
     * AWS WAFv2 managed rule set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_MANAGED_RULE_SET;

    /**
     * AWS WAFv2 regex pattern set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_REGEX_PATTERN_SET;

    /**
     * AWS WAFv2 rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_RULE_GROUP;

    /**
     * AWS WAFv2 web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_WEB_ACL;

    /**
     * Amazon WorkSpaces connection alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WORKSPACES_CONNECTION_ALIAS;

    /**
     * Amazon WorkSpaces workSpace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WORKSPACES_WORKSPACE;

    /**
     * AWS X-Ray encryption configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType XRAY_ENCRYPTION_CONFIGURATION;

    /**
     * Valid value of resource type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComplianceResourceType() {
        return software.amazon.jsii.Kernel.get(this, "complianceResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
