package software.amazon.awscdk.services.customerprofiles;

/**
 * Properties for defining a <code>CfnEventTrigger</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnEventTriggerProps cfnEventTriggerProps = CfnEventTriggerProps.builder()
 *         .domainName("domainName")
 *         .eventTriggerConditions(List.of(EventTriggerConditionProperty.builder()
 *                 .eventTriggerDimensions(List.of(EventTriggerDimensionProperty.builder()
 *                         .objectAttributes(List.of(ObjectAttributeProperty.builder()
 *                                 .comparisonOperator("comparisonOperator")
 *                                 .values(List.of("values"))
 *                                 // the properties below are optional
 *                                 .fieldName("fieldName")
 *                                 .source("source")
 *                                 .build()))
 *                         .build()))
 *                 .logicalOperator("logicalOperator")
 *                 .build()))
 *         .eventTriggerName("eventTriggerName")
 *         .objectTypeName("objectTypeName")
 *         // the properties below are optional
 *         .description("description")
 *         .eventTriggerLimits(EventTriggerLimitsProperty.builder()
 *                 .eventExpiration(123)
 *                 .periods(List.of(PeriodProperty.builder()
 *                         .unit("unit")
 *                         .value(123)
 *                         // the properties below are optional
 *                         .maxInvocationsPerProfile(123)
 *                         .unlimited(false)
 *                         .build()))
 *                 .build())
 *         .segmentFilter("segmentFilter")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:45.664Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnEventTriggerProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventTriggerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventTriggerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique name of the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * A list of conditions that determine when an event should trigger the destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerconditions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEventTriggerConditions();

    /**
     * The unique name of the event trigger.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventTriggerName();

    /**
     * The unique name of the object type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-objecttypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-objecttypename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectTypeName();

    /**
     * The description of the event trigger.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventTriggerLimits() {
        return null;
    }

    /**
     * The destination is triggered only for profiles that meet the criteria of a segment definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-segmentfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-segmentfilter</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSegmentFilter() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventTriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventTriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventTriggerProps> {
        java.lang.String domainName;
        java.lang.Object eventTriggerConditions;
        java.lang.String eventTriggerName;
        java.lang.String objectTypeName;
        java.lang.String description;
        java.lang.Object eventTriggerLimits;
        java.lang.String segmentFilter;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEventTriggerProps#getDomainName}
         * @param domainName The unique name of the domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getEventTriggerConditions}
         * @param eventTriggerConditions A list of conditions that determine when an event should trigger the destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerConditions(software.amazon.awscdk.IResolvable eventTriggerConditions) {
            this.eventTriggerConditions = eventTriggerConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getEventTriggerConditions}
         * @param eventTriggerConditions A list of conditions that determine when an event should trigger the destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerConditions(java.util.List<? extends java.lang.Object> eventTriggerConditions) {
            this.eventTriggerConditions = eventTriggerConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getEventTriggerName}
         * @param eventTriggerName The unique name of the event trigger. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerName(java.lang.String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getObjectTypeName}
         * @param objectTypeName The unique name of the object type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeName(java.lang.String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getDescription}
         * @param description The description of the event trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getEventTriggerLimits}
         * @param eventTriggerLimits Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerLimits(software.amazon.awscdk.IResolvable eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getEventTriggerLimits}
         * @param eventTriggerLimits Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerLimits(software.amazon.awscdk.services.customerprofiles.CfnEventTrigger.EventTriggerLimitsProperty eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getSegmentFilter}
         * @param segmentFilter The destination is triggered only for profiles that meet the criteria of a segment definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentFilter(java.lang.String segmentFilter) {
            this.segmentFilter = segmentFilter;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventTriggerProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventTriggerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventTriggerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventTriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventTriggerProps {
        private final java.lang.String domainName;
        private final java.lang.Object eventTriggerConditions;
        private final java.lang.String eventTriggerName;
        private final java.lang.String objectTypeName;
        private final java.lang.String description;
        private final java.lang.Object eventTriggerLimits;
        private final java.lang.String segmentFilter;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventTriggerConditions = software.amazon.jsii.Kernel.get(this, "eventTriggerConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventTriggerName = software.amazon.jsii.Kernel.get(this, "eventTriggerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectTypeName = software.amazon.jsii.Kernel.get(this, "objectTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventTriggerLimits = software.amazon.jsii.Kernel.get(this, "eventTriggerLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.segmentFilter = software.amazon.jsii.Kernel.get(this, "segmentFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.eventTriggerConditions = java.util.Objects.requireNonNull(builder.eventTriggerConditions, "eventTriggerConditions is required");
            this.eventTriggerName = java.util.Objects.requireNonNull(builder.eventTriggerName, "eventTriggerName is required");
            this.objectTypeName = java.util.Objects.requireNonNull(builder.objectTypeName, "objectTypeName is required");
            this.description = builder.description;
            this.eventTriggerLimits = builder.eventTriggerLimits;
            this.segmentFilter = builder.segmentFilter;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Object getEventTriggerConditions() {
            return this.eventTriggerConditions;
        }

        @Override
        public final java.lang.String getEventTriggerName() {
            return this.eventTriggerName;
        }

        @Override
        public final java.lang.String getObjectTypeName() {
            return this.objectTypeName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEventTriggerLimits() {
            return this.eventTriggerLimits;
        }

        @Override
        public final java.lang.String getSegmentFilter() {
            return this.segmentFilter;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("eventTriggerConditions", om.valueToTree(this.getEventTriggerConditions()));
            data.set("eventTriggerName", om.valueToTree(this.getEventTriggerName()));
            data.set("objectTypeName", om.valueToTree(this.getObjectTypeName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEventTriggerLimits() != null) {
                data.set("eventTriggerLimits", om.valueToTree(this.getEventTriggerLimits()));
            }
            if (this.getSegmentFilter() != null) {
                data.set("segmentFilter", om.valueToTree(this.getSegmentFilter()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnEventTriggerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventTriggerProps.Jsii$Proxy that = (CfnEventTriggerProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!eventTriggerConditions.equals(that.eventTriggerConditions)) return false;
            if (!eventTriggerName.equals(that.eventTriggerName)) return false;
            if (!objectTypeName.equals(that.objectTypeName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eventTriggerLimits != null ? !this.eventTriggerLimits.equals(that.eventTriggerLimits) : that.eventTriggerLimits != null) return false;
            if (this.segmentFilter != null ? !this.segmentFilter.equals(that.segmentFilter) : that.segmentFilter != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.eventTriggerConditions.hashCode());
            result = 31 * result + (this.eventTriggerName.hashCode());
            result = 31 * result + (this.objectTypeName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.eventTriggerLimits != null ? this.eventTriggerLimits.hashCode() : 0);
            result = 31 * result + (this.segmentFilter != null ? this.segmentFilter.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
