package software.amazon.awscdk.services.datapipeline;

/**
 * Properties for defining a <code>CfnPipeline</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datapipeline.*;
 * CfnPipelineProps cfnPipelineProps = CfnPipelineProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .activate(false)
 *         .description("description")
 *         .parameterObjects(List.of(ParameterObjectProperty.builder()
 *                 .attributes(List.of(ParameterAttributeProperty.builder()
 *                         .key("key")
 *                         .stringValue("stringValue")
 *                         .build()))
 *                 .id("id")
 *                 .build()))
 *         .parameterValues(List.of(ParameterValueProperty.builder()
 *                 .id("id")
 *                 .stringValue("stringValue")
 *                 .build()))
 *         .pipelineObjects(List.of(PipelineObjectProperty.builder()
 *                 .fields(List.of(FieldProperty.builder()
 *                         .key("key")
 *                         // the properties below are optional
 *                         .refValue("refValue")
 *                         .stringValue("stringValue")
 *                         .build()))
 *                 .id("id")
 *                 .name("name")
 *                 .build()))
 *         .pipelineTags(List.of(PipelineTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:45.779Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datapipeline.CfnPipelineProps")
@software.amazon.jsii.Jsii.Proxy(CfnPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Indicates whether to validate and start the pipeline or stop an active pipeline.
     * <p>
     * By default, the value is set to <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-activate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-activate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActivate() {
        return null;
    }

    /**
     * A description of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The parameter objects used with the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parameterobjects">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parameterobjects</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameterObjects() {
        return null;
    }

    /**
     * The parameter values used with the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parametervalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parametervalues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameterValues() {
        return null;
    }

    /**
     * The objects that define the pipeline.
     * <p>
     * These objects overwrite the existing pipeline definition. Not all objects, fields, and values can be updated. For information about restrictions, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-manage-pipeline-modify-console.html">Editing Your Pipeline</a> in the <em>AWS Data Pipeline Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelineobjects">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelineobjects</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPipelineObjects() {
        return null;
    }

    /**
     * A list of arbitrary tags (key-value pairs) to associate with the pipeline, which you can use to control permissions.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling Access to Pipelines and Resources</a> in the <em>AWS Data Pipeline Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelinetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelinetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty> getPipelineTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPipelineProps> {
        java.lang.String name;
        java.lang.Object activate;
        java.lang.String description;
        java.lang.Object parameterObjects;
        java.lang.Object parameterValues;
        java.lang.Object pipelineObjects;
        java.util.List<software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty> pipelineTags;

        /**
         * Sets the value of {@link CfnPipelineProps#getName}
         * @param name The name of the pipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getActivate}
         * @param activate Indicates whether to validate and start the pipeline or stop an active pipeline.
         *                 By default, the value is set to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activate(java.lang.Boolean activate) {
            this.activate = activate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getActivate}
         * @param activate Indicates whether to validate and start the pipeline or stop an active pipeline.
         *                 By default, the value is set to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activate(software.amazon.awscdk.IResolvable activate) {
            this.activate = activate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getDescription}
         * @param description A description of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getParameterObjects}
         * @param parameterObjects The parameter objects used with the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterObjects(software.amazon.awscdk.IResolvable parameterObjects) {
            this.parameterObjects = parameterObjects;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getParameterObjects}
         * @param parameterObjects The parameter objects used with the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterObjects(java.util.List<? extends java.lang.Object> parameterObjects) {
            this.parameterObjects = parameterObjects;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getParameterValues}
         * @param parameterValues The parameter values used with the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterValues(software.amazon.awscdk.IResolvable parameterValues) {
            this.parameterValues = parameterValues;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getParameterValues}
         * @param parameterValues The parameter values used with the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterValues(java.util.List<? extends java.lang.Object> parameterValues) {
            this.parameterValues = parameterValues;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineObjects}
         * @param pipelineObjects The objects that define the pipeline.
         *                        These objects overwrite the existing pipeline definition. Not all objects, fields, and values can be updated. For information about restrictions, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-manage-pipeline-modify-console.html">Editing Your Pipeline</a> in the <em>AWS Data Pipeline Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineObjects(software.amazon.awscdk.IResolvable pipelineObjects) {
            this.pipelineObjects = pipelineObjects;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineObjects}
         * @param pipelineObjects The objects that define the pipeline.
         *                        These objects overwrite the existing pipeline definition. Not all objects, fields, and values can be updated. For information about restrictions, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-manage-pipeline-modify-console.html">Editing Your Pipeline</a> in the <em>AWS Data Pipeline Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineObjects(java.util.List<? extends java.lang.Object> pipelineObjects) {
            this.pipelineObjects = pipelineObjects;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineTags}
         * @param pipelineTags A list of arbitrary tags (key-value pairs) to associate with the pipeline, which you can use to control permissions.
         *                     For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-control-access.html">Controlling Access to Pipelines and Resources</a> in the <em>AWS Data Pipeline Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder pipelineTags(java.util.List<? extends software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty> pipelineTags) {
            this.pipelineTags = (java.util.List<software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty>)pipelineTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPipelineProps {
        private final java.lang.String name;
        private final java.lang.Object activate;
        private final java.lang.String description;
        private final java.lang.Object parameterObjects;
        private final java.lang.Object parameterValues;
        private final java.lang.Object pipelineObjects;
        private final java.util.List<software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty> pipelineTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.activate = software.amazon.jsii.Kernel.get(this, "activate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterObjects = software.amazon.jsii.Kernel.get(this, "parameterObjects", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parameterValues = software.amazon.jsii.Kernel.get(this, "parameterValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pipelineObjects = software.amazon.jsii.Kernel.get(this, "pipelineObjects", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pipelineTags = software.amazon.jsii.Kernel.get(this, "pipelineTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.activate = builder.activate;
            this.description = builder.description;
            this.parameterObjects = builder.parameterObjects;
            this.parameterValues = builder.parameterValues;
            this.pipelineObjects = builder.pipelineObjects;
            this.pipelineTags = (java.util.List<software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty>)builder.pipelineTags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getActivate() {
            return this.activate;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getParameterObjects() {
            return this.parameterObjects;
        }

        @Override
        public final java.lang.Object getParameterValues() {
            return this.parameterValues;
        }

        @Override
        public final java.lang.Object getPipelineObjects() {
            return this.pipelineObjects;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.datapipeline.CfnPipeline.PipelineTagProperty> getPipelineTags() {
            return this.pipelineTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getActivate() != null) {
                data.set("activate", om.valueToTree(this.getActivate()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getParameterObjects() != null) {
                data.set("parameterObjects", om.valueToTree(this.getParameterObjects()));
            }
            if (this.getParameterValues() != null) {
                data.set("parameterValues", om.valueToTree(this.getParameterValues()));
            }
            if (this.getPipelineObjects() != null) {
                data.set("pipelineObjects", om.valueToTree(this.getPipelineObjects()));
            }
            if (this.getPipelineTags() != null) {
                data.set("pipelineTags", om.valueToTree(this.getPipelineTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datapipeline.CfnPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPipelineProps.Jsii$Proxy that = (CfnPipelineProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.activate != null ? !this.activate.equals(that.activate) : that.activate != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.parameterObjects != null ? !this.parameterObjects.equals(that.parameterObjects) : that.parameterObjects != null) return false;
            if (this.parameterValues != null ? !this.parameterValues.equals(that.parameterValues) : that.parameterValues != null) return false;
            if (this.pipelineObjects != null ? !this.pipelineObjects.equals(that.pipelineObjects) : that.pipelineObjects != null) return false;
            return this.pipelineTags != null ? this.pipelineTags.equals(that.pipelineTags) : that.pipelineTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.activate != null ? this.activate.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.parameterObjects != null ? this.parameterObjects.hashCode() : 0);
            result = 31 * result + (this.parameterValues != null ? this.parameterValues.hashCode() : 0);
            result = 31 * result + (this.pipelineObjects != null ? this.pipelineObjects.hashCode() : 0);
            result = 31 * result + (this.pipelineTags != null ? this.pipelineTags.hashCode() : 0);
            return result;
        }
    }
}
