package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnNatGateway</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNatGatewayProps cfnNatGatewayProps = CfnNatGatewayProps.builder()
 *         .subnetId("subnetId")
 *         // the properties below are optional
 *         .allocationId("allocationId")
 *         .connectivityType("connectivityType")
 *         .maxDrainDurationSeconds(123)
 *         .privateIpAddress("privateIpAddress")
 *         .secondaryAllocationIds(List.of("secondaryAllocationIds"))
 *         .secondaryPrivateIpAddressCount(123)
 *         .secondaryPrivateIpAddresses(List.of("secondaryPrivateIpAddresses"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:46.591Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNatGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnNatGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNatGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the subnet in which the NAT gateway is located.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * [Public NAT gateway only] The allocation ID of the Elastic IP address that's associated with the NAT gateway.
     * <p>
     * This property is required for a public NAT gateway and cannot be specified with a private NAT gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllocationId() {
        return null;
    }

    /**
     * Indicates whether the NAT gateway supports public or private connectivity.
     * <p>
     * The default is public connectivity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-connectivitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-connectivitytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectivityType() {
        return null;
    }

    /**
     * The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are still in progress.
     * <p>
     * Default value is 350 seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-maxdraindurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-maxdraindurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDrainDurationSeconds() {
        return null;
    }

    /**
     * The private IPv4 address to assign to the NAT gateway.
     * <p>
     * If you don't provide an address, a private IPv4 address will be automatically assigned.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-privateipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-privateipaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return null;
    }

    /**
     * Secondary EIP allocation IDs.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT gateway</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryallocationids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryallocationids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecondaryAllocationIds() {
        return null;
    }

    /**
     * [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT gateway.
     * <p>
     * For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresscount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresscount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
        return null;
    }

    /**
     * Secondary private IPv4 addresses.
     * <p>
     * For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecondaryPrivateIpAddresses() {
        return null;
    }

    /**
     * The tags for the NAT gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNatGatewayProps> {
        java.lang.String subnetId;
        java.lang.String allocationId;
        java.lang.String connectivityType;
        java.lang.Number maxDrainDurationSeconds;
        java.lang.String privateIpAddress;
        java.util.List<java.lang.String> secondaryAllocationIds;
        java.lang.Number secondaryPrivateIpAddressCount;
        java.util.List<java.lang.String> secondaryPrivateIpAddresses;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSubnetId}
         * @param subnetId The ID of the subnet in which the NAT gateway is located. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getAllocationId}
         * @param allocationId [Public NAT gateway only] The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         *                     This property is required for a public NAT gateway and cannot be specified with a private NAT gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationId(java.lang.String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getConnectivityType}
         * @param connectivityType Indicates whether the NAT gateway supports public or private connectivity.
         *                         The default is public connectivity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectivityType(java.lang.String connectivityType) {
            this.connectivityType = connectivityType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getMaxDrainDurationSeconds}
         * @param maxDrainDurationSeconds The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are still in progress.
         *                                Default value is 350 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDrainDurationSeconds(java.lang.Number maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getPrivateIpAddress}
         * @param privateIpAddress The private IPv4 address to assign to the NAT gateway.
         *                         If you don't provide an address, a private IPv4 address will be automatically assigned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSecondaryAllocationIds}
         * @param secondaryAllocationIds Secondary EIP allocation IDs.
         *                               For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT gateway</a> in the <em>Amazon VPC User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryAllocationIds(java.util.List<java.lang.String> secondaryAllocationIds) {
            this.secondaryAllocationIds = secondaryAllocationIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSecondaryPrivateIpAddressCount}
         * @param secondaryPrivateIpAddressCount [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT gateway.
         *                                       For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         *                                       <p>
         *                                       <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSecondaryPrivateIpAddresses}
         * @param secondaryPrivateIpAddresses Secondary private IPv4 addresses.
         *                                    For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         *                                    <p>
         *                                    <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryPrivateIpAddresses(java.util.List<java.lang.String> secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses = secondaryPrivateIpAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getTags}
         * @param tags The tags for the NAT gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNatGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNatGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNatGatewayProps {
        private final java.lang.String subnetId;
        private final java.lang.String allocationId;
        private final java.lang.String connectivityType;
        private final java.lang.Number maxDrainDurationSeconds;
        private final java.lang.String privateIpAddress;
        private final java.util.List<java.lang.String> secondaryAllocationIds;
        private final java.lang.Number secondaryPrivateIpAddressCount;
        private final java.util.List<java.lang.String> secondaryPrivateIpAddresses;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allocationId = software.amazon.jsii.Kernel.get(this, "allocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectivityType = software.amazon.jsii.Kernel.get(this, "connectivityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxDrainDurationSeconds = software.amazon.jsii.Kernel.get(this, "maxDrainDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secondaryAllocationIds = software.amazon.jsii.Kernel.get(this, "secondaryAllocationIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.secondaryPrivateIpAddressCount = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.secondaryPrivateIpAddresses = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subnetId = java.util.Objects.requireNonNull(builder.subnetId, "subnetId is required");
            this.allocationId = builder.allocationId;
            this.connectivityType = builder.connectivityType;
            this.maxDrainDurationSeconds = builder.maxDrainDurationSeconds;
            this.privateIpAddress = builder.privateIpAddress;
            this.secondaryAllocationIds = builder.secondaryAllocationIds;
            this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
            this.secondaryPrivateIpAddresses = builder.secondaryPrivateIpAddresses;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.lang.String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final java.lang.String getConnectivityType() {
            return this.connectivityType;
        }

        @Override
        public final java.lang.Number getMaxDrainDurationSeconds() {
            return this.maxDrainDurationSeconds;
        }

        @Override
        public final java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final java.util.List<java.lang.String> getSecondaryAllocationIds() {
            return this.secondaryAllocationIds;
        }

        @Override
        public final java.lang.Number getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final java.util.List<java.lang.String> getSecondaryPrivateIpAddresses() {
            return this.secondaryPrivateIpAddresses;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subnetId", om.valueToTree(this.getSubnetId()));
            if (this.getAllocationId() != null) {
                data.set("allocationId", om.valueToTree(this.getAllocationId()));
            }
            if (this.getConnectivityType() != null) {
                data.set("connectivityType", om.valueToTree(this.getConnectivityType()));
            }
            if (this.getMaxDrainDurationSeconds() != null) {
                data.set("maxDrainDurationSeconds", om.valueToTree(this.getMaxDrainDurationSeconds()));
            }
            if (this.getPrivateIpAddress() != null) {
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getSecondaryAllocationIds() != null) {
                data.set("secondaryAllocationIds", om.valueToTree(this.getSecondaryAllocationIds()));
            }
            if (this.getSecondaryPrivateIpAddressCount() != null) {
                data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
            }
            if (this.getSecondaryPrivateIpAddresses() != null) {
                data.set("secondaryPrivateIpAddresses", om.valueToTree(this.getSecondaryPrivateIpAddresses()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNatGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNatGatewayProps.Jsii$Proxy that = (CfnNatGatewayProps.Jsii$Proxy) o;

            if (!subnetId.equals(that.subnetId)) return false;
            if (this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null) return false;
            if (this.connectivityType != null ? !this.connectivityType.equals(that.connectivityType) : that.connectivityType != null) return false;
            if (this.maxDrainDurationSeconds != null ? !this.maxDrainDurationSeconds.equals(that.maxDrainDurationSeconds) : that.maxDrainDurationSeconds != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.secondaryAllocationIds != null ? !this.secondaryAllocationIds.equals(that.secondaryAllocationIds) : that.secondaryAllocationIds != null) return false;
            if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
            if (this.secondaryPrivateIpAddresses != null ? !this.secondaryPrivateIpAddresses.equals(that.secondaryPrivateIpAddresses) : that.secondaryPrivateIpAddresses != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.subnetId.hashCode();
            result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
            result = 31 * result + (this.connectivityType != null ? this.connectivityType.hashCode() : 0);
            result = 31 * result + (this.maxDrainDurationSeconds != null ? this.maxDrainDurationSeconds.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.secondaryAllocationIds != null ? this.secondaryAllocationIds.hashCode() : 0);
            result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
            result = 31 * result + (this.secondaryPrivateIpAddresses != null ? this.secondaryPrivateIpAddresses.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
