package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnRoute</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnRouteProps cfnRouteProps = CfnRouteProps.builder()
 *         .routeTableId("routeTableId")
 *         // the properties below are optional
 *         .carrierGatewayId("carrierGatewayId")
 *         .coreNetworkArn("coreNetworkArn")
 *         .destinationCidrBlock("destinationCidrBlock")
 *         .destinationIpv6CidrBlock("destinationIpv6CidrBlock")
 *         .destinationPrefixListId("destinationPrefixListId")
 *         .egressOnlyInternetGatewayId("egressOnlyInternetGatewayId")
 *         .gatewayId("gatewayId")
 *         .instanceId("instanceId")
 *         .localGatewayId("localGatewayId")
 *         .natGatewayId("natGatewayId")
 *         .networkInterfaceId("networkInterfaceId")
 *         .transitGatewayId("transitGatewayId")
 *         .vpcEndpointId("vpcEndpointId")
 *         .vpcPeeringConnectionId("vpcPeeringConnectionId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:46.645Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnRouteProps")
@software.amazon.jsii.Jsii.Proxy(CfnRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the route table for the route.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteTableId();

    /**
     * The ID of the carrier gateway.
     * <p>
     * You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-carriergatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-carriergatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCarrierGatewayId() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the core network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-corenetworkarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-corenetworkarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkArn() {
        return null;
    }

    /**
     * The IPv4 CIDR address block used for the destination match.
     * <p>
     * Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code> , we modify it to <code>100.68.0.0/18</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationCidrBlock() {
        return null;
    }

    /**
     * The IPv6 CIDR block used for the destination match.
     * <p>
     * Routing decisions are based on the most specific match.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationIpv6CidrBlock() {
        return null;
    }

    /**
     * The ID of a prefix list used for the destination match.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationprefixlistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationprefixlistid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPrefixListId() {
        return null;
    }

    /**
     * [IPv6 traffic only] The ID of an egress-only internet gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEgressOnlyInternetGatewayId() {
        return null;
    }

    /**
     * The ID of an internet gateway or virtual private gateway attached to your VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGatewayId() {
        return null;
    }

    /**
     * The ID of a NAT instance in your VPC.
     * <p>
     * The operation fails if you specify an instance ID unless exactly one network interface is attached.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * The ID of the local gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-localgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-localgatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocalGatewayId() {
        return null;
    }

    /**
     * [IPv4 traffic only] The ID of a NAT gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNatGatewayId() {
        return null;
    }

    /**
     * The ID of a network interface.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
        return null;
    }

    /**
     * The ID of a transit gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return null;
    }

    /**
     * The ID of a VPC endpoint.
     * <p>
     * Supported for Gateway Load Balancer endpoints only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcendpointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcendpointid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
        return null;
    }

    /**
     * The ID of a VPC peering connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcPeeringConnectionId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRouteProps> {
        java.lang.String routeTableId;
        java.lang.String carrierGatewayId;
        java.lang.String coreNetworkArn;
        java.lang.String destinationCidrBlock;
        java.lang.String destinationIpv6CidrBlock;
        java.lang.String destinationPrefixListId;
        java.lang.String egressOnlyInternetGatewayId;
        java.lang.String gatewayId;
        java.lang.String instanceId;
        java.lang.String localGatewayId;
        java.lang.String natGatewayId;
        java.lang.String networkInterfaceId;
        java.lang.String transitGatewayId;
        java.lang.String vpcEndpointId;
        java.lang.String vpcPeeringConnectionId;

        /**
         * Sets the value of {@link CfnRouteProps#getRouteTableId}
         * @param routeTableId The ID of the route table for the route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeTableId(java.lang.String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getCarrierGatewayId}
         * @param carrierGatewayId The ID of the carrier gateway.
         *                         You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder carrierGatewayId(java.lang.String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getCoreNetworkArn}
         * @param coreNetworkArn The Amazon Resource Name (ARN) of the core network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkArn(java.lang.String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getDestinationCidrBlock}
         * @param destinationCidrBlock The IPv4 CIDR address block used for the destination match.
         *                             Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code> , we modify it to <code>100.68.0.0/18</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getDestinationIpv6CidrBlock}
         * @param destinationIpv6CidrBlock The IPv6 CIDR block used for the destination match.
         *                                 Routing decisions are based on the most specific match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationIpv6CidrBlock(java.lang.String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getDestinationPrefixListId}
         * @param destinationPrefixListId The ID of a prefix list used for the destination match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPrefixListId(java.lang.String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getEgressOnlyInternetGatewayId}
         * @param egressOnlyInternetGatewayId [IPv6 traffic only] The ID of an egress-only internet gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressOnlyInternetGatewayId(java.lang.String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getGatewayId}
         * @param gatewayId The ID of an internet gateway or virtual private gateway attached to your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayId(java.lang.String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getInstanceId}
         * @param instanceId The ID of a NAT instance in your VPC.
         *                   The operation fails if you specify an instance ID unless exactly one network interface is attached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getLocalGatewayId}
         * @param localGatewayId The ID of the local gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayId(java.lang.String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getNatGatewayId}
         * @param natGatewayId [IPv4 traffic only] The ID of a NAT gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewayId(java.lang.String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getNetworkInterfaceId}
         * @param networkInterfaceId The ID of a network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getTransitGatewayId}
         * @param transitGatewayId The ID of a transit gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getVpcEndpointId}
         * @param vpcEndpointId The ID of a VPC endpoint.
         *                      Supported for Gateway Load Balancer endpoints only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getVpcPeeringConnectionId}
         * @param vpcPeeringConnectionId The ID of a VPC peering connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcPeeringConnectionId(java.lang.String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRouteProps {
        private final java.lang.String routeTableId;
        private final java.lang.String carrierGatewayId;
        private final java.lang.String coreNetworkArn;
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String destinationIpv6CidrBlock;
        private final java.lang.String destinationPrefixListId;
        private final java.lang.String egressOnlyInternetGatewayId;
        private final java.lang.String gatewayId;
        private final java.lang.String instanceId;
        private final java.lang.String localGatewayId;
        private final java.lang.String natGatewayId;
        private final java.lang.String networkInterfaceId;
        private final java.lang.String transitGatewayId;
        private final java.lang.String vpcEndpointId;
        private final java.lang.String vpcPeeringConnectionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeTableId = software.amazon.jsii.Kernel.get(this, "routeTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.carrierGatewayId = software.amazon.jsii.Kernel.get(this, "carrierGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.coreNetworkArn = software.amazon.jsii.Kernel.get(this, "coreNetworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationCidrBlock = software.amazon.jsii.Kernel.get(this, "destinationCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationIpv6CidrBlock = software.amazon.jsii.Kernel.get(this, "destinationIpv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationPrefixListId = software.amazon.jsii.Kernel.get(this, "destinationPrefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.egressOnlyInternetGatewayId = software.amazon.jsii.Kernel.get(this, "egressOnlyInternetGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gatewayId = software.amazon.jsii.Kernel.get(this, "gatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localGatewayId = software.amazon.jsii.Kernel.get(this, "localGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.natGatewayId = software.amazon.jsii.Kernel.get(this, "natGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayId = software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcEndpointId = software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcPeeringConnectionId = software.amazon.jsii.Kernel.get(this, "vpcPeeringConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeTableId = java.util.Objects.requireNonNull(builder.routeTableId, "routeTableId is required");
            this.carrierGatewayId = builder.carrierGatewayId;
            this.coreNetworkArn = builder.coreNetworkArn;
            this.destinationCidrBlock = builder.destinationCidrBlock;
            this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
            this.destinationPrefixListId = builder.destinationPrefixListId;
            this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
            this.gatewayId = builder.gatewayId;
            this.instanceId = builder.instanceId;
            this.localGatewayId = builder.localGatewayId;
            this.natGatewayId = builder.natGatewayId;
            this.networkInterfaceId = builder.networkInterfaceId;
            this.transitGatewayId = builder.transitGatewayId;
            this.vpcEndpointId = builder.vpcEndpointId;
            this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        }

        @Override
        public final java.lang.String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final java.lang.String getCarrierGatewayId() {
            return this.carrierGatewayId;
        }

        @Override
        public final java.lang.String getCoreNetworkArn() {
            return this.coreNetworkArn;
        }

        @Override
        public final java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final java.lang.String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public final java.lang.String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        @Override
        public final java.lang.String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final java.lang.String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.String getLocalGatewayId() {
            return this.localGatewayId;
        }

        @Override
        public final java.lang.String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final java.lang.String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final java.lang.String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeTableId", om.valueToTree(this.getRouteTableId()));
            if (this.getCarrierGatewayId() != null) {
                data.set("carrierGatewayId", om.valueToTree(this.getCarrierGatewayId()));
            }
            if (this.getCoreNetworkArn() != null) {
                data.set("coreNetworkArn", om.valueToTree(this.getCoreNetworkArn()));
            }
            if (this.getDestinationCidrBlock() != null) {
                data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            }
            if (this.getDestinationIpv6CidrBlock() != null) {
                data.set("destinationIpv6CidrBlock", om.valueToTree(this.getDestinationIpv6CidrBlock()));
            }
            if (this.getDestinationPrefixListId() != null) {
                data.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
            }
            if (this.getEgressOnlyInternetGatewayId() != null) {
                data.set("egressOnlyInternetGatewayId", om.valueToTree(this.getEgressOnlyInternetGatewayId()));
            }
            if (this.getGatewayId() != null) {
                data.set("gatewayId", om.valueToTree(this.getGatewayId()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getLocalGatewayId() != null) {
                data.set("localGatewayId", om.valueToTree(this.getLocalGatewayId()));
            }
            if (this.getNatGatewayId() != null) {
                data.set("natGatewayId", om.valueToTree(this.getNatGatewayId()));
            }
            if (this.getNetworkInterfaceId() != null) {
                data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            }
            if (this.getTransitGatewayId() != null) {
                data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            }
            if (this.getVpcEndpointId() != null) {
                data.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
            }
            if (this.getVpcPeeringConnectionId() != null) {
                data.set("vpcPeeringConnectionId", om.valueToTree(this.getVpcPeeringConnectionId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRouteProps.Jsii$Proxy that = (CfnRouteProps.Jsii$Proxy) o;

            if (!routeTableId.equals(that.routeTableId)) return false;
            if (this.carrierGatewayId != null ? !this.carrierGatewayId.equals(that.carrierGatewayId) : that.carrierGatewayId != null) return false;
            if (this.coreNetworkArn != null ? !this.coreNetworkArn.equals(that.coreNetworkArn) : that.coreNetworkArn != null) return false;
            if (this.destinationCidrBlock != null ? !this.destinationCidrBlock.equals(that.destinationCidrBlock) : that.destinationCidrBlock != null) return false;
            if (this.destinationIpv6CidrBlock != null ? !this.destinationIpv6CidrBlock.equals(that.destinationIpv6CidrBlock) : that.destinationIpv6CidrBlock != null) return false;
            if (this.destinationPrefixListId != null ? !this.destinationPrefixListId.equals(that.destinationPrefixListId) : that.destinationPrefixListId != null) return false;
            if (this.egressOnlyInternetGatewayId != null ? !this.egressOnlyInternetGatewayId.equals(that.egressOnlyInternetGatewayId) : that.egressOnlyInternetGatewayId != null) return false;
            if (this.gatewayId != null ? !this.gatewayId.equals(that.gatewayId) : that.gatewayId != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.localGatewayId != null ? !this.localGatewayId.equals(that.localGatewayId) : that.localGatewayId != null) return false;
            if (this.natGatewayId != null ? !this.natGatewayId.equals(that.natGatewayId) : that.natGatewayId != null) return false;
            if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
            if (this.transitGatewayId != null ? !this.transitGatewayId.equals(that.transitGatewayId) : that.transitGatewayId != null) return false;
            if (this.vpcEndpointId != null ? !this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId != null) return false;
            return this.vpcPeeringConnectionId != null ? this.vpcPeeringConnectionId.equals(that.vpcPeeringConnectionId) : that.vpcPeeringConnectionId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.routeTableId.hashCode();
            result = 31 * result + (this.carrierGatewayId != null ? this.carrierGatewayId.hashCode() : 0);
            result = 31 * result + (this.coreNetworkArn != null ? this.coreNetworkArn.hashCode() : 0);
            result = 31 * result + (this.destinationCidrBlock != null ? this.destinationCidrBlock.hashCode() : 0);
            result = 31 * result + (this.destinationIpv6CidrBlock != null ? this.destinationIpv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.destinationPrefixListId != null ? this.destinationPrefixListId.hashCode() : 0);
            result = 31 * result + (this.egressOnlyInternetGatewayId != null ? this.egressOnlyInternetGatewayId.hashCode() : 0);
            result = 31 * result + (this.gatewayId != null ? this.gatewayId.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.localGatewayId != null ? this.localGatewayId.hashCode() : 0);
            result = 31 * result + (this.natGatewayId != null ? this.natGatewayId.hashCode() : 0);
            result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
            result = 31 * result + (this.transitGatewayId != null ? this.transitGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0);
            result = 31 * result + (this.vpcPeeringConnectionId != null ? this.vpcPeeringConnectionId.hashCode() : 0);
            return result;
        }
    }
}
