package software.amazon.awscdk.services.ec2;

/**
 * Provides the options for specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .instanceType(InstanceType.of(InstanceClass.T3, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .vpc(vpc)
 *         .creditSpecification(CpuCredits.STANDARD)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-how-to.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-how-to.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:46.867Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CpuCredits")
public enum CpuCredits {
    /**
     * Standard bursting mode.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-standard-mode.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-standard-mode.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Unlimited bursting mode.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UNLIMITED,
}
