package software.amazon.awscdk.services.ec2;

/**
 * Optional properties for the InterfaceVpcEndpointAwsService class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * InterfaceVpcEndpointAwsServiceProps interfaceVpcEndpointAwsServiceProps = InterfaceVpcEndpointAwsServiceProps.builder()
 *         .global(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:46.962Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsServiceProps")
@software.amazon.jsii.Jsii.Proxy(InterfaceVpcEndpointAwsServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointAwsServiceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * If true, the service is a global endpoint and its name will not be prefixed with the stack's region.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGlobal() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointAwsServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InterfaceVpcEndpointAwsServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InterfaceVpcEndpointAwsServiceProps> {
        java.lang.Boolean global;

        /**
         * Sets the value of {@link InterfaceVpcEndpointAwsServiceProps#getGlobal}
         * @param global If true, the service is a global endpoint and its name will not be prefixed with the stack's region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder global(java.lang.Boolean global) {
            this.global = global;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointAwsServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InterfaceVpcEndpointAwsServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InterfaceVpcEndpointAwsServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceVpcEndpointAwsServiceProps {
        private final java.lang.Boolean global;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.global = software.amazon.jsii.Kernel.get(this, "global", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.global = builder.global;
        }

        @Override
        public final java.lang.Boolean getGlobal() {
            return this.global;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGlobal() != null) {
                data.set("global", om.valueToTree(this.getGlobal()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InterfaceVpcEndpointAwsServiceProps.Jsii$Proxy that = (InterfaceVpcEndpointAwsServiceProps.Jsii$Proxy) o;

            return this.global != null ? this.global.equals(that.global) : that.global == null;
        }

        @Override
        public final int hashCode() {
            int result = this.global != null ? this.global.hashCode() : 0;
            return result;
        }
    }
}
