package software.amazon.awscdk.services.ec2;

/**
 * Options when creating <code>MultipartBody</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * MultipartBodyOptions multipartBodyOptions = MultipartBodyOptions.builder()
 *         .contentType("contentType")
 *         // the properties below are optional
 *         .body("body")
 *         .transferEncoding("transferEncoding")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-05-07T19:18:46.979Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.MultipartBodyOptions")
@software.amazon.jsii.Jsii.Proxy(MultipartBodyOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MultipartBodyOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * <code>Content-Type</code> header of this part.
     * <p>
     * Some examples of content types:
     * <p>
     * <ul>
     * <li><code>text/x-shellscript; charset="utf-8"</code> (shell script)</li>
     * <li><code>text/cloud-boothook; charset="utf-8"</code> (shell script executed during boot phase)</li>
     * </ul>
     * <p>
     * For Linux shell scripts use <code>text/x-shellscript</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContentType();

    /**
     * The body of message.
     * <p>
     * Default: undefined - body will not be added to part
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
        return null;
    }

    /**
     * <code>Content-Transfer-Encoding</code> header specifying part encoding.
     * <p>
     * Default: undefined - body is not encoded
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransferEncoding() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MultipartBodyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MultipartBodyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MultipartBodyOptions> {
        java.lang.String contentType;
        java.lang.String body;
        java.lang.String transferEncoding;

        /**
         * Sets the value of {@link MultipartBodyOptions#getContentType}
         * @param contentType <code>Content-Type</code> header of this part. This parameter is required.
         *                    Some examples of content types:
         *                    <p>
         *                    <ul>
         *                    <li><code>text/x-shellscript; charset="utf-8"</code> (shell script)</li>
         *                    <li><code>text/cloud-boothook; charset="utf-8"</code> (shell script executed during boot phase)</li>
         *                    </ul>
         *                    <p>
         *                    For Linux shell scripts use <code>text/x-shellscript</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link MultipartBodyOptions#getBody}
         * @param body The body of message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(java.lang.String body) {
            this.body = body;
            return this;
        }

        /**
         * Sets the value of {@link MultipartBodyOptions#getTransferEncoding}
         * @param transferEncoding <code>Content-Transfer-Encoding</code> header specifying part encoding.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transferEncoding(java.lang.String transferEncoding) {
            this.transferEncoding = transferEncoding;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MultipartBodyOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MultipartBodyOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MultipartBodyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultipartBodyOptions {
        private final java.lang.String contentType;
        private final java.lang.String body;
        private final java.lang.String transferEncoding;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transferEncoding = software.amazon.jsii.Kernel.get(this, "transferEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentType = java.util.Objects.requireNonNull(builder.contentType, "contentType is required");
            this.body = builder.body;
            this.transferEncoding = builder.transferEncoding;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getBody() {
            return this.body;
        }

        @Override
        public final java.lang.String getTransferEncoding() {
            return this.transferEncoding;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("contentType", om.valueToTree(this.getContentType()));
            if (this.getBody() != null) {
                data.set("body", om.valueToTree(this.getBody()));
            }
            if (this.getTransferEncoding() != null) {
                data.set("transferEncoding", om.valueToTree(this.getTransferEncoding()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.MultipartBodyOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MultipartBodyOptions.Jsii$Proxy that = (MultipartBodyOptions.Jsii$Proxy) o;

            if (!contentType.equals(that.contentType)) return false;
            if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
            return this.transferEncoding != null ? this.transferEncoding.equals(that.transferEncoding) : that.transferEncoding == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentType.hashCode();
            result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
            result = 31 * result + (this.transferEncoding != null ? this.transferEncoding.hashCode() : 0);
            return result;
        }
    }
}
